<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

/**
 * Add open tickets count in toolbar
 */
add_action( 'admin_bar_menu', 'wast_add_toolbar_items', 100 );
function wast_add_toolbar_items( $admin_bar ) {
	global $current_user;
	if ( user_can( $current_user, "subscriber" ) ) {
		return false;
	}

	$user_id    = get_current_user_id();
	$user       = get_userdata( $user_id );
	$user_email = $user->user_email;

	global $wpdb;
	$terms = $wpdb->get_results(
		$wpdb->prepare(
			"SELECT `term_id` FROM `$wpdb->termmeta` 
			WHERE `meta_key` = '_wast_recipient_email' AND `meta_value` = %s", $user_email
		)
	);

	$count = 0;

	if ( $terms ) {
		$term_ids = array();
		foreach ( $terms as $term ) {
			$term_ids[] = $term->term_id;
		}

		$args  = array(
			'post_type'      => 'ticket',
			'posts_per_page' => - 1,
			'post_status'    => 'open',
			'tax_query'      => array(
				array(
					'taxonomy' => 'ticket-type',
					'field'    => 'term_id',
					'terms'    => $term_ids,
				),
			),
		);
		$posts = new WP_Query( $args );
		$count = $posts->found_posts;
	}

	if ( ! $count ) {
		return false;
	}

	$url = add_query_arg(
		array(
			'post_type'          => 'ticket',
			'filter_open_ticket' => '1',
		),
		esc_url( admin_url( 'edit.php' ) )
	);

	$admin_bar->add_menu( array(
		'id'    => 'my-open-tickets',
		'title' => '<span class="ab-icon"></span><span class="ab-label">' . $count . '</span>',
		'href'  => $url,
		'meta'  => array(
			'title' => 'تیکت‌های باز شما',
		),
	) );
}

/**
 * Send email for user after ticket send
 */
add_action( 'wast_send_email', 'wast_send_ticket_email', 10, 2 );
function wast_send_ticket_email( $to, $ticket_id ) {
	$send_email = new WAST_Send_Email();
	$send_email->send( $to, $ticket_id );
}

/**
 * Send sms for user after ticket send
 */
add_action( 'wast_send_sms', 'wast_send_ticket_sms', 10, 2 );
function wast_send_ticket_sms( $to, $ticket_id ) {
	$send_sms = new WAST_Send_SMS();
	$send_sms->send( $to, $ticket_id );
}

/**
 * Add custom filed to woocommerce edit account form
 */
add_action( 'woocommerce_edit_account_form', 'wast_woocommerce_edit_account_form' );
function wast_woocommerce_edit_account_form() {
	$user_id = get_current_user_id();
	$mobile  = get_user_meta( $user_id, '_wast_mobile', true );
	?>
    <p class="wast-form-group woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
        <label for="wast-mobile">شماره همراه
            <small class="wast-text-muted">(جهت دریافت اعلانات تیکت شماره همراه خود را وارد نمایید.)</small>
        </label>
        <input type="text" class="wast-form-control woocommerce-Input woocommerce-Input--password input-text" id="wast-mobile" name="wast-mobile" value="<?php echo esc_attr( $mobile ); ?>">
    </p>
	<?php
}

add_action( 'woocommerce_save_account_details', 'wast_woocommerce_save_account_details' );
function wast_woocommerce_save_account_details( $user_id ) {
	if ( isset( $_POST['wast-mobile'] ) && ! empty( $_POST['wast-mobile'] ) ) {
		update_user_meta( $user_id, '_wast_mobile', sanitize_text_field( $_POST['wast-mobile'] ) );
	} else {
		delete_user_meta( $user_id, '_wast_mobile' );
	}
}

/**
 * Use radio inputs instead of checkboxes for term checklists in specified taxonomies.
 *
 * @param   array $args
 *
 * @return  array
 */
add_filter( 'wp_terms_checklist_args', 'wast_term_radio_checklist' );
function wast_term_radio_checklist( $args ) {
	if ( ! empty( $args['taxonomy'] ) && $args['taxonomy'] === 'ticket-type' ) {
		if ( empty( $args['walker'] ) || is_a( $args['walker'], 'Walker' ) ) {
			if ( ! class_exists( 'Walker_Category_Checklist' ) ) {
				/**
				 * Custom walker for switching checkbox inputs to radio.
				 *
				 * @see Walker_Category_Checklist
				 */
				 class Walker_Category_Checklist extends Walker 
				 {
					function walk( $elements, $max_depth, $args = array() ) {
						$output = parent::walk( $elements, $max_depth, $args );
						$output = str_replace(
							array( 'type="checkbox"', "type='checkbox'" ),
							array( 'type="radio"', "type='radio'" ),
							$output
						);

						return $output;
					}
				}
			}

			$args['walker'] = new Walker_Category_Checklist;
		}
	}

	return $args;
}

/**
 * Filter tickets in admin table by author ID
 */
add_action( 'pre_get_posts', 'wast_filter_by_author' );
function wast_filter_by_author( $query ) {
	global $pagenow;
	if ( ! is_admin() ) {
		return;
	}

	if ( $pagenow == 'edit.php' && isset( $_GET['post_type'] ) && $_GET['post_type'] == 'ticket' ) {
		if ( isset( $_GET['_author_id'] ) && ctype_digit( $_GET['_author_id'] ) ) {
			$query->set( 'author', $_GET['_author_id'] );
		}
	}
}

/**
 * Add open numbers to ticket on admin menu
 *
 * @param $menu
 *
 * @return mixed
 */
add_filter( 'add_menu_classes', 'wast_show_open_number' );
function wast_show_open_number( $menu ) {
	$types = array( 'ticket' );
	foreach ( $types as $type ) {
		$open_count = wast_get_all_open_tickets();

		if ( $type == 'post' ) {
			$menu_str = 'edit.php';
		} else {
			$menu_str = 'edit.php?post_type=' . $type;
		}

		foreach ( $menu as $menu_key => $menu_data ) {
			if ( $menu_str != $menu_data[2] ) {
				continue;
			}
			$menu[ $menu_key ][0] .= " <span class='update-plugins count-$open_count'><span class='plugin-count'>" . number_format_i18n( $open_count ) . '</span></span>';
		}
	}

	return $menu;
}

/**
 * Filter open tickets in admin table by admin ID
 */
add_action( 'pre_get_posts', 'wast_filter_open_ticket_by_admin' );
function wast_filter_open_ticket_by_admin( $query ) {
	global $pagenow;
	if ( ! is_admin() ) {
		return;
	}

	if ( $pagenow == 'edit.php' && isset( $_GET['filter_open_ticket'] ) && ! empty( $_GET['filter_open_ticket'] ) ) {
		$user_terms = wast_get_user_ticket_types();
		$tax_query  = array(
			array(
				'taxonomy' => 'ticket-type',
				'field'    => 'term_id',
				'terms'    => $user_terms,
			),
		);
		$query->set( 'tax_query', $tax_query );
		$query->set( 'post_type', 'ticket' );
		$query->set( 'post_status', 'open' );
	}
}

/**
 * Filter tickets in admin table by admin ID
 * Prevent to view others tickets
 */
add_action( 'pre_get_posts', 'wast_filter_by_admin' );
function wast_filter_by_admin( $query ) {
	if ( current_user_can( 'manage_options' ) ) {
		return;
	}

	if ( ! wast_get_option( 'limit-access' ) ) {
		return;
	}

	global $pagenow;
	if ( ! is_admin() ) {
		return;
	}

	if ( $pagenow == 'edit.php' && isset( $_GET['post_type'] ) && $_GET['post_type'] == 'ticket' ) {
		$user_terms = wast_get_user_ticket_types();
		$tax_query  = array(
			array(
				'taxonomy' => 'ticket-type',
				'field'    => 'term_id',
				'terms'    => $user_terms,
			),
		);
		$query->set( 'tax_query', $tax_query );
		$query->set( 'post_type', 'ticket' );
	}

	if ( $pagenow == 'post.php' && isset( $_GET['post'] ) && ctype_digit( $_GET['post'] ) ) {
		$pt = get_post_type( $_GET['post'] );
		if ( $pt == 'ticket' ) {
			$terms = wp_get_post_terms( $_GET['post'], 'ticket-type' );
			if ( $terms && is_array( $terms ) ) {
				$term_id = $terms[0]->term_id;
				if ( ! in_array( $term_id, wast_get_user_ticket_types() ) ) {
					wp_safe_redirect( admin_url() );
				}
			}
		}
	}
}

/**
 * Disable the single view for a ticket post type
 */
add_action( 'template_redirect', 'wast_redirect_ticket_post' );
function wast_redirect_ticket_post() {
	$queried_post_type = get_query_var( 'post_type' );
	if ( is_single() && 'ticket' == $queried_post_type ) {
		wp_redirect( home_url() );
		exit;
	}
}