<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

add_action( 'wp_ajax_wast_search', 'wast_search_product' );

/**
 * Get all product by search term
 * and send with as json
 */
function wast_search_product() {
	check_ajax_referer( 'ajax_nonce', '_wast_nonce', true );

	$src_term = $_POST['searchTerm'];
	if ( ! $src_term ) {
		wast_make_response( [
			'_success' => false,
		] );
	}

	$html = '<ul>';

	$all_posts_args = array(
		'post_type'      => 'product',
		'posts_per_page' => - 1,
		's'              => $src_term,
	);
	$all_posts      = new WP_Query( $all_posts_args );
	if ( $all_posts->have_posts() ) {
		while ( $all_posts->have_posts() ) {
			$all_posts->the_post();
			$html .= '<li data-id="' . $all_posts->post->ID . '">' . get_the_title( $all_posts->post->ID ) . '</li>';
		}
	}

	$html .= '<ul>';

	wast_make_response( [
		'_success' => true,
		'_result'  => $html,
	] );
}

/**
 * Make ajax response
 *
 * @param $data
 */
function wast_make_response( $data ) {
	if ( is_array( $data ) ) {
		wp_send_json( $data );
	} else {
		die( $data );
	}
}