<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

use Melipayamak\MelipayamakApi;

class WAST_Send_SMS {

	/**
	 * Send sms
	 *
	 * @param $to
	 * @param $ticket_id
	 *
	 * @return bool
	 */
	public function send( $to, $ticket_id ) {
		if ( ! $to || ! intval( $ticket_id ) ) {
			return false;
		}

		$active   = wast_get_option( 'active-sms-notifications' );
		$service  = wast_get_option( 'sms-service' );
		$username = wast_get_option( 'sms-username' );
		$password = wast_get_option( 'sms-pass' );
		$from     = wast_get_option( 'sms-sender' );

		if ( ! $active || ! $service || ! $username || ! $password ) {
			return false;
		}

		$text = $this->get_message( $to, $ticket_id );

		$this->$service( $username, $password, $to, $from, $text );
	}

	/**
	 * Get message body
	 *
	 * @param $to
	 * @param $ticket_id
	 *
	 * @return mixed
	 */
	private function get_message( $to, $ticket_id ) {

		if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
			$user_arg = array( 'meta_key' => '_wast_mobile', 'meta_value' => $to );
		} else {
			$user_arg = array( 'meta_key' => 'billing_phone', 'meta_value' => $to );
		}
		$user = get_users( $user_arg );
		if ( ! $user ) {
			return false;
		}

		$recipient_display_name = $user[0]->data->display_name;

		$sender_id    = get_current_user_id();
		$user         = get_userdata( $sender_id );
		$display_name = $user->display_name;

		$product_id    = get_post_meta( $ticket_id, '_wast_ticket_product_id', true );
		$product_title = $product_id;
		if ( is_numeric( $product_id ) ) {
			$product_title = get_the_title( $product_id );
		}

		$ticket       = get_post( $ticket_id );
		$ticket_title = $ticket->post_title;

		$date = date_i18n( 'Y/m/d H:i', time() );

		$message = $ticket_title . PHP_EOL;
		$message .= 'سلام، ' . $recipient_display_name . ' عزیز' . PHP_EOL;
		$message .= 'کاربر ' . $display_name . ' در تاریخ ' . $date . ' یک تیکت پشتیبانی جدید در ارتباط با محصول ' . $product_title . ' ارسال کرده است.' . PHP_EOL;
		$message .= home_url() . PHP_EOL;
		$message .= get_bloginfo( 'name' );

		return $message;
	}

	/**
	 * Send SMS via melipayamak
	 *
	 * @param $username
	 * @param $password
	 * @param $to
	 * @param $from
	 * @param $text
	 */
	private function melipayamak( $username, $password, $to, $from, $text ) {
		require WAST_PATH . 'vendor/autoload.php';

		try {
			$api = new MelipayamakApi( $username, $password );
			$sms = $api->sms();
			$sms->send( $to, $from, $text );
		} catch ( Exception $e ) {
			//$e->getMessage();
		}
	}

	/**
	 * Send SMS via newsms
	 *
	 * @param $username
	 * @param $password
	 * @param $to
	 * @param $text
	 */
	private function newsms( $username, $password, $to, $text ) {
		$host         = "newsms.ir";
		$path         = "/API/default.aspx";
		$data_to_send = "username=$username&password=$password&to=$to&text=" . urlencode( $text );

		$fp   = fsockopen( $host, 80 );
		$outp = "POST $path HTTP/1.1\n";
		$outp .= "Host: $host\n";
		$outp .= "Content-type: application/x-www-form-urlencoded\n";
		$outp .= "Content-length: " . strlen( $data_to_send ) . "\n";
		$outp .= "Connection: close\n\n";
		$outp .= $data_to_send;
		fputs( $fp, $outp );
		fclose( $fp );
	}

	/**
	 * Send SMS via smsir
	 *
	 * @param $username
	 * @param $password
	 * @param $to
	 * @param $from
	 * @param $text
	 */
	private function smsir( $username, $password, $to, $from, $text ) {
		$content = 'user=' . rawurlencode( $username ) . '&pass=' . rawurlencode( $password ) . '&to=' . rawurlencode( $to ) . '&lineNo=' . rawurlencode( $from ) . '&text=' . rawurlencode( $text );

		$curlSession = curl_init();
		curl_setopt( $curlSession, CURLOPT_URL, 'http://ip.sms.ir/SendMessage.ashx?' . $content );
		curl_setopt( $curlSession, CURLOPT_BINARYTRANSFER, true );
		curl_setopt( $curlSession, CURLOPT_RETURNTRANSFER, true );
		curl_exec( $curlSession );
		curl_close( $curlSession );
	}

	/**
	 * Send SMS via payamresan
	 *
	 * @param $username
	 * @param $password
	 * @param $to
	 * @param $from
	 * @param $text
	 */
	private function payamresan( $username, $password, $to, $from, $text ) {
		$content = 'http://www.payam-resan.com/APISend.aspx?UserName=' . rawurlencode( $username ) . '&Password=' . rawurlencode( $password ) . '&To=' . rawurlencode( $to ) . '&From=' . rawurlencode( $from ) . '&Text=' . rawurlencode( $text );

		if ( extension_loaded( 'curl' ) ) {
			$curlSession = curl_init();
			curl_setopt( $curlSession, CURLOPT_URL, $content );
			curl_setopt( $curlSession, CURLOPT_BINARYTRANSFER, true );
			curl_setopt( $curlSession, CURLOPT_RETURNTRANSFER, true );
			curl_exec( $curlSession );
			curl_close( $curlSession );
		} else {
			//file_get_contents( $content );
		}
	}

	/**
	 * Send SMS via farapayamak
	 *
	 * @param $username
	 * @param $password
	 * @param $to
	 * @param $from
	 * @param $text
	 */
	private function farapayamak( $username, $password, $to, $from, $text ) {
		ini_set( "soap.wsdl_cache_enabled", "0" );
		try {
			$client = new SoapClient( 'http://api.payamak-panel.com/post/send.asmx?wsdl', array( 'encoding' => 'UTF-8' ) );

			$parameters['username'] = $username;
			$parameters['password'] = $password;
			$parameters['from']     = $from;
			$parameters['to']       = array( $to );
			$parameters['text']     = $text;
			$parameters['isflash']  = true;
			$parameters['udh']      = "";
			$parameters['recId']    = array( 0 );
			$parameters['status']   = 0x0;
			//$client->GetCredit( array( "username" => "wsdemo", "password" => "wsdemo" ) )->GetCreditResult;
			$client->SendSms( $parameters )->SendSmsResult;
			//echo $status;
		} catch ( SoapFault $ex ) {
			//echo $ex->faultstring;
		}
	}

	/**
	 * Send SMS via payamkutah
	 *
	 * @param $username
	 * @param $password
	 * @param $to
	 * @param $from
	 * @param $text
	 */
	private function payamkutah( $username, $password, $to, $from, $text ) {
		$url = "37.130.202.188/services.jspd";

		$rcpt_nm = array( $to );
		$param   = array(
			'uname'   => $username,
			'pass'    => $password,
			'from'    => $from,
			'message' => $text,
			'to'      => json_encode( $rcpt_nm ),
			'op'      => 'send'
		);

		$handler = curl_init( $url );
		curl_setopt( $handler, CURLOPT_CUSTOMREQUEST, "POST" );
		curl_setopt( $handler, CURLOPT_POSTFIELDS, $param );
		curl_setopt( $handler, CURLOPT_RETURNTRANSFER, true );
		$response2 = curl_exec( $handler );

		//$response2 = json_decode( $response2 );
		//$res_code  = $response2[0];
		//$res_data  = $response2[1];
	}

	/**
	 * Send SMS via zhiak
	 *
	 * @param $username
	 * @param $password
	 * @param $to
	 * @param $from
	 * @param $text
	 */
	private function zhiak( $username, $password, $to, $from, $text ) {
		ini_set( "soap.wsdl_cache_enabled", "0" );
		try {
			$client         = new SoapClient( "http://37.130.202.188/class/sms/wsdlservice/server.php?wsdl" );
			$user           = $username;
			$pass           = $password;
			$fromNum        = $from;
			$toNum          = array( $to );
			$messageContent = $text;
			$op             = "send";

			$time = '';

			$client->SendSMS( $fromNum, $toNum, $messageContent, $user, $pass, $time, $op );
			//echo $status;
		} catch ( SoapFault $ex ) {
			//echo $ex->faultstring;
		}
	}

	/**
	 * Send SMS via maxsms
	 *
	 * @param $username
	 * @param $password
	 * @param $to
	 * @param $from
	 * @param $text
	 */
	private function maxsms( $username, $password, $to, $from, $text ) {
		$url = "37.130.202.188/services.jspd";

		$rcpt_nm = array( $to );
		$param   = array(
			'uname'   => $username,
			'pass'    => $password,
			'from'    => $from,
			'message' => $text,
			'to'      => json_encode( $rcpt_nm ),
			'op'      => 'send'
		);

		$handler = curl_init( $url );
		curl_setopt( $handler, CURLOPT_CUSTOMREQUEST, "POST" );
		curl_setopt( $handler, CURLOPT_POSTFIELDS, $param );
		curl_setopt( $handler, CURLOPT_RETURNTRANSFER, true );
		$response2 = curl_exec( $handler );

		$response2 = json_decode( $response2 );
		$res_code  = $response2[0];
		$res_data  = $response2[1];

		//echo $res_data;
	}
}