<?php
/**
 * The common array lists of the plugin.
 *
 * @author  : Ginger Plugins <gingerplugins@gmail.com>
 * @license : GPL2
 * */

defined('ABSPATH') or die('Direct Access is not allowed');

class Ginger_Social_Icons
{


    /**
     * Social icons list
     *
     * @since  1.1.2
     * @return array The list of social icons
     */
    public static function icon_list()
    {
        return [
            "whatsapp"           => [
                'label'      => 'whatsapp',
                'title'      => 'WhatsApp',
                'value'      => 'Phone number ',
                'example'    => '1526459946',
                'color'      => '#4dc247',
                'icon'       => '<svg viewBox="0 0 56.693 56.693" xml:space="preserve" xmlns="http://www.w3.org/2000/svg"><path class="st0" d="m46.38 10.714c-4.6512-4.6565-10.836-7.222-17.427-7.2247-13.578 0-24.63 11.051-24.635 24.633-0.0019 4.342 1.1325 8.58 3.2884 12.316l-3.495 12.766 13.06-3.4257c3.5982 1.9626 7.6495 2.9971 11.773 2.9985h0.01 2e-4c13.577 0 24.629-11.052 24.635-24.635 0.0024-6.5826-2.5577-12.772-7.2088-17.428zm-17.426 37.902h-0.0083c-3.674-0.0014-7.2777-0.9886-10.422-2.8541l-0.7476-0.4437-7.7497 2.0328 2.0686-7.5558-0.4869-0.7748c-2.0496-3.26-3.1321-7.028-3.1305-10.897 0.0044-11.289 9.19-20.474 20.484-20.474 5.469 0.0017 10.61 2.1344 14.476 6.0047 3.8658 3.8703 5.9936 9.0148 5.9914 14.486-0.0046 11.29-9.1899 20.476-20.476 20.476z"/><path class="st0" d="m40.185 33.281c-0.6155-0.3081-3.6419-1.797-4.2061-2.0026-0.5642-0.2054-0.9746-0.3081-1.3849 0.3081-0.4103 0.6161-1.59 2.0027-1.9491 2.4136-0.359 0.4106-0.7182 0.4623-1.3336 0.1539-0.6155-0.3081-2.5989-0.958-4.95-3.0551-1.83-1.6323-3.0653-3.6479-3.4245-4.2643-0.359-0.6161-0.0382-0.9492 0.27-1.2562 0.2769-0.2759 0.6156-0.7189 0.9234-1.0784 0.3077-0.3593 0.4103-0.6163 0.6155-1.0268 0.2052-0.4109 0.1027-0.7704-0.0513-1.0784-0.1539-0.3081-1.3849-3.3379-1.8978-4.5706-0.4998-1.2001-1.0072-1.0375-1.3851-1.0566-0.3585-0.0179-0.7694-0.0216-1.1797-0.0216s-1.0773 0.1541-1.6414 0.7702c-0.5642 0.6163-2.1545 2.1056-2.1545 5.1351 0 3.0299 2.2057 5.9569 2.5135 6.3676 0.3077 0.411 4.3405 6.6282 10.515 9.2945 1.4686 0.6343 2.6152 1.013 3.5091 1.2966 1.4746 0.4686 2.8165 0.4024 3.8771 0.2439 1.1827-0.1767 3.6419-1.489 4.1548-2.9267 0.513-1.438 0.513-2.6706 0.359-2.9272-0.1538-0.2567-0.5642-0.4108-1.1797-0.719z"/></svg>',
                'class_name' => 'is-required',
            ],
            "facebook_messenger" => [
                'label'      => 'facebook_messenger',
                'title'      => 'Facebook Messenger',
                'value'      => 'Facebook page ID',
                'example'    => '100100010000100',
                'color'      => '#0075FF',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" height="909.333" viewBox="-21 -28 682.667 682" width="909.333"><path d="M545.602 84.63C485.242 30 405.125-.082 320-.082S154.758 30 94.398 84.63C33.523 139.727 0 213.133 0 291.332c0 58.578 18.863 114.742 54.633 162.94L27.14 626.188 201.06 561.94c37.828 13.81 77.805 20.81 118.94 20.81 85.125 0 165.242-30.086 225.602-84.715C606.477 442.938 640 369.53 640 291.332S606.477 139.727 545.602 84.63zM348.047 375.027l-70.738-55.344-169.203 66.965L301.71 194.086l71.594 57.168 154.875-60.047zm0 0"/></svg>',
                'class_name' => 'is-required is-facebook',
            ],
            "viber"              => [
                'label'      => 'viber',
                'title'      => 'Viber',
                'value'      => 'Phone number',
                'example'    => '+1526459946',
                'color'      => '#774D99',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M11.398.002C9.473.028 5.33.344 3.014 2.467c-1.72 1.7-2.32 4.23-2.39 7.353-.06 3.1-.13 8.95 5.5 10.54v2.42s-.038.97.602 1.17c.8.25 1.24-.5 2-1.3l1.4-1.58c3.85.32 6.8-.42 7.14-.53.78-.25 5.18-.81 5.9-6.652.74-6.03-.36-9.83-2.34-11.55l-.01-.002c-.6-.55-3-2.3-8.37-2.32 0 0-.396-.025-1.038-.016zm.067 1.697c.545-.003.88.02.88.02 4.54.01 6.71 1.38 7.22 1.84 1.67 1.43 2.528 4.856 1.9 9.892-.6 4.88-4.17 5.2-4.83 5.4-.28.1-2.88.73-6.152.52 0 0-2.44 2.94-3.2 3.7-.12.13-.26.17-.35.15-.13-.03-.17-.2-.16-.4l.02-4.02c-4.77-1.32-4.49-6.302-4.44-8.902.06-2.6.55-4.732 2-6.172 1.957-1.77 5.475-2 7.1-2.02zm.36 2.6a.299.299 0 0 0-.3.299.3.3 0 0 0 .3.3 5.631 5.631 0 0 1 4.03 1.59c1.1 1.06 1.62 2.48 1.64 4.34a.3.3 0 0 0 .3.3v-.01a.3.3 0 0 0 .3-.3 6.451 6.451 0 0 0-1.81-4.76c-1.2-1.16-2.692-1.76-4.462-1.76zm-3.954.7a.955.955 0 0 0-.615.12h-.012c-.4.24-.788.54-1.148.94-.27.32-.42.64-.46.95a1.24 1.24 0 0 0 .05.541l.02.01a13.722 13.722 0 0 0 1.2 2.6 15.383 15.383 0 0 0 2.32 3.171l.03.04.04.03.06.06a15.603 15.603 0 0 0 3.18 2.33c1.32.72 2.122 1.06 2.602 1.2V17c.14.04.268.06.398.06a1.84 1.84 0 0 0 1.102-.472c.4-.35.7-.738.93-1.148v-.01c.23-.43.15-.84-.18-1.12a13.632 13.632 0 0 0-2.15-1.54c-.5-.28-1.03-.1-1.24.17l-.45.57c-.23.28-.65.24-.65.24l-.012.01c-3.12-.8-3.95-3.96-3.95-3.96s-.04-.43.25-.65l.56-.45c.27-.22.46-.74.17-1.25a13.522 13.522 0 0 0-1.54-2.15.843.843 0 0 0-.504-.3zm4.473.9a.3.3 0 0 0 .002.6 3.78 3.78 0 0 1 2.65 1.15 3.5 3.5 0 0 1 .9 2.57.3.3 0 0 0 .3.299l.01.012a.3.3 0 0 0 .3-.301c.03-1.2-.34-2.2-1.07-3s-1.75-1.25-3.05-1.34a.3.3 0 0 0-.042 0zm.5 1.62a.305.305 0 0 0-.018.611c1 .05 1.47.55 1.53 1.58a.3.3 0 0 0 .3.29h.01a.3.3 0 0 0 .29-.32c-.07-1.34-.8-2.09-2.1-2.16a.305.305 0 0 0-.012 0z"/></svg>',
                'class_name' => 'is-required',
            ],
            "line"               => [
                'label'      => 'line',
                'title'      => 'Line',
                'value'      => 'URL',
                'example'    => 'https://line.me/R/ti/p/@username',
                'color'      => '#1AD14C',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M19.365 9.863a.63.63 0 1 1 0 1.261H17.6v1.125h1.755a.63.63 0 0 1 .63.63.63.63 0 0 1-.63.629H16.98a.63.63 0 0 1-.627-.629v-4.77a.63.63 0 0 1 .63-.63h2.386a.63.63 0 1 1-.003 1.26H17.6v1.125h1.755zM15.5 12.88a.63.63 0 0 1-.432.596c-.064.02-.133.03-.2.03-.21 0-.39-.1-.5-.25L11.926 9.94v2.94a.63.63 0 0 1-.631.629.63.63 0 0 1-.626-.629v-4.77c0-.27.173-.5.43-.595a.58.58 0 0 1 .194-.033c.195 0 .375.104.495.254l2.462 3.33V8.108a.63.63 0 0 1 .63-.63c.345 0 .63.285.63.63v4.77zm-5.74 0a.63.63 0 0 1-.631.629.63.63 0 0 1-.627-.629v-4.77a.63.63 0 0 1 .63-.63.63.63 0 0 1 .628.63v4.77zm-2.466.63H4.917c-.345 0-.63-.285-.63-.63v-4.77c0-.345.285-.63.63-.63a.63.63 0 0 1 .63.63v4.14h1.756a.63.63 0 0 1 .629.63.63.63 0 0 1-.629.629M24 10.314c0-5.37-5.385-9.742-12-9.742S0 4.943 0 10.314c0 4.81 4.27 8.842 10.035 9.608.39.082.923.258 1.058.6.12.3.08.766.038 1.08l-.164 1.02c-.045.3-.24 1.186 1.05.645s6.916-4.078 9.436-6.975C23.176 14.393 24 12.458 24 10.314"/></svg>',
                'class_name' => 'is-required',
            ],
            "mail"               => [
                'label'      => "mail",
                'title'      => "Mail",
                'value'      => "Email address",
                'example'    => "email@domain.com",
                'color'      => '#F36D23',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M339.392 258.624L512 367.744V144.896zM0 144.896v222.848l172.608-109.12zM480 80H32C16.032 80 3.36 91.904.96 107.232L256 275.264l255.04-168.032C508.64 91.904 495.968 80 480 80zM310.08 277.952l-45.28 29.824a15.98 15.98 0 0 1-17.6 0l-45.28-29.856L1.024 404.992C3.488 420.192 16.096 432 32 432h448c15.904 0 28.512-11.808 30.976-27.008L310.08 277.952z"/></svg>',
                'class_name' => 'is-required is-email',
            ],
            "telegram"           => [
                'label'      => "telegram",
                'title'      => "Telegram",
                'value'      => "Username",
                'example'    => "myusername",
                'color'      => '#0088CC',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" height="512" viewBox="0 0 24 24" width="512"><path d="M9.417 15.18l-.397 5.584c.568 0 .814-.244 1.11-.537l2.663-2.545 5.518 4.04c1.012.564 1.725.267 1.998-.93L23.93 3.82h.001c.32-1.496-.54-2.08-1.527-1.714l-21.3 8.15c-1.453.564-1.43 1.374-.247 1.74L6.3 13.69l12.643-7.91c.595-.394 1.136-.176.69.218z"/></svg>',
                'class_name' => 'is-required',
            ],
            "vkontakte"          => [
                'label'      => "vkontakte",
                'title'      => "Vkontakte",
                'value'      => "Username",
                'example'    => "myusername",
                'color'      => '#45668E',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M20 13c.24-.45 1.1-1.74 1.73-2.7C23.65 7.46 24 6.86 24 6.5a.5.5 0 0 0-.5-.5H19a.5.5 0 0 0-.49.41c-.25 1.38-3.5 5.34-4 5.6-.2 0-.5-.52-.5-1.5V6.28a1.18 1.18 0 0 0-.24-.93C13.43 5 12.92 5 11.5 5 8.92 5 8 5.77 8 6.5a.46.46 0 0 0 .45.5S9 7.36 9 9.5a14.61 14.61 0 0 1-.13 2.5C7.6 11.77 5.84 8.6 5 6.32A.5.5 0 0 0 4.5 6h-4a.5.5 0 0 0-.5.59C.56 9.6 6.9 19 11 19h2c1.06 0 1.14-1.15 1.2-1.9s.1-1.1.3-1.1c.62 0 1.9 1.1 2.72 1.82S18.6 19 19 19h2.5c1.3 0 2.5 0 2.5-1 0-.38-.33-.82-2.23-3-.63-.7-1.48-1.64-1.77-2z" /></svg>',
                'class_name' => 'is-required',
            ],
            "sms"                => [
                'label'      => "sms",
                'title'      => "SMS",
                'value'      => "Phone number",
                'example'    => "+98456479746",
                'color'      => '#FF9F00',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 495.968 495.968"><path d="M423.984 0h-352c-35.296 0-64 28.704-64 64v288c0 35.296 28.704 64 64 64v63.968a16.02 16.02 0 0 0 9.216 14.496c2.144.992 4.48 1.504 6.784 1.504 3.68 0 7.328-1.248 10.24-3.712L189.776 416h234.208c35.296 0 64-28.704 64-64V64c0-35.296-28.704-64-64-64zm-304 192c26.464 0 48 21.536 48 48s-21.536 48-48 48h-32a16.01 16.01 0 0 1-16-16 16.01 16.01 0 0 1 16-16h32a16.01 16.01 0 0 0 16-16 16.01 16.01 0 0 0-16-16c-26.464 0-48-21.536-48-48s21.536-48 48-48h32a16.01 16.01 0 0 1 16 16 16.01 16.01 0 0 1-16 16h-32a16.01 16.01 0 0 0-16 16 16.01 16.01 0 0 0 16 16zm176 80a16.01 16.01 0 0 1-16 16 16.01 16.01 0 0 1-16-16v-60.224l-1.696 3.392c-5.44 10.848-23.2 10.848-28.64 0l-1.664-3.392V272a16.01 16.01 0 0 1-16 16 16.01 16.01 0 0 1-16-16V144c0-7.424 5.12-13.888 12.32-15.584 7.136-1.728 14.656 1.792 17.984 8.416l17.696 35.392 17.696-35.36c3.296-6.688 10.624-10.144 17.984-8.448 7.232 1.696 12.32 8.16 12.32 15.584v128zm80-80c26.464 0 48 21.536 48 48s-21.536 48-48 48h-32a16.01 16.01 0 0 1-16-16 16.01 16.01 0 0 1 16-16h32c8.8 0 16-7.168 16-16s-7.2-16-16-16c-26.464 0-48-21.536-48-48s21.536-48 48-48h32a16.01 16.01 0 0 1 16 16 16.01 16.01 0 0 1-16 16h-32c-8.8 0-16 7.168-16 16s7.2 16 16 16z"/></svg>',
                'class_name' => 'is-required',
            ],
            "phone"              => [
                'label'      => "phone",
                'title'      => "Phone",
                'value'      => "Phone number",
                'example'    => "+98456479746",
                'color'      => '#00bb70',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 405.333 405.333"><path d="M373.333 266.88c-25.003 0-49.493-3.904-72.704-11.563-11.328-3.904-24.192-.896-31.637 6.7l-46.016 34.752c-52.8-28.18-86.592-61.952-114.39-114.368l33.813-44.928c8.512-8.512 11.563-20.97 7.915-32.64-7.723-23.36-11.648-47.872-11.648-72.832 0-17.643-14.357-32-32-32H32C14.357 0 0 14.357 0 32c0 205.845 167.488 373.333 373.333 373.333 17.643 0 32-14.357 32-32V298.88c0-17.643-14.357-32-32-32z"/></svg>',
                'class_name' => 'is-required',
            ],
            "wechat"             => [
                'label'      => "wechat",
                'title'      => "WeChat",
                'value'      => "User ID",
                'example'    => "User ID",
                'color'      => '#00C80F',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" height="512" viewBox="0 0 24 24" width="512"><path d="M12.82 9.618c-7.242 3.732-2.425 13.745 6.6 11.13.842.327 1.592.857 2.408 1.25-.21-.7-.436-1.412-.676-2.11 2.8-1.995 3.414-4.818 2.38-7.138-1.616-3.677-6.776-5.183-10.72-3.133zm2.53 3.658c-.21.655-1.156.85-1.615.353-.506-.46-.31-1.424.355-1.63.734-.3 1.582.54 1.26 1.277zm4.78.094h.014c-.257.587-1.14.725-1.575.27-.21-.192-.27-.48-.344-.733.104-.46.42-.937.93-.96.705-.098 1.336.776.975 1.422z"/><path d="M17.414 8.248c-.436-2.144-1.936-3.955-3.824-5h.027v-.001C6.917-.54-1.425 4.742.187 10.97c.433 1.848 1.71 3.397 3.262 4.43-.3.853-.585 1.706-.855 2.565L5.52 16.4c1.17.377 2.415.56 3.66.52-1.538-4.412 2.407-9.086 8.234-8.67zm-6.077-2.56c.785-.316 1.713.345 1.65 1.2L13 6.89c.008.965-1.275 1.567-1.995.913-.747-.538-.535-1.845.342-2.115zM6.932 7.134c-.172.838-1.29 1.243-1.946.68-.76-.537-.546-1.868.345-2.14.873-.338 1.865.552 1.6 1.46z"/></svg>',
                'class_name' => 'is-required',
            ],
            "snapchat"           => [
                'label'      => "snapchat",
                'title'      => "Snapchat",
                'value'      => "Username",
                'example'    => "myusername",
                'color'      => '#FFFC00',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 511.976 511.976"><path d="M501.94 374.42c-68.448-11.264-99.296-81.376-100.544-84.352-.096-.192-.16-.384-.288-.576-3.488-7.104-4.32-12.96-2.4-17.408 3.744-8.768 18.08-13.312 27.552-16.32 2.752-.864 5.344-1.696 7.488-2.528 9.344-3.68 16-7.68 20.416-12.192 5.248-5.408 6.272-10.592 6.208-13.952-.16-8.192-6.432-15.488-16.448-19.04-3.36-1.376-7.232-2.112-11.136-2.112-2.656 0-6.624.352-10.368 2.112-8 3.744-15.168 5.792-21.344 6.08-3.264-.16-5.568-.864-7.072-1.536l.704-11.36c2.208-34.656 4.928-77.76-6.528-103.36-7.84-17.536-18.368-32.608-31.328-44.832-10.848-10.24-23.456-18.56-37.472-24.704-24.352-10.752-47.072-12.352-58.464-12.352h-1.28l-8.8.096c-11.36 0-34.112 1.6-58.528 12.352-13.984 6.144-26.528 14.432-37.344 24.672-12.896 12.224-23.392 27.264-31.2 44.736-11.456 25.568-8.736 68.672-6.56 103.296v.064l.704 11.36c-1.664.736-4.384 1.568-8.384 1.568-6.464 0-14.144-2.048-22.816-6.112-2.56-1.184-5.472-1.792-8.672-1.792-5.152 0-10.624 1.504-15.328 4.288-5.952 3.488-9.792 8.384-10.848 13.856-.672 3.584-.64 10.72 7.296 17.952 4.384 3.968 10.784 7.648 19.072 10.912 2.176.864 4.768 1.664 7.488 2.528 9.472 3.008 23.84 7.552 27.584 16.32 1.888 4.448 1.056 10.304-2.432 17.408-.096.192-.192.384-.256.576-.896 2.048-9.056 20.448-25.792 39.872-9.504 11.04-19.968 20.288-31.104 27.456-13.6 8.768-28.288 14.464-43.68 16.992-6.048.992-10.368 6.368-10.016 12.48.096 1.76.512 3.52 1.248 5.216v.032c2.464 5.728 8.128 10.56 17.344 14.816 11.264 5.216 28.096 9.6 50.08 13.024 1.12 2.112 2.272 7.392 3.072 11.008.832 3.84 1.696 7.808 2.944 12 1.344 4.544 4.8 9.984 13.728 9.984 3.392 0 7.264-.768 11.776-1.632 6.592-1.28 15.616-3.04 26.848-3.04 6.24 0 12.704.544 19.2 1.632 12.544 2.08 23.36 9.696 35.872 18.528 18.304 12.928 39.04 27.552 70.72 27.552.864 0 1.728-.032 2.592-.096a62.21 62.21 0 0 0 3.68.096c31.68 0 52.416-14.624 70.72-27.52l.032-.032c12.512-8.8 23.328-16.416 35.872-18.496 6.496-1.088 12.96-1.632 19.2-1.632 10.752 0 19.264 1.376 26.848 2.848 4.96.96 8.8 1.44 11.776 1.44h.576c6.528 0 11.328-3.584 13.152-9.824 1.216-4.128 2.08-7.968 2.944-11.904.736-3.392 1.952-8.832 3.04-10.944 21.984-3.456 38.816-7.808 50.08-13.024 9.184-4.256 14.848-9.088 17.312-14.784.736-1.696 1.184-3.456 1.28-5.28.352-6.048-3.968-11.456-10.016-12.416z"/></svg>',
                'class_name' => 'is-required',
            ],
            "linkedin"           => [
                'label'      => "linkedin",
                'title'      => "Linkedin",
                'value'      => "Username",
                'example'    => "https://linkedin.com/in/username",
                'color'      => '#0074B2',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" height="512" viewBox="0 0 24 24" width="512"><path d="M23.994 24H24v-8.802c0-4.306-.927-7.623-5.96-7.623-2.42 0-4.044 1.328-4.707 2.587h-.07V7.976H8.5V24h4.97v-7.934c0-2.1.396-4.1 2.983-4.1 2.55 0 2.587 2.384 2.587 4.243V24zM.396 7.977h4.976V24H.396zM2.882 0A2.88 2.88 0 0 0 0 2.882c0 1.592 1.3 2.9 2.882 2.9s2.882-1.318 2.882-2.9S4.472 0 2.882 0z"/></svg>',
                'class_name' => 'is-required',
            ],
            "twitter"            => [
                'label'      => "twitter",
                'title'      => "Twitter",
                'value'      => "Username",
                'example'    => "myusername",
                'color'      => '#000000',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><path d="M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8L200.7 275.5 26.8 48H172.4L272.9 180.9 389.2 48zM364.4 421.8h39.1L151.1 88h-42L364.4 421.8z"/></svg>',
                'class_name' => 'is-required',
            ],
            "slack"              => [
                'label'      => "slack",
                'title'      => "Slack",
                'value'      => "Workplace URL",
                'example'    => "https://workplace.slack.com",
                'color'      => '#541755',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" ><path d="M8.843 12.65a2.52 2.52 0 0 0-2.521 2.521v6.306a2.521 2.521 0 1 0 5.042 0V15.17a2.52 2.52 0 0 0-2.52-2.52zM.02 15.172c0 1.393 1.13 2.523 2.523 2.523s2.523-1.13 2.523-2.523V12.65h-2.52C1.15 12.65.02 13.78.02 15.172z" class="fill-color" fill="#e91e63"/><path d="M8.846-.001C7.45-.001 6.32 1.13 6.32 2.522s1.13 2.523 2.523 2.523h2.52V2.522A2.52 2.52 0 0 0 8.846-.001zm-6.32 11.37h6.318c1.393 0 2.523-1.13 2.523-2.523s-1.13-2.523-2.523-2.523H2.525c-1.393 0-2.523 1.13-2.523 2.523s1.13 2.523 2.523 2.523z" class="fill-color" fill="#00bcd4"/><path d="M21.457 6.323a2.52 2.52 0 0 0-2.518 2.518v2.528h2.52c1.393 0 2.523-1.13 2.523-2.523s-1.13-2.523-2.523-2.523zm-8.817-3.8v6.325a2.521 2.521 0 1 0 5.042 0V2.522a2.521 2.521 0 1 0-5.042 0z" class="fill-color" fill="#4caf50"/><path d="M17.682 21.476a2.52 2.52 0 0 0-2.521-2.521h-2.52v2.523a2.521 2.521 0 0 0 5.042-.002zm3.798-8.826h-6.32c-1.393 0-2.523 1.13-2.523 2.523s1.13 2.523 2.523 2.523h6.318c1.393 0 2.523-1.13 2.523-2.523s-1.13-2.523-2.523-2.523z" class="fill-color" fill="#ff9800"/></svg>',
                'class_name' => 'is-required',
            ],
            "instagram"          => [
                'label'      => "instagram",
                'title'      => "Instagram",
                'value'      => "Username",
                'example'    => "myusername",
                'color'      => '#df0079',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12.004 5.838a6.16 6.16 0 0 0-6.158 6.158 6.16 6.16 0 0 0 6.158 6.158 6.16 6.16 0 0 0 6.158-6.158 6.16 6.16 0 0 0-6.158-6.158zm0 10.155c-2.2 0-3.997-1.8-3.997-3.997S9.796 8 12.004 8 16 9.788 16 11.996s-1.788 3.997-3.997 3.997zM16.948.076C14.74-.027 9.27-.022 7.06.076c-1.942.1-3.655.56-5.036 1.94-2.307 2.31-2.012 5.42-2.012 9.98 0 4.668-.26 7.706 2.013 9.98 2.317 2.316 5.472 2.013 9.98 2.013 4.624 0 6.22.003 7.855-.63 2.223-.863 3.9-2.85 4.065-6.42a161.35 161.35 0 0 0 0-9.887c-.2-4.212-2.46-6.768-6.977-6.976zm3.495 20.372c-1.513 1.513-3.612 1.378-8.468 1.378-5 0-7.005.074-8.468-1.393-1.685-1.677-1.38-4.37-1.38-8.453 0-5.525-.567-9.504 4.978-9.788 1.274-.045 1.65-.06 4.856-.06l.045.03c5.33 0 9.5-.558 9.76 4.986.057 1.265.07 1.645.07 4.847-.001 4.942.093 6.96-1.394 8.453z"/><circle cx="18.406" cy="5.595" r="1.439"/></svg>',
                'class_name' => 'is-required',
            ],
            "waze"               => [
                'label'      => "waze",
                'title'      => "Waze",
                'value'      => "URL",
                'example'    => "https://www.waze.com/ul?q=XXXXXXX",
                'color'      => '#75cae3',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" height="512" viewBox="0 0 24 24" width="512"><path d="M17.763 11.033c-.4-.085-.804.17-.9.577-.72 3.36-6.826 3.374-7.3.015a.75.75 0 1 0-1.485.213c.72 5.035 9.198 5.057 10.26.086a.75.75 0 0 0-.576-.891zm-1.36-.733a1.73 1.73 0 0 0 1.728-1.726 1.73 1.73 0 0 0-1.728-1.727 1.73 1.73 0 0 0-1.729 1.727 1.73 1.73 0 0 0 1.729 1.726zm.228-1.727c0 .25-.457.248-.457 0 .001-.3.457-.3.457 0zM10.533 10.3a1.73 1.73 0 0 0 1.728-1.726 1.73 1.73 0 0 0-1.728-1.727 1.73 1.73 0 0 0-1.729 1.727 1.73 1.73 0 0 0 1.729 1.726zm.228-1.727c0 .25-.457.248-.457 0 0-.3.457-.3.457 0zm6.67-6.82C13.725.328 9.635.962 6.483 3.46 3.26 6.042 3.025 9.13 2.87 11.175c-.146 1.914-.275 2.066-.935 2.066-.737 0-1.418.43-1.727 1.078-.33.656-.263 1.433.175 2.032 1.1 1.483 1.9 2 3.785 3.033.314.172.696.106.944-.223-.184.412-.26.878-.2 1.37.207 2.4 3.217 3.343 4.768 1.508a2.67 2.67 0 0 0 .624-1.691c.04.356.316.647.685.67a15.07 15.07 0 0 0 1.533.021c.385-.015.678-.32.707-.695.037 1.586 1.307 2.658 2.7 2.658.078 0 .156-.003.234-.01a2.69 2.69 0 0 0 2.067-1.263 2.67 2.67 0 0 0 .23-2.398c-.04-.108-.095-.208-.15-.308.23.268.642.385.965.192 3.457-2.088 5.27-5.94 4.618-9.813-.567-3.442-2.975-6.297-6.442-7.638zM7.7 21.496a1.21 1.21 0 0 1-1.306-1.104c-.083-.825.552-1.284 1.246-1.284.6 0 1.092.347 1.162 1.088.055.66-.437 1.242-1.102 1.3zm9.238-.564c-.204.325-.54.53-.923.564-1.055.094-1.713-1.143-1.035-1.962.6-.713 1.732-.523 2.06.332v.001c.137.354.1.742-.102 1.065zm1.605-3.043c-.33.154-.524.547-.38.92-.54-.808-1.5-1.292-2.482-1.203-.73.062-1.388.407-1.855.97-.385.464-.6 1.045-.6 1.627-.044-.385-.357-.68-.766-.665a13.17 13.17 0 0 1-1.382-.019.74.74 0 0 0-.775.63c-.002-.028.003-.056.001-.084C10.08 17.76 7.6 16.96 5.95 18.137c-.322.23-.558.528-.738.856.134-.346.007-.743-.327-.926-1.83-1-2.4-1.385-3.295-2.606a.45.45 0 0 1-.036-.484c.07-.146.215-.236.38-.236 2.167 0 2.307-1.834 2.43-3.452.152-1.998.342-4.483 3.053-6.657 2.73-2.16 6.27-2.7 9.472-1.47 2.967 1.147 5.023 3.57 5.503 6.484.546 3.24-.964 6.468-3.85 8.244z"/></svg>',
                'class_name' => 'is-required',
            ],
            "google-map"         => [
                'label'      => "google-map",
                'title'      => "Google Map",
                'value'      => "Google map URL",
                'example'    => "https://www.google.com/maps/place/*",
                'color'      => '#E84A35',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 511.999 511.999"><path d="M256 0C152.786 0 68.817 85.478 68.817 190.545c0 58.77 29.724 130.103 88.35 212.017 42.902 59.948 85.178 102.702 86.957 104.494a16.69 16.69 0 0 0 11.879 4.943c4.182 0 8.367-1.558 11.61-4.683 1.783-1.717 44.166-42.74 87.15-101.86 58.672-80.7 88.42-153.007 88.42-214.912C443.18 85.478 359.2 0 256 0zm0 272.806c-50.46 0-91.51-41.052-91.51-91.51s41.052-91.51 91.51-91.51 91.51 41.052 91.51 91.51-41.053 91.51-91.51 91.51z"/></svg>',
                'class_name' => 'is-required',
            ],
            "signal"             => [
                'label'      => "signal",
                'title'      => "Signal",
                'value'      => "Signal group link",
                'example'    => "https://signal.group/[group-id]",
                'color'      => '#3a76f0',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" width="170.667" height="170.667" viewBox="0 0 128 128"><path d="M55.4 1.4c-.3.8-.4 2.2-.2 3.1.2 1.4 1.7 1.7 8.8 1.7h8.5V3.3.5L64.2.2c-6.5-.2-8.3 0-8.8 1.2zm-11.9 2c-2.2.7-5.9 2.2-8.2 3.4-4 2.1-4.2 2.4-3.1 4.7 1.4 3.1 1.3 3.1 7.5 0 2.8-1.3 6.3-2.7 7.7-3.1 2.8-.7 2.9-.8 2-4.2-.7-2.5-.6-2.5-5.9-.8zm35.1 1.1c-.4 1.5-.6 2.8-.4 3 .2.1 3.1 1.2 6.6 2.5 3.4 1.2 6.5 2.7 6.8 3.1 1 1.7 3.1.9 4.2-1.7 1.2-2.4 1-2.6-5-5.4-9.7-4.5-11.4-4.7-12.2-1.5zm-26.2 9c-18.6 4-34.4 19.7-38.9 38.6-2.7 11.7-1.3 24.5 4 34.9l2.5 4.9-2.4 10.3c-1.4 5.6-2.4 10.4-2.3 10.5s4.9-.9 10.5-2.3l10.3-2.4 4.9 2.5c29.3 14.9 65.9-2.4 73.5-34.7 8.8-37.2-24.4-70.5-62.1-62.3zm-33.6 5.3c-3.2 3.3-5.8 6.3-5.8 6.8s1 1.5 2.1 2.3c2 1.2 2.6.8 8.1-4.7 5.4-5.3 5.9-6.2 4.9-8.1-.7-1.1-1.7-2.1-2.3-2.1s-3.7 2.6-7 5.8zm81.1-3.7c-1 1.9-.5 2.8 4.9 8.1 5.3 5.4 6.2 5.9 8.1 4.9 1.1-.7 2.1-1.7 2.1-2.3 0-1.5-11.3-12.8-12.8-12.8-.6 0-1.6 1-2.3 2.1zM6 37.2c-4.5 9.7-4.7 11.4-1.5 12.2 1.5.4 2.8.6 3 .4.1-.2 1.2-3.1 2.5-6.6 1.2-3.4 2.7-6.5 3.1-6.8 1.7-1 .9-3.1-1.7-4.2-2.4-1.2-2.6-1-5.4 5zm110.5-5l-2.4 1.4c-.1.1.8 2.7 2.2 5.6 1.4 3 2.9 6.6 3.3 8.2.6 2.4 1 2.7 3.3 2.1 1.4-.4 2.8-.8 2.9-1 .8-.8-6-17.6-7.1-17.5-.1 0-1.1.6-2.2 1.2zM.4 56.3c-.3.8-.4 4.7-.2 8.8.3 7.4.3 7.4 3.1 7.4h2.9V64c0-8.4 0-8.5-2.6-8.8C2 55 .8 55.4.4 56.3zm121.6-.9c-.1.3-.1 4.3-.1 8.8l-.1 8.3h2.9 2.8V64v-8.5l-2.7-.3c-1.6-.2-2.8-.1-2.8.2zM3.7 78.7c-2.2.6-1.8 3.1 1.8 11 1.8 4 2.2 6 1.5 8.2-.7 2.6-.5 3 1.6 3.5 3.4.9 4 .3 4.7-4.1.5-2.8 0-5-1.8-8.8-1.3-2.8-2.7-6.3-3-7.8-.7-2.7-1.3-2.9-4.8-2zm115.5 3c-.6 2.1-2 5.6-3.1 7.7-2.2 4.2-2.1 5 .9 6.6 1.7.9 2.3.4 4.3-3.7 2.6-5.2 5.1-12.2 4.5-12.8-.1-.2-1.5-.6-2.9-1-2.3-.6-2.7-.2-3.7 3.2zm-14.6 23.2c-5.2 5.2-5.7 6.1-4.7 8 .7 1.1 1.6 2.1 2 2.1 1.3 0 11-8.9 12.3-11.3.8-1.6.7-2.3-.8-3.4-1-.7-2-1.3-2.4-1.3-.3 0-3.2 2.6-6.4 5.9zM3.5 113c-2.7 11.1-.4 14.1 9.4 12.1 8.5-1.9 9-2.1 8.5-3.7l-.8-2.8c-.4-1.2-1.3-1.3-6.3-.1-3.2.7-5.9 1.3-6 1.2s.5-2.8 1.2-6c1.2-5 1.1-5.9-.1-6.3-.8-.2-2-.6-2.8-.8-1-.3-1.9 1.4-3.1 6.4zm26.5 1.7c-3.5.6-4.2 1.6-3.5 4.6.6 2.3 1 2.4 3.7 1.6 2.3-.6 3.9-.4 6.7 1 4.2 2.1 11.1 4.5 11.6 3.9.2-.1.6-1.5 1-2.9.6-2.3.3-2.7-2-3.3-1.5-.4-5-1.8-7.8-3.1-2.8-1.4-5.6-2.4-6.1-2.4l-3.6.6zm61.6.2c-.3.4-3.4 1.9-6.8 3.1l-6.6 2.5c-.2.2 0 1.5.4 3 .8 3.2 2.2 3 12-1.5 6.2-2.8 6.4-3 5.2-5.4-1.1-2.6-3.2-3.4-4.2-1.7zm-36.3 7.8c-.3.6-.3 2-.1 3 .3 1.6 1.4 1.8 8.8 1.8h8.5v-2.8-2.9l-8.4-.1c-5.7-.1-8.5.2-8.8 1z"/></svg>',
                'class_name' => 'is-required',
                'help_link'  => 'https://support.signal.org/hc/en-us/articles/360051086971-Group-Link-or-QR-code',
            ],
            "tiktok"             => [
                'label'      => "tiktok",
                'title'      => "TikTok",
                'value'      => "Username",
                'example'    => "https://www.tiktok.com/@[username]",
                'color'      => '#000000',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M448 209.91a210.06 210.06 0 0 1-122.77-39.25v178.72A162.55 162.55 0 1 1 185 188.31v89.89a74.62 74.62 0 1 0 52.23 71.18V0h88a121.18 121.18 0 0 0 1.86 22.17h0A122.18 122.18 0 0 0 381 102.39a121.43 121.43 0 0 0 67 20.14z"/></svg>',
                'class_name' => 'is-required',
            ],
            "contact_form"       => [
                'label'      => "contact_form",
                'title'      => "Contact Form",
                'value'      => "Username",
                'example'    => "https://www.tiktok.com/@[username]",
                'color'      => '#736bc4',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><path d="M384 48c8.8 0 16 7.2 16 16V448c0 8.8-7.2 16-16 16H96c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16H384zM96 0C60.7 0 32 28.7 32 64V448c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H96zM240 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-32 32c-44.2 0-80 35.8-80 80c0 8.8 7.2 16 16 16H336c8.8 0 16-7.2 16-16c0-44.2-35.8-80-80-80H208zM512 80c0-8.8-7.2-16-16-16s-16 7.2-16 16v64c0 8.8 7.2 16 16 16s16-7.2 16-16V80zM496 192c-8.8 0-16 7.2-16 16v64c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16zm16 144c0-8.8-7.2-16-16-16s-16 7.2-16 16v64c0 8.8 7.2 16 16 16s16-7.2 16-16V336z"/></svg>',
                'class_name' => 'is-required',
            ],
            "discord"            => [
                'label'      => "discord",
                'title'      => "Discord",
                'value'      => "Discord URL",
                'example'    => "https://discord.gg/xyz",
                'color'      => '#5865F2',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M524.531 69.836a1.5 1.5 0 0 0-.764-.7A485.065 485.065 0 0 0 404.081 32.03a1.816 1.816 0 0 0-1.923.91 337.461 337.461 0 0 0-14.9 30.6 447.848 447.848 0 0 0-134.426 0 309.541 309.541 0 0 0-15.135-30.6 1.89 1.89 0 0 0-1.924-.91 483.689 483.689 0 0 0-119.688 37.107 1.712 1.712 0 0 0-.788.676C39.068 183.651 18.186 294.69 28.43 404.354a2.016 2.016 0 0 0 .765 1.375 487.666 487.666 0 0 0 146.825 74.189 1.9 1.9 0 0 0 2.063-.676A348.2 348.2 0 0 0 208.12 430.4a1.86 1.86 0 0 0-1.019-2.588 321.173 321.173 0 0 1-45.868-21.853 1.885 1.885 0 0 1-.185-3.126c3.082-2.309 6.166-4.711 9.109-7.137a1.819 1.819 0 0 1 1.9-.256c96.229 43.917 200.41 43.917 295.5 0a1.812 1.812 0 0 1 1.924.233c2.944 2.426 6.027 4.851 9.132 7.16a1.884 1.884 0 0 1-.162 3.126 301.407 301.407 0 0 1-45.89 21.83 1.875 1.875 0 0 0-1 2.611 391.055 391.055 0 0 0 30.014 48.815 1.864 1.864 0 0 0 2.063.7A486.048 486.048 0 0 0 610.7 405.729a1.882 1.882 0 0 0 .765-1.352c12.264-126.783-20.532-236.912-86.934-334.541zM222.491 337.58c-28.972 0-52.844-26.587-52.844-59.239s23.409-59.241 52.844-59.241c29.665 0 53.306 26.82 52.843 59.239 0 32.654-23.41 59.241-52.843 59.241zm195.38 0c-28.971 0-52.843-26.587-52.843-59.239s23.409-59.241 52.843-59.241c29.667 0 53.307 26.82 52.844 59.239 0 32.654-23.177 59.241-52.844 59.241z"/></svg>',
                'class_name' => 'is-required',
            ],
            'microsoft_teams'    => [
                'label'      => "microsoft_teams",
                'title'      => "Microsoft Teams",
                'value'      => "URL",
                'example'    => "https://teams.microsoft.com/join/abcde",
                'color'      => '#4b53bc',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="#d1d1d1"><path d="M9.186 4.797a2.42 2.42 0 1 0-2.86-2.448h1.178a1.68 1.68 0 0 1 1.682 1.682zm-4.295 7.738h2.613a1.68 1.68 0 0 0 1.682-1.682V5.58h2.783a.7.7 0 0 1 .682.716v4.294a4.197 4.197 0 0 1-4.093 4.293c-1.618-.04-3-.99-3.667-2.35zm10.737-9.372a1.675 1.675 0 1 1-3.349 0 1.675 1.675 0 0 1 3.349 0m-2.238 9.488l-.12-.002a5.2 5.2 0 0 0 .381-2.07V6.306a1.7 1.7 0 0 0-.15-.725h1.792a.71.71 0 0 1 .707.707v3.765a2.6 2.6 0 0 1-2.598 2.598zM.682 3.349h6.822a.68.68 0 0 1 .682.682v6.822a.68.68 0 0 1-.682.682H.682A.68.68 0 0 1 0 10.853V4.03a.68.68 0 0 1 .682-.682zm5.206 2.596v-.72h-3.59v.72h1.357V9.66h.87V5.945z"/></svg>',
                'class_name' => 'is-required',
            ],
            'zalo'               => [
                'label'      => "zalo",
                'title'      => "Zalo",
                'value'      => "URL",
                'example'    => "https://zalo.me/0123456789",
                'color'      => '#2196F3',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="50" height="50" viewBox="0 0 50 50"> <path d="M 9 4 C 6.2504839 4 4 6.2504839 4 9 L 4 41 C 4 43.749516 6.2504839 46 9 46 L 41 46 C 43.749516 46 46 43.749516 46 41 L 46 9 C 46 6.2504839 43.749516 4 41 4 L 9 4 z M 9 6 L 15.580078 6 C 12.00899 9.7156859 10 14.518083 10 19.5 C 10 24.66 12.110156 29.599844 15.910156 33.339844 C 16.030156 33.549844 16.129922 34.579531 15.669922 35.769531 C 15.379922 36.519531 14.799687 37.499141 13.679688 37.869141 C 13.249688 38.009141 12.97 38.430859 13 38.880859 C 13.03 39.330859 13.360781 39.710781 13.800781 39.800781 C 16.670781 40.370781 18.529297 39.510078 20.029297 38.830078 C 21.379297 38.210078 22.270625 37.789609 23.640625 38.349609 C 26.440625 39.439609 29.42 40 32.5 40 C 36.593685 40 40.531459 39.000731 44 37.113281 L 44 41 C 44 42.668484 42.668484 44 41 44 L 9 44 C 7.3315161 44 6 42.668484 6 41 L 6 9 C 6 7.3315161 7.3315161 6 9 6 z M 33 15 C 33.55 15 34 15.45 34 16 L 34 25 C 34 25.55 33.55 26 33 26 C 32.45 26 32 25.55 32 25 L 32 16 C 32 15.45 32.45 15 33 15 z M 18 16 L 23 16 C 23.36 16 23.700859 16.199531 23.880859 16.519531 C 24.050859 16.829531 24.039609 17.219297 23.849609 17.529297 L 19.800781 24 L 23 24 C 23.55 24 24 24.45 24 25 C 24 25.55 23.55 26 23 26 L 18 26 C 17.64 26 17.299141 25.800469 17.119141 25.480469 C 16.949141 25.170469 16.960391 24.780703 17.150391 24.470703 L 21.199219 18 L 18 18 C 17.45 18 17 17.55 17 17 C 17 16.45 17.45 16 18 16 z M 27.5 19 C 28.11 19 28.679453 19.169219 29.189453 19.449219 C 29.369453 19.189219 29.65 19 30 19 C 30.55 19 31 19.45 31 20 L 31 25 C 31 25.55 30.55 26 30 26 C 29.65 26 29.369453 25.810781 29.189453 25.550781 C 28.679453 25.830781 28.11 26 27.5 26 C 25.57 26 24 24.43 24 22.5 C 24 20.57 25.57 19 27.5 19 z M 38.5 19 C 40.43 19 42 20.57 42 22.5 C 42 24.43 40.43 26 38.5 26 C 36.57 26 35 24.43 35 22.5 C 35 20.57 36.57 19 38.5 19 z M 27.5 21 C 27.39625 21 27.29502 21.011309 27.197266 21.03125 C 27.001758 21.071133 26.819727 21.148164 26.660156 21.255859 C 26.500586 21.363555 26.363555 21.500586 26.255859 21.660156 C 26.148164 21.819727 26.071133 22.001758 26.03125 22.197266 C 26.011309 22.29502 26 22.39625 26 22.5 C 26 22.60375 26.011309 22.70498 26.03125 22.802734 C 26.051191 22.900488 26.079297 22.994219 26.117188 23.083984 C 26.155078 23.17375 26.202012 23.260059 26.255859 23.339844 C 26.309707 23.419629 26.371641 23.492734 26.439453 23.560547 C 26.507266 23.628359 26.580371 23.690293 26.660156 23.744141 C 26.819727 23.851836 27.001758 23.928867 27.197266 23.96875 C 27.29502 23.988691 27.39625 24 27.5 24 C 27.60375 24 27.70498 23.988691 27.802734 23.96875 C 28.487012 23.82916 29 23.22625 29 22.5 C 29 21.67 28.33 21 27.5 21 z M 38.5 21 C 38.39625 21 38.29502 21.011309 38.197266 21.03125 C 38.099512 21.051191 38.005781 21.079297 37.916016 21.117188 C 37.82625 21.155078 37.739941 21.202012 37.660156 21.255859 C 37.580371 21.309707 37.507266 21.371641 37.439453 21.439453 C 37.303828 21.575078 37.192969 21.736484 37.117188 21.916016 C 37.079297 22.005781 37.051191 22.099512 37.03125 22.197266 C 37.011309 22.29502 37 22.39625 37 22.5 C 37 22.60375 37.011309 22.70498 37.03125 22.802734 C 37.051191 22.900488 37.079297 22.994219 37.117188 23.083984 C 37.155078 23.17375 37.202012 23.260059 37.255859 23.339844 C 37.309707 23.419629 37.371641 23.492734 37.439453 23.560547 C 37.507266 23.628359 37.580371 23.690293 37.660156 23.744141 C 37.739941 23.797988 37.82625 23.844922 37.916016 23.882812 C 38.005781 23.920703 38.099512 23.948809 38.197266 23.96875 C 38.29502 23.988691 38.39625 24 38.5 24 C 38.60375 24 38.70498 23.988691 38.802734 23.96875 C 39.487012 23.82916 40 23.22625 40 22.5 C 40 21.67 39.33 21 38.5 21 z"></path> </svg>',
                'class_name' => 'is-required',
            ],
            "link"               => [
                'label'      => "link",
                'title'      => "Custom Link",
                'value'      => "Link",
                'example'    => "https://www.example.com/",
                'color'      => '#0068aa',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512.092 512.092"><path d="M312.453 199.6c-6.066-6.102-12.792-11.5-20.053-16.128a119.47 119.47 0 0 0-64.427-18.859 118.95 118.95 0 0 0-84.48 34.987L34.95 308.23C12.613 330.6.06 360.93.04 392.548c-.042 65.98 53.4 119.5 119.4 119.543a118.7 118.7 0 0 0 84.395-34.816l89.6-89.6c1.628-1.614 2.537-3.816 2.524-6.108-.027-4.713-3.87-8.5-8.583-8.484h-3.413c-18.72.066-37.273-3.53-54.613-10.58a8.53 8.53 0 0 0-9.3 1.877l-64.44 64.5c-20.006 20.006-52.442 20.006-72.448 0s-20.006-52.442 0-72.448l108.97-108.885c20-19.965 52.373-19.965 72.363 0 13.472 12.68 34.486 12.68 47.957 0a34.19 34.19 0 0 0 9.9-21.675 34.14 34.14 0 0 0-9.9-26.282zM477.06 34.993c-46.657-46.657-122.303-46.657-168.96 0l-89.515 89.43c-2.458 2.47-3.167 6.185-1.792 9.387a8.53 8.53 0 0 0 8.021 5.205h3.157a143.38 143.38 0 0 1 54.528 10.667 8.53 8.53 0 0 0 9.3-1.877l64.256-64.17c20.006-20.006 52.442-20.006 72.448 0s20.006 52.442 0 72.448L348.46 236.04l-.683.768-28 27.82c-20 19.965-52.373 19.965-72.363 0-13.472-12.68-34.486-12.68-47.957 0a34.14 34.14 0 0 0-9.899 21.845 34.13 34.13 0 0 0 9.9 26.283c9.877 9.92 21.433 18.008 34.133 23.893 1.792.853 3.584 1.536 5.376 2.304s3.67 1.365 5.46 2.048 3.67 1.28 5.46 1.792l5.035 1.365c3.413.853 6.827 1.536 10.325 2.133 4.214.626 8.458 1.025 12.715 1.195h6.485l5.12-.597c1.877-.085 3.84-.512 6.06-.512h2.9l5.888-.853 2.73-.512 4.95-1.024h.94a119.46 119.46 0 0 0 55.38-31.403l108.63-108.63c46.66-46.657 46.66-122.303.003-168.96z"/></svg>',
                'class_name' => 'is-required',
            ],
            "custom-link"        => [
                'label'      => "custom-link",
                'title'      => "Custom Link",
                'value'      => "Link",
                'example'    => "https://www.example.com/",
                'color'      => '#F83F3C',
                'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512.092 512.092"><path d="M312.453 199.6c-6.066-6.102-12.792-11.5-20.053-16.128a119.47 119.47 0 0 0-64.427-18.859 118.95 118.95 0 0 0-84.48 34.987L34.95 308.23C12.613 330.6.06 360.93.04 392.548c-.042 65.98 53.4 119.5 119.4 119.543a118.7 118.7 0 0 0 84.395-34.816l89.6-89.6c1.628-1.614 2.537-3.816 2.524-6.108-.027-4.713-3.87-8.5-8.583-8.484h-3.413c-18.72.066-37.273-3.53-54.613-10.58a8.53 8.53 0 0 0-9.3 1.877l-64.44 64.5c-20.006 20.006-52.442 20.006-72.448 0s-20.006-52.442 0-72.448l108.97-108.885c20-19.965 52.373-19.965 72.363 0 13.472 12.68 34.486 12.68 47.957 0a34.19 34.19 0 0 0 9.9-21.675 34.14 34.14 0 0 0-9.9-26.282zM477.06 34.993c-46.657-46.657-122.303-46.657-168.96 0l-89.515 89.43c-2.458 2.47-3.167 6.185-1.792 9.387a8.53 8.53 0 0 0 8.021 5.205h3.157a143.38 143.38 0 0 1 54.528 10.667 8.53 8.53 0 0 0 9.3-1.877l64.256-64.17c20.006-20.006 52.442-20.006 72.448 0s20.006 52.442 0 72.448L348.46 236.04l-.683.768-28 27.82c-20 19.965-52.373 19.965-72.363 0-13.472-12.68-34.486-12.68-47.957 0a34.14 34.14 0 0 0-9.899 21.845 34.13 34.13 0 0 0 9.9 26.283c9.877 9.92 21.433 18.008 34.133 23.893 1.792.853 3.584 1.536 5.376 2.304s3.67 1.365 5.46 2.048 3.67 1.28 5.46 1.792l5.035 1.365c3.413.853 6.827 1.536 10.325 2.133 4.214.626 8.458 1.025 12.715 1.195h6.485l5.12-.597c1.877-.085 3.84-.512 6.06-.512h2.9l5.888-.853 2.73-.512 4.95-1.024h.94a119.46 119.46 0 0 0 55.38-31.403l108.63-108.63c46.66-46.657 46.66-122.303.003-168.96z"/></svg>',
                'class_name' => 'is-required',
            ],
        ];

    }//end icon_list()


    /**
     * Color list
     *
     * This function returns an array of predefined colors.
     * The colors can be used for various purposes such as styling elements or providing color options.
     *
     * @since  1.1.2
     * @return array The list of colors
     */
    public static function color_list()
    {
        return [
            '#000000',
        // Black.
            '#ffffff',
        // White.
            '#16D39A',
        // Teal.
            '#1c5fc6',
        // Blue.
            '#7C4DFF',
        // Purple.
            '#FF5370',
        // Red.
            '#e64056',
        // Salmon.
            '#ff5e3a',
        // Orange.
        ];

    }//end color_list()


    /**
     * Chat icons list
     *
     * This function returns an associative array containing various chat icons along with their labels, disabled status, and SVG code.
     * The icons can be used for displaying different types of chat-related elements.
     *
     * @since  1.1.2
     * @return array The list of chat icons
     */
    public static function get_chat_icons()
    {
        return [
            "chat-line"   => [
                "label"    => "chat-line",
                "disabled" => "",
                "icon"     => '<svg style="enable-background:new 1 -1 100 100;" version="1.1" viewBox="1 -1 100 100" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M82,9.5H20c-5.5,0-10,4.5-10,10v42c0,5.5,4.5,10,10,10h8v17l25-17h29c5.5,0,10-4.5,10-10v-42C92,14,87.5,9.5,82,9.5z   M31.8,29.5h20.4c1.7,0,3,1.3,3,3s-1.3,3-3,3H31.8c-1.6,0-3-1.3-3-3C28.8,30.9,30.1,29.5,31.8,29.5z M68.2,49.5H31.8  c-1.6,0-3-1.3-3-3c0-1.6,1.3-3,3-3h36.4c1.7,0,3,1.3,3,3S69.9,49.5,68.2,49.5z"/></svg>',
            ],
            "bubble"      => [
                "label"    => "bubble",
                "disabled" => "",
                "icon"     => '<svg style="enable-background:new 0 0 512 512;" version="1.1" viewBox="0 0 512 512" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><g><path d="M221.4,81.6C102.4,81.6,6,153.7,6,242.7C6,295.8,40.5,343,93.6,372.3c-5.2,18.1-17.3,40.6-45.3,56.4   c0,0,52.9,13.5,97.9-35.1c23.4,6.5,48.8,10.1,75.3,10.1c119,0,215.4-72.1,215.4-161S340.4,81.6,221.4,81.6z M122.3,208.5   c18.9,0,34.1,15.3,34.1,34.1c0,18.9-15.3,34.1-34.1,34.1c-18.9,0-34.1-15.3-34.1-34.1C88.1,223.8,103.4,208.5,122.3,208.5z    M221.4,276.8c-18.9,0-34.1-15.3-34.1-34.1c0-18.9,15.3-34.1,34.1-34.1s34.1,15.3,34.1,34.1C255.6,261.5,240.3,276.8,221.4,276.8z    M320.6,276.8c-18.9,0-34.1-15.3-34.1-34.1c0-18.9,15.3-34.1,34.1-34.1c18.9,0,34.1,15.3,34.1,34.1   C354.7,261.5,339.4,276.8,320.6,276.8z"/><g><path d="M455,387.8c31-17.1,51-44.6,51-75.5c0-33.8-24-63.5-59.9-80c0.3,3.5,0.4,6.9,0.4,10.4    c0,46.2-23.8,89.4-67,121.6c-17.1,12.8-36.4,23.2-57.2,31.1c17.4,6.8,37.2,10.7,58.1,10.7c15.4,0,30.2-2.1,43.9-5.9    c26.2,28.3,57,20.4,57,20.4C465,411.5,458,398.3,455,387.8z" id="XMLID_1_"/></g></g></svg>',
            ],
            "chat"        => [
                "label"    => "chat",
                "disabled" => "",
                "icon"     => '<svg enable-background="new 0 0 500 500" version="1.1" viewBox="0 0 500 500" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path clip-rule="evenodd" d="M36.992,326.039c0,20.079,16.262,36.34,36.34,36.34h54.513v56.062  c0,10.087,8.181,18.168,18.172,18.168c5.092,0,9.714-2.095,12.989-5.448l68.78-68.781h199.881c20.078,0,36.34-16.261,36.34-36.34  V98.902c0-20.079-16.262-36.341-36.34-36.341H73.333c-20.079,0-36.34,16.262-36.34,36.341V326.039z M146.018,221.557  c0-12.536,10.177-22.713,22.713-22.713c12.536,0,22.713,10.177,22.713,22.713c0,12.537-10.177,22.713-22.713,22.713  C156.194,244.27,146.018,234.093,146.018,221.557z M227.787,221.557c0-12.536,10.177-22.713,22.713-22.713  c12.537,0,22.715,10.177,22.715,22.713c0,12.537-10.178,22.713-22.715,22.713C237.964,244.27,227.787,234.093,227.787,221.557z   M309.556,221.557c0-12.536,10.176-22.713,22.715-22.713c12.537,0,22.711,10.177,22.711,22.713  c0,12.537-10.174,22.713-22.711,22.713C319.731,244.27,309.556,234.093,309.556,221.557z" fill-rule="evenodd"/></svg>',
            ],
            "chat-bubble" => [
                "label"    => "chat-bubble",
                "disabled" => "",
                "icon"     => '<svg enable-background="new 0 0 465.882 465.882" height="512" viewBox="0 0 465.882 465.882" width="512" xmlns="http://www.w3.org/2000/svg"><path d="m436.765 0h-291.177c-16.082 0-29.118 13.036-29.118 29.118v58.235h203.824c32.118 0 58.235 26.118 58.235 58.235v169.852l58.235 33.971-19.412-87.353h19.412c16.082 0 29.118-13.038 29.118-29.118v-203.822c0-16.082-13.035-29.118-29.117-29.118z"/><path d="m320.294 116.471h-291.176c-16.082 0-29.118 13.035-29.118 29.117v203.824c0 16.08 13.036 29.118 29.118 29.118h77.648l-19.412 87.353 149.749-87.353h83.193c16.082 0 29.118-13.038 29.118-29.118v-203.824c-.002-16.082-13.038-29.117-29.12-29.117zm-218.382 174.705c-8.04 0-14.559-6.519-14.559-14.559 0-8.042 6.519-14.559 14.559-14.559 8.042 0 14.559 6.517 14.559 14.559 0 8.041-6.517 14.559-14.559 14.559zm72.794 0c-8.04 0-14.559-6.519-14.559-14.559 0-8.042 6.519-14.559 14.559-14.559 8.042 0 14.559 6.517 14.559 14.559 0 8.041-6.517 14.559-14.559 14.559zm72.794 0c-8.04 0-14.559-6.519-14.559-14.559 0-8.042 6.519-14.559 14.559-14.559 8.042 0 14.559 6.517 14.559 14.559 0 8.041-6.517 14.559-14.559 14.559z"/></svg>',
            ],
            "chat-circle" => [
                "label"    => "chat-circle",
                "disabled" => "",
                "icon"     => '<svg style="enable-background:new 1 -1 100 100;" version="1.1" viewBox="1 -1 100 100" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M66.3,8.1C61.2,6.4,56,5.6,50.7,5.8C27,6.5,8.3,26.3,9.1,50.1c0.1,4.9,1.1,9.7,2.9,14.2c1.5,3.8,3.5,7.4,6.1,10.6l-3.6,8.5  c-1.4,3.2,0.1,7,3.4,8.3c1.1,0.5,2.4,0.6,3.6,0.4L38,89.2c22.4,7.8,46.9-4,54.7-26.4C100.5,40.4,88.7,15.9,66.3,8.1z M34.7,56.1  c-3.6,0-6.6-2.9-6.6-6.6c0-3.6,2.9-6.6,6.6-6.6c3.6,0,6.6,2.9,6.6,6.6S38.3,56.1,34.7,56.1z M52,56.1c-3.6,0-6.6-2.9-6.6-6.6  s2.9-6.6,6.6-6.6c3.6,0,6.6,2.9,6.6,6.6S55.6,56.1,52,56.1z M69.3,56.1c-3.6,0-6.6-2.9-6.6-6.6s2.9-6.6,6.6-6.6  c3.6,0,6.6,2.9,6.6,6.6S72.9,56.1,69.3,56.1z"/></svg>',
            ],
            "chat-double" => [
                "label"    => "chat-double",
                "disabled" => "",
                "icon"     => '<svg enable-background="new 0 0 511.626 511.626" version="1.1" viewBox="0 0 511.63 511.63" xml:space="preserve" xmlns="http://www.w3.org/2000/svg"><path d="m301.93 327.6c30.926-13.038 55.34-30.785 73.23-53.248 17.888-22.458 26.833-46.915 26.833-73.372 0-26.458-8.945-50.917-26.84-73.376-17.888-22.459-42.298-40.208-73.228-53.249-30.93-13.039-64.571-19.556-100.93-19.556-36.354 0-69.995 6.521-100.93 19.556-30.929 13.04-55.34 30.789-73.229 53.249-17.891 22.463-26.838 46.918-26.838 73.377 0 22.648 6.767 43.975 20.28 63.96 13.512 19.981 32.071 36.829 55.671 50.531-1.902 4.572-3.853 8.754-5.852 12.566-2 3.806-4.377 7.467-7.139 10.991-2.76 3.525-4.899 6.283-6.423 8.275-1.523 1.998-3.997 4.812-7.425 8.422-3.427 3.617-5.617 5.996-6.567 7.135 0-0.191-0.381 0.24-1.143 1.287-0.763 1.047-1.191 1.52-1.285 1.431-0.096-0.103-0.477 0.373-1.143 1.42-0.666 1.048-1 1.571-1 1.571l-0.715 1.423c-0.282 0.575-0.476 1.137-0.57 1.712-0.096 0.567-0.144 1.19-0.144 1.854s0.094 1.28 0.288 1.854c0.381 2.471 1.475 4.466 3.283 5.996 1.807 1.52 3.756 2.279 5.852 2.279h0.857c9.515-1.332 17.701-2.854 24.552-4.569 29.312-7.61 55.771-19.797 79.372-36.545 17.129 3.046 33.879 4.568 50.247 4.568 36.357 0.013 70.002-6.502 100.93-19.542z"/><path d="m491.35 338.17c13.518-19.889 20.272-41.247 20.272-64.09 0-23.414-7.146-45.316-21.416-65.68-14.277-20.362-33.694-37.305-58.245-50.819 4.374 14.274 6.563 28.739 6.563 43.398 0 25.503-6.368 49.676-19.129 72.519-12.752 22.836-31.025 43.01-54.816 60.524-22.08 15.988-47.205 28.261-75.377 36.829-28.164 8.562-57.573 12.848-88.218 12.848-5.708 0-14.084-0.377-25.122-1.137 38.256 25.119 83.177 37.685 134.76 37.685 16.371 0 33.119-1.526 50.251-4.571 23.6 16.755 50.06 28.931 79.37 36.549 6.852 1.718 15.037 3.237 24.554 4.568 2.283 0.191 4.381-0.476 6.283-1.999 1.903-1.522 3.142-3.61 3.71-6.272-0.089-1.143 0-1.77 0.287-1.861 0.281-0.09 0.233-0.712-0.144-1.852-0.376-1.144-0.568-1.715-0.568-1.715l-0.712-1.424c-0.198-0.376-0.52-0.903-0.999-1.567-0.476-0.66-0.855-1.143-1.143-1.427-0.28-0.284-0.705-0.763-1.28-1.424-0.568-0.66-0.951-1.092-1.143-1.283-0.951-1.143-3.139-3.521-6.564-7.139-3.429-3.613-5.899-6.42-7.422-8.418-1.523-1.999-3.665-4.757-6.424-8.282-2.758-3.518-5.14-7.183-7.139-10.991-1.998-3.806-3.949-7.995-5.852-12.56 23.602-13.716 42.156-30.513 55.667-50.409z"/></svg>',
            ],
            "help"        => [
                "label"    => "help",
                "disabled" => "",
                "icon"     => '<svg enable-background="new 0 0 365.442 365.442" version="1.1" viewBox="0 0 365.44 365.44" xml:space="preserve" xmlns="http://www.w3.org/2000/svg"><path d="m212.99 274.07h-68.522c-3.042 0-5.708 1.149-7.992 3.429-2.286 2.286-3.427 4.948-3.427 7.994v68.525c0 3.046 1.145 5.712 3.427 7.994 2.284 2.279 4.947 3.426 7.992 3.426h68.522c3.042 0 5.715-1.144 7.99-3.426 2.29-2.282 3.433-4.948 3.433-7.994v-68.525c0-3.046-1.14-5.708-3.433-7.994-2.275-2.286-4.948-3.429-7.99-3.429z"/><path d="m302.94 68.951c-7.806-14.378-17.891-26.506-30.266-36.406-12.367-9.896-26.271-17.799-41.685-23.697-15.417-5.896-30.738-8.848-45.968-8.848-57.859 0-102.02 25.315-132.47 75.946-1.521 2.473-2.046 5.137-1.571 7.993 0.478 2.852 1.953 5.232 4.427 7.135l46.824 35.691c2.474 1.52 4.854 2.281 7.139 2.281 3.427 0 6.375-1.525 8.852-4.57 13.702-17.128 23.887-28.072 30.548-32.833 8.186-5.518 18.461-8.276 30.833-8.276 11.61 0 21.838 3.046 30.692 9.132 8.85 6.092 13.271 13.135 13.271 21.129 0 8.942-2.375 16.178-7.135 21.698-4.757 5.518-12.754 10.845-23.986 15.986-14.842 6.661-28.457 16.988-40.823 30.978-12.375 13.991-18.558 28.885-18.558 44.682v12.847c0 3.62 0.994 7.187 2.996 10.708 2 3.524 4.425 5.283 7.282 5.283h68.521c3.046 0 5.708-1.472 7.994-4.432 2.279-2.942 3.426-6.036 3.426-9.267 0-4.757 2.617-11.14 7.847-19.13 5.235-7.994 11.752-14.186 19.562-18.565 7.419-4.186 13.219-7.56 17.411-10.133 4.196-2.566 9.664-6.715 16.423-12.421 6.756-5.712 11.991-11.375 15.698-16.988 3.713-5.614 7.046-12.896 9.996-21.844 2.956-8.945 4.428-18.558 4.428-28.835-2e-3 -15.798-3.907-30.881-11.706-45.244z"/></svg>',
            ],
            "custom"      => [
                "label"    => "custom-icon",
                "disabled" => "disabled",
                "icon"     => '<svg height="48" viewBox="0 0 48 48" width="48" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h48v48h-48z" fill="none"/><path d="M18 32h12v-12h8l-14-14-14 14h8zm-8 4h28v4h-28z"/></svg>',
            ],
        ];

    }//end get_chat_icons()


    /**
     * Get Upload Icon SVG
     *
     * This function returns the SVG code for an upload icon.
     *
     * @since  1.1.2
     * @return string The SVG icon code for upload
     */
    public static function get_upload_icon()
    {
        return '<svg height="48" viewBox="0 0 48 48" width="48" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h48v48h-48z" fill="none"/><path d="M18 32h12v-12h8l-14-14-14 14h8zm-8 4h28v4h-28z"/></svg>';

    }//end get_upload_icon()


    /**
     * Button Animation Styles
     *
     * This function returns an array of button animation styles.
     *
     * @since  1.1.2
     * @return array The animation styles of buttons, each represented as an associative array with keys:
     *               - class_name: CSS class name for the animation style.
     *               - disabled: Indicates if the animation is disabled or not.
     *               - title: Human-readable title for the animation style.
     */
    public static function animation_styles()
    {
        return [
            "none"                 => [
                "class_name" => "none",
                "disabled"   => "",
                "title"      => "None",
            ],
            "ginger-btn-bounce"    => [
                "class_name" => "ginger-btn-bounce",
                "disabled"   => "disabled",
                "title"      => "Bounce",
            ],
            "ginger-btn-fade"      => [
                "class_name" => "ginger-btn-fade",
                "disabled"   => "disabled",
                "title"      => "Fade",
            ],
            "ginger-btn-pulse"     => [
                "class_name" => "ginger-btn-pulse",
                "disabled"   => "disabled",
                "title"      => "Pulse",
            ],
            "ginger-btn-spin"      => [
                "class_name" => "ginger-btn-spin",
                "disabled"   => "disabled",
                "title"      => "Spin",
            ],
            "ginger-btn-zoom"      => [
                "class_name" => "ginger-btn-zoom",
                "disabled"   => "disabled",
                "title"      => "Zoom",
            ],
            "ginger-btn-shockwave" => [
                "class_name" => "ginger-btn-shockwave",
                "disabled"   => "disabled",
                "title"      => "Shockwave",
            ],
        ];

    }//end animation_styles()


    /**
     * Menu Animation Styles
     *
     * This function returns an array of menu animation styles.
     *
     * @since  1.1.2
     * @return array The animation styles of the menu, each represented as an associative array with keys:
     *               - class_name: CSS class name for the animation style.
     *               - title: Human-readable title for the animation style.
     */
    public static function menu_animations()
    {
        return [
            "ginger-menu-none"  => [
                "class_name" => "ginger-menu-none",
                "title"      => "None",
            ],
            "ginger-menu-slide" => [
                "class_name" => "ginger-menu-slide",
                "title"      => "Slide",
            ],
            "ginger-menu-fade"  => [
                "class_name" => "ginger-menu-fade",
                "title"      => "Fade",
            ],
            "ginger-menu-spin"  => [
                "class_name" => "ginger-menu-spin",
                "title"      => "Spin",
            ],
            "ginger-menu-pop"   => [
                "class_name" => "ginger-menu-pop",
                "title"      => "Pop",
            ],
        ];

    }//end menu_animations()


    /**
     * Get System Font List
     *
     * This function returns an array of system fonts.
     *
     * @since  1.1.2
     * @return array The list of system fonts, where each font is represented as an associative array
     *               with the font name as the key and the type (e.g., 'system') as the value.
     */
    public static function get_system_fonts_list()
    {
        return [
            'Arial'           => 'system',
            'Tahoma'          => 'system',
            'Verdana'         => 'system',
            'Helvetica'       => 'system',
            'Times New Roman' => 'system',
            'Trebuchet MS'    => 'system',
            'Georgia'         => 'system',
        ];

    }//end get_system_fonts_list()


    /**
     * Retrieve Google fonts list.
     *
     * @return array The array of Google fonts.
     * @since  1.1.2
     */
    public static function get_google_fonts_list()
    {
        // Google fonts.
        return [
            'ABeeZee'                           => 'google',
            'Abel'                              => 'google',
            'Abhaya Libre'                      => 'google',
            'Aboreto'                           => 'google',
            'Abril Fatface'                     => 'google',
            'Abyssinica SIL'                    => 'google',
            'Aclonica'                          => 'google',
            'Acme'                              => 'google',
            'Actor'                             => 'google',
            'Adamina'                           => 'google',
            'Advent Pro'                        => 'google',
            'Aguafina Script'                   => 'google',
            'Akaya Kanadaka'                    => 'google',
            'Akaya Telivigala'                  => 'google',
            'Akronim'                           => 'google',
            'Akshar'                            => 'google',
            'Aladin'                            => 'google',
            'Alata'                             => 'google',
            'Alatsi'                            => 'google',
            'Albert Sans'                       => 'google',
            'Aldrich'                           => 'google',
            'Alef'                              => 'google',
            'Alef Hebrew'                       => 'google',
            'Alegreya'                          => 'google',
            'Alegreya SC'                       => 'google',
            'Alegreya Sans'                     => 'google',
            'Alegreya Sans SC'                  => 'google',
            'Aleo'                              => 'google',
            'Alex Brush'                        => 'google',
            'Alexandria'                        => 'google',
            'Alfa Slab One'                     => 'google',
            'Alice'                             => 'google',
            'Alike'                             => 'google',
            'Alike Angular'                     => 'google',
            'Alkalami'                          => 'google',
            'Allan'                             => 'google',
            'Allerta'                           => 'google',
            'Allerta Stencil'                   => 'google',
            'Allison'                           => 'google',
            'Allura'                            => 'google',
            'Almarai'                           => 'google',
            'Almendra'                          => 'google',
            'Almendra Display'                  => 'google',
            'Almendra SC'                       => 'google',
            'Alumni Sans'                       => 'google',
            'Alumni Sans Collegiate One'        => 'google',
            'Alumni Sans Inline One'            => 'google',
            'Alumni Sans Pinstripe'             => 'google',
            'Amarante'                          => 'google',
            'Amaranth'                          => 'google',
            'Amatic SC'                         => 'google',
            'Amethysta'                         => 'google',
            'Amiko'                             => 'google',
            'Amiri'                             => 'google',
            'Amiri Quran'                       => 'google',
            'Amita'                             => 'google',
            'Anaheim'                           => 'google',
            'Andada Pro'                        => 'google',
            'Andika'                            => 'google',
            'Anek Bangla'                       => 'google',
            'Anek Devanagari'                   => 'google',
            'Anek Gujarati'                     => 'google',
            'Anek Gurmukhi'                     => 'google',
            'Anek Kannada'                      => 'google',
            'Anek Latin'                        => 'google',
            'Anek Malayalam'                    => 'google',
            'Anek Odia'                         => 'google',
            'Anek Tamil'                        => 'google',
            'Anek Telugu'                       => 'google',
            'Angkor'                            => 'google',
            'Annie Use Your Telescope'          => 'google',
            'Anonymous Pro'                     => 'google',
            'Antic'                             => 'google',
            'Antic Didone'                      => 'google',
            'Antic Slab'                        => 'google',
            'Anton'                             => 'google',
            'Antonio'                           => 'google',
            'Anybody'                           => 'google',
            'Arapey'                            => 'google',
            'Arbutus'                           => 'google',
            'Arbutus Slab'                      => 'google',
            'Architects Daughter'               => 'google',
            'Archivo'                           => 'google',
            'Archivo Black'                     => 'google',
            'Archivo Narrow'                    => 'google',
            'Are You Serious'                   => 'google',
            'Aref Ruqaa'                        => 'google',
            'Aref Ruqaa Ink'                    => 'google',
            'Arima'                             => 'google',
            'Arima Madurai'                     => 'google',
            'Arimo'                             => 'google',
            'Arizonia'                          => 'google',
            'Armata'                            => 'google',
            'Arsenal'                           => 'google',
            'Artifika'                          => 'google',
            'Arvo'                              => 'google',
            'Arya'                              => 'google',
            'Asap'                              => 'google',
            'Asap Condensed'                    => 'google',
            'Asar'                              => 'google',
            'Asset'                             => 'google',
            'Assistant'                         => 'google',
            'Astloch'                           => 'google',
            'Asul'                              => 'google',
            'Athiti'                            => 'google',
            'Atkinson Hyperlegible'             => 'google',
            'Atma'                              => 'google',
            'Atomic Age'                        => 'google',
            'Aubrey'                            => 'google',
            'Audiowide'                         => 'google',
            'Autour One'                        => 'google',
            'Average'                           => 'google',
            'Average Sans'                      => 'google',
            'Averia Gruesa Libre'               => 'google',
            'Averia Libre'                      => 'google',
            'Averia Sans Libre'                 => 'google',
            'Averia Serif Libre'                => 'google',
            'Azeret Mono'                       => 'google',
            'B612'                              => 'google',
            'B612 Mono'                         => 'google',
            'BIZ UDGothic'                      => 'google',
            'BIZ UDMincho'                      => 'google',
            'BIZ UDPGothic'                     => 'google',
            'BIZ UDPMincho'                     => 'google',
            'Babylonica'                        => 'google',
            'Bad Script'                        => 'google',
            'Bahiana'                           => 'google',
            'Bahianita'                         => 'google',
            'Bai Jamjuree'                      => 'google',
            'Bakbak One'                        => 'google',
            'Ballet'                            => 'google',
            'Baloo 2'                           => 'google',
            'Baloo Bhai 2'                      => 'google',
            'Baloo Bhaijaan 2'                  => 'google',
            'Baloo Bhaina 2'                    => 'google',
            'Baloo Chettan 2'                   => 'google',
            'Baloo Da 2'                        => 'google',
            'Baloo Paaji 2'                     => 'google',
            'Baloo Tamma 2'                     => 'google',
            'Baloo Tammudu 2'                   => 'google',
            'Baloo Thambi 2'                    => 'google',
            'Balsamiq Sans'                     => 'google',
            'Balthazar'                         => 'google',
            'Bangers'                           => 'google',
            'Barlow'                            => 'google',
            'Barlow Condensed'                  => 'google',
            'Barlow Semi Condensed'             => 'google',
            'Barriecito'                        => 'google',
            'Barrio'                            => 'google',
            'Basic'                             => 'google',
            'Baskervville'                      => 'google',
            'Battambang'                        => 'google',
            'Baumans'                           => 'google',
            'Bayon'                             => 'google',
            'Be Vietnam Pro'                    => 'google',
            'Beau Rivage'                       => 'google',
            'Bebas Neue'                        => 'google',
            'Belgrano'                          => 'google',
            'Bellefair'                         => 'google',
            'Belleza'                           => 'google',
            'Bellota'                           => 'google',
            'Bellota Text'                      => 'google',
            'BenchNine'                         => 'google',
            'Benne'                             => 'google',
            'Bentham'                           => 'google',
            'Berkshire Swash'                   => 'google',
            'Besley'                            => 'google',
            'Beth Ellen'                        => 'google',
            'Bevan'                             => 'google',
            'BhuTuka Expanded One'              => 'google',
            'Big Shoulders Display'             => 'google',
            'Big Shoulders Inline Display'      => 'google',
            'Big Shoulders Inline Text'         => 'google',
            'Big Shoulders Stencil Display'     => 'google',
            'Big Shoulders Stencil Text'        => 'google',
            'Big Shoulders Text'                => 'google',
            'Bigelow Rules'                     => 'google',
            'Bigshot One'                       => 'google',
            'Bilbo'                             => 'google',
            'Bilbo Swash Caps'                  => 'google',
            'BioRhyme'                          => 'google',
            'BioRhyme Expanded'                 => 'google',
            'Birthstone'                        => 'google',
            'Birthstone Bounce'                 => 'google',
            'Biryani'                           => 'google',
            'Bitter'                            => 'google',
            'Black And White Picture'           => 'google',
            'Black Han Sans'                    => 'google',
            'Black Ops One'                     => 'google',
            'Blaka'                             => 'google',
            'Blaka Hollow'                      => 'google',
            'Blaka Ink'                         => 'google',
            'Blinker'                           => 'google',
            'Bodoni Moda'                       => 'google',
            'Bokor'                             => 'google',
            'Bona Nova'                         => 'google',
            'Bonbon'                            => 'google',
            'Bonheur Royale'                    => 'google',
            'Boogaloo'                          => 'google',
            'Bowlby One'                        => 'google',
            'Bowlby One SC'                     => 'google',
            'Brawler'                           => 'google',
            'Bree Serif'                        => 'google',
            'Brygada 1918'                      => 'google',
            'Bubblegum Sans'                    => 'google',
            'Bubbler One'                       => 'google',
            'Buda'                              => 'google',
            'Buenard'                           => 'google',
            'Bungee'                            => 'google',
            'Bungee Hairline'                   => 'google',
            'Bungee Inline'                     => 'google',
            'Bungee Outline'                    => 'google',
            'Bungee Shade'                      => 'google',
            'Bungee Spice'                      => 'google',
            'Butcherman'                        => 'google',
            'Butterfly Kids'                    => 'google',
            'Cabin'                             => 'google',
            'Cabin Condensed'                   => 'google',
            'Cabin Sketch'                      => 'google',
            'Caesar Dressing'                   => 'google',
            'Cagliostro'                        => 'google',
            'Cairo'                             => 'google',
            'Cairo Play'                        => 'google',
            'Caladea'                           => 'google',
            'Calistoga'                         => 'google',
            'Calligraffitti'                    => 'google',
            'Cambay'                            => 'google',
            'Cambo'                             => 'google',
            'Candal'                            => 'google',
            'Cantarell'                         => 'google',
            'Cantata One'                       => 'google',
            'Cantora One'                       => 'google',
            'Capriola'                          => 'google',
            'Caramel'                           => 'google',
            'Carattere'                         => 'google',
            'Cardo'                             => 'google',
            'Carme'                             => 'google',
            'Carrois Gothic'                    => 'google',
            'Carrois Gothic SC'                 => 'google',
            'Carter One'                        => 'google',
            'Castoro'                           => 'google',
            'Catamaran'                         => 'google',
            'Caudex'                            => 'google',
            'Caveat'                            => 'google',
            'Caveat Brush'                      => 'google',
            'Cedarville Cursive'                => 'google',
            'Ceviche One'                       => 'google',
            'Chakra Petch'                      => 'google',
            'Changa'                            => 'google',
            'Changa One'                        => 'google',
            'Chango'                            => 'google',
            'Charis SIL'                        => 'google',
            'Charm'                             => 'google',
            'Charmonman'                        => 'google',
            'Chathura'                          => 'google',
            'Chau Philomene One'                => 'google',
            'Chela One'                         => 'google',
            'Chelsea Market'                    => 'google',
            'Chenla'                            => 'google',
            'Cherish'                           => 'google',
            'Cherry Cream Soda'                 => 'google',
            'Cherry Swash'                      => 'google',
            'Chewy'                             => 'google',
            'Chicle'                            => 'google',
            'Chilanka'                          => 'google',
            'Chivo'                             => 'google',
            'Chivo Mono'                        => 'google',
            'Chonburi'                          => 'google',
            'Cinzel'                            => 'google',
            'Cinzel Decorative'                 => 'google',
            'Clicker Script'                    => 'google',
            'Coda'                              => 'google',
            'Coda Caption'                      => 'google',
            'Codystar'                          => 'google',
            'Coiny'                             => 'google',
            'Combo'                             => 'google',
            'Comfortaa'                         => 'google',
            'Comforter'                         => 'google',
            'Comforter Brush'                   => 'google',
            'Comic Neue'                        => 'google',
            'Coming Soon'                       => 'google',
            'Commissioner'                      => 'google',
            'Concert One'                       => 'google',
            'Condiment'                         => 'google',
            'Content'                           => 'google',
            'Contrail One'                      => 'google',
            'Convergence'                       => 'google',
            'Cookie'                            => 'google',
            'Copse'                             => 'google',
            'Corben'                            => 'google',
            'Corinthia'                         => 'google',
            'Cormorant'                         => 'google',
            'Cormorant Garamond'                => 'google',
            'Cormorant Infant'                  => 'google',
            'Cormorant SC'                      => 'google',
            'Cormorant Unicase'                 => 'google',
            'Cormorant Upright'                 => 'google',
            'Courgette'                         => 'google',
            'Courier Prime'                     => 'google',
            'Cousine'                           => 'google',
            'Coustard'                          => 'google',
            'Covered By Your Grace'             => 'google',
            'Crafty Girls'                      => 'google',
            'Creepster'                         => 'google',
            'Crete Round'                       => 'google',
            'Crimson Pro'                       => 'google',
            'Crimson Text'                      => 'google',
            'Croissant One'                     => 'google',
            'Crushed'                           => 'google',
            'Cuprum'                            => 'google',
            'Cute Font'                         => 'google',
            'Cutive'                            => 'google',
            'Cutive Mono'                       => 'google',
            'DM Mono'                           => 'google',
            'DM Sans'                           => 'google',
            'DM Serif Display'                  => 'google',
            'DM Serif Text'                     => 'google',
            'Damion'                            => 'google',
            'Dancing Script'                    => 'google',
            'Dangrek'                           => 'google',
            'Darker Grotesque'                  => 'google',
            'David Libre'                       => 'google',
            'Dawning of a New Day'              => 'google',
            'Days One'                          => 'google',
            'Dekko'                             => 'google',
            'Dela Gothic One'                   => 'google',
            'Delius'                            => 'google',
            'Delius Swash Caps'                 => 'google',
            'Delius Unicase'                    => 'google',
            'Della Respira'                     => 'google',
            'Denk One'                          => 'google',
            'Devonshire'                        => 'google',
            'Dhurjati'                          => 'google',
            'Didact Gothic'                     => 'google',
            'Diplomata'                         => 'google',
            'Diplomata SC'                      => 'google',
            'Do Hyeon'                          => 'google',
            'Dokdo'                             => 'google',
            'Domine'                            => 'google',
            'Donegal One'                       => 'google',
            'Dongle'                            => 'google',
            'Doppio One'                        => 'google',
            'Dorsa'                             => 'google',
            'Dosis'                             => 'google',
            'DotGothic16'                       => 'google',
            'Dr Sugiyama'                       => 'google',
            'Droid Arabic Kufi'                 => 'google',
            'Droid Arabic Naskh'                => 'google',
            'Duru Sans'                         => 'google',
            'DynaPuff'                          => 'google',
            'Dynalight'                         => 'google',
            'EB Garamond'                       => 'google',
            'Eagle Lake'                        => 'google',
            'East Sea Dokdo'                    => 'google',
            'Eater'                             => 'google',
            'Economica'                         => 'google',
            'Eczar'                             => 'google',
            'Edu NSW ACT Foundation'            => 'google',
            'Edu QLD Beginner'                  => 'google',
            'Edu SA Beginner'                   => 'google',
            'Edu TAS Beginner'                  => 'google',
            'Edu VIC WA NT Beginner'            => 'google',
            'El Messiri'                        => 'google',
            'Electrolize'                       => 'google',
            'Elsie'                             => 'google',
            'Elsie Swash Caps'                  => 'google',
            'Emblema One'                       => 'google',
            'Emilys Candy'                      => 'google',
            'Encode Sans'                       => 'google',
            'Encode Sans Condensed'             => 'google',
            'Encode Sans Expanded'              => 'google',
            'Encode Sans SC'                    => 'google',
            'Encode Sans Semi Condensed'        => 'google',
            'Encode Sans Semi Expanded'         => 'google',
            'Engagement'                        => 'google',
            'Englebert'                         => 'google',
            'Enriqueta'                         => 'google',
            'Ephesis'                           => 'google',
            'Epilogue'                          => 'google',
            'Erica One'                         => 'google',
            'Esteban'                           => 'google',
            'Estonia'                           => 'google',
            'Euphoria Script'                   => 'google',
            'Ewert'                             => 'google',
            'Exo'                               => 'google',
            'Exo 2'                             => 'google',
            'Expletus Sans'                     => 'google',
            'Explora'                           => 'google',
            'Fahkwang'                          => 'google',
            'Familjen Grotesk'                  => 'google',
            'Fanwood Text'                      => 'google',
            'Farro'                             => 'google',
            'Farsan'                            => 'google',
            'Fascinate'                         => 'google',
            'Fascinate Inline'                  => 'google',
            'Faster One'                        => 'google',
            'Fasthand'                          => 'google',
            'Fauna One'                         => 'google',
            'Faustina'                          => 'google',
            'Federant'                          => 'google',
            'Federo'                            => 'google',
            'Felipa'                            => 'google',
            'Fenix'                             => 'google',
            'Festive'                           => 'google',
            'Figtree'                           => 'google',
            'Finger Paint'                      => 'google',
            'Finlandica'                        => 'google',
            'Fira Code'                         => 'google',
            'Fira Mono'                         => 'google',
            'Fira Sans'                         => 'google',
            'Fira Sans Condensed'               => 'google',
            'Fira Sans Extra Condensed'         => 'google',
            'Fjalla One'                        => 'google',
            'Fjord One'                         => 'google',
            'Flamenco'                          => 'google',
            'Flavors'                           => 'google',
            'Fleur De Leah'                     => 'google',
            'Flow Block'                        => 'google',
            'Flow Circular'                     => 'google',
            'Flow Rounded'                      => 'google',
            'Fondamento'                        => 'google',
            'Fontdiner Swanky'                  => 'google',
            'Forum'                             => 'google',
            'Fragment Mono'                     => 'google',
            'Francois One'                      => 'google',
            'Frank Ruhl Libre'                  => 'google',
            'Fraunces'                          => 'google',
            'Freckle Face'                      => 'google',
            'Fredericka the Great'              => 'google',
            'Fredoka'                           => 'google',
            'Fredoka One'                       => 'google',
            'Freehand'                          => 'google',
            'Fresca'                            => 'google',
            'Frijole'                           => 'google',
            'Fruktur'                           => 'google',
            'Fugaz One'                         => 'google',
            'Fuggles'                           => 'google',
            'Fuzzy Bubbles'                     => 'google',
            'GFS Didot'                         => 'google',
            'GFS Neohellenic'                   => 'google',
            'Gabriela'                          => 'google',
            'Gaegu'                             => 'google',
            'Gafata'                            => 'google',
            'Galada'                            => 'google',
            'Galdeano'                          => 'google',
            'Galindo'                           => 'google',
            'Gamja Flower'                      => 'google',
            'Gantari'                           => 'google',
            'Gayathri'                          => 'google',
            'Gelasio'                           => 'google',
            'Gemunu Libre'                      => 'google',
            'Genos'                             => 'google',
            'Gentium Book Basic'                => 'google',
            'Gentium Book Plus'                 => 'google',
            'Gentium Plus'                      => 'google',
            'Geo'                               => 'google',
            'Georama'                           => 'google',
            'Geostar'                           => 'google',
            'Geostar Fill'                      => 'google',
            'Germania One'                      => 'google',
            'Gideon Roman'                      => 'google',
            'Gidugu'                            => 'google',
            'Gilda Display'                     => 'google',
            'Girassol'                          => 'google',
            'Give You Glory'                    => 'google',
            'Glass Antiqua'                     => 'google',
            'Glegoo'                            => 'google',
            'Gloria Hallelujah'                 => 'google',
            'Glory'                             => 'google',
            'Gluten'                            => 'google',
            'Goblin One'                        => 'google',
            'Gochi Hand'                        => 'google',
            'Goldman'                           => 'google',
            'Gorditas'                          => 'google',
            'Gothic A1'                         => 'google',
            'Gotu'                              => 'google',
            'Goudy Bookletter 1911'             => 'google',
            'Gowun Batang'                      => 'google',
            'Gowun Dodum'                       => 'google',
            'Graduate'                          => 'google',
            'Grand Hotel'                       => 'google',
            'Grandstander'                      => 'google',
            'Grape Nuts'                        => 'google',
            'Gravitas One'                      => 'google',
            'Great Vibes'                       => 'google',
            'Grechen Fuemen'                    => 'google',
            'Grenze'                            => 'google',
            'Grenze Gotisch'                    => 'google',
            'Grey Qo'                           => 'google',
            'Griffy'                            => 'google',
            'Gruppo'                            => 'google',
            'Gudea'                             => 'google',
            'Gugi'                              => 'google',
            'Gulzar'                            => 'google',
            'Gupter'                            => 'google',
            'Gurajada'                          => 'google',
            'Gwendolyn'                         => 'google',
            'Habibi'                            => 'google',
            'Hachi Maru Pop'                    => 'google',
            'Hahmlet'                           => 'google',
            'Halant'                            => 'google',
            'Hammersmith One'                   => 'google',
            'Hanalei'                           => 'google',
            'Hanalei Fill'                      => 'google',
            'Handlee'                           => 'google',
            'Hanken Grotesk'                    => 'google',
            'Hanuman'                           => 'google',
            'Happy Monkey'                      => 'google',
            'Harmattan'                         => 'google',
            'Headland One'                      => 'google',
            'Heebo'                             => 'google',
            'Henny Penny'                       => 'google',
            'Hepta Slab'                        => 'google',
            'Herr Von Muellerhoff'              => 'google',
            'Hi Melody'                         => 'google',
            'Hina Mincho'                       => 'google',
            'Hind'                              => 'google',
            'Hind Guntur'                       => 'google',
            'Hind Madurai'                      => 'google',
            'Hind Siliguri'                     => 'google',
            'Hind Vadodara'                     => 'google',
            'Holtwood One SC'                   => 'google',
            'Homemade Apple'                    => 'google',
            'Homenaje'                          => 'google',
            'Hubballi'                          => 'google',
            'Hurricane'                         => 'google',
            'IBM Plex Mono'                     => 'google',
            'IBM Plex Sans'                     => 'google',
            'IBM Plex Sans Arabic'              => 'google',
            'IBM Plex Sans Condensed'           => 'google',
            'IBM Plex Sans Devanagari'          => 'google',
            'IBM Plex Sans Hebrew'              => 'google',
            'IBM Plex Sans JP'                  => 'google',
            'IBM Plex Sans KR'                  => 'google',
            'IBM Plex Sans Thai'                => 'google',
            'IBM Plex Sans Thai Looped'         => 'google',
            'IBM Plex Serif'                    => 'google',
            'IM Fell DW Pica'                   => 'google',
            'IM Fell DW Pica SC'                => 'google',
            'IM Fell Double Pica'               => 'google',
            'IM Fell Double Pica SC'            => 'google',
            'IM Fell English'                   => 'google',
            'IM Fell English SC'                => 'google',
            'IM Fell French Canon'              => 'google',
            'IM Fell French Canon SC'           => 'google',
            'IM Fell Great Primer'              => 'google',
            'IM Fell Great Primer SC'           => 'google',
            'Ibarra Real Nova'                  => 'google',
            'Iceberg'                           => 'google',
            'Iceland'                           => 'google',
            'Imbue'                             => 'google',
            'Imperial Script'                   => 'google',
            'Imprima'                           => 'google',
            'Inconsolata'                       => 'google',
            'Inder'                             => 'google',
            'Indie Flower'                      => 'google',
            'Ingrid Darling'                    => 'google',
            'Inika'                             => 'google',
            'Inknut Antiqua'                    => 'google',
            'Inria Sans'                        => 'google',
            'Inria Serif'                       => 'google',
            'Inspiration'                       => 'google',
            'Inter'                             => 'google',
            'Inter Tight'                       => 'google',
            'Irish Grover'                      => 'google',
            'Island Moments'                    => 'google',
            'Istok Web'                         => 'google',
            'Italiana'                          => 'google',
            'Italianno'                         => 'google',
            'Itim'                              => 'google',
            'Jacques Francois'                  => 'google',
            'Jacques Francois Shadow'           => 'google',
            'Jaldi'                             => 'google',
            'JetBrains Mono'                    => 'google',
            'Jim Nightshade'                    => 'google',
            'Joan'                              => 'google',
            'Jockey One'                        => 'google',
            'Jolly Lodger'                      => 'google',
            'Jomhuria'                          => 'google',
            'Jomolhari'                         => 'google',
            'Josefin Sans'                      => 'google',
            'Josefin Slab'                      => 'google',
            'Jost'                              => 'google',
            'Joti One'                          => 'google',
            'Jua'                               => 'google',
            'Judson'                            => 'google',
            'Julee'                             => 'google',
            'Julius Sans One'                   => 'google',
            'Junge'                             => 'google',
            'Jura'                              => 'google',
            'Just Another Hand'                 => 'google',
            'Just Me Again Down Here'           => 'google',
            'K2D'                               => 'google',
            'Kadwa'                             => 'google',
            'Kaisei Decol'                      => 'google',
            'Kaisei HarunoUmi'                  => 'google',
            'Kaisei Opti'                       => 'google',
            'Kaisei Tokumin'                    => 'google',
            'Kalam'                             => 'google',
            'Kameron'                           => 'google',
            'Kanit'                             => 'google',
            'Kantumruy'                         => 'google',
            'Kantumruy Pro'                     => 'google',
            'Karantina'                         => 'google',
            'Karla'                             => 'google',
            'Karma'                             => 'google',
            'Katibeh'                           => 'google',
            'Kaushan Script'                    => 'google',
            'Kavivanar'                         => 'google',
            'Kavoon'                            => 'google',
            'Kdam Thmor Pro'                    => 'google',
            'Keania One'                        => 'google',
            'Kelly Slab'                        => 'google',
            'Kenia'                             => 'google',
            'Khand'                             => 'google',
            'Khmer'                             => 'google',
            'Khula'                             => 'google',
            'Kings'                             => 'google',
            'Kirang Haerang'                    => 'google',
            'Kite One'                          => 'google',
            'Kiwi Maru'                         => 'google',
            'Klee One'                          => 'google',
            'Knewave'                           => 'google',
            'KoHo'                              => 'google',
            'Kodchasan'                         => 'google',
            'Koh Santepheap'                    => 'google',
            'Kolker Brush'                      => 'google',
            'Kosugi'                            => 'google',
            'Kosugi Maru'                       => 'google',
            'Kotta One'                         => 'google',
            'Koulen'                            => 'google',
            'Kranky'                            => 'google',
            'Kreon'                             => 'google',
            'Kristi'                            => 'google',
            'Krona One'                         => 'google',
            'Krub'                              => 'google',
            'Kufam'                             => 'google',
            'Kulim Park'                        => 'google',
            'Kumar One'                         => 'google',
            'Kumar One Outline'                 => 'google',
            'Kumbh Sans'                        => 'google',
            'Kurale'                            => 'google',
            'La Belle Aurore'                   => 'google',
            'Lacquer'                           => 'google',
            'Laila'                             => 'google',
            'Lakki Reddy'                       => 'google',
            'Lalezar'                           => 'google',
            'Lancelot'                          => 'google',
            'Langar'                            => 'google',
            'Lateef'                            => 'google',
            'Lato'                              => 'google',
            'Lavishly Yours'                    => 'google',
            'League Gothic'                     => 'google',
            'League Script'                     => 'google',
            'League Spartan'                    => 'google',
            'Leckerli One'                      => 'google',
            'Ledger'                            => 'google',
            'Lekton'                            => 'google',
            'Lemon'                             => 'google',
            'Lemonada'                          => 'google',
            'Lexend'                            => 'google',
            'Lexend Deca'                       => 'google',
            'Lexend Exa'                        => 'google',
            'Lexend Giga'                       => 'google',
            'Lexend Mega'                       => 'google',
            'Lexend Peta'                       => 'google',
            'Lexend Tera'                       => 'google',
            'Lexend Zetta'                      => 'google',
            'Libre Barcode 128'                 => 'google',
            'Libre Barcode 128 Text'            => 'google',
            'Libre Barcode 39'                  => 'google',
            'Libre Barcode 39 Extended'         => 'google',
            'Libre Barcode 39 Extended Text'    => 'google',
            'Libre Barcode 39 Text'             => 'google',
            'Libre Barcode EAN13 Text'          => 'google',
            'Libre Baskerville'                 => 'google',
            'Libre Bodoni'                      => 'google',
            'Libre Caslon Display'              => 'google',
            'Libre Caslon Text'                 => 'google',
            'Libre Franklin'                    => 'google',
            'Licorice'                          => 'google',
            'Life Savers'                       => 'google',
            'Lilita One'                        => 'google',
            'Lily Script One'                   => 'google',
            'Limelight'                         => 'google',
            'Linden Hill'                       => 'google',
            'Literata'                          => 'google',
            'Liu Jian Mao Cao'                  => 'google',
            'Livvic'                            => 'google',
            'Lobster'                           => 'google',
            'Lobster Two'                       => 'google',
            'Londrina Outline'                  => 'google',
            'Londrina Shadow'                   => 'google',
            'Londrina Sketch'                   => 'google',
            'Londrina Solid'                    => 'google',
            'Long Cang'                         => 'google',
            'Lora'                              => 'google',
            'Love Light'                        => 'google',
            'Love Ya Like A Sister'             => 'google',
            'Loved by the King'                 => 'google',
            'Lovers Quarrel'                    => 'google',
            'Luckiest Guy'                      => 'google',
            'Lusitana'                          => 'google',
            'Lustria'                           => 'google',
            'Luxurious Roman'                   => 'google',
            'Luxurious Script'                  => 'google',
            'M PLUS 1'                          => 'google',
            'M PLUS 1 Code'                     => 'google',
            'M PLUS 1p'                         => 'google',
            'M PLUS 2'                          => 'google',
            'M PLUS Code Latin'                 => 'google',
            'M PLUS Rounded 1c'                 => 'google',
            'Ma Shan Zheng'                     => 'google',
            'Macondo'                           => 'google',
            'Macondo Swash Caps'                => 'google',
            'Mada'                              => 'google',
            'Magra'                             => 'google',
            'Maiden Orange'                     => 'google',
            'Maitree'                           => 'google',
            'Major Mono Display'                => 'google',
            'Mako'                              => 'google',
            'Mali'                              => 'google',
            'Mallanna'                          => 'google',
            'Mandali'                           => 'google',
            'Manjari'                           => 'google',
            'Manrope'                           => 'google',
            'Mansalva'                          => 'google',
            'Manuale'                           => 'google',
            'Marcellus'                         => 'google',
            'Marcellus SC'                      => 'google',
            'Marck Script'                      => 'google',
            'Margarine'                         => 'google',
            'Marhey'                            => 'google',
            'Markazi Text'                      => 'google',
            'Marko One'                         => 'google',
            'Marmelad'                          => 'google',
            'Martel'                            => 'google',
            'Martel Sans'                       => 'google',
            'Martian Mono'                      => 'google',
            'Marvel'                            => 'google',
            'Mate'                              => 'google',
            'Mate SC'                           => 'google',
            'Maven Pro'                         => 'google',
            'McLaren'                           => 'google',
            'Mea Culpa'                         => 'google',
            'Meddon'                            => 'google',
            'MedievalSharp'                     => 'google',
            'Medula One'                        => 'google',
            'Meera Inimai'                      => 'google',
            'Megrim'                            => 'google',
            'Meie Script'                       => 'google',
            'Meow Script'                       => 'google',
            'Merienda'                          => 'google',
            'Merienda One'                      => 'google',
            'Merriweather'                      => 'google',
            'Merriweather Sans'                 => 'google',
            'Metal'                             => 'google',
            'Metal Mania'                       => 'google',
            'Metamorphous'                      => 'google',
            'Metrophobic'                       => 'google',
            'Michroma'                          => 'google',
            'Milonga'                           => 'google',
            'Miltonian'                         => 'google',
            'Miltonian Tattoo'                  => 'google',
            'Mina'                              => 'google',
            'Mingzat'                           => 'google',
            'Miniver'                           => 'google',
            'Miriam Libre'                      => 'google',
            'Mirza'                             => 'google',
            'Miss Fajardose'                    => 'google',
            'Mitr'                              => 'google',
            'Mochiy Pop One'                    => 'google',
            'Mochiy Pop P One'                  => 'google',
            'Modak'                             => 'google',
            'Modern Antiqua'                    => 'google',
            'Mogra'                             => 'google',
            'Mohave'                            => 'google',
            'Molengo'                           => 'google',
            'Molle'                             => 'google',
            'Monda'                             => 'google',
            'Monofett'                          => 'google',
            'Monoton'                           => 'google',
            'Monsieur La Doulaise'              => 'google',
            'Montaga'                           => 'google',
            'Montagu Slab'                      => 'google',
            'MonteCarlo'                        => 'google',
            'Montez'                            => 'google',
            'Montserrat'                        => 'google',
            'Montserrat Alternates'             => 'google',
            'Montserrat Subrayada'              => 'google',
            'Moo Lah Lah'                       => 'google',
            'Moon Dance'                        => 'google',
            'Moul'                              => 'google',
            'Moulpali'                          => 'google',
            'Mountains of Christmas'            => 'google',
            'Mouse Memoirs'                     => 'google',
            'Mr Bedfort'                        => 'google',
            'Mr Dafoe'                          => 'google',
            'Mr De Haviland'                    => 'google',
            'Mrs Saint Delafield'               => 'google',
            'Mrs Sheppards'                     => 'google',
            'Ms Madi'                           => 'google',
            'Mukta'                             => 'google',
            'Mukta Mahee'                       => 'google',
            'Mukta Malar'                       => 'google',
            'Mukta Vaani'                       => 'google',
            'Mulish'                            => 'google',
            'Murecho'                           => 'google',
            'MuseoModerno'                      => 'google',
            'My Soul'                           => 'google',
            'Mystery Quest'                     => 'google',
            'NTR'                               => 'google',
            'Nabla'                             => 'google',
            'Nanum Brush Script'                => 'google',
            'Nanum Gothic'                      => 'google',
            'Nanum Gothic Coding'               => 'google',
            'Nanum Myeongjo'                    => 'google',
            'Nanum Pen Script'                  => 'google',
            'Neonderthaw'                       => 'google',
            'Nerko One'                         => 'google',
            'Neucha'                            => 'google',
            'Neuton'                            => 'google',
            'New Rocker'                        => 'google',
            'New Tegomin'                       => 'google',
            'News Cycle'                        => 'google',
            'Newsreader'                        => 'google',
            'Niconne'                           => 'google',
            'Niramit'                           => 'google',
            'Nixie One'                         => 'google',
            'Nobile'                            => 'google',
            'Nokora'                            => 'google',
            'Norican'                           => 'google',
            'Nosifer'                           => 'google',
            'Notable'                           => 'google',
            'Nothing You Could Do'              => 'google',
            'Noticia Text'                      => 'google',
            'Noto Color Emoji'                  => 'google',
            'Noto Emoji'                        => 'google',
            'Noto Kufi Arabic'                  => 'google',
            'Noto Music'                        => 'google',
            'Noto Naskh Arabic'                 => 'google',
            'Noto Nastaliq Urdu'                => 'google',
            'Noto Rashi Hebrew'                 => 'google',
            'Noto Sans'                         => 'google',
            'Noto Sans Adlam'                   => 'google',
            'Noto Sans Adlam Unjoined'          => 'google',
            'Noto Sans Anatolian Hieroglyphs'   => 'google',
            'Noto Sans Arabic'                  => 'google',
            'Noto Sans Armenian'                => 'google',
            'Noto Sans Avestan'                 => 'google',
            'Noto Sans Balinese'                => 'google',
            'Noto Sans Bamum'                   => 'google',
            'Noto Sans Bassa Vah'               => 'google',
            'Noto Sans Batak'                   => 'google',
            'Noto Sans Bengali'                 => 'google',
            'Noto Sans Bhaiksuki'               => 'google',
            'Noto Sans Brahmi'                  => 'google',
            'Noto Sans Buginese'                => 'google',
            'Noto Sans Buhid'                   => 'google',
            'Noto Sans Canadian Aboriginal'     => 'google',
            'Noto Sans Carian'                  => 'google',
            'Noto Sans Caucasian Albanian'      => 'google',
            'Noto Sans Chakma'                  => 'google',
            'Noto Sans Cham'                    => 'google',
            'Noto Sans Cherokee'                => 'google',
            'Noto Sans Coptic'                  => 'google',
            'Noto Sans Cuneiform'               => 'google',
            'Noto Sans Cypriot'                 => 'google',
            'Noto Sans Deseret'                 => 'google',
            'Noto Sans Devanagari'              => 'google',
            'Noto Sans Display'                 => 'google',
            'Noto Sans Duployan'                => 'google',
            'Noto Sans Egyptian Hieroglyphs'    => 'google',
            'Noto Sans Elbasan'                 => 'google',
            'Noto Sans Elymaic'                 => 'google',
            'Noto Sans Ethiopic'                => 'google',
            'Noto Sans Georgian'                => 'google',
            'Noto Sans Glagolitic'              => 'google',
            'Noto Sans Gothic'                  => 'google',
            'Noto Sans Grantha'                 => 'google',
            'Noto Sans Gujarati'                => 'google',
            'Noto Sans Gunjala Gondi'           => 'google',
            'Noto Sans Gurmukhi'                => 'google',
            'Noto Sans HK'                      => 'google',
            'Noto Sans Hanifi Rohingya'         => 'google',
            'Noto Sans Hanunoo'                 => 'google',
            'Noto Sans Hatran'                  => 'google',
            'Noto Sans Hebrew'                  => 'google',
            'Noto Sans Imperial Aramaic'        => 'google',
            'Noto Sans Indic Siyaq Numbers'     => 'google',
            'Noto Sans Inscriptional Pahlavi'   => 'google',
            'Noto Sans Inscriptional Parthian'  => 'google',
            'Noto Sans JP'                      => 'google',
            'Noto Sans Javanese'                => 'google',
            'Noto Sans KR'                      => 'google',
            'Noto Sans Kaithi'                  => 'google',
            'Noto Sans Kannada'                 => 'google',
            'Noto Sans Kayah Li'                => 'google',
            'Noto Sans Kharoshthi'              => 'google',
            'Noto Sans Khmer'                   => 'google',
            'Noto Sans Khojki'                  => 'google',
            'Noto Sans Khudawadi'               => 'google',
            'Noto Sans Lao'                     => 'google',
            'Noto Sans Lao Looped'              => 'google',
            'Noto Sans Lepcha'                  => 'google',
            'Noto Sans Limbu'                   => 'google',
            'Noto Sans Linear A'                => 'google',
            'Noto Sans Linear B'                => 'google',
            'Noto Sans Lisu'                    => 'google',
            'Noto Sans Lycian'                  => 'google',
            'Noto Sans Lydian'                  => 'google',
            'Noto Sans Mahajani'                => 'google',
            'Noto Sans Malayalam'               => 'google',
            'Noto Sans Mandaic'                 => 'google',
            'Noto Sans Manichaean'              => 'google',
            'Noto Sans Marchen'                 => 'google',
            'Noto Sans Masaram Gondi'           => 'google',
            'Noto Sans Math'                    => 'google',
            'Noto Sans Mayan Numerals'          => 'google',
            'Noto Sans Medefaidrin'             => 'google',
            'Noto Sans Meetei Mayek'            => 'google',
            'Noto Sans Mende Kikakui'           => 'google',
            'Noto Sans Meroitic'                => 'google',
            'Noto Sans Miao'                    => 'google',
            'Noto Sans Modi'                    => 'google',
            'Noto Sans Mongolian'               => 'google',
            'Noto Sans Mono'                    => 'google',
            'Noto Sans Mro'                     => 'google',
            'Noto Sans Multani'                 => 'google',
            'Noto Sans Myanmar'                 => 'google',
            'Noto Sans N Ko'                    => 'google',
            'Noto Sans Nabataean'               => 'google',
            'Noto Sans New Tai Lue'             => 'google',
            'Noto Sans Newa'                    => 'google',
            'Noto Sans Nushu'                   => 'google',
            'Noto Sans Ogham'                   => 'google',
            'Noto Sans Ol Chiki'                => 'google',
            'Noto Sans Old Hungarian'           => 'google',
            'Noto Sans Old Italic'              => 'google',
            'Noto Sans Old North Arabian'       => 'google',
            'Noto Sans Old Permic'              => 'google',
            'Noto Sans Old Persian'             => 'google',
            'Noto Sans Old Sogdian'             => 'google',
            'Noto Sans Old South Arabian'       => 'google',
            'Noto Sans Old Turkic'              => 'google',
            'Noto Sans Oriya'                   => 'google',
            'Noto Sans Osage'                   => 'google',
            'Noto Sans Osmanya'                 => 'google',
            'Noto Sans Pahawh Hmong'            => 'google',
            'Noto Sans Palmyrene'               => 'google',
            'Noto Sans Pau Cin Hau'             => 'google',
            'Noto Sans Phags Pa'                => 'google',
            'Noto Sans Phoenician'              => 'google',
            'Noto Sans Psalter Pahlavi'         => 'google',
            'Noto Sans Rejang'                  => 'google',
            'Noto Sans Runic'                   => 'google',
            'Noto Sans SC'                      => 'google',
            'Noto Sans Samaritan'               => 'google',
            'Noto Sans Saurashtra'              => 'google',
            'Noto Sans Sharada'                 => 'google',
            'Noto Sans Shavian'                 => 'google',
            'Noto Sans Siddham'                 => 'google',
            'Noto Sans SignWriting'             => 'google',
            'Noto Sans Sinhala'                 => 'google',
            'Noto Sans Sogdian'                 => 'google',
            'Noto Sans Sora Sompeng'            => 'google',
            'Noto Sans Soyombo'                 => 'google',
            'Noto Sans Sundanese'               => 'google',
            'Noto Sans Syloti Nagri'            => 'google',
            'Noto Sans Symbols'                 => 'google',
            'Noto Sans Symbols 2'               => 'google',
            'Noto Sans Syriac'                  => 'google',
            'Noto Sans TC'                      => 'google',
            'Noto Sans Tagalog'                 => 'google',
            'Noto Sans Tagbanwa'                => 'google',
            'Noto Sans Tai Le'                  => 'google',
            'Noto Sans Tai Tham'                => 'google',
            'Noto Sans Tai Viet'                => 'google',
            'Noto Sans Takri'                   => 'google',
            'Noto Sans Tamil'                   => 'google',
            'Noto Sans Tamil Supplement'        => 'google',
            'Noto Sans Tangsa'                  => 'google',
            'Noto Sans Telugu'                  => 'google',
            'Noto Sans Thaana'                  => 'google',
            'Noto Sans Thai'                    => 'google',
            'Noto Sans Thai Looped'             => 'google',
            'Noto Sans Tifinagh'                => 'google',
            'Noto Sans Tirhuta'                 => 'google',
            'Noto Sans Ugaritic'                => 'google',
            'Noto Sans Vai'                     => 'google',
            'Noto Sans Wancho'                  => 'google',
            'Noto Sans Warang Citi'             => 'google',
            'Noto Sans Yi'                      => 'google',
            'Noto Sans Zanabazar Square'        => 'google',
            'Noto Serif'                        => 'google',
            'Noto Serif Ahom'                   => 'google',
            'Noto Serif Armenian'               => 'google',
            'Noto Serif Balinese'               => 'google',
            'Noto Serif Bengali'                => 'google',
            'Noto Serif Devanagari'             => 'google',
            'Noto Serif Display'                => 'google',
            'Noto Serif Dogra'                  => 'google',
            'Noto Serif Ethiopic'               => 'google',
            'Noto Serif Georgian'               => 'google',
            'Noto Serif Grantha'                => 'google',
            'Noto Serif Gujarati'               => 'google',
            'Noto Serif Gurmukhi'               => 'google',
            'Noto Serif HK'                     => 'google',
            'Noto Serif Hebrew'                 => 'google',
            'Noto Serif JP'                     => 'google',
            'Noto Serif KR'                     => 'google',
            'Noto Serif Kannada'                => 'google',
            'Noto Serif Khmer'                  => 'google',
            'Noto Serif Khojki'                 => 'google',
            'Noto Serif Lao'                    => 'google',
            'Noto Serif Malayalam'              => 'google',
            'Noto Serif Myanmar'                => 'google',
            'Noto Serif NP Hmong'               => 'google',
            'Noto Serif Nyiakeng Puachue Hmong' => 'google',
            'Noto Serif Oriya'                  => 'google',
            'Noto Serif SC'                     => 'google',
            'Noto Serif Sinhala'                => 'google',
            'Noto Serif TC'                     => 'google',
            'Noto Serif Tamil'                  => 'google',
            'Noto Serif Tangut'                 => 'google',
            'Noto Serif Telugu'                 => 'google',
            'Noto Serif Thai'                   => 'google',
            'Noto Serif Tibetan'                => 'google',
            'Noto Serif Toto'                   => 'google',
            'Noto Serif Yezidi'                 => 'google',
            'Noto Traditional Nushu'            => 'google',
            'Nova Cut'                          => 'google',
            'Nova Flat'                         => 'google',
            'Nova Mono'                         => 'google',
            'Nova Oval'                         => 'google',
            'Nova Round'                        => 'google',
            'Nova Script'                       => 'google',
            'Nova Slim'                         => 'google',
            'Nova Square'                       => 'google',
            'Numans'                            => 'google',
            'Nunito'                            => 'google',
            'Nunito Sans'                       => 'google',
            'Nuosu SIL'                         => 'google',
            'Odibee Sans'                       => 'google',
            'Odor Mean Chey'                    => 'google',
            'Offside'                           => 'google',
            'Oi'                                => 'google',
            'Old Standard TT'                   => 'google',
            'Oldenburg'                         => 'google',
            'Ole'                               => 'google',
            'Oleo Script'                       => 'google',
            'Oleo Script Swash Caps'            => 'google',
            'Oooh Baby'                         => 'google',
            'Open Sans'                         => 'google',
            'Open Sans Hebrew'                  => 'google',
            'Open Sans Hebrew Condensed'        => 'google',
            'Oranienbaum'                       => 'google',
            'Orbitron'                          => 'google',
            'Oregano'                           => 'google',
            'Orelega One'                       => 'google',
            'Orienta'                           => 'google',
            'Original Surfer'                   => 'google',
            'Oswald'                            => 'google',
            'Outfit'                            => 'google',
            'Over the Rainbow'                  => 'google',
            'Overlock'                          => 'google',
            'Overlock SC'                       => 'google',
            'Overpass'                          => 'google',
            'Overpass Mono'                     => 'google',
            'Ovo'                               => 'google',
            'Oxanium'                           => 'google',
            'Oxygen'                            => 'google',
            'Oxygen Mono'                       => 'google',
            'PT Mono'                           => 'google',
            'PT Sans'                           => 'google',
            'PT Sans Caption'                   => 'google',
            'PT Sans Narrow'                    => 'google',
            'PT Serif'                          => 'google',
            'PT Serif Caption'                  => 'google',
            'Pacifico'                          => 'google',
            'Padauk'                            => 'google',
            'Padyakke Expanded One'             => 'google',
            'Palanquin'                         => 'google',
            'Palanquin Dark'                    => 'google',
            'Pangolin'                          => 'google',
            'Paprika'                           => 'google',
            'Parisienne'                        => 'google',
            'Passero One'                       => 'google',
            'Passion One'                       => 'google',
            'Passions Conflict'                 => 'google',
            'Pathway Gothic One'                => 'google',
            'Patrick Hand'                      => 'google',
            'Patrick Hand SC'                   => 'google',
            'Pattaya'                           => 'google',
            'Patua One'                         => 'google',
            'Pavanam'                           => 'google',
            'Paytone One'                       => 'google',
            'Peddana'                           => 'google',
            'Peralta'                           => 'google',
            'Permanent Marker'                  => 'google',
            'Petemoss'                          => 'google',
            'Petit Formal Script'               => 'google',
            'Petrona'                           => 'google',
            'Philosopher'                       => 'google',
            'Piazzolla'                         => 'google',
            'Piedra'                            => 'google',
            'Pinyon Script'                     => 'google',
            'Pirata One'                        => 'google',
            'Plaster'                           => 'google',
            'Play'                              => 'google',
            'Playball'                          => 'google',
            'Playfair Display'                  => 'google',
            'Playfair Display SC'               => 'google',
            'Plus Jakarta Sans'                 => 'google',
            'Podkova'                           => 'google',
            'Poiret One'                        => 'google',
            'Poller One'                        => 'google',
            'Poly'                              => 'google',
            'Pompiere'                          => 'google',
            'Pontano Sans'                      => 'google',
            'Poor Story'                        => 'google',
            'Poppins'                           => 'google',
            'Port Lligat Sans'                  => 'google',
            'Port Lligat Slab'                  => 'google',
            'Potta One'                         => 'google',
            'Pragati Narrow'                    => 'google',
            'Praise'                            => 'google',
            'Prata'                             => 'google',
            'Preahvihear'                       => 'google',
            'Press Start 2P'                    => 'google',
            'Pridi'                             => 'google',
            'Princess Sofia'                    => 'google',
            'Prociono'                          => 'google',
            'Prompt'                            => 'google',
            'Prosto One'                        => 'google',
            'Proza Libre'                       => 'google',
            'Public Sans'                       => 'google',
            'Puppies Play'                      => 'google',
            'Puritan'                           => 'google',
            'Purple Purse'                      => 'google',
            'Qahiri'                            => 'google',
            'Quando'                            => 'google',
            'Quantico'                          => 'google',
            'Quattrocento'                      => 'google',
            'Quattrocento Sans'                 => 'google',
            'Questrial'                         => 'google',
            'Quicksand'                         => 'google',
            'Quintessential'                    => 'google',
            'Qwigley'                           => 'google',
            'Qwitcher Grypen'                   => 'google',
            'Racing Sans One'                   => 'google',
            'Radio Canada'                      => 'google',
            'Radley'                            => 'google',
            'Rajdhani'                          => 'google',
            'Rakkas'                            => 'google',
            'Raleway'                           => 'google',
            'Raleway Dots'                      => 'google',
            'Ramabhadra'                        => 'google',
            'Ramaraja'                          => 'google',
            'Rambla'                            => 'google',
            'Rammetto One'                      => 'google',
            'Rampart One'                       => 'google',
            'Ranchers'                          => 'google',
            'Rancho'                            => 'google',
            'Ranga'                             => 'google',
            'Rasa'                              => 'google',
            'Rationale'                         => 'google',
            'Ravi Prakash'                      => 'google',
            'Readex Pro'                        => 'google',
            'Recursive'                         => 'google',
            'Red Hat Display'                   => 'google',
            'Red Hat Mono'                      => 'google',
            'Red Hat Text'                      => 'google',
            'Red Rose'                          => 'google',
            'Redacted'                          => 'google',
            'Redacted Script'                   => 'google',
            'Redressed'                         => 'google',
            'Reem Kufi'                         => 'google',
            'Reem Kufi Fun'                     => 'google',
            'Reem Kufi Ink'                     => 'google',
            'Reenie Beanie'                     => 'google',
            'Reggae One'                        => 'google',
            'Revalia'                           => 'google',
            'Rhodium Libre'                     => 'google',
            'Ribeye'                            => 'google',
            'Ribeye Marrow'                     => 'google',
            'Righteous'                         => 'google',
            'Risque'                            => 'google',
            'Road Rage'                         => 'google',
            'Roboto'                            => 'google',
            'Roboto Condensed'                  => 'google',
            'Roboto Flex'                       => 'google',
            'Roboto Mono'                       => 'google',
            'Roboto Serif'                      => 'google',
            'Roboto Slab'                       => 'google',
            'Rochester'                         => 'google',
            'Rock Salt'                         => 'google',
            'RocknRoll One'                     => 'google',
            'Rokkitt'                           => 'google',
            'Romanesco'                         => 'google',
            'Ropa Sans'                         => 'google',
            'Rosario'                           => 'google',
            'Rosarivo'                          => 'google',
            'Rouge Script'                      => 'google',
            'Rowdies'                           => 'google',
            'Rozha One'                         => 'google',
            'Rubik'                             => 'google',
            'Rubik 80s Fade'                    => 'google',
            'Rubik Beastly'                     => 'google',
            'Rubik Bubbles'                     => 'google',
            'Rubik Burned'                      => 'google',
            'Rubik Dirt'                        => 'google',
            'Rubik Distressed'                  => 'google',
            'Rubik Gemstones'                   => 'google',
            'Rubik Glitch'                      => 'google',
            'Rubik Iso'                         => 'google',
            'Rubik Marker Hatch'                => 'google',
            'Rubik Maze'                        => 'google',
            'Rubik Microbe'                     => 'google',
            'Rubik Mono One'                    => 'google',
            'Rubik Moonrocks'                   => 'google',
            'Rubik Puddles'                     => 'google',
            'Rubik Spray Paint'                 => 'google',
            'Rubik Storm'                       => 'google',
            'Rubik Vinyl'                       => 'google',
            'Rubik Wet Paint'                   => 'google',
            'Ruda'                              => 'google',
            'Rufina'                            => 'google',
            'Ruge Boogie'                       => 'google',
            'Ruluko'                            => 'google',
            'Rum Raisin'                        => 'google',
            'Ruslan Display'                    => 'google',
            'Russo One'                         => 'google',
            'Ruthie'                            => 'google',
            'Rye'                               => 'google',
            'STIX Two Text'                     => 'google',
            'Sacramento'                        => 'google',
            'Sahitya'                           => 'google',
            'Sail'                              => 'google',
            'Saira'                             => 'google',
            'Saira Condensed'                   => 'google',
            'Saira Extra Condensed'             => 'google',
            'Saira Semi Condensed'              => 'google',
            'Saira Stencil One'                 => 'google',
            'Salsa'                             => 'google',
            'Sanchez'                           => 'google',
            'Sancreek'                          => 'google',
            'Sansita'                           => 'google',
            'Sansita Swashed'                   => 'google',
            'Sarabun'                           => 'google',
            'Sarala'                            => 'google',
            'Sarina'                            => 'google',
            'Sarpanch'                          => 'google',
            'Sassy Frass'                       => 'google',
            'Satisfy'                           => 'google',
            'Sawarabi Gothic'                   => 'google',
            'Sawarabi Mincho'                   => 'google',
            'Scada'                             => 'google',
            'Scheherazade New'                  => 'google',
            'Schoolbell'                        => 'google',
            'Scope One'                         => 'google',
            'Seaweed Script'                    => 'google',
            'Secular One'                       => 'google',
            'Sedgwick Ave'                      => 'google',
            'Sedgwick Ave Display'              => 'google',
            'Sen'                               => 'google',
            'Send Flowers'                      => 'google',
            'Sevillana'                         => 'google',
            'Seymour One'                       => 'google',
            'Shadows Into Light'                => 'google',
            'Shadows Into Light Two'            => 'google',
            'Shalimar'                          => 'google',
            'Shanti'                            => 'google',
            'Share'                             => 'google',
            'Share Tech'                        => 'google',
            'Share Tech Mono'                   => 'google',
            'Shippori Antique'                  => 'google',
            'Shippori Antique B1'               => 'google',
            'Shippori Mincho'                   => 'google',
            'Shippori Mincho B1'                => 'google',
            'Shojumaru'                         => 'google',
            'Short Stack'                       => 'google',
            'Shrikhand'                         => 'google',
            'Siemreap'                          => 'google',
            'Sigmar One'                        => 'google',
            'Signika'                           => 'google',
            'Signika Negative'                  => 'google',
            'Silkscreen'                        => 'google',
            'Simonetta'                         => 'google',
            'Single Day'                        => 'google',
            'Sintony'                           => 'google',
            'Sirin Stencil'                     => 'google',
            'Six Caps'                          => 'google',
            'Skranji'                           => 'google',
            'Slabo 13px'                        => 'google',
            'Slabo 27px'                        => 'google',
            'Slackey'                           => 'google',
            'Smokum'                            => 'google',
            'Smooch'                            => 'google',
            'Smooch Sans'                       => 'google',
            'Smythe'                            => 'google',
            'Sniglet'                           => 'google',
            'Snippet'                           => 'google',
            'Snowburst One'                     => 'google',
            'Sofadi One'                        => 'google',
            'Sofia'                             => 'google',
            'Sofia Sans'                        => 'google',
            'Sofia Sans Condensed'              => 'google',
            'Sofia Sans Extra Condensed'        => 'google',
            'Sofia Sans Semi Condensed'         => 'google',
            'Solitreo'                          => 'google',
            'Solway'                            => 'google',
            'Song Myung'                        => 'google',
            'Sono'                              => 'google',
            'Sonsie One'                        => 'google',
            'Sora'                              => 'google',
            'Sorts Mill Goudy'                  => 'google',
            'Source Code Pro'                   => 'google',
            'Source Sans 3'                     => 'google',
            'Source Sans Pro'                   => 'google',
            'Source Serif 4'                    => 'google',
            'Source Serif Pro'                  => 'google',
            'Space Grotesk'                     => 'google',
            'Space Mono'                        => 'google',
            'Special Elite'                     => 'google',
            'Spectral'                          => 'google',
            'Spectral SC'                       => 'google',
            'Spicy Rice'                        => 'google',
            'Spinnaker'                         => 'google',
            'Spirax'                            => 'google',
            'Splash'                            => 'google',
            'Spline Sans'                       => 'google',
            'Spline Sans Mono'                  => 'google',
            'Squada One'                        => 'google',
            'Square Peg'                        => 'google',
            'Sree Krushnadevaraya'              => 'google',
            'Sriracha'                          => 'google',
            'Srisakdi'                          => 'google',
            'Staatliches'                       => 'google',
            'Stalemate'                         => 'google',
            'Stalinist One'                     => 'google',
            'Stardos Stencil'                   => 'google',
            'Stick'                             => 'google',
            'Stick No Bills'                    => 'google',
            'Stint Ultra Condensed'             => 'google',
            'Stint Ultra Expanded'              => 'google',
            'Stoke'                             => 'google',
            'Strait'                            => 'google',
            'Style Script'                      => 'google',
            'Stylish'                           => 'google',
            'Sue Ellen Francisco'               => 'google',
            'Suez One'                          => 'google',
            'Sulphur Point'                     => 'google',
            'Sumana'                            => 'google',
            'Sunflower'                         => 'google',
            'Sunshiney'                         => 'google',
            'Supermercado One'                  => 'google',
            'Sura'                              => 'google',
            'Suranna'                           => 'google',
            'Suravaram'                         => 'google',
            'Suwannaphum'                       => 'google',
            'Swanky and Moo Moo'                => 'google',
            'Syncopate'                         => 'google',
            'Syne'                              => 'google',
            'Syne Mono'                         => 'google',
            'Syne Tactile'                      => 'google',
            'Tai Heritage Pro'                  => 'google',
            'Tajawal'                           => 'google',
            'Tangerine'                         => 'google',
            'Tapestry'                          => 'google',
            'Taprom'                            => 'google',
            'Tauri'                             => 'google',
            'Taviraj'                           => 'google',
            'Teko'                              => 'google',
            'Telex'                             => 'google',
            'Tenali Ramakrishna'                => 'google',
            'Tenor Sans'                        => 'google',
            'Text Me One'                       => 'google',
            'Texturina'                         => 'google',
            'Thasadith'                         => 'google',
            'The Girl Next Door'                => 'google',
            'The Nautigal'                      => 'google',
            'Tienne'                            => 'google',
            'Tillana'                           => 'google',
            'Timmana'                           => 'google',
            'Tinos'                             => 'google',
            'Tiro Bangla'                       => 'google',
            'Tiro Devanagari Hindi'             => 'google',
            'Tiro Devanagari Marathi'           => 'google',
            'Tiro Devanagari Sanskrit'          => 'google',
            'Tiro Gurmukhi'                     => 'google',
            'Tiro Kannada'                      => 'google',
            'Tiro Tamil'                        => 'google',
            'Tiro Telugu'                       => 'google',
            'Titan One'                         => 'google',
            'Titillium Web'                     => 'google',
            'Tomorrow'                          => 'google',
            'Tourney'                           => 'google',
            'Trade Winds'                       => 'google',
            'Train One'                         => 'google',
            'Trirong'                           => 'google',
            'Trispace'                          => 'google',
            'Trocchi'                           => 'google',
            'Trochut'                           => 'google',
            'Truculenta'                        => 'google',
            'Trykker'                           => 'google',
            'Tulpen One'                        => 'google',
            'Turret Road'                       => 'google',
            'Twinkle Star'                      => 'google',
            'Ubuntu'                            => 'google',
            'Ubuntu Condensed'                  => 'google',
            'Ubuntu Mono'                       => 'google',
            'Uchen'                             => 'google',
            'Ultra'                             => 'google',
            'Unbounded'                         => 'google',
            'Uncial Antiqua'                    => 'google',
            'Underdog'                          => 'google',
            'Unica One'                         => 'google',
            'UnifrakturCook'                    => 'google',
            'UnifrakturMaguntia'                => 'google',
            'Unkempt'                           => 'google',
            'Unlock'                            => 'google',
            'Unna'                              => 'google',
            'Updock'                            => 'google',
            'Urbanist'                          => 'google',
            'VT323'                             => 'google',
            'Vampiro One'                       => 'google',
            'Varela'                            => 'google',
            'Varela Round'                      => 'google',
            'Varta'                             => 'google',
            'Vast Shadow'                       => 'google',
            'Vazirmatn'                         => 'google',
            'Vesper Libre'                      => 'google',
            'Viaoda Libre'                      => 'google',
            'Vibes'                             => 'google',
            'Vibur'                             => 'google',
            'Vidaloka'                          => 'google',
            'Viga'                              => 'google',
            'Voces'                             => 'google',
            'Volkhov'                           => 'google',
            'Vollkorn'                          => 'google',
            'Vollkorn SC'                       => 'google',
            'Voltaire'                          => 'google',
            'Vujahday Script'                   => 'google',
            'Waiting for the Sunrise'           => 'google',
            'Wallpoet'                          => 'google',
            'Walter Turncoat'                   => 'google',
            'Warnes'                            => 'google',
            'Water Brush'                       => 'google',
            'Waterfall'                         => 'google',
            'Wellfleet'                         => 'google',
            'Wendy One'                         => 'google',
            'Whisper'                           => 'google',
            'WindSong'                          => 'google',
            'Wire One'                          => 'google',
            'Work Sans'                         => 'google',
            'Xanh Mono'                         => 'google',
            'Yaldevi'                           => 'google',
            'Yanone Kaffeesatz'                 => 'google',
            'Yantramanav'                       => 'google',
            'Yatra One'                         => 'google',
            'Yellowtail'                        => 'google',
            'Yeon Sung'                         => 'google',
            'Yeseva One'                        => 'google',
            'Yesteryear'                        => 'google',
            'Yomogi'                            => 'google',
            'Yrsa'                              => 'google',
            'Yuji Boku'                         => 'google',
            'Yuji Mai'                          => 'google',
            'Yuji Syuku'                        => 'google',
            'Yusei Magic'                       => 'google',
            'ZCOOL KuaiLe'                      => 'google',
            'ZCOOL QingKe HuangYou'             => 'google',
            'ZCOOL XiaoWei'                     => 'google',
            'Zen Antique'                       => 'google',
            'Zen Antique Soft'                  => 'google',
            'Zen Dots'                          => 'google',
            'Zen Kaku Gothic Antique'           => 'google',
            'Zen Kaku Gothic New'               => 'google',
            'Zen Kurenaido'                     => 'google',
            'Zen Loop'                          => 'google',
            'Zen Maru Gothic'                   => 'google',
            'Zen Old Mincho'                    => 'google',
            'Zen Tokyo Zoo'                     => 'google',
            'Zeyada'                            => 'google',
            'Zhi Mang Xing'                     => 'google',
            'Zilla Slab'                        => 'google',
            'Zilla Slab Highlight'              => 'google',
        ];

    }//end get_google_fonts_list()


    /**
     * Get SVG Icons
     *
     * This method returns an array of SVG icons, where each icon is identified by a key.
     *
     * @return array An associative array of SVG icons, where keys represent the icon name and values are SVG markup.
     */
    public static function svg_icons()
    {
        return [
            'action'     => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" svg-inline="" role="presentation" focusable="false" tabindex="-1"><path d="M8 8.667a.667.667 0 100-1.334.667.667 0 000 1.334zM8 4a.667.667 0 100-1.333A.667.667 0 008 4zM8 13.333A.667.667 0 108 12a.667.667 0 000 1.333z" stroke="currentColor" stroke-width="1.33" stroke-linecap="round" stroke-linejoin="round"></path></svg>',
            'close'      => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M310.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L160 210.7 54.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L114.7 256 9.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 301.3 265.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L205.3 256 310.6 150.6z"></path></svg>',
            'setting'    => '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M11 14C12.6569 14 14 12.6569 14 11C14 9.34315 12.6569 8 11 8C9.34315 8 8 9.34315 8 11C8 12.6569 9.34315 14 11 14Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M17.7273 13.7273C17.6063 14.0015 17.5702 14.3056 17.6236 14.6005C17.6771 14.8954 17.8177 15.1676 18.0273 15.3818L18.0818 15.4364C18.2509 15.6052 18.385 15.8057 18.4765 16.0265C18.568 16.2472 18.6151 16.4838 18.6151 16.7227C18.6151 16.9617 18.568 17.1983 18.4765 17.419C18.385 17.6397 18.2509 17.8402 18.0818 18.0091C17.913 18.1781 17.7124 18.3122 17.4917 18.4037C17.271 18.4952 17.0344 18.5423 16.7955 18.5423C16.5565 18.5423 16.3199 18.4952 16.0992 18.4037C15.8785 18.3122 15.678 18.1781 15.5091 18.0091L15.4545 17.9545C15.2403 17.745 14.9682 17.6044 14.6733 17.5509C14.3784 17.4974 14.0742 17.5335 13.8 17.6545C13.5311 17.7698 13.3018 17.9611 13.1403 18.205C12.9788 18.4489 12.8921 18.7347 12.8909 19.0273V19.1818C12.8909 19.664 12.6994 20.1265 12.3584 20.4675C12.0174 20.8084 11.5549 21 11.0727 21C10.5905 21 10.1281 20.8084 9.78708 20.4675C9.4461 20.1265 9.25455 19.664 9.25455 19.1818V19.1C9.24751 18.7991 9.15011 18.5073 8.97501 18.2625C8.79991 18.0176 8.55521 17.8312 8.27273 17.7273C7.99853 17.6063 7.69437 17.5702 7.39947 17.6236C7.10456 17.6771 6.83244 17.8177 6.61818 18.0273L6.56364 18.0818C6.39478 18.2509 6.19425 18.385 5.97353 18.4765C5.7528 18.568 5.51621 18.6151 5.27727 18.6151C5.03834 18.6151 4.80174 18.568 4.58102 18.4765C4.36029 18.385 4.15977 18.2509 3.99091 18.0818C3.82186 17.913 3.68775 17.7124 3.59626 17.4917C3.50476 17.271 3.45766 17.0344 3.45766 16.7955C3.45766 16.5565 3.50476 16.3199 3.59626 16.0992C3.68775 15.8785 3.82186 15.678 3.99091 15.5091L4.04545 15.4545C4.25503 15.2403 4.39562 14.9682 4.4491 14.6733C4.50257 14.3784 4.46647 14.0742 4.34545 13.8C4.23022 13.5311 4.03887 13.3018 3.79497 13.1403C3.55107 12.9788 3.26526 12.8921 2.97273 12.8909H2.81818C2.33597 12.8909 1.87351 12.6994 1.53253 12.3584C1.19156 12.0174 1 11.5549 1 11.0727C1 10.5905 1.19156 10.1281 1.53253 9.78708C1.87351 9.4461 2.33597 9.25455 2.81818 9.25455H2.9C3.2009 9.24751 3.49273 9.15011 3.73754 8.97501C3.98236 8.79991 4.16883 8.55521 4.27273 8.27273C4.39374 7.99853 4.42984 7.69437 4.37637 7.39947C4.3229 7.10456 4.18231 6.83244 3.97273 6.61818L3.91818 6.56364C3.74913 6.39478 3.61503 6.19425 3.52353 5.97353C3.43203 5.7528 3.38493 5.51621 3.38493 5.27727C3.38493 5.03834 3.43203 4.80174 3.52353 4.58102C3.61503 4.36029 3.74913 4.15977 3.91818 3.99091C4.08704 3.82186 4.28757 3.68775 4.50829 3.59626C4.72901 3.50476 4.96561 3.45766 5.20455 3.45766C5.44348 3.45766 5.68008 3.50476 5.9008 3.59626C6.12152 3.68775 6.32205 3.82186 6.49091 3.99091L6.54545 4.04545C6.75971 4.25503 7.03183 4.39562 7.32674 4.4491C7.62164 4.50257 7.9258 4.46647 8.2 4.34545H8.27273C8.54161 4.23022 8.77093 4.03887 8.93245 3.79497C9.09397 3.55107 9.18065 3.26526 9.18182 2.97273V2.81818C9.18182 2.33597 9.37338 1.87351 9.71435 1.53253C10.0553 1.19156 10.5178 1 11 1C11.4822 1 11.9447 1.19156 12.2856 1.53253C12.6266 1.87351 12.8182 2.33597 12.8182 2.81818V2.9C12.8193 3.19253 12.906 3.47834 13.0676 3.72224C13.2291 3.96614 13.4584 4.15749 13.7273 4.27273C14.0015 4.39374 14.3056 4.42984 14.6005 4.37637C14.8954 4.3229 15.1676 4.18231 15.3818 3.97273L15.4364 3.91818C15.6052 3.74913 15.8057 3.61503 16.0265 3.52353C16.2472 3.43203 16.4838 3.38493 16.7227 3.38493C16.9617 3.38493 17.1983 3.43203 17.419 3.52353C17.6397 3.61503 17.8402 3.74913 18.0091 3.91818C18.1781 4.08704 18.3122 4.28757 18.4037 4.50829C18.4952 4.72901 18.5423 4.96561 18.5423 5.20455C18.5423 5.44348 18.4952 5.68008 18.4037 5.9008C18.3122 6.12152 18.1781 6.32205 18.0091 6.49091L17.9545 6.54545C17.745 6.75971 17.6044 7.03183 17.5509 7.32674C17.4974 7.62164 17.5335 7.9258 17.6545 8.2V8.27273C17.7698 8.54161 17.9611 8.77093 18.205 8.93245C18.4489 9.09397 18.7347 9.18065 19.0273 9.18182H19.1818C19.664 9.18182 20.1265 9.37338 20.4675 9.71435C20.8084 10.0553 21 10.5178 21 11C21 11.4822 20.8084 11.9447 20.4675 12.2856C20.1265 12.6266 19.664 12.8182 19.1818 12.8182H19.1C18.8075 12.8193 18.5217 12.906 18.2778 13.0676C18.0339 13.2291 17.8425 13.4584 17.7273 13.7273Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>',
            'upload'     => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M19 13V14.2C19 15.8802 19 16.7202 18.673 17.362C18.3854 17.9265 17.9265 18.3854 17.362 18.673C16.7202 19 15.8802 19 14.2 19H5.8C4.11984 19 3.27976 19 2.63803 18.673C2.07354 18.3854 1.6146 17.9265 1.32698 17.362C1 16.7202 1 15.8802 1 14.2V13M15 6L10 1M10 1L5 6M10 1V13" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>',
            'plus'       => '<svg idth="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M8 1V15M1 8H15" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>',
            'trash'      => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M16 6V5.2C16 4.0799 16 3.51984 15.782 3.09202C15.5903 2.71569 15.2843 2.40973 14.908 2.21799C14.4802 2 13.9201 2 12.8 2H11.2C10.0799 2 9.51984 2 9.09202 2.21799C8.71569 2.40973 8.40973 2.71569 8.21799 3.09202C8 3.51984 8 4.0799 8 5.2V6M3 6H21M19 6V17.2C19 18.8802 19 19.7202 18.673 20.362C18.3854 20.9265 17.9265 21.3854 17.362 21.673C16.7202 22 15.8802 22 14.2 22H9.8C8.11984 22 7.27976 22 6.63803 21.673C6.07354 21.3854 5.6146 20.9265 5.32698 20.362C5 19.7202 5 18.8802 5 17.2V6" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>',
            'edit'       => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M18 10L14 6M2.49997 21.5L5.88434 21.124C6.29783 21.078 6.50457 21.055 6.69782 20.9925C6.86926 20.937 7.03242 20.8586 7.18286 20.7594C7.35242 20.6475 7.49951 20.5005 7.7937 20.2063L21 7C22.1046 5.89543 22.1046 4.10457 21 3C19.8954 1.89543 18.1046 1.89543 17 3L3.7937 16.2063C3.49952 16.5005 3.35242 16.6475 3.24061 16.8171C3.1414 16.9676 3.06298 17.1307 3.00748 17.3022C2.94493 17.4954 2.92195 17.7021 2.87601 18.1156L2.49997 21.5Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>',
            'clone'      => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M8 8V5.2C8 4.0799 8 3.51984 8.21799 3.09202C8.40973 2.71569 8.71569 2.40973 9.09202 2.21799C9.51984 2 10.0799 2 11.2 2H18.8C19.9201 2 20.4802 2 20.908 2.21799C21.2843 2.40973 21.5903 2.71569 21.782 3.09202C22 3.51984 22 4.0799 22 5.2V12.8C22 13.9201 22 14.4802 21.782 14.908C21.5903 15.2843 21.2843 15.5903 20.908 15.782C20.4802 16 19.9201 16 18.8 16H16M5.2 22H12.8C13.9201 22 14.4802 22 14.908 21.782C15.2843 21.5903 15.5903 21.2843 15.782 20.908C16 20.4802 16 19.9201 16 18.8V11.2C16 10.0799 16 9.51984 15.782 9.09202C15.5903 8.71569 15.2843 8.40973 14.908 8.21799C14.4802 8 13.9201 8 12.8 8H5.2C4.0799 8 3.51984 8 3.09202 8.21799C2.71569 8.40973 2.40973 8.71569 2.21799 9.09202C2 9.51984 2 10.0799 2 11.2V18.8C2 19.9201 2 20.4802 2.21799 20.908C2.40973 21.2843 2.71569 21.5903 3.09202 21.782C3.51984 22 4.07989 22 5.2 22Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>',
            'to_link'    => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M21 9.00001L21 3.00001M21 3.00001H15M21 3.00001L12 12M10 3H7.8C6.11984 3 5.27976 3 4.63803 3.32698C4.07354 3.6146 3.6146 4.07354 3.32698 4.63803C3 5.27976 3 6.11984 3 7.8V16.2C3 17.8802 3 18.7202 3.32698 19.362C3.6146 19.9265 4.07354 20.3854 4.63803 20.673C5.27976 21 6.11984 21 7.8 21H16.2C17.8802 21 18.7202 21 19.362 20.673C19.9265 20.3854 20.3854 19.9265 20.673 19.362C21 18.7202 21 17.8802 21 16.2V14" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
            'down-arrow' => '<svg width="14" height="8" viewBox="0 0 14 8" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M1 1L7 7L13 1" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
            'pro'        => '<svg xmlns="http://www.w3.org/2000/svg" width="512" height="512" viewBox="0 0 512 512" fill="none"> <path d="M405.333 204.373L350.507 218.027L282.027 132.693C279.028 128.956 275.229 125.94 270.909 123.867C266.589 121.794 261.858 120.718 257.067 120.718C252.275 120.718 247.545 121.794 243.225 123.867C238.905 125.94 235.105 128.956 232.107 132.693L163.627 218.027L107.733 204.373C102.377 203.091 96.7809 203.204 91.4803 204.701C86.1798 206.198 81.3516 209.029 77.4569 212.924C73.5623 216.818 70.7313 221.646 69.2344 226.947C67.7374 232.248 67.6246 237.843 68.9067 243.2L106.667 375.893C107.957 380.508 110.763 384.553 114.633 387.379C118.503 390.204 123.212 391.644 128 391.467H384C388.788 391.644 393.497 390.204 397.367 387.379C401.237 384.553 404.043 380.508 405.333 375.893L443.307 243.2C444.532 237.929 444.41 232.433 442.952 227.221C441.493 222.01 438.745 217.249 434.96 213.38C431.176 209.511 426.478 206.657 421.3 205.083C416.122 203.509 410.631 203.265 405.333 204.373Z" fill="#EFA83C"/> <path d="M58.6667 181.333C73.3943 181.333 85.3333 169.394 85.3333 154.667C85.3333 139.939 73.3943 128 58.6667 128C43.9391 128 32 139.939 32 154.667C32 169.394 43.9391 181.333 58.6667 181.333Z" fill="#EFA83C"/> <path d="M453.333 181.333C468.061 181.333 480 169.394 480 154.667C480 139.939 468.061 128 453.333 128C438.606 128 426.667 139.939 426.667 154.667C426.667 169.394 438.606 181.333 453.333 181.333Z" fill="#EFA83C"/> <path d="M256 90.6668C270.728 90.6668 282.667 78.7278 282.667 64.0002C282.667 49.2726 270.728 37.3335 256 37.3335C241.272 37.3335 229.333 49.2726 229.333 64.0002C229.333 78.7278 241.272 90.6668 256 90.6668Z" fill="#EFA83C"/> <path d="M384 469.334H128C122.342 469.334 116.916 467.086 112.915 463.085C108.914 459.085 106.667 453.658 106.667 448C106.667 442.342 108.914 436.916 112.915 432.915C116.916 428.915 122.342 426.667 128 426.667H384C389.658 426.667 395.084 428.915 399.085 432.915C403.086 436.916 405.333 442.342 405.333 448C405.333 453.658 403.086 459.085 399.085 463.085C395.084 467.086 389.658 469.334 384 469.334Z" fill="#EFA83C"/> </svg>',
            'analytics'  => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M21 21H4.6C4.03995 21 3.75992 21 3.54601 20.891C3.35785 20.7951 3.20487 20.6422 3.10899 20.454C3 20.2401 3 19.9601 3 19.4V3M21 7L15.5657 12.4343C15.3677 12.6323 15.2687 12.7313 15.1545 12.7684C15.0541 12.8011 14.9459 12.8011 14.8455 12.7684C14.7313 12.7313 14.6323 12.6323 14.4343 12.4343L12.5657 10.5657C12.3677 10.3677 12.2687 10.2687 12.1545 10.2316C12.0541 10.1989 11.9459 10.1989 11.8455 10.2316C11.7313 10.2687 11.6323 10.3677 11.4343 10.5657L7 15M21 7H17M21 7V11" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>',
            'diamond'    => '<svg width="22" height="20" viewBox="0 0 22 20" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M1.49954 7H20.4995M8.99954 1L6.99954 7L10.9995 18.5L14.9995 7L12.9995 1M11.6141 18.2625L20.5727 7.51215C20.7246 7.32995 20.8005 7.23885 20.8295 7.13717C20.8551 7.04751 20.8551 6.95249 20.8295 6.86283C20.8005 6.76114 20.7246 6.67005 20.5727 6.48785L16.2394 1.28785C16.1512 1.18204 16.1072 1.12914 16.0531 1.09111C16.0052 1.05741 15.9518 1.03238 15.8953 1.01717C15.8314 1 15.7626 1 15.6248 1H6.37424C6.2365 1 6.16764 1 6.10382 1.01717C6.04728 1.03238 5.99385 1.05741 5.94596 1.09111C5.89192 1.12914 5.84783 1.18204 5.75966 1.28785L1.42633 6.48785C1.2745 6.67004 1.19858 6.76114 1.16957 6.86283C1.144 6.95249 1.144 7.04751 1.16957 7.13716C1.19858 7.23885 1.2745 7.32995 1.42633 7.51215L10.385 18.2625C10.596 18.5158 10.7015 18.6424 10.8279 18.6886C10.9387 18.7291 11.0603 18.7291 11.1712 18.6886C11.2975 18.6424 11.4031 18.5158 11.6141 18.2625Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
            'check'      => '<svg width="16" height="16" viewBox="0 0 18 13" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M17 1L6 12L1 7" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
            'prev'       => '<svg width="8" height="12" viewBox="0 0 8 14" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M7 13L1 7L7 1" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
            'next'       => '<svg width="8" height="12" viewBox="0 0 8 14" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M1 13L7 7L1 1" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>'
        ];

    }//end svg_icons()


    /**
     * Widget default setting
     *
     * @since  1.1.2
     * @return array The setting of the widget
     */
    public static function get_customize_widget_setting()
    {
        return [
            'view'                        => 'icon_view',
            'chat_icon'                   => "chat-line",
            'list_view_title'             => 'How would you like to contact us?',
            'list_view_subtitle'          => 'Welcome!',
            'woocommerce_customization'   => "no",
            'woo_list_view_title'         => "How would you like to contact us?",
            'woo_list_view_subtitle'      => "Welcome!",
            'list_title_bg'               => '#1c5fc6',
            'list_title_color'            => '#ffffff',
            'bg_color'                    => '#1c5fc6',
            'interaction_bg_color'        => '#1c5fc6',
            'text_color'                  => '#ffffff',
            'interaction_text_color'      => '#ffffff',
            'icon_size'                   => "56",
            'border_radius'               => "28",
            'call_to_action'              => 'Contact Us',
            'font_family'                 => '',
            'menu_animation'              => 'ginger-menu-slide',
            'animation'                   => 'ginger-btn-shockwave',
            'position'                    => 'right',
            'position_in_mobile'          => 'no',
            'menu_view'                   => 'vertical',
            'show_cta'                    => 'all_time',
            'default_state'               => 'click',
            'show_close_button'           => 'yes',
            'hide_menu_after_close_click' => 'yes',
            'has_pending_message'         => 'no',
            'no_of_messages'              => 1,
            'message_bg_color'            => '#e64056',
            'message_text_color'          => '#ffffff',
            'widget_analytics'            => 'no',
            'show_greeting_message'       => 'no',
            'greeting_text'               => '<p>Hi there! How can we help you?</p><p>Tap here to start chat with us.</p>',
            'greeting_after'              => '3',
            'greeting_bg_color'           => '#ffffff',
            'greeting_text_color'         => '#000000'
        ];

    }//end get_customize_widget_setting()


    /**
     * Display rule default setting
     *
     * @since  1.1.2
     * @return array The setting of the display rule
     */
    public static function get_display_rule_setting()
    {
        return [
            'time_rule'    => 'all_time',
            'page_rule'    => 'all_pages',
            'country_rule' => 'all_country',
            'dates_rule'   => 'all_dates',
            'user_rule'    => 'all_users',
        ];

    }//end get_display_rule_setting()


    /**
     * Tooltip default setting
     *
     * @since  1.1.2
     * @return array The setting of the tooltip
     */
    public static function get_tooltip_setting()
    {
        return [
            'font_size'      => '16',
            'tooltip_height' => '20',
            'border_radius'  => '5',
            'bg_color'       => "#ffffff",
            'text_color'     => '#000000',
        ];

    }//end get_tooltip_setting()


    /**
     * Trigger rule default setting
     *
     * @since  1.1.2
     * @return array The setting of trigger rules
     */
    public static function get_trigger_rule_setting()
    {
        return [
            'on_scroll'     => 'yes',
            'page_scroll'   => '0',
            'after_seconds' => 'yes',
            'seconds'       => '0',
            'exit_intent'   => 'no',
            'browser'       => 'yes',
            'on_inactivity' => 'yes',
        ];

    }//end get_trigger_rule_setting()


    /**
     * Channel default setting
     *
     * @since  1.1.2
     * @param  array $icon An array containing icon information.
     * @return array The default settings for a channel.
     */
    public static function get_channel_setting($icon)
    {
        return [
            'value'                     => '',
            'title'                     => $icon['title'],
            'icon'                      => $icon['icon'],
            'for_desktop'               => 'yes',
            'for_mobile'                => 'yes',
            'image_id'                  => '',
            'bg_color'                  => $icon['color'],
            'text_color'                => '#ffffff',
            'bg_hover_color'            => $icon['color'],
            'text_hover_color'          => '#ffffff',
            'custom_id'                 => '',
            'custom_class'              => '',
            'whatsapp_message'          => '',
            'is_mobile_link'            => 'no',
            'email_subject'             => '',
            'sms_message'               => '',
            'show_whatsapp_popup'       => 'no',
            'custom_whatsapp_profile'   => '',
            'whatsapp_popup_title'      => esc_html__("Need any help?", 'sticky-chat-widget'),
            'whatsapp_popup_sub_title'  => esc_html__("Let's chat on WhatsApp", 'sticky-chat-widget'),
            'whatsapp_popup_text'       => '<p>Hi there,</p><p>How can I help you?</p>',
            'whatsapp_user_profile_img' => '',
            'whatsapp_name_to_display'  => '',
            'wechat_qr_popup_heading'   => 'WeChat ID',
            'wechat_qr_bg_color'        => '#00C80F',
            'wechat_qr_heading'         => 'Scan QR Code',
            'wechat_qr_img'             => '',
            'is_ig_link'                => 'no',
            'open_in_new_tab'           => 'yes'
        ];

    }//end get_channel_setting()


    /**
     * Contact form default setting
     *
     * @since  1.1.2
     * @param  array $icon An array containing icon information.
     * @return array The default settings for a contact form.
     */
    public static function get_contact_form_setting($icon)
    {
        return [
            'btn_bg_hover_color'       => $icon['color'],
            'btn_bg_color'             => $icon['color'],
            'btn_color'                => '#ffffff',
            'btn_hover_color'          => '#ffffff',
            'success_msg'              => esc_html__('Form Submitted Successfully!', 'sticky-chat-widget'),
            'btn_text'                 => esc_html__('Submit', 'sticky-chat-widget'),
            'form_title'               => esc_html__('Contact Form', 'sticky-chat-widget'),
            'is_redirect'              => 0,
            'redirect_url'             => '',
            'is_redirect_new_tab'      => 0,
            'is_close_aftr_submit'     => 0,
            'close_after_sec'          => 5,
            'is_send_leads'            => 0,
            'auto_responder'           => 0,
            'google_captcha'           => 0,
            'sends_leads_to_mailchimp' => 0,
            'sends_leads_to_mailpoet'  => 0,
            'fields'                   => [
                'name'    => [
                    'label'            => esc_html__('Name', 'sticky-chat-widget'),
                    'placeholder_text' => '',
                    'is_visible'       => 1,
                    'is_required'      => 1,
                    'required_msg'     => esc_html__('This field is required', 'sticky-chat-widget'),
                ],
                'email'   => [
                    'label'            => esc_html__('Email', 'sticky-chat-widget'),
                    'placeholder_text' => '',
                    'is_visible'       => 1,
                    'is_required'      => 1,
                    'required_msg'     => esc_html__('This field is required', 'sticky-chat-widget'),
                ],
                'phone'   => [
                    'label'            => esc_html__('Mobile number', 'sticky-chat-widget'),
                    'placeholder_text' => '',
                    'is_visible'       => 1,
                    'is_required'      => 1,
                    'required_msg'     => esc_html__('This field is required', 'sticky-chat-widget'),
                ],
                'message' => [
                    'label'            => esc_html__('Message', 'sticky-chat-widget'),
                    'placeholder_text' => '',
                    'is_visible'       => 1,
                    'is_required'      => 1,
                    'required_msg'     => esc_html__('This field is required', 'sticky-chat-widget'),
                ],
                'consent_checkbox' => [
                    'label'            => esc_html__('Consent Checkbox', 'sticky-chat-widget'),
                    'placeholder_text' => esc_html__('I accept terms & conditions', 'sticky-chat-widget'),
                    'is_visible'       => 1,
                    'is_required'      => 1,
                    'required_msg'     => esc_html__('This field is required', 'sticky-chat-widget')
                ]
            ],
        ];

    }//end get_contact_form_setting()


    /**
     * Load and sanitize SVG file path
     *
     * @param string $file_path The path of the SVG file
     * @return void
     */
    public static function load_and_sanitize_svg($file_path ) {

        $kses_defaults = wp_kses_allowed_html( 'post' );

        $svg_args = array(
            'svg' => Ginger_Social_Icons::get_allowed_tags(),
            'altglyph' => Ginger_Social_Icons::get_allowed_tags(),
            'altglyphdef' => Ginger_Social_Icons::get_allowed_tags(),
            'altglyphitem' => Ginger_Social_Icons::get_allowed_tags(),
            'animatecolor' => Ginger_Social_Icons::get_allowed_tags(),
            'animatemotion' => Ginger_Social_Icons::get_allowed_tags(),
            'animatetransform' => Ginger_Social_Icons::get_allowed_tags(),
            'circle' => Ginger_Social_Icons::get_allowed_tags(),
            'clippath' => Ginger_Social_Icons::get_allowed_tags(),
            'defs' => Ginger_Social_Icons::get_allowed_tags(),
            'desc' => Ginger_Social_Icons::get_allowed_tags(),
            'ellipse' => Ginger_Social_Icons::get_allowed_tags(),
            'filter' => Ginger_Social_Icons::get_allowed_tags(),
            'font' => Ginger_Social_Icons::get_allowed_tags(),
            'g' => Ginger_Social_Icons::get_allowed_tags(),
            'glyph' => Ginger_Social_Icons::get_allowed_tags(),
            'glyphref' => Ginger_Social_Icons::get_allowed_tags(),
            'hkern' => Ginger_Social_Icons::get_allowed_tags(),
            'image' => Ginger_Social_Icons::get_allowed_tags(),
            'line' => Ginger_Social_Icons::get_allowed_tags(),
            'lineargradient' => Ginger_Social_Icons::get_allowed_tags(),
            'marker' => Ginger_Social_Icons::get_allowed_tags(),
            'mask' => Ginger_Social_Icons::get_allowed_tags(),
            'metadata' => Ginger_Social_Icons::get_allowed_tags(),
            'mpath' => Ginger_Social_Icons::get_allowed_tags(),
            'path' => Ginger_Social_Icons::get_allowed_tags(),
            'pattern' => Ginger_Social_Icons::get_allowed_tags(),
            'polygon' => Ginger_Social_Icons::get_allowed_tags(),
            'polyline' => Ginger_Social_Icons::get_allowed_tags(),
            'radialgradient' => Ginger_Social_Icons::get_allowed_tags(),
            'rect' => Ginger_Social_Icons::get_allowed_tags(),
            'stop' => Ginger_Social_Icons::get_allowed_tags(),
            'switch' => Ginger_Social_Icons::get_allowed_tags(),
            'symbol' => Ginger_Social_Icons::get_allowed_tags(),
            'text' => Ginger_Social_Icons::get_allowed_tags(),
            'textpath' => Ginger_Social_Icons::get_allowed_tags(),
            'title' => Ginger_Social_Icons::get_allowed_tags(),
            'tref' => Ginger_Social_Icons::get_allowed_tags(),
            'tspan' => Ginger_Social_Icons::get_allowed_tags(),
            'use' => Ginger_Social_Icons::get_allowed_tags(),
            'view' => Ginger_Social_Icons::get_allowed_tags(),
            'vkern' => Ginger_Social_Icons::get_allowed_tags(),
        );

        $allowed_tags = array_merge( $kses_defaults, $svg_args );

        echo wp_kses( $file_path, $allowed_tags );
    }


    /**
     * Get allowed tags
     *
     * @return array The array of allowed tags
     */
    public static function get_allowed_tags() {
        return array(
            'accent-height' => true,
            'accumulate' => true,
            'additivive' => true,
            'alignment-baseline' => true,
            'ascent' => true,
            'attributename' => true,
            'attributetype' => true,
            'azimuth' => true,
            'basefrequency' => true,
            'baseline-shift' => true,
            'begin' => true,
            'bias' => true,
            'by' => true,
            'class' => true,
            'clip' => true,
            'clip-path' => true,
            'clip-rule' => true,
            'color' => true,
            'color-interpolation' => true,
            'color-interpolation-filters' => true,
            'color-profile' => true,
            'color-rendering' => true,
            'cx' => true,
            'cy' => true,
            'd' => true,
            'dx' => true,
            'dy' => true,
            'diffuseconstant' => true,
            'direction' => true,
            'display' => true,
            'divisor' => true,
            'dur' => true,
            'edgemode' => true,
            'elevation' => true,
            'end' => true,
            'fill' => true,
            'fill-opacity' => true,
            'fill-rule' => true,
            'filter' => true,
            'filterUnits' => true,
            'flood-color' => true,
            'flood-opacity' => true,
            'font-family' => true,
            'font-size' => true,
            'font-size-adjust' => true,
            'font-stretch' => true,
            'font-style' => true,
            'font-variant' => true,
            'font-weight' => true,
            'fx' => true,
            'fy' => true,
            'g1' => true,
            'g2' => true,
            'glyph-name' => true,
            'glyphref' => true,
            'gradientunits' => true,
            'gradienttransform' => true,
            'height' => true,
            'href' => true,
            'id' => true,
            'image-rendering' => true,
            'in' => true,
            'in2' => true,
            'k' => true,
            'k1' => true,
            'k2' => true,
            'k3' => true,
            'k4' => true,
            'kerning' => true,
            'keypoints' => true,
            'keysplines' => true,
            'keytimes' => true,
            'lang' => true,
            'lengthadjust' => true,
            'letter-spacing' => true,
            'kernelmatrix' => true,
            'kernelunitlength' => true,
            'lighting-color' => true,
            'local' => true,
            'marker-end' => true,
            'marker-mid' => true,
            'marker-start' => true,
            'markerheight' => true,
            'markerunits' => true,
            'markerwidth' => true,
            'maskcontentunits' => true,
            'maskunits' => true,
            'max' => true,
            'mask' => true,
            'media' => true,
            'method' => true,
            'mode' => true,
            'min' => true,
            'name' => true,
            'numoctaves' => true,
            'offset' => true,
            'operator' => true,
            'opacity' => true,
            'order' => true,
            'orient' => true,
            'orientation' => true,
            'origin' => true,
            'overflow' => true,
            'paint-order' => true,
            'path' => true,
            'pathlength' => true,
            'patterncontentunits' => true,
            'patterntransform' => true,
            'patternunits',
            'points' => true,
            'preservealpha' => true,
            'preserveaspectratio' => true,
            'r' => true,
            'rx' => true,
            'ry' => true,
            'radius' => true,
            'refx' => true,
            'refy' => true,
            'repeatcount' => true,
            'repeatdur' => true,
            'restart' => true,
            'result' => true,
            'rotate' => true,
            'scale' => true,
            'seed' => true,
            'shape-rendering' => true,
            'specularconstant' => true,
            'specularexponent' => true,
            'spreadmethod' => true,
            'stddeviation' => true,
            'stitchtiles' => true,
            'stop-color' => true,
            'stop-opacity' => true,
            'stroke-dasharray' => true,
            'stroke-dashoffset' => true,
            'stroke-linecap' => true,
            'stroke-linejoin' => true,
            'stroke-miterlimit' => true,
            'stroke-opacity' => true,
            'stroke' => true,
            'stroke-width' => true,
            'style' => true,
            'surfacescale' => true,
            'tabindex' => true,
            'targetx' => true,
            'targety' => true,
            'transform' => true,
            'text-anchor' => true,
            'text-decoration' => true,
            'text-rendering' => true,
            'textlength' => true,
            'type' => true,
            'u1' => true,
            'u2' => true,
            'unicode' => true,
            'values' => true,
            'viewbox' => true,
            'visibility' => true,
            'vector-effect' => true,
            'vert-adv-y' => true,
            'vert-origin-x' => true,
            'vert-origin-y' => true,
            'width' => true,
            'word-spacing' => true,
            'wrap' => true,
            'writing-mode' => true,
            'xchannelselector' => true,
            'ychannelselector' => true,
            'x' => true,
            'x1' => true,
            'x2' => true,
            'xmlns' => true,
            'y' => true,
            'y1' => true,
            'y2' => true,
            'z' => true,
            'zoomandpan' => true,
        );
    }


}//end class
