<?php 
$args = array(
  'post_type'      => 'post',
  'posts_per_page' => 3,
  'orderby'        => 'modified',
  'order'          => 'DESC',
);

$updated_posts = new WP_Query($args);
if ( $updated_posts->have_posts() ) :

    $update_title = get_field('update_title', 'option'); 
?>
<section class="recently-updated-posts">
    <div class="container-lg">
        <div class="row section-head">
            <div class="col">
                <h2 class="section-title fs-4 fw-medium">
                    <i class="icon-user"></i>
                   <?php echo $update_title; ?>
                </h2>
            </div>
        </div>
        <div class="row row-scrollable">
            <?php while ( $updated_posts->have_posts() ) : $updated_posts->the_post(); ?>
            <div class="col-10 col-sm-8 col-md-4">
                <?php get_template_part('templates/card/updated', 'card'); ?>
            </div>
            <?php
                endwhile;
            ?>
        </div>
    </div>
</section>
<?php wp_reset_postdata(); 
endif; ?>