<?php 
$args = array(
    'post_type' => 'post',
    'posts_per_page' => '4',
    'meta_query' => array(
        array(
            'key' => 'slider_post',
            'compare' => ' = ',
            'value' => '1'
        )
    )
);
$query = new WP_Query($args);
if ($query->have_posts()):
?>
<section class="home_slider">
    <div class="container-lg">
        <h3 class="section-title title-line mb-3 d-block d-md-none">منتخب سردبیر</h3>
        <div id="carouselHomeSlider" class="carousel slide" data-bs-ride="carousel">
            <div class="carousel-indicators">
                <?php 
                    $i = 0;
                    while ($query->have_posts()) : $query->the_post();  
                ?>
                    <button type="button" data-bs-target="#carouselHomeSlider" data-bs-slide-to="<?php echo $i; ?>" class="<?php echo $i == 0 ? 'active' : ''; ?>" aria-current="true" aria-label="Slide 1"></button>
                <?php $i++; endwhile; ?>
            </div>
            <div class="carousel-inner">
                <?php 
                    $i = 0;
                    while ($query->have_posts()) : $query->the_post();  
                    $trimexcerpt = get_the_excerpt();
                    $shortexcerpt = mb_strimwidth($trimexcerpt, 0, $num_words = 170, ' ...');
                ?>
                <div class="carousel-item <?php if($i==0)  echo 'active'; ?>">
                    <article class="blog-item" itemscope="itemscope" itemtype="http://schema.org/Article">
                        <div class="row g-0">
                            <div class="col-12 col-md-4 col-lg-5">
                                <a class="entry-media" href="<?php echo get_the_permalink(); ?>">
                                    <figure class="entry-media ratio ratio-4x3">
                                        <?php
                                        if (has_post_thumbnail()) {
                                            the_post_thumbnail('medium-large');
                                        }
                                        ?>
                                    </figure>
                                </a>
                            </div>
                            <div class="col-12 col-md-8 col-lg-7">
                                <div class="carousel-content">
                                    <span class="entry-top-title d-none d-md-block">منتخب سردبیر</span>
                                    <h3 class="entry-title">
                                        <a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?>  </a>
                                    </h3>
                                    <p class="entry-content"><?php echo $shortexcerpt; ?></p>
                                    <div class="button-wrapper d-inline-flex">
                                        <a class="more-btn_text text-btn" href="<?php echo get_the_permalink(); ?>">
                                            مشاهده مطلب
                                            <i class="icon-arrow-left"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </article>
                </div>
                <?php $i++; endwhile; ?>
            </div>
        </div>
    </div>
</section>

<?php endif; ?>