<article class="blog-card" itemscope="itemscope" itemtype="http://schema.org/Article">
    <a class="entry-media" href="<?php echo esc_url( get_permalink() ); ?>" itemprop="url">
        <figure class="blog-card_media ratio ratio-16x9" itemprop="image">
            <?php
                if (has_post_thumbnail()) {
                    the_post_thumbnail('post-thumb');
                }
            ?>
        </figure>
    </a>
    <div class="blog-card_content">
        <div class="d-flex justify-content-between align-items-center blog-card_meta">
            <?php
                $category = get_the_category();
            if ( ! empty( $category ) ) :
            ?>
            <a 
            class="blog-card_category" 
            href="<?php echo esc_url( get_category_link( $category[0]->term_id ) ); ?>" 
            itemprop="articleSection">
                <?php echo esc_html( $category[0]->name ); ?>
            </a>
            <?php endif; ?>
            <time 
            class="blog-card_date" 
            datetime="<?php echo esc_attr( get_the_modified_date( 'c' ) ); ?>"
            itemprop="datePublished"
            >
                <?php echo esc_html( get_the_modified_date('j M Y') ); ?>
                <i class="icon-calendar"></i>
            </time>
        </div>
        <h3 class="blog-card_title">
            <a class="d-inline-block fw-medium" href="<?php echo esc_url( get_permalink() ); ?>" itemprop="url">
                <?php echo esc_html( get_the_title() ); ?>
            </a>
        </h3>
    </div>
</article>
