<?php
get_header();
?>
<div class="single-page">
    <?php
    if (have_posts()) :
        while (have_posts()) : the_post();
            ?>
            <section class="main-single-content">
                <div class="container-lg">
                    <div class="row single-row">
                        <?php 
                            ob_start();
                            get_sidebar();
                            $sidebar_content = ob_get_clean();
                        ?>
                        <div class="col-12 col-md-8 col-lg-9">
                            <article class="single-page-wrapper" itemscope="itemscope" itemtype="http://schema.org/Article">
                                <?php if (has_post_thumbnail()) { ?>
                                    <figure class="entry-media text-center">
                                        <?php the_post_thumbnail('large'); ?>
                                    </figure>
                                <?php } ?>

                                <h1 class="single-title fw-medium title-line"><?php echo get_the_title(); ?></h1>

                                <div class="single-meta d-flex align-items-center flex-wrap">
                                    <?php 
                                        $categories = get_the_category();
                                        if ( $categories ) {
                                        echo '<p class="meta-col">';
                                            foreach ( $categories as $category ) {
                                                echo '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '" class="cat-link">';
                                                    echo esc_html( $category->name );
                                                echo '</a>';
                                            }
                                        echo '</p>';
                                        }
                                    ?>
                                    <?php
                                    $study_time = get_field('study_time');
                                    if ($study_time != '') { ?>
                                        <p class="meta-col">
                                            <!--<span class="post-label">زمان مطالعه :</span>-->
                                            <span class="meta-item">
                                                <?php echo $study_time; ?>
                                            </span>
                                        </p>
                                    <?php } ?>
                                    <p class="meta-col">
                                        <i class="icon-calendar"></i>
                                        <span class="post-label">
                                            <?php 
                                                echo esc_html( get_the_modified_date() != get_the_date() ? 'ویرایش :' : 'انتشار :' );
                                            ?>
                                        </span>
                                        <span class="meta-item" itemprop="datePublished">
                                            <?php 
                                                echo esc_html( get_the_modified_date() != get_the_date() ? get_the_modified_date('j . M . Y') : get_the_date('j . M . Y') );
                                            ?>
                                        </span>
                                    </p>
                                </div>
                                <div class="entry-content default-editor">
                                    <?php the_content(); ?>
                                </div>
                            </article>

                            <!-- Comment-->
                            <?php
                            if (comments_open() && post_type_supports(get_post_type(), 'comments')) {
                                ?>
                                <div class="post-comments">
                                    <?php comments_template(); ?>
                                </div>
                            <?php } ?>
                        </div>
                        <aside class="col-12 col-md-4 col-lg-3 d-none d-md-block">
                            <div class="sidebar">
                               <?php echo $sidebar_content; ?>
                            </div>
                        </aside>
                    </div>
                </div>
            </section>
        <?php
        endwhile;
    endif; ?>

    <?php
    $related = get_field('related_blog');
    if ($related) {
        $posts = new WP_Query(array(
            'post_type' => 'post',
            'post__in' => $related,
            'posts_per_page' => '3',
        ));
    
    if ($posts->have_posts()) { ?>
    <section class="related-blog gray-bg">
        <div class="container">
            <div class="row section-head">
                <div class="col">
                    <h2 class="section-title fs-4 fw-medium">
                        <i class="icon-user"></i>
                        مطالب پیشنهادی
                    </h2>
                </div>
            </div>
            <div class="row row-scrollable">
                <?php while ( $posts->have_posts() ) : $posts->the_post(); ?>
                <div class="col-10 col-md-4 blog-item">
                    <?php get_template_part('templates/card/blog', 'card'); ?>
                </div>
                <?php
                    endwhile;
                ?>
            </div>
        </div>
    </section>
    <?php }
        wp_reset_postdata();
    }
    ?>

    <?php 
    $faqs = get_field('add_faq');
    if ($faqs && is_array($faqs) && have_rows('add_faq')): ?>
        <section class="faq-section ui-p-64 d-none d-sm-block">
            <div class="container">
                <div class="row">
                    <div class="col-12 col-lg-9">
                        <h3 class="section-title fs-4 fw-medium title-line">
                            پرسش‌های متداول
                        </h3>

                        <div class="faq-wrapper accordion" id="faqAccordion">
                            <?php
                                $count = 1;
                                $i = 1;
                                $faqjd = '<script type="application/ld+json">
                                {
                                    "@context": "https://schema.org",
                                    "@type": "FAQPage",
                                    "mainEntity": [';

                                while (have_rows('add_faq')) : the_row();
                                    $faq_title = get_sub_field('question');
                                    $faq_text = get_sub_field('answer');
                                ?>
                                <div class="faq-item">
                                    <?php if ($faq_title != '') { ?>
                                        <div class="faq-item_question" id="heading<?php echo $i; ?>">
                                            <div class="faq-item_inner d-flex align-items-center <?php echo ($count === 1) ? '' : 'collapsed'; ?>" data-bs-toggle="collapse"
                                                    data-bs-target="#collapse<?php echo $i; ?>"
                                                    aria-expanded="true"
                                                    aria-controls="collapse<?php echo $i; ?>">
                                                <h4 class="faq-question"><?php echo $faq_title; ?></h4>
                                                <span class="arrow-down"></span>
                                            </div>
                                        </div>
                                    <?php }
                                    if ($faq_text): ?>
                                    <div id="collapse<?php echo $i; ?>"
                                        class="faq-item_answer collapse <?php echo ($count == 1) ? 'show' : ''; ?>" 
                                        aria-labelledby="heading<?php echo $i; ?>"
                                        data-bs-parent="#faqAccordion">
                                        <div class="pt-0"><?php echo wp_kses_post($faq_text); ?></div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <?php
                                $faqjd .= '{
                                    "@type": "Question",
                                    "name": "' . esc_html(get_sub_field('question_faq')) . '",
                                    "acceptedAnswer": {
                                        "@type": "Answer",
                                        "text": "' . esc_html(str_replace('"', "'", get_sub_field('answer_faq'))) . '"
                                    }
                                },';
                                $count++;
                                $i++;
                            endwhile;
                            $faqjd = rtrim($faqjd, ',') . ']}</script>';
                            echo $faqjd;
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    
   <aside class="d-block d-md-none mobile-sidebar">
        <div class="sidebar">
           <?php echo $sidebar_content; ?>
        </div>
    </aside> 
</div>
<?php get_footer(); ?>
