<?php
get_header();
$paged = (get_query_var('paged')) ? get_query_var('paged') : ((get_query_var('page')) ? get_query_var('page') : 1);
?>

<div class="page-wrap archive-blog">
    <section class="archive-list">
        <div class="container-lg">
            <div class="row">
                <div class="col-12">
                    <h1 class="page-title fs-4 fw-medium">
                        <i class="icon-user"></i>
                        <?php echo get_the_title( get_option('page_for_posts') ); ?>
                    </h1>
                </div>
                <?php
                    $args = array(
                        'post_type' => 'post',
                        'paged' => $paged,
                        'post_status ' => 'publish',
                    );
                    $posts = new WP_Query($args);
                    if ($posts->have_posts()):
                        while ($posts->have_posts()) : $posts->the_post();
                            ?>
                            <div class="col-12 col-sm-6 col-md-4 ui-mb-20">
                                <?php get_template_part('templates/card/blog', 'card'); ?>
                            </div>
                            <?php endwhile;
                    endif;
                    wp_reset_postdata();
                ?>

            </div>
            <div class="col-12">
                <div class="site-pagination">
                    <?php pagination_bar($posts); ?>
                </div>
            </div>
        </div>
    </section>
</div>
<?php get_footer(); ?>
