<?php
/**
Include ACF Plugin
**/
add_filter('acf/settings/path', 'my_acf_settings_path');
function my_acf_settings_path( $path ) {
    $path = get_stylesheet_directory() . '/includes/acf/';
    return $path;
}
add_filter('acf/settings/dir', 'my_acf_settings_dir');
function my_acf_settings_dir( $dir ) {
    $dir = get_stylesheet_directory_uri() . '/includes/acf/';
    return $dir;
}
include_once( get_stylesheet_directory() . '/includes/acf/acf.php' );

/**
General Settings
**/
add_action('after_setup_theme', 'tiyara_theme_setup');
function tiyara_theme_setup(){
    load_theme_textdomain('tiyara', get_template_directory() . '/languages');

	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
	//Remove Default Wordpress Gallery Styles
	add_filter( 'use_default_gallery_style', '__return_false' );
}
/**
  Proper way to enqueue scripts and styles
**/
function tiyara_scripts() {
	wp_enqueue_style( 'bootstrap', get_template_directory_uri() .'/assets/vendors/bootstrap/bootstrap.rtl.min.css' );
	wp_enqueue_style( 'style', get_template_directory_uri() .'/style.css' );
    wp_enqueue_script( 'bootstrapjs', get_template_directory_uri() . '/assets/vendors/bootstrap/bootstrap.min.js', array('jquery'), '1.0', true );
	if ( is_singular() ) {
		wp_enqueue_script( 'comment-reply' );
		wp_enqueue_script( 'validate', get_template_directory_uri() . '/assets/js/jquery.validate.min.js', array(), '1.0', true );
	}
	wp_enqueue_script( 'custom.js', get_template_directory_uri() . '/assets/js/custom.js', array('jquery'), '1.0', true );

}
add_action( 'wp_enqueue_scripts', 'tiyara_scripts' );
/**
 Starndard Image Sizes
**/
add_action('after_setup_theme', 'tiyara_image_sizes');
function tiyara_image_sizes(){
	add_image_size( 'post-thumb', 364, 200, true ); // (cropped)
	add_image_size( 'medium-large', 460, 340, true ); // (cropped)
	
}
/**
 Register Menu Locations
**/
add_action('after_setup_theme', 'tiyara_menus');

function tiyara_menus(){

    register_nav_menus( array(
		'main'  => __( 'منوی اصلی', 'tiyara' ),
		'mobile'  => __( 'منوی اصلی (موبایل)', 'tiyara' ),
		'footer-1'  => __( ' منوی فوتر(1)', 'tiyara' ),
		'footer-2'  => __( ' منوی فوتر(2)', 'tiyara' ),
		'footer-mobile'  => __( ' منوی فوتر (موبایل) ', 'tiyara' ),
	) );
	
}
/**
 Register Sidebar
**/
add_action( 'widgets_init', 'tiyara_register_sidebars' );

function tiyara_register_sidebars() {
	register_sidebar( array(
		'name'          => 'سایدبار',
		'id'            => 'sidebar-blog',
		'description'   => 'سایدبار مقالات',
		'class'         => '',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	) );
}


if( function_exists('acf_add_options_page') ) {

    acf_add_options_page(array(
        'page_title'    => 'تنظیمات کلی قالب',
        'menu_title'    => 'تنظیمات قالب',
        'menu_slug'     => 'theme-settings', // اسلاگ انگلیسی
        'capability'    => 'manage_options',
        'redirect'      => false
    ));

    acf_add_options_sub_page(array(
        'page_title'    => 'تنظیمات صفحه اصلی',
        'menu_title'    => 'صفحه اصلی',
        'parent_slug'   => 'theme-settings', // اسلاگ انگلیسی
        'menu_slug'     => 'home-settings',  // اسلاگ انگلیسی
        'capability'    => 'manage_options',
    ));

}

?>
