<?php
function socialshares()
{
    $title = urlencode(get_the_title());
    $url = urlencode(get_permalink());
    $homeurl = urlencode(get_bloginfo('url'));
    $desc = urlencode(get_the_excerpt());
    $share = '<ul class="share-social">';
    $share .= '';
    $share .= '<li><a href="https://www.facebook.com/sharer/sharer.php?u=' . $url . '&amp;t=' . $title . '" title="Share on Facebook" target="_blank" rel=" nofollow noopener" class="facebook"><i class="icon-facebook"></i></a></li>';
    $share .= '<li><a href="https://twitter.com/intent/tweet?source=' . $url . '&amp;text=' . $title . ':' . $homeurl . '" target="_blank" title="Tweet" rel="nofollow noopener" class="twitter"><i class="icon-twitter"></i></a></li>';
//    $share .= '<li ><a href="https://telegram.me/share/url?url=' . $url . '&amp;text=' . $title . ':' . $homeurl . '" title="telegram" rel="nofollow noopener" target="_blank" class="telegram"><i class="icon-telegram"></i></a></li>';
    $share .= '<li><a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=' . $url . '&amp;title=' . $title . '&amp;summary=' . $desc . '&amp;source=' . $homeurl . '" target="_blank" title="Share on LinkedIn" class="linkedin" rel="nofollow noopener" ><i class="icon-linkedin"></i></a></li>';
    $share .= '</ul>';
    return $share;
}

function social_links()
{
    if (have_rows('add_social', 'option')):
        $share = '<ul class="social-list d-flex align-items-center">';
        while (have_rows('add_social', 'option')) : the_row();
            $social_icon = get_sub_field('social_icon', 'option');
            $social_url = get_sub_field('social_link', 'option');
            if ($social_url != '') {
                $share .= '<li class="social-list_item">';
                $share .= '<a href = "' . $social_url . '" target = "_blank" class="' . $social_icon . '" >';
                $share .= '<i class="icon-' . $social_icon . '" ></i>';
                $share .= '</a>';
                $share .= '</li>';
            }
        endwhile;
        $share .= '</ul>';
        return $share;
    endif;
}

// Pagination
function pagination_bar($custom_query)
{
    $total_pages = $custom_query->max_num_pages;
    $big = 999999999; 
    if ($total_pages > 1) {
        $current_page = max(1, get_query_var('paged'));
        echo paginate_links(array(
            'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
            'format' => '?paged=%#%',
            'prev_text' => '<i class="icon-arrow-left"></i>',
            'next_text' => '<i class="icon-arrow-left"></i>',
            'before_page_number' => '',
            'current' => $current_page,
            'total' => $total_pages,
        ));
    }
}

class Latest_Posts_Widget extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'latest_posts_widget',
            __('آخرین مقالات با تصویر شاخص', 'tiyara'), 
            array('description' => __('نمایش آخرین مقالات با تصویر شاخص و عنوان', 'tiyara'))
        );
    }

    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : __('جدیدترین مطالب', 'tiyara');
        $number = !empty($instance['number']) ? $instance['number'] : 5;
        ?>
        <p>
            <label><?php _e('عنوان:'); ?></label>
            <input class="widefat" name="<?php echo $this->get_field_name('title'); ?>" 
                   type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label><?php _e('تعداد:'); ?></label>
            <input class="tiny-text" name="<?php echo $this->get_field_name('number'); ?>" 
                   type="number" step="1" min="1" value="<?php echo esc_attr($number); ?>" size="3">
        </p>
        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        $instance['number'] = (!empty($new_instance['number'])) ? intval($new_instance['number']) : 5;
        return $instance;
    }

    public function widget($args, $instance) {
        $title = apply_filters('widget_title', $instance['title']);
        $number = !empty($instance['number']) ? $instance['number'] : 4;

        echo $args['before_widget'];
        if (!empty($title)) {
            echo $args['before_title'] . $title . $args['after_title'];
        }

        $query = new WP_Query(array(
            'post_type' => 'post',
            'posts_per_page' => $number
        ));

        if ($query->have_posts()) {
            echo '<ul class="latest-posts-widget">';
            while ($query->have_posts()) {
                $query->the_post();
                echo '<li class="d-flex align-items-center">';
                if (has_post_thumbnail()) {
                    echo '<a class="latest-posts-widget_image" href="' . get_permalink() . '">';
                    the_post_thumbnail('thumbnail');
                    echo '</a>';
                }
                echo '<a class="latest-posts-widget_title" href="' . get_permalink() . '">' . get_the_title() . '</a>';
                echo '</li>';
            }
            echo '</ul>';
            wp_reset_postdata();
        }

        echo $args['after_widget'];
    }
}

function register_latest_posts_widget() {
    register_widget('Latest_Posts_Widget');
}
add_action('widgets_init', 'register_latest_posts_widget');

function my_custom_mce_button() {
    if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') ) return;
    if ( get_user_option('rich_editing') == 'true' ) {
        add_filter('mce_external_plugins', 'my_custom_mce_plugin');
        add_filter('mce_buttons', 'my_register_mce_button');
    }
}
add_action('admin_head', 'my_custom_mce_button');

function my_custom_mce_plugin($plugin_array) {
    $plugin_array['my_custom_card'] = get_template_directory_uri() . '/assets/js/mce-card.js';
    return $plugin_array;
}

function my_register_mce_button($buttons) {
    array_push($buttons, 'my_custom_card');
    return $buttons;
}



add_filter('nav_menu_item_title', function ($title, $item, $args, $depth) {
    if ($args->theme_location === 'mobile') {
        $icon = get_field('menu_icon', $item);
        if ($icon) {
            $icon_html = '<img src="' . esc_url($icon['url']) . '" alt="' . esc_attr($item->title) . '" class="menu-icon">';
            $title = $icon_html . '<span class="menu-text">' . esc_html($title) . '</span>';
        } else {
            $title = '<span class="menu-text">' . esc_html($title) . '</span>';
        }
    }
    return $title;
}, 10, 4);
?>
