<?php
$copy_right = get_field('copyright', 'option');
$logo = get_field('logo', 'option');
$about_text = get_field('about_text', 'option');
$footer_logo1 = get_field('footer_logo1', 'options');
$footer_logo2 = get_field('footer_logo2', 'options');
?>
</main>
<footer class="site-footer position-relative">
        <div class="container site-footer-container">
            <div class="row footer-row">
                <div class="col-12 col-md-6 col-lg-5">
                    <div class="footer-about">
                        <?php
                        if ($logo) {
                            echo '<a class="logo-footer" href="' . get_bloginfo('url') . '" >';
                            echo '<img src="' . $logo['url'] . '" width="' . $logo['width'] . '" height="' . $logo['height'] . '" alt="' . $logo['alt'] . '" />';
                            echo '</a>';
                        } 
                        
                        if ($about_text != '') { ?>
                            <p><?php echo $about_text; ?></p>
                        <?php } ?>
                    </div>
                </div>
                <div class="col-12 col-md-6 col-lg-6">
                    <?php
                        if (has_nav_menu('footer-2')) {
                            echo '<div class="footer-menu d-sm-none">';
                                $defaults = array(
                                    'theme_location' => 'footer-mobile',
                                    'menu_class' => 'footer-menu',
                                    'menu_id' => '',
                                    'echo' => true,
                                    'fallback_cb' => 'wp_page_menu',
                                    'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                                    'depth' => 1,
                                );
                                wp_nav_menu($defaults);
                            echo '</div>';
                        }
                    ?>
                    <div class="row d-none d-sm-flex">
                        <div class="col-6 col-md-5 col-lg-6">
                            <?php
                            if (has_nav_menu('footer-1')) {
                                echo '<div class="footer-menu">';
                                    $defaults = array(
                                        'theme_location' => 'footer-1',
                                        'menu_class' => 'footer-menu',
                                        'menu_id' => '',
                                        'echo' => true,
                                        'fallback_cb' => 'wp_page_menu',
                                        'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                                        'depth' => 1,
                                    );
                                    wp_nav_menu($defaults);
                                echo '</div>';
                            }
                            ?>
                        </div>
                         <div class="col-6 col-md-5 col-lg-6">
                            <?php
                            if (has_nav_menu('footer-2')) {
                                echo '<div class="footer-menu">';
                                    $defaults = array(
                                        'theme_location' => 'footer-2',
                                        'menu_class' => 'footer-menu',
                                        'menu_id' => '',
                                        'echo' => true,
                                        'fallback_cb' => 'wp_page_menu',
                                        'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                                        'depth' => 1,
                                    );
                                    wp_nav_menu($defaults);
                                echo '</div>';
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row footer-bottom">
                <div class="col-12 col-md-7 col-lg-6">
                    <?php
                        echo '<div class="social-list-wrapper">';
                            echo social_links();
                        echo '</div>';
                    ?>
                </div>
                <?php if($footer_logo1 || $footer_logo2) {
                echo '<div class="col-12 col-md-5 col-lg-6 text-center text-md-end align-self-center">';
                    if($footer_logo1) {
                        echo '<div class="logo-wrapper">
                            <a href="'. $footer_logo1['_link'] .'"> 
                            <img src="' . $footer_logo1['_img']['url'] . '" width="' . $footer_logo1['_img']['width'] . '" height="' . $footer_logo1['_img']['height'] . '" alt="' . $footer_logo1['_img']['alt'] . '" />
                            </a>
                        </div>';
                    }
                    
                    if($footer_logo2) {
                        echo '<div class="logo-wrapper">
                            <a href="'. $footer_logo2['_link2'] .'"> 
                            <img src="' . $footer_logo2['_img2']['url'] . '" width="' . $footer_logo2['_img2']['width'] . '" height="' . $footer_logo2['_img2']['height'] . '" alt="' . $footer_logo2['_img2']['alt'] . '" />
                            </a>
                        </div>';
                    }
                echo '</div>';
                } ?>
            </div>

            <?php if ($copy_right != '') { ?>
            <div class="row">
                <?php
                    echo '<div class="col-12 site-copyright"><p class="text-center">';
                      
                      echo wp_kses($copy_right, [
                        'a' => [
                          'href' => true,
                          'target' => true,
                          'rel' => true,
                        ],
                      ]);
                         
                    echo '</p></div>';
                ?>
            </div>
            <?php } ?>
        </div>
    </div>
</footer>

<button id="scrollToTopBtn" title="Scroll to Top">
  <span><i class="icon-arrow-up"></i></span>
</button>

<?php
wp_nav_menu([
    'theme_location' => 'mobile',
    'container' => 'nav',
    'menu_class' => 'mobile-menu',
    'container_class' => 'mobile-bottom-nav d-block d-sm-none',
    'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
    'walker' => new Walker_Nav_Menu(),
]);
?>
<?php wp_footer(); 

if (is_singular()) {
    ?>
    <script>
        jQuery('#commentform').validate({
            rules: {
                comment: {
                    required: true,
                    minlength: 1
                }
            },

            messages: {
                comment: "متن نظر الزامی است"
            },

            errorElement: "div",
            errorPlacement: function (error, element) {
                element.after(error);
                jQuery(element).parent('div').addClass('check_error');
            }
        });

    </script>
<?php } ?>
</body>
</html>
