<?php
$section_title = get_field('category_title', 'option');
$category_desc = get_field('category_desc', 'option');
$category1 = get_field('category_1', 'option');
$category2 = get_field('category_2', 'option');
$category3 = get_field('category_3', 'option');
$category4 = get_field('category_4', 'option');
?>
<section class="home-category position-relative" id="categories">
    <span class="shape fill-star"></span>
    <span class="shape circle"></span>
    <span class="shape triangle"></span>
    <div class="container">
        <?php if ($section_title != '' || $category_desc != '') { ?>
            <div class="row">
                <div class="col-12 col-md-10 col-lg-8 mx-auto text-center">
                    <?php if ($section_title != '') { ?>
                        <h2 class="home-title wow fadeInUp" data-wow-delay="0.25s"><?php echo $section_title; ?></h2>
                    <?php }
                    if ($category_desc != '') {
                        ?>
                        <p class="category-desc wow fadeInUp" data-wow-delay="0.5s"><?php echo $category_desc; ?></p>
                    <?php } ?>
                </div>
            </div>
        <?php } ?>
        <div class="row justify-content-center">
            <div class="col-sm-6 col-md-3 col-lg-2">
                <div class="category-item wow fadeInRight" data-wow-delay="0.75s">
                    <img src="<?php echo esc_url($category1['category_image']['url']); ?>"
                         width="<?php echo esc_attr($category1['category_image']['width']); ?>"
                         height="<?php echo esc_attr($category1['category_image']['height']); ?>"
                         alt="<?php echo esc_attr($category1['category_image']['alt']); ?>"/>
                    <h4 class="category-title">
                        <a class="stretched-link" href="<?php echo esc_url($category1['category_link']); ?>"><?php echo esc_html($category1['category_title']); ?></a>
                    </h4>
                </div>
                <div class="category-item wow fadeInRight" data-wow-delay="1s">
                    <img src="<?php echo esc_url($category2['category_image']['url']); ?>"
                         width="<?php echo esc_attr($category2['category_image']['width']); ?>"
                         height="<?php echo esc_attr($category2['category_image']['height']); ?>"
                         alt="<?php echo esc_attr($category2['category_image']['alt']); ?>"/>

                    <h4 class="category-title">
                        <a class="stretched-link" href="<?php echo esc_url($category2['category_link']); ?>">
                            <?php echo esc_html($category2['category_title']); ?>
                        </a>
                    </h4>
                </div>
            </div>
            <div class="col-md-6 col-lg-5 d-flex justify-content-center align-items-center position-relative category-log-wrapper">
                <div class="category-bg"></div>
                <div class="category-image">
                    <div class="category-logo d-flex justify-content-center align-items-center">
<!--                        <div class="wow drawIn" data-wow-delay="3s">-->
                            <svg data-wow-delay="2s" id="path_logo" width="108" height="110" viewBox="0 0 108 110" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill="none" d="M95.0451 62.5461L88.9975 72.2214L96.8983 83.0847L92.4517 89.527L80.7715 69.4581C84.3664 66.7989 86.841 63.681 88.1331 60.1812C88.9691 57.9773 89.2752 55.6077 89.0268 53.2637C87.9704 44.5022 81.6615 40.3316 77.9935 38.6228C76.554 37.9585 74.988 37.6132 73.4026 37.6103H38.8243L54.1762 10.2346L65.5987 30.5374H77.8437L59.9331 0H48.9821L22.0579 47.0078L73.059 47.0681C73.6547 47.0708 74.2328 47.27 74.7038 47.6347C78.4212 50.5333 78.6972 52.9219 78.6643 54.9323C78.5948 59.1358 74.055 62.0929 73.0535 62.696L32.1517 62.3652L19.8574 83.3223L26.0969 91.8974L37.704 72.0332L70.7562 72.1136L92.057 109.643L108.001 83.0591L95.0451 62.5461Z" stroke="#FF9A36"  style="opacity: 1; stroke-dashoffset: 0px;" />
                                <path fill="none" d="M28.5116 54.0627H17.4894L0.925781 82.7744L16.0181 109.046L22.02 99.5628L11.981 82.6099L28.5116 54.0627Z" stroke="#98D55A" stroke-dasharray="47.40 47.40" stroke-dashoffset="47.40" opacity="0" style="opacity: 1; stroke-dashoffset: 0px;"/>
                            </svg>
<!--                        </div>-->
<!--                        <img src="--><?php //echo get_template_directory_uri(); ?><!--/assets/images/logo.png" width="108" height="110" alt="pasha">-->

                        <div class="path_logo_mask">
                            <svg  width="108" height="110" viewBox="0 0 108 110" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M95.0451 62.5461L88.9975 72.2214L96.8983 83.0847L92.4517 89.527L80.7715 69.4581C84.3664 66.7989 86.841 63.681 88.1331 60.1812C88.9691 57.9773 89.2752 55.6077 89.0268 53.2637C87.9704 44.5022 81.6615 40.3316 77.9935 38.6228C76.554 37.9585 74.988 37.6132 73.4026 37.6103H38.8243L54.1762 10.2346L65.5987 30.5374H77.8437L59.9331 0H48.9821L22.0579 47.0078L73.059 47.0681C73.6547 47.0708 74.2328 47.27 74.7038 47.6347C78.4212 50.5333 78.6972 52.9219 78.6643 54.9323C78.5948 59.1358 74.055 62.0929 73.0535 62.696L32.1517 62.3652L19.8574 83.3223L26.0969 91.8974L37.704 72.0332L70.7562 72.1136L92.057 109.643L108.001 83.0591L95.0451 62.5461Z" fill="#FF9A36"  />
                                <path d="M28.5116 54.0627H17.4894L0.925781 82.7744L16.0181 109.046L22.02 99.5628L11.981 82.6099L28.5116 54.0627Z" fill="#98D55A"/>
                            </svg>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3 col-lg-2">
                <div class="category-item wow fadeInLeft" data-wow-delay="0.75s">
                    <img src="<?php echo esc_url($category3['category_image']['url']); ?>"
                         width="<?php echo esc_attr($category3['category_image']['width']); ?>"
                         height="<?php echo esc_attr($category3['category_image']['height']); ?>"
                         alt="<?php echo esc_attr($category3['category_image']['alt']); ?>"/>

                    <h4 class="category-title">
                        <a class="stretched-link" href="<?php echo esc_url($category3['category_link']); ?>">
                            <?php echo esc_html($category3['category_title']); ?>
                        </a>
                    </h4>
                </div>
                <div class="category-item wow fadeInLeft" data-wow-delay="1s">
                    <img src="<?php echo esc_url($category4['category_image']['url']); ?>"
                         width="<?php echo esc_attr($category4['category_image']['width']); ?>"
                         height="<?php echo esc_attr($category4['category_image']['height']); ?>"
                         alt="<?php echo esc_attr($category4['category_image']['alt']); ?>"/>

                    <h4 class="category-title">
                        <a class="stretched-link" href="<?php echo esc_url($category4['category_link']); ?>">
                            <?php echo esc_html($category4['category_title']); ?>
                        </a>
                    </h4>
                </div>
            </div>
        </div>
    </div>
</section>
