<?php
get_header();

$terms = get_the_terms( get_the_ID(), 'portfolio_category' );
?>

<div class="single-portfolio">
    <?php
    if (have_posts()) :
        while (have_posts()) : the_post();
            ?>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12 col-md-6 mobile-p-0">
                        <?php
                            $gallery_images = array();
                            
                            if ( has_post_thumbnail() ) {
                                $thumb_id = get_post_thumbnail_id();
                                $thumb_url = wp_get_attachment_image_src( $thumb_id, 'full' );
                                $gallery_images[] = array(
                                    'url' => $thumb_url[0],
                                    'alt' => get_the_title()
                                );
                            }
                            
                            if ( have_rows('gallery') ) :
                                while ( have_rows('gallery') ) : the_row();
                                    $image = get_sub_field('image'); 
                                    if ( $image ) {
                                        $gallery_images[] = $image;
                                    }
                                endwhile;
                            endif;
                            ?>

                        <?php if ( !empty($gallery_images)  ) : ?>
                        <div class="swiper swiper-container">
                            <div class="swiper-wrapper portfolio-slider">
                            <?php foreach ( $gallery_images as $image ) :
                                    ?>
                        
                                <div class="portfolio-image swiper-slide">
                                    <div class="slide-inner">
                            <img src="<?php echo esc_url( $image['url'] ); ?>" alt="<?php echo esc_attr( $image['alt'] ); ?>" />
                                    </div>
                                </div>
                            <?php endforeach; ?>
                            </div>
                        </div>
                        <?php endif; ?>
    
                    </div>
                   
                    <div class="col-12 col-md-6">
                        <div class="portfolio-info-wrapper">
                            <article class="portfolio-info" itemscope="itemscope"
                                     itemtype="http://schema.org/Article">
                                <div class="portfolio-info-top">
                                    <h1 class="entry-title">
                                        <?php echo get_the_title(); ?>
                                    </h1>
                                    <div class="entry-content">
                                        <?php the_content(); ?>
                                    </div>
                                </div>
                                
                                <ul class="portfolio-meta">
                                    <?php 
                                    if ( $terms && ! is_wp_error( $terms ) ) : ?>
                                        <li class="portfolio-categories">
                                            <span>دسته بندی</span>
                                            <?php foreach ( $terms as $term ) : ?>
                                                <a 
                                                    href="<?php echo esc_url( get_term_link( $term ) ); ?>"
                                                    class="portfolio-category"
                                                >
                                                    <?php echo esc_html( $term->name ); ?>
                                                </a>
                                            <?php endforeach; ?>
                                        </li>
                                    <?php endif;
                                   
                                    if(get_field('create_date') !='') { ?>
                                    <li>
                                        <span>تاریخ</span>
                                        <p><?php echo get_field('create_date'); ?></p>
                                    </li>
                                    <?php } ?>
                                </ul>
                            </article>
                            <?php
                            $prev_post = get_previous_post(false, '', 'portfolio_category'); 
                            $next_post = get_next_post(false, '', 'portfolio_category');
                            ?>
                                
                            <div class="portfolio-navigation">
                                <?php if ( $prev_post ) : ?>
                                    <a href="<?php echo get_permalink($prev_post->ID); ?>" class="portfolio-prev">
                                    <span class="portfolio-navigation_icon"><i class="icon-arrow-left"></i></span>
                                <span class="portfolio-navigation_text"><?php echo esc_html( get_the_title($prev_post->ID) ); ?></span>
                                    
                                    </a>
                                <?php endif; ?>
                            
                                <?php if ( $next_post ) : ?>
                                    <a href="<?php echo get_permalink($next_post->ID); ?>" class="portfolio-next">
                                    <span class="portfolio-navigation_text"> <?php echo esc_html( get_the_title($next_post->ID) ); ?> </span>
                                     <span class="portfolio-navigation_icon"><i class="icon-arrow-left"></i></span>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php
        endwhile;
    endif; ?>
</div>
<?php get_footer('inner'); ?>
