<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta content="telephone=no" name="format-detection">
    <meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
    <?php
        $icon = get_site_icon_url();
        if ( $icon ) {
            echo '<link rel="shortcut icon" type="image/png" href="' . esc_url( $icon ) . '" sizes="32x32" />';
        }
    wp_head(); ?>
</head>
<body <?php body_class('unxw-fade-push-text-right'); ?>>
<?php wp_body_open(); ?>
<header class="site-header <?php echo !is_home() || !is_front_page() ? 'inner-header' : 'home-header'; ?>" id="header">
    <div class="container-lg">
        <div class="row align-items-center">
            <div class="col col-sm-6 col-md-9 col-lg-9 col-right">
                <div class="logo-wrap  d-lg-inline-flex">
                    <?php
                        /* logo */
                        $logo = get_field('logo_header' ,'option');
                        if ($logo) {
                            echo '<a class="logo-header" href="' . get_bloginfo('url') . '" >';
                            echo '<img src="' . $logo['url'] . '" width="' . $logo['width'] . '" height="' . $logo['height'] . '" alt="' . $logo['alt'] . '" />';
                            echo '</a>';
                        }
                    ?>
                </div>

                <div class="mobile-menu-btn position-relative d-inline-flex d-md-none">
                    <span class="unxw-fullscreen-menu-close-icon">
                        <span class="icon_close"><i class="icon-close"></i></span>							
                    </span>
                    <span class="unxw-fullscreen-menu-opener-icon">
                        <span class="icon_menu"><i class="icon-menu"></i></span>							
                    </span>
                </div>
                <nav class="primary-menu d-none d-md-inline-flex">
                    <?php
                    if (has_nav_menu('main')) {
                        $defaults = array(
                            'theme_location' => 'main',
                            'container' => '',
                            'menu_class' => 'd-flex',
                            'echo' => true,
                            'fallback_cb' => 'wp_page_menu',
                            'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                            'depth' => 3,
                        );
                        wp_nav_menu($defaults);
                    }
                    ?>
                </nav>
            </div>
            <div class="col col-sm-6 col-md-3 col-lg-3 col-left">
                <a href="/contact-us" class="theme-button secondary">
                    <span class="mas">تماس با ما</span>
                    <span class="btn">تماس با ما</span>
                </a>
            </div>
        </div>
    </div>
</header>

<div class="unxw-fullscreen-menu-holder-outer ps">
    <div class="unxw-fullscreen-menu-holder">
        <div class="unxw-fullscreen-menu-holder-inner">
            <div class="unxw-container-inner">
                <nav class="unxw-fullscreen-menu">
                     <?php
                        if (has_nav_menu('mobile')) {
                            $defaults = array(
                                'theme_location' => 'mobile',
                                'container' => '',
                                'menu_class' => 'd-flex',
                                'echo' => true,
                                'fallback_cb' => 'wp_page_menu',
                                'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                                'depth' => 3,
                            );
                            wp_nav_menu($defaults);
                        }
                    ?>
                </nav>
            </div>
        </div>
    </div>

    <div class="ps__rail-x" style="left: 0; bottom: 0;">
        <div class="ps__thumb-x" tabindex="0" style="left: 0; width: 0;"></div>
    </div>

    <div class="ps__rail-y" style="top: 0; right: 0;">
        <div class="ps__thumb-y" tabindex="0" style="top: 0; height: 0;"></div>
    </div>
</div>

<main class="main-content <?php echo !is_home() || !is_front_page() ? 'inner-main' : ''; ?>">

