<?php
function socilaLinlks()
{
        $share = '<ul class="social-list d-flex justify-content-center align-items-center">';
            $whatsapp = get_field('whatsapp', 'option');
            $telegram = get_field('telegram', 'option');
            $instagram = get_field('instagram', 'option');
            if ($whatsapp != '') {
                $share .= '<li>';
                $share .= '<a href = "' . $whatsapp . '" target = "_blank" class="whatsapp" >';
                $share .= '<i class="icon-whatsapp" ></i >';
                $share .= '</a >';
                $share .= '</li>';
            }
            if ($telegram != '') {
                $share .= '<li>';
                $share .= '<a href = "' . $telegram . '" target = "_blank" class="telegram" >';
                $share .= '<i class="icon-telegram" ></i >';
                $share .= '</a >';
                $share .= '</li>';
            }
            if ($instagram != '') {
                $share .= '<li>';
                $share .= '<a href = "' . $instagram . '" target = "_blank" class="instagram" >';
                $share .= '<i class="icon-instagram" ></i >';
                $share .= '</a >';
                $share .= '</li>';
            }
        $share .= '</ul>';
        return $share;
}

// Pagination
function pagination_bar($custom_query)
{
    $total_pages = $custom_query->max_num_pages;
    $big = 999999999;
    if ($total_pages > 1) {
        $current_page = max(1, get_query_var('paged'));
        echo paginate_links(array(
            'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
            'format' => '?paged=%#%',
            'prev_text' => '<i class="icon-arrow-right"></i>',
            'next_text' => '<i class="icon-arrow-right"></i>',
            'before_page_number' => '',
            'current' => $current_page,
            'total' => $total_pages,
        ));
    }
}

add_action('rest_api_init', function() {
    register_rest_route('acf/v3', '/homepage', [
        'methods' => 'GET',
        'callback' => function() {
            return [
                'service_title' => get_field('service_title', 'option'),
                'service_text'  => get_field('service_text', 'option'),
                'portfolio_title'  => get_field('portfolio_title', 'option'),
                'portfolio_text'  => get_field('portfolio_text', 'option'),
                'blog_title'  => get_field('blog_title', 'option'),
                'blog_text'  => get_field('blog_text', 'option'),
                'about_title'  => get_field('about_title', 'option'),
                'about_slogan'  => get_field('about_slogan', 'option'),
                'about_desc'  => get_field('about_desc', 'option'),
                'about_more'  => get_field('about_more', 'option'),
                'about_image' => get_field('about_image', 'option'), 
                'add_services'   => get_field('add_services', 'option'), 
                'add_projects'   => get_field('add_projects', 'option'), 
                'add_slider'   => get_field('add_slider', 'option'),
                'image_slider'  => get_field('image_slider', 'option'),
            ];
        },
    ]);

    register_rest_route('acf/v3', '/theme-options', [
        'methods'  => 'GET',
        'callback' => function () {
            return get_fields('option');
        }
    ]);
});