<?php
/* Template Name: Contact */
get_header();

$contact_form_title = get_field('contact_form_title');
$contact_image = get_field('contact_image');

$email= get_field('_email');
$phone = get_field('_phone');
?>
<div class="page-wrap contact-page">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="page-header text-center">
                    <h1 class="page-title wow fadeInUp" data-wow-delay="0.25s">
                        <?php echo get_the_title(); ?>
                    </h1>
                    <?php get_template_part('templates/content/breadcrumb'); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-12 col-md-6">
                <div class="contact-info_card">
                    <div class="contact-card wow fadeInUp" data-wow-delay="0.5s">
                        <span class="icon-wrapper mail">
                            <i class="icon-mail"></i>
                        </span>
                       
                        <a href="mailto:<?php echo $email; ?>">
                            <?php echo $email; ?></a>
                    </div>
        
                    <div class="contact-card wow fadeInUp" data-wow-delay="0.25s">
                            <span class="icon-wrapper">
                                <i class="icon-time"></i>
                            </span>
                            <p class="mb-0"><?php echo $phone; ?></p>
                    </div>
                    
                    <div class="contact-card wow fadeInUp" data-wow-delay="0.5s">
                            <span class="icon-wrapper">
                                <i class="icon-uptime"></i>
                            </span>
                            <p class="mb-0">پاسخگویی سریع آنلاین کمتر از 24 ساعت</p>
                    </div>
                    
                    <div class="contact-social wow fadeInUp" data-wow-delay="0.5s">
                        <?php echo socilaLinlks(); ?>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-6">
                <div class="contact-image">
                    <?php 
                    echo '<img src="' . $contact_image['url'] . '" width="' . $contact_image['width'] . '" height="' . $contact_image['height'] . '" alt="' . $contact_image['alt'] . '" />';
                    ?>
                </div>
            </div>
        </div>
    </div>

    <section class="contact-form">
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-9 mx-auto">
                    <div class="contact-form-wrap">
                        <div class="section-head text-center">
                             <?php if($contact_form_title!='') { ?>
                                <h3 class="section-title  wow fadeInUp" data-wow-delay="0.5s"><?php echo $contact_form_title; ?></h3>
                            <?php }
                            ?>
                            <p class="page-desc wow fadeInUp" data-wow-delay="0.75s"><?php echo get_field('contact_desc'); ?></p>
                        </div>
                       
                        <?php
                        
                            echo do_shortcode('[contact-form-7 id="549d44a" title="Contact form 1"]');
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php get_footer('inner'); ?>

