<?php
get_header();
$paged = (get_query_var('paged')) ? get_query_var('paged') : ((get_query_var('page')) ? get_query_var('page') : 1);
global $wp_query;
$cat_id = $wp_query->get_queried_object_id();
?>
<div class="page-wrap category-blog">
    <div class="container-lg">
        <div class="row">
            <div class="col-12 text-center">
                <div class="page-header text-center">
                    <h1 class="page-title wow fadeInUp" data-wow-delay="0.25s">
                        <?php echo single_cat_title(); ?>
                    </h1>
                    <?php get_template_part('templates/content/breadcrumb'); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="container-lg">
        <div class="row">
            <div class="col-12 col-md-8 col-lg-9 order-first order-md-last">
                <?php if (category_description() != '') { ?>
                    <div class="entry-description wow fadeInUp" data-wow-delay="0.5s">
                        <?php echo category_description(); ?>
                    </div>
                <?php } ?>
                <div class="site-post-archive">
                    <div class="row">

                        <?php
                        $args = array(
                            'post_type' => 'post',
                            'paged' => $paged,
                            'post_status ' => 'publish',
                            'cat' => $cat_id,
                        );
                        $posts = new WP_Query($args);
                        if ($posts->have_posts()):
                            $i = 0.25;
                            while ($posts->have_posts()) : $posts->the_post();
                                ?>
                                <div class="col-12 col-sm-6 col-lg-4 wow fadeInUp" data-wow-delay="<?php echo $i; ?>s">
                                    <?php get_template_part('templates/card/blog', 'card'); ?>
                                </div>
                                <?php
                                $i += 0.25; endwhile;
                        endif;
                        wp_reset_postdata();
                        ?>


                        <div class="col col-12">
                            <div class="site-pagination">
                                <?php pagination_bar($posts); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-4 col-lg-3 order-last order-md-first">
                <?php get_sidebar(); ?>
            </div>
        </div>
    </div>
</div>
<?php get_footer('inner'); ?>
