<?php
/**
 * Review Comments Template
 *
 * Closing li is left out on purpose!.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/review.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>
<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">

	<div id="comment-<?php comment_ID(); ?>" class="comment_container">
        <div class="d-flex justify-content-between align-items-center">
            <div class="d-flex align-items-center">
                <?php
                /**
                 * The woocommerce_review_before hook
                 *
                 * @hooked woocommerce_review_display_gravatar - 10
                 */
                do_action( 'woocommerce_review_before', $comment );

                /**
                 * The woocommerce_review_meta hook.
                 *
                 * @hooked woocommerce_review_display_meta - 10
                 */
                do_action( 'woocommerce_review_meta', $comment );
                ?>
            </div>
            <div class="d-flex align-items-center">
                <span>این دیدگاه مورد تایید شما میباشد؟</span>
<!--                <div class="comment-action d-flex align-items-center">-->
<!--                    <button class="comment-action_button like">-->
<!--                        <i class="icon-like"></i>-->
<!--                    </button>-->
<!--                    <button class="comment-action_button dislike">-->
<!--                        <i class="icon-dislike"></i>-->
<!--                    </button>-->
<!--                </div>-->
                <?php echo my_comment_vote_buttons(get_comment_ID()); ?>
            </div>
        </div>
		<div class="comment-text d-flex align-items-center justify-content-between">
            <div class="comment-text_right col-8">
                <?php
                /**
                 * The woocommerce_review_before_comment_meta hook.
                 *
                 * @hooked woocommerce_review_display_rating - 10
                 */
                do_action( 'woocommerce_review_before_comment_meta', $comment );

                do_action( 'woocommerce_review_before_comment_text', $comment );

                /**
                 * The woocommerce_review_comment_text hook
                 *
                 * @hooked woocommerce_review_display_comment_text - 10
                 */
                do_action( 'woocommerce_review_comment_text', $comment );

                do_action( 'woocommerce_review_after_comment_text', $comment );
                ?>
            </div>
            <?php echo my_comment_vote_counts(get_comment_ID()); ?>
<!--            <div class="comment-text_left col-auto">-->
<!--                <span><i class="icon-like"></i>33</span>-->
<!--                <span><i class="icon-dislike"></i>3</span>-->
<!--            </div>-->
		</div>
	</div>
