<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

$suitable_for = get_field('suitable_for');
$day_night = (is_array($suitable_for) && isset($suitable_for['day_night']))
    ? $suitable_for['day_night']
    : '';
$perfume_type = get_field('perfume_type');

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
//do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
    <section>
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-6 col-lg-5 position-relative">
                    <?php
                    /**
                     * Hook: woocommerce_before_single_product_summary.
                     *
                     * @hooked woocommerce_show_product_sale_flash - 10
                     * @hooked woocommerce_show_product_images - 20
                     */
                    do_action( 'woocommerce_before_single_product_summary' );

                    if ($perfume_type || $day_night!='' ) {
                        echo '<div class="product-type">';
                        if($perfume_type) { echo '<span><i class="icon-'. $perfume_type .'"></i></span>'; }
                        if($day_night != '' && $day_night['value'] !== 'none') { echo '<span><i class="icon-'. $day_night['value'] .'"></i></span>'; }
                        echo '</div>';
                    }
                    ?>
                </div>
                <div class="col-12 col-md-6 col-lg-7">
                    <div class="summary entry-summary">
                        <?php
                        /**
                         * Hook: woocommerce_single_product_summary.
                         *
                         * @hooked woocommerce_template_single_title - 5
                         * @hooked woocommerce_template_single_rating - 10
                         * @hooked woocommerce_template_single_price - 10
                         * @hooked woocommerce_template_single_excerpt - 20
                         * @hooked woocommerce_template_single_add_to_cart - 30
                         * @hooked woocommerce_template_single_meta - 40
                         * @hooked woocommerce_template_single_sharing - 50
                         * @hooked WC_Structured_Data::generate_product_data() - 60
                         */
                        do_action( 'woocommerce_single_product_summary' );
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
	<?php
	/**
	 * Hook: woocommerce_after_single_product_summary.
	 *
	 * @hooked woocommerce_output_product_data_tabs - 10
	 * @hooked woocommerce_upsell_display - 15
	 * @hooked woocommerce_output_related_products - 20
	 */
	do_action( 'woocommerce_after_single_product_summary' );
	?>

    <section class="single-product_info">
        <div class="container">
            <div class="row">
                <div class="col-12 section-title_wrapper">
                    <h3 class="section-title">اطلاعات  <?php echo get_the_title(); ?></h3>
                </div>
                <div class="col-12 col-md-6">
                    <?php
                        $attributes = $product->get_attributes();

                        if ( ! $attributes ) {
                            return;
                        }

                        echo '<ul class="product-attributes">';

                        foreach ( $attributes as $attribute ) {

                            if ( $attribute->is_taxonomy() ) {
                                $values = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'names' ) );
                                $value = implode( ', ', $values );
                            } else {
                                $value = $attribute->get_options();
                                $value = implode( ', ', $value );
                            }

                            echo '<li class="d-flex flex-wrap"><strong>' . wc_attribute_label( $attribute->get_name() ) . ':</strong><p>' . esc_html( $value ) . '</p></li>';
                        }

                        echo '</ul>';
                    ?>
                </div>

                <?php
                if( have_rows('chart_acord_new') ): ?>
                    <div class="col-12 col-md-6">
                        <div class="row chart-row">
                            <?php while( have_rows('chart_acord_new') ) : the_row();
                                $chart_title = get_sub_field('chart_aq');
                                $chart_img = get_sub_field('chart_img');
                                $aq_val  = $chart_title['value'];
                                $sep_aq = explode(" - ", $aq_val);

                                $white_items = array("violet", "cacao", "patchouli", "animalic", "Cannabi", "camphor", "Amber" , "Smoky" , "Oud" , "Marine" , "Tobacco" , "Warm Spice" , "Green" , "coffee" , "Earthy" , "Woody" , "Leather" , "Sweet" , "Rose" , "Iris" , "Cinnamon" , "Cannabi" , "animalic" , "patchouli" , "Conifer");
                                ?>
                                <div class="col-6 col-md-3 text-center">
                                    <div class="acord-card">
                                        <?php if($chart_img) { ?>
                                        <div class="acord-image">
                                            <img src="<?php echo $chart_img['url']; ?>" alt="<?php echo $chart_img['alt']; ?>" />
                                        </div>
                                        <?php } ?>
                                        <h5 class="acord-title">
                                            <?php echo $chart_title['label']; ?>
                                        </h5>
                                        <div class="progress">
                                            <div class="progress-bar" role="progressbar" style="width: <?php the_sub_field('value'); ?>%;" aria-valuenow="<?php the_sub_field('value'); ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <?php
//        $banner_type = get_field('suitable_for');
        $day_night = (is_array($suitable_for) && isset($suitable_for['day_night']))
        ? $suitable_for['day_night']
        : '';
        $season_type = (is_array($suitable_for) && isset($suitable_for['season_type']))
        ? $suitable_for['season_type']
        : '';
//        $banner_day_type = $suitable_for ['day_night'];
//        $banner_season_type = $suitable_for ['season_type'];
    ?>
    <section class="single-product_banner">
        <div class="container">
            <div class="row">
                <?php if($season_type!='') { ?>
                <div class="col-12 col-md-6">
                    <div class="single-banner single-banner_season <?php echo $season_type['value'] === 'cold' ? 'cold' : 'warm'; ?>">
                        <div class="single-banner_content">
                            <h4 class="single-banner_title">
                                کاربران   <?php echo get_field('fa_product_title'); ?> برای فصلهای <span class="season"><?php echo $season_type['label']; ?></span>  میپسندند
                            </h4>
                        </div>
                        <div class="single-banner_image">
                            <div class="image-wrapper">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/season.png" width="" height="" alt="">
                            </div>
                        </div>
                    </div>
                </div>
                <?php }
                if($day_night!='') {
                ?>
                <div class="col-12 col-md-6">
                    <div class="single-banner single-banner_dayNight <?php echo $day_night['value'] === 'day' ? 'day' : 'night'; ?>">
                        <div class="single-banner_content">
                            <h4 class="single-banner_title">
                                کاربران   <?php echo get_field('fa_product_title'); ?> برای مصرف در <span class="dayNight"><?php echo $day_night['label']; ?></span> میپسندند
                            </h4>
                        </div>
                        <div class="single-banner_image">
                            <div class="image-wrapper">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/day-night.png" width="" height="" alt="">
                            </div>
                        </div>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </section>

    <section class="single-product_poll">
        <?php do_action('wcps_render_surveys'); ?>
    </section>

    <?php
        $video_banner_title = get_field('video_banner_title', 'option');
        $video_desc = get_field('video_desc', 'option');
        $video_image = get_field('video_pimage');
        $video_embed = get_field('video_embed');
    ?>
    <section class="single-product_video">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="introduce-video radius-12 position-relative">
                        <div class="introduce-video_inner position-absolute">
                            <div class="banner-content introduce-video_caption">
                                <?php
                                    if($video_banner_title!='') {
                                        echo '<h3 class="entry-title with-star">'.$video_banner_title.'</h3>';
                                    }
                                    if($video_desc!='') {
                                        echo '<div class="entry-description wow fadeInUp" data-wow-delay="0.5s"><p class="">'.$video_desc.'</p></div>';
                                    }
                                    if($video_embed!='') {
                                ?>
                                <button type="button" class="video-modal_btn theme-button large" data-bs-toggle="modal" data-bs-target="#videoeModal">
                                    مشاهده ویدیو
                                    <i class="icon-arrow-left"></i>
                                </button>
                                <?php } ?>
                            </div>
                            <?php if( $video_image ) { ?>
                            <div class="introduce-video_image">
                                <figure class="introduce-video_img">
                                    <img src="<?php echo $video_image['url']; ?>" width="<?php echo $video_image['width']; ?>" height="<?php echo $video_image['height']; ?>" alt="<?php echo $video_image['alt']; ?>">
                                </figure>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section>
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <?php  if ( comments_open() ) {
                        comments_template();
                    } ?>
                </div>
            </div>
        </div>
    </section>
</div>

<?php if( $video_embed!='') { ?>
<div class="modal modal-video fade" id="videoeModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <?php if($video_title!='') {
                    echo '<h5 class="modal-title" id="exampleModalLabel">'. $video_title. '</h5>';
                } ?>

                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <?php echo $video_embed; ?>
            </div>
        </div>
    </div>
</div>
<?php }

 do_action( 'woocommerce_after_single_product' ); ?>
