<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
// Check if the product is a valid WooCommerce product and ensure its visibility before proceeding.
if ( ! is_a( $product, WC_Product::class ) || ! $product->is_visible() ) {
    return;
}

?>
<div <?php wc_product_class( 'product-card', $product ); ?>>

    <?php
    /**
     * Hook: woocommerce_before_shop_loop_item.
     *
     * @hooked woocommerce_template_loop_product_link_open - 10
     */
    do_action( 'woocommerce_before_shop_loop_item' );
    echo '<div class="product-card_image position-relative">';
        /**
         * Hook: woocommerce_before_shop_loop_item_title.
         *
         * @hooked woocommerce_show_product_loop_sale_flash - 10
         * @hooked woocommerce_template_loop_product_thumbnail - 10
         */
        do_action( 'woocommerce_before_shop_loop_item_title' );
        echo '<div class="ratio ratio-1x1">';
        woocommerce_template_loop_product_thumbnail();
        echo '</div>';
    echo '</div>';

    /**
     * Hook: woocommerce_shop_loop_item_title.
     *
     * @hooked woocommerce_template_loop_product_title - 10
     */
    do_action( 'woocommerce_shop_loop_item_title' );


    /**
     * Hook: woocommerce_after_shop_loop_item.
     *
     * @hooked woocommerce_template_loop_product_link_close - 5
     * @hooked woocommerce_template_loop_add_to_cart - 10
     */
    do_action( 'woocommerce_after_shop_loop_item' );
    ?>

    <div class="row align-items-center product-card_footer">
        <div class="col-auto product-price" data-base-price="<?= wc_get_price_to_display($product); ?>">
            <?= $product->get_price_html(); ?>
        </div>
        <div class="col text-end">
            <div class="qty-wrapper hidden">
                <button class="qty-minus">−</button>
                <input type="number" class="qty-input" value="1" min="0">
                <button class="qty-plus">+</button>
            </div>
            <button class="add-to-cart-btn add-to-cart_button">
                <i class="icon-cart"></i>
            </button>
        </div>
    </div>

</div>
