<?php
$product = get_query_var('product');
if ( ! $product ) return;
?>

<li class="discount-product_card horizontal-card">
    <div class="discount-product_right horizontal-card_right">
        <a class="product-image" href="<?php echo get_permalink( $product->get_id() ); ?>">
            <?php echo $product->get_image( 'woocommerce_thumbnail' ); ?>
        </a>
        <div class="discount-product_info horizontal-card_info">
            <h3 class="product-title">
                <a href="<?php echo get_permalink( $product->get_id() ); ?>">
                    <?php echo $product->get_name(); ?>
                </a>
            </h3>

            <div class="product-price">
                <?php echo woocommerce_template_loop_price(); ?>
            </div>
        </div>
    </div>
    <div class="discount-product_left horizontal-card_left">
        <a class="discount-product_cart add-to-cart_button" href="<?php echo get_permalink( $product->get_id() ); ?>">
            <i class="icon-cart"></i>
        </a>
        <?php
        $a5_terms = wc_get_product_terms(
            $product->get_id(),
            'pa_a5',
            array( 'fields' => 'names' )
        );

        if ( ! empty( $a5_terms ) && ! is_wp_error( $a5_terms ) ) :
            ?>
            <div class="product-volume_items d-flex">
                <?php foreach ( $a5_terms as $term_name ) : ?>
                    <span class="variant"><?php echo esc_html( $term_name ); ?></span>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</li>
