<?php
get_header();
?>
<div class="single-page">
    <?php
    if (have_posts()) :
        while (have_posts()) : the_post();
            ?>
            <div class="container">
                <div class="single-media">
                    <?php if (has_post_thumbnail()) { ?>
                        <figure class="entry-media">
                            <?php the_post_thumbnail('large'); ?>
                        </figure>
                    <?php } ?>
                </div>
                <div class="col-12">
                    <article class="post-single" itemscope="itemscope"
                             itemtype="http://schema.org/Article">
                        <h1 class="entry-title"><?php echo get_the_title(); ?></h1>
                        <div class="entry-meta top">
                            <div class="category">
                                <?php the_category('', ' '); ?>
                            </div>
                            <span class="entry-published" itemprop="datePublished">
                                <?php echo get_the_date('j / m / Y'); ?>
                                <i class="icon-edit"></i>
                            </span>
                        </div>
                        <div class="entry-content">
                            <?php the_content(); ?>
                        </div>
                    </article>

                    <div class="row entry-footer bottom align-items-center">
                        <?php if (has_tag()) { ?>
                            <div class="col-12 col-md-9 tags">
                                <?php the_tags('برچسب ها: ', '', '  '); ?>
                            </div>
                        <?php } ?>

                        <div class="col-12 col-md-3 social-share text-end">
                            <?php echo socialshares(); ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php
        endwhile;
    endif; ?>

    <?php

    $id = get_field('similar_blog');
    if ($id) {
        $related_posts = new WP_Query(array(
            'post_type' => 'post',
            'post__in' => $id,
            'posts_per_page' => '4',
        ));

        if ($related_posts->have_posts()) { ?>
            <section class="related-blog">
                <div class="container">
                    <div class="row">
                        <div class="col-12">
                            <h2 class="section-title text-center">مقالات مشابه</h2>
                        </div>

                        <?php
                        $i = 0.25;
                        while ($related_posts->have_posts()) :
                            $related_posts->the_post();
                            ?>
                            <div class="col-12 col-sm-6 col-md-4 col-lg-3 wow fadeInUp"
                                 data-wow-delay="<?php echo $i; ?>s">
                                <?php get_template_part('templates/card/blog', 'card'); ?>
                            </div>
                            <?php
                            $i += 0.25; endwhile;
                        ?>
                    </div>
                </div>
            </section>
        <?php }
        wp_reset_query();

    }
    ?>

    <section class="post-comments blur-bg">
        <div class="container">
            <?php
            if (comments_open() && post_type_supports(get_post_type(), 'comments')) {
                ?>
                <?php comments_template(); ?>
            <?php } ?>

        </div>
    </section>
</div>
<?php get_footer(); ?>
