<?php
// After setup theme hook adds WC support
function mytheme_add_woocommerce_support()
{
    add_theme_support('woocommerce'); //
    remove_theme_support( 'wc-product-gallery-zoom' );
    remove_theme_support( 'wc-product-gallery-lightbox' );
    remove_theme_support( 'wc-product-gallery-slider' );
}
add_action('after_setup_theme', 'mytheme_add_woocommerce_support');


//Change the order of filter in product archive
remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10);
//remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);

//remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10);
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price' , 10);
remove_action('woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10);
remove_action('woocommerce_cart_collaterals', 'woocommerce_cross_sell_display');
remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 10);
remove_action( 'woocommerce_product_thumbnails', 'woocommerce_show_product_thumbnails', 20 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
remove_action( 'woocommerce_review_before_comment_meta', 'woocommerce_review_display_rating', 10 );

add_action('template_redirect', 'remove_sidebar_shop');

remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 30 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 40 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );

add_action( 'woocommerce_before_shop_loop_item', 'custom_product_link_open', 10 );
function custom_product_link_open() {
    echo '<a href="' . esc_url( get_the_permalink() ) . '" class="product-card_link">';
}

add_action( 'woocommerce_shop_loop_item_title', 'custom_product_link_close', 15 );
function custom_product_link_close() {
    echo '</a>';
}

remove_action( 'woocommerce_product_additional_information', 'woocommerce_product_additional_information_tab', 10 );


function remove_sidebar_shop()
{
    if (is_product()) {
        remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar');
    }
}

add_filter('woocommerce_enqueue_styles', '__return_empty_array');
// Remove Marketing Hub menu item
add_filter('woocommerce_marketing_menu_items', '__return_empty_array');

// Sidebar
function sidebar_woocommerce_filter()
{
    register_sidebar(array(
        'name' => __('سایدبار فروشگاه', 'textdomain'),
        'id' => 'sidebar-woocommerce-filter',
        'before_widget' => '<div id="%1$s" class="widget widget-product %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="widget-title">',
        'after_title' => '</h4>'
    ));
}

add_action('widgets_init', 'sidebar_woocommerce_filter');

/**
 * Change number of products that are displayed per page (shop page)
 */
add_filter('loop_shop_per_page', 'new_loop_shop_per_page', 20);

function new_loop_shop_per_page($cols)
{
    $cols = 12;
    return $cols;
}

//Remove download from my account
add_filter('woocommerce_account_menu_items', 'bbloomer_remove_downloads_my_account', 999);

function bbloomer_remove_downloads_my_account($items)
{
    unset($items['downloads']);
    return $items;
}

/* Remove the Dashboard tab of the My Account Page */
function custom_my_account_menu_items($items)
{
    unset($items['dashboard']);
    return $items;
}

add_filter('woocommerce_account_menu_items', 'custom_my_account_menu_items');


add_filter('woocommerce_structured_data_product', 'structured_data_product_nulled', 10, 2);
function structured_data_product_nulled($markup, $product)
{
    if (is_product()) {
        $markup = '';
    }
    return $markup;
}

add_action('woocommerce_checkout_process', 'my_custom_checkout_field_process');
function my_custom_checkout_field_process() {
    global $woocommerce;

    // Check if set, if its not set add an error. This one is only requite for companies
    if (!(preg_match('/^[0-9]{11}$/D', $_POST['billing_phone']))) {
        wc_add_notice("شماره تلفن شما باید 11 رقم باشد . ورود حروف غیرمجاز است.", 'error');
    }
    // Check if set, if its not set add an error. This one is only requite for companies
    if (!(preg_match('/^[0-9]{10}$/D', $_POST['billing_postcode']))) {
        wc_add_notice("طول کدپستی در صورتحساب باید 10 رقم باشد.", 'error');
    }
}


add_filter( 'woocommerce_add_to_cart_fragments', 'refresh_cart_count', 50, 1 );
function refresh_cart_count( $fragments ){
    ob_start();
    ?>
    <span class="counter cart-count-icon" id="cart-count"><?php
        $cart_count = WC()->cart->get_cart_contents_count();
        echo sprintf ( _n( '%d', '%d', $cart_count ), $cart_count );
        ?></span>
    <?php
    $fragments['#cart-count'] = ob_get_clean();

    return $fragments;
}

require get_template_directory() . '/includes/cart-ajax.php';

add_action('wp_enqueue_scripts', function () {
    if(!is_product()) {
        wp_enqueue_script(
            'custom-cart',
            get_template_directory_uri() . '/assets/js/cart.js',
            ['jquery'],
            null,
            true
        );

        wp_localize_script('custom-cart', 'wc_cart', [
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('cart_nonce')
        ]);
    }
});


    add_action('wp_footer', function () {
        if (!WC()->cart) return;

        if(is_shop() || is_product_category()) {
        ?>
        <script>
            jQuery(function ($) {
                <?php foreach (WC()->cart->get_cart() as $cart_item): ?>
                let productId   = <?= (int) $cart_item['product_id'] ?>;
                const variationId = <?= (int) $cart_item['variation_id'] ?>;
                const qty         = <?= (int) $cart_item['quantity'] ?>;

                const card = $('.product-card[data-product-id="' + productId + '"]');

                const option = card
                    .find('.variation-option[data-variation-id="' + variationId + '"]');

                if (option.length) {
                    option.addClass('active')
                        .siblings().removeClass('active');

                    card.find('.add-to-cart-btn').addClass('hidden');
                    card.find('.qty-wrapper').removeClass('hidden')
                        .find('.qty-input').val(qty);
                }
                <?php endforeach; ?>

            });
        </script>
        <?php
        }
    });


add_filter( 'woocommerce_json_search_found_products', function( $found_products ) {
    $term = isset($_GET['term']) ? sanitize_text_field($_GET['term']) : '';
    if ( empty($term) ) return $found_products;
    $args = array(
        'post_type'      => array( 'product_variation' ),
        'posts_per_page' => 15,
        's'              => $term
    );

    $variations = get_posts( $args );

    if ( ! empty( $variations ) ) {
        foreach ( $variations as $variation ) {
            $product_variation = wc_get_product( $variation->ID );
            if ( $product_variation ) {
                $found_products[ $variation->ID ] = $product_variation->get_formatted_name();
            }
        }
    }

    return $found_products;
});


add_action( 'woocommerce_shop_loop_item_title', 'display_selected_variations_on_card', 25 );
function display_selected_variations_on_card() {
    global $product;

    if ( ! $product || ! $product->is_type( 'grouped' ) ) return;

    $children_ids = $product->get_children();
    if ( empty( $children_ids ) ) return;

    echo '<div class="custom-grouped-list">';

    foreach ( $children_ids as $child_id ) {
        $child_product = wc_get_product( $child_id );
        if ( ! $child_product ) continue;

        if ( $child_product->is_type( 'variation' ) ) {
            $attributes = $child_product->get_attributes();

            if ( !empty($attributes) ) {
                $label = implode(' ', array_values($attributes));
                $label = urldecode($label);
                $label = str_replace('-', ' ', $label);
            } else {
                $label = urldecode($child_product->get_name());
            }
        } else {
            $label = $child_product->get_name();
        }

        echo '<div class="grouped-item-row">';
        echo '  <span class="item-tick">✓</span>';
        echo '  <span class="item-text">' . esc_html($label) . '</span>';
        echo '</div>';
    }

    echo '</div>';
}


add_action('woocommerce_product_query', function ($q) {
    if ( is_admin() ) return;
    if ( is_shop() || is_product_category() || is_product_tag() ) {
        $tax_query = (array) $q->get('tax_query');

        $tax_query[] = [
            'taxonomy' => 'product_type',
            'field'    => 'slug',
            'terms'    => ['grouped'],
            'operator' => 'NOT IN',
        ];

        $q->set('tax_query', $tax_query);
    }
});

add_filter( 'woocommerce_format_price_range', 'bbloomer_variation_price_format_min', 9999, 3 );

function bbloomer_variation_price_format_min( $price, $from, $to ) {
    return  sprintf( _x( '%1$s', '', 'bbloomer' ), is_numeric( $from ) ? wc_price( $from ) : $from );
}

class WC_Only_In_Stock_Widget extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'wc_only_in_stock',
            'WooCommerce: فقط کالاهای موجود',
            ['description' => 'فیلتر نمایش فقط کالاهای موجود']
        );
    }

    public function widget($args, $instance) {
        if ( ! ( is_shop() || is_product_category() || is_product_tag() ) ) {
            return;
        }

        $checked = isset($_GET['in_stock']) && $_GET['in_stock'] === '1';

        echo $args['before_widget'];
        ?>
        <form method="get" class="only-in-stock-widget">

            <?php
            foreach ( $_GET as $key => $value ) {
                if ( $key === 'in_stock' ) continue;
                echo '<input type="hidden" name="'.esc_attr($key).'" value="'.esc_attr($value).'">';
            }
            ?>

            <label class="stock-switch">
                <input type="checkbox" name="in_stock" value="1" <?php checked($checked); ?> onchange="this.form.submit()">
                <span class="switch-ui"></span>
                <span class="label-text">فقط کالاهای موجود</span>
            </label>

        </form>
        <?php
        echo $args['after_widget'];
    }
}

add_action('widgets_init', function () {
    register_widget('WC_Only_In_Stock_Widget');
});

add_action('woocommerce_product_query', function ($q) {

    if ( is_admin() ) return;

    if ( isset($_GET['in_stock']) && $_GET['in_stock'] === '1' ) {

        $meta_query = (array) $q->get('meta_query');

        $meta_query[] = [
            'key'     => '_stock_status',
            'value'   => 'instock',
        ];

        $q->set('meta_query', $meta_query);
    }
});

add_action('joe_woocommerce_layered_nav_bottom', 'add_clear_filters');
function add_clear_filters()
{
    $filterreset = $_SERVER['REQUEST_URI'];
    if (strpos($filterreset, '?filter_') !== false | strpos($filterreset, '?min_price') !== false | strpos($filterreset, '?max_price')) {
        $filterreset = strtok($filterreset, '?');
        echo '<div class="clear-filters-container"><a id="woo-clear-filters" href="' . $filterreset . '">حذف فیلتر</a></div>';
    }

}

//add_filter( 'woocommerce_variable_sale_price_html', 'remove_variation_price_range', 10, 2 );
//add_filter( 'woocommerce_variable_price_html', 'remove_variation_price_range', 10, 2 );
//
//function remove_variation_price_range( $price, $product ) {
//        $min_price = $product->get_variation_price('min', true);
//        return '';
//}


add_filter( 'comment_form_fields', 'move_comment_field_to_bottom' );
function move_comment_field_to_bottom( $fields ) {
    $comment_field = $fields['comment'];
    unset( $fields['comment'] );
    $fields['comment'] = $comment_field;

    return $fields;
}

do_action('wcps_render_surveys');

add_filter( 'wp_require_comment_author_name', '__return_true' );
add_filter( 'wp_require_comment_author_email', '__return_false' );

add_filter( 'woocommerce_product_tabs', function( $tabs ) {
    unset( $tabs['description'] );
    unset( $tabs['additional_information'] );
    unset( $tabs['reviews'] );
    return $tabs;
}, 98 );


function my_comment_vote_buttons($comment_id) {
    $nonce = wp_create_nonce('my_comment_vote_nonce');
    ob_start();
    ?>
    <div class="comment-action d-flex align-items-center" data-comment-id="<?php echo $comment_id; ?>">
        <button class="comment-action_button comment-like" data-type="like" data-nonce="<?php echo $nonce; ?>">👍</button>
        <button class="comment-action_button comment-dislike" data-type="dislike" data-nonce="<?php echo $nonce; ?>">👎</button>
    </div>
    <?php
    return ob_get_clean();
}

function my_comment_vote_counts($comment_id) {
    $likes = get_comment_meta($comment_id, 'my_comment_likes', true) ?: 0;
    $dislikes = get_comment_meta($comment_id, 'my_comment_dislikes', true) ?: 0;

    ob_start();
    ?>
    <div class="comment-text_left comment-vote-counts col-auto" data-comment-id="<?php echo $comment_id; ?>">
        <span>
            <i class="icon-like"></i>
            <span class="comment-like-count">
                <?php echo $likes; ?>
            </span>
        </span>
        <span>
            <i class="icon-dislike"></i>
            <span class="comment-dislike-count">
                <?php echo $dislikes; ?>
            </span>
        </span>
    </div>
    <?php
    return ob_get_clean();
}

// ثبت و لود کردن JS برای لایک/دیسلایک
function my_comment_vote_scripts() {
    if (!is_singular()) {
        return;
    }

    wp_enqueue_script(
        'my-comment-vote-js',
        get_stylesheet_directory_uri() . '/assets/js/my-comment-vote.js',
        array('jquery'),
        '1.0',
        true
    );

    wp_localize_script('my-comment-vote-js', 'myCommentVote', array(
        'ajax_url' => admin_url('admin-ajax.php'),
    ));
}
add_action('wp_enqueue_scripts', 'my_comment_vote_scripts');

add_action('wp_ajax_my_comment_vote', 'my_comment_vote_handler');
add_action('wp_ajax_nopriv_my_comment_vote', 'my_comment_vote_handler');

function my_comment_vote_handler() {

    if (!isset($_POST['comment_id'], $_POST['vote_type'], $_POST['nonce'])) {
        wp_send_json_error(['message' => 'درخواست نامعتبر است.']);
    }

    $comment_id = intval($_POST['comment_id']);
    $vote_type = sanitize_text_field($_POST['vote_type']);
    $nonce = sanitize_text_field($_POST['nonce']);

    if (!wp_verify_nonce($nonce, 'my_comment_vote_nonce')) {
        wp_send_json_error(['message' => 'توکن امنیتی نامعتبر است.']);
    }

    if (!in_array($vote_type, ['like', 'dislike'], true)) {
        wp_send_json_error(['message' => 'نوع رأی نامعتبر است.']);
    }

    // خواندن کوکی JSON
    $cookie_name = 'my_comment_votes';
    $votes = [];

    if (isset($_COOKIE[$cookie_name])) {
        $votes = json_decode(stripslashes($_COOKIE[$cookie_name]), true);
        if (!is_array($votes)) $votes = [];
    }

    $previous_vote = isset($votes[$comment_id]) ? $votes[$comment_id] : '';

    $like_key = 'my_comment_likes';
    $dislike_key = 'my_comment_dislikes';

    $likes = intval(get_comment_meta($comment_id, $like_key, true) ?: 0);
    $dislikes = intval(get_comment_meta($comment_id, $dislike_key, true) ?: 0);

    // حالت ۱: اولین رأی
    if ($previous_vote === '') {
        if ($vote_type === 'like') $likes++;
        else $dislikes++;

        $votes[$comment_id] = $vote_type;
    }

    // حالت ۲: همان رأی قبلی → هیچ تغییری نکن
    elseif ($previous_vote === $vote_type) {
        // هیچ تغییری
    }

    // حالت ۳: تغییر رأی
    else {
        if ($previous_vote === 'like' && $likes > 0) $likes--;
        if ($previous_vote === 'dislike' && $dislikes > 0) $dislikes--;

        if ($vote_type === 'like') $likes++;
        else $dislikes++;

        $votes[$comment_id] = $vote_type;
    }

    update_comment_meta($comment_id, $like_key, $likes);
    update_comment_meta($comment_id, $dislike_key, $dislikes);

    // ذخیره کوکی JSON
    setcookie(
        $cookie_name,
        json_encode($votes),
        time() + 30 * DAY_IN_SECONDS,
        COOKIEPATH,
        COOKIE_DOMAIN
    );

    wp_send_json_success([
        'likes' => $likes,
        'dislikes' => $dislikes,
        'user_vote' => $votes[$comment_id] ?? ''
    ]);
}


add_filter( 'gettext', 'change_cart_totals_title', 20, 3 );
function change_cart_totals_title( $translated_text, $text, $domain ) {
    if ( $text === 'Cart totals' && $domain === 'woocommerce' ) {
        $translated_text = 'فاکتور سبد خرید';
    }
    return $translated_text;
}

add_action( 'woocommerce_cart_totals_before_order_total', 'show_customer_saving_in_cart_totals' );
function show_customer_saving_in_cart_totals() {

    $cart = WC()->cart;
    $total_saving = 0;

    foreach ( $cart->get_cart() as $cart_item ) {

        $product = $cart_item['data'];
        $qty     = $cart_item['quantity'];

        $regular = $product->get_regular_price();
        $sale    = $product->get_sale_price();

        if ( $sale && $regular > $sale ) {
            $saving_per_item = $regular - $sale;
            $total_saving   += $saving_per_item * $qty;
        }
    }

    $coupon_discount = $cart->get_discount_total();
    if ( $coupon_discount > 0 ) {
        $total_saving += $coupon_discount;
    }

    if ( $total_saving <= 0 ) {
        return;
    }

    ?>
    <div class="cart-saving">
        <span class="cart-item-label">سود شما از این خرید</span>
        <span><?php echo wc_price( $total_saving ); ?></span>
    </div>
    <?php
}

add_action( 'woocommerce_cart_totals_after_title', function() {
    if ( wc_coupons_enabled() ) {
        ?>
        <form action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post" class="woocommerce-coupon-form">
            <div class="coupon">
                <input type="text" name="coupon_code" class="input-text form-control mb-0"
                       placeholder="<?php esc_attr_e( 'Coupon code', 'woocommerce' ); ?>" />

                <button type="submit" class="button" name="apply_coupon"
                        value="<?php esc_attr_e( 'Apply coupon', 'woocommerce' ); ?>">
                    <i class="icon-discount"></i> اعمال
                </button>
            </div>
        </form>
        <?php
    }
});
