<?php
/**
Include ACF Plugin
**/
add_filter('acf/settings/path', 'my_acf_settings_path');
function my_acf_settings_path( $path ) {
    $path = get_stylesheet_directory() . '/includes/acf/';
    return $path;
}
add_filter('acf/settings/dir', 'my_acf_settings_dir');
function my_acf_settings_dir( $dir ) {
    $dir = get_stylesheet_directory_uri() . '/includes/acf/';
    return $dir;
}
include_once( get_stylesheet_directory() . '/includes/acf/acf.php' );

/**
General Settings
**/
add_action('after_setup_theme', 'unixa_theme_setup');
function unixa_theme_setup(){
    load_theme_textdomain('unixa', get_template_directory() . '/languages');

	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
	//Remove Default Wordpress Gallery Styles
	add_filter( 'use_default_gallery_style', '__return_false' );
}
/**
  Proper way to enqueue scripts and styles
**/
function unixa_scripts() {
	//Styles
	wp_enqueue_style( 'bootstrap', get_template_directory_uri() .'/assets/vendors/bootstrap/bootstrap.rtl.min.css' );
	wp_enqueue_style( 'swiper-css', get_template_directory_uri() .'/assets/vendors/swiper/swiper-bundle.min.css' );
	wp_enqueue_style( 'animate', get_template_directory_uri() .'/assets/vendors/animate.css' );
	wp_enqueue_style( 'style', get_template_directory_uri() .'/style.css' );
	//Scripts
    wp_enqueue_script( 'bootstrap-js', get_template_directory_uri() . '/assets/vendors/bootstrap/bootstrap.min.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'swiper-js', get_template_directory_uri() . '/assets/vendors/swiper/swiper-bundle.min.js', array(), '1.0', true );
	wp_enqueue_script( 'wow.min', get_template_directory_uri() . '/assets/vendors/wow.min.js', array('jquery'), '1.0', true );

	//Styles and scripts for Comment Reply
	if ( is_singular() ) {
		wp_enqueue_script( 'comment-reply' );
		wp_enqueue_script( 'validate', get_template_directory_uri() . '/assets/js/jquery.validate.min.js', array(), '1.0', true );
	}
	if ( is_front_page() ) {
		wp_enqueue_script('home.js', get_template_directory_uri() . '/assets/js/home.js', array('jquery'), '1.0', true);
	}
	wp_enqueue_script( 'custom.js', get_template_directory_uri() . '/assets/js/custom.js', array('jquery'), '1.0', true );
	wp_localize_script('custom.js', 'ajax_data', array(
		'url' => admin_url('admin-ajax.php')
	));

}
add_action( 'wp_enqueue_scripts', 'unixa_scripts' );
/**
 Starndard Image Sizes
**/
add_action('after_setup_theme', 'unixa_image_sizes');
function unixa_image_sizes(){
	add_image_size( 'post-thumb', 370, 240, true ); // (cropped)
}

/**
 Register Menu Locations
**/
add_action('after_setup_theme', 'unixa_menus');
function unixa_menus(){
    register_nav_menus( array(
		'main'  => __( 'Main Menu', 'unixa' ),
		'mobile'  => __( 'Mobile Menu', 'unixa' ),
	) );
}
/**
 Register Sidebar
**/
add_action('after_setup_theme', 'unixa_sidebars');
function unixa_sidebars(){
	register_sidebar(array(
		'name'          => __('سایدبار مقالات','unixa'),
		'id'            => 'sidebar-blog',
		'description'   => '',
		'class'         => '',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>'
	));
}

if( function_exists('acf_add_options_page') ) {

	acf_add_options_page(array(
		'page_title'    => 'تنظیمات سایت',
		'menu_title'    => 'تنظیمات سایت',
		'menu_slug'     => 'theme-general-settings',
		'capability'    => 'edit_posts',
		'redirect'      => false
	));

	acf_add_options_sub_page(array(
		'page_title'    => 'Theme Home Settings',
		'menu_title'    => 'Home',
		'parent_slug'   => 'theme-general-settings',
	));

	acf_add_options_page(array(
		'page_title' => 'تنظیمات عضویت',
		'menu_title' => 'تنظیمات عضویت',
		'menu_slug' => 'unixa-auth-register-settings',
		'capability' => 'edit_posts'
	));

}

?>
