<?php
/* Template Name: Contact */
get_header();

$contact_form_title = get_field('contact_form_title');
$contact_form_desc = get_field('contact_form_desc');
$contact_map = get_field('contact_map');
$map_image = get_field('map_image');
$map_embed = get_field('map_embed');

$address = get_field('_address', 'option');
$email= get_field('_email', 'option');
$phone = get_field('_phone', 'option');
?>
<div class="page-wrap contact-page">
    <div class="container">
        <div class="row">
            <div class="col-12 col-lg-10 mx-auto">
                <div class="page-header text-center">
                    <h1 class="page-title wow fadeInUp" data-wow-delay="0.25s">
                        <?php echo get_the_title(); ?>
                    </h1>
                    <p><?php echo get_field('contact_form_desc'); ?></p>
                </div>
                <div class="map-wrapper position-relative">
                    <img src="<?php echo $map_image['url']; ?>" width="<?php echo $map_image['width']; ?>" height="<?php echo $map_image['height']; ?>" alt="map">
                    <?php echo $map_embed; ?>
                </div>
                <div class="row justify-content-between">
                    <div class="col-12 col-md-4 col-lg-3 wow fadeInUp" data-wow-delay="0.5s">
                        <div class="contact-card text-center">
                            <span class="icon-wrapper mail"><i class="icon-mail"></i></span>
                            <p><a href="mailto:<?php echo $email; ?>"><?php echo $email; ?></a></p>
                        </div>
                    </div>
                    <div class="col-12 col-md-4 col-lg-5 px-3 wow fadeInUp" data-wow-delay="0.25s">
                        <div class="contact-card text-center">
                            <span class="icon-wrapper location"><i class="icon-location"></i></span>
                            <p><?php echo $address; ?></p>
                        </div>
                    </div>
                    <div class="col-12 col-md-4 col-lg-3 wow fadeInUp" data-wow-delay="0.5s">
                        <div class="contact-card text-center">
                            <span class="icon-wrapper phone"><i class="icon-phone"></i></span>
                            <p><a class="ltr" href="tel:<?php echo $phone; ?>"><?php echo $phone; ?></a></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <section class="contact-form blur-bg">
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-10 mx-auto">
                    <div class="contact-form-wrap">
                        <?php if($contact_form_title!='') { ?>
                            <h3 class="page-title text-center wow fadeInUp" data-wow-delay="0.5s"><?php echo $contact_form_title; ?></h3>
                        <?php }
                        if($contact_form_desc!='') {
                        ?>
                            <p class="page-desc text-center wow fadeInUp" data-wow-delay="0.75s"><?php echo $contact_form_desc; ?></p>
                        <?php
                        }
                            echo do_shortcode('[contact-form-7 id="668d6e6" title="Contact form 1"]');
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php get_footer(); ?>

