jQuery(document).ready(function ($) {

    $(document).on('click', '.comment-like, .comment-dislike', function (e) {
        e.preventDefault();

        var $btn = $(this);
        var $wrapper = $btn.closest('.comment-action');
        var commentId = $wrapper.data('comment-id');
        var voteType = $btn.data('type');
        var nonce = $btn.data('nonce');

        $.ajax({
            url: myCommentVote.ajax_url,
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'my_comment_vote',
                comment_id: commentId,
                vote_type: voteType,
                nonce: nonce
            },
            beforeSend: function () {
                $('[data-comment-id="' + commentId + '"]').addClass('my-comment-vote-loading');
            },
            success: function (response) {

                $('[data-comment-id="' + commentId + '"]').removeClass('my-comment-vote-loading');

                if (!response.success) return;

                var likes = response.data.likes;
                var dislikes = response.data.dislikes;
                var userVote = response.data.user_vote;

                // آپدیت دکمه‌ها
                $('.comment-action[data-comment-id="' + commentId + '"]').each(function () {
                    var $block = $(this);

                    var $likeBtn = $block.find('.comment-like');
                    var $dislikeBtn = $block.find('.comment-dislike');

                    $likeBtn.removeClass('voted');
                    $dislikeBtn.removeClass('voted');

                    if (userVote === 'like') $likeBtn.addClass('voted');
                    if (userVote === 'dislike') $dislikeBtn.addClass('voted');
                });

                // آپدیت شمارنده‌ها
                $('.comment-vote-counts[data-comment-id="' + commentId + '"]').each(function () {
                    $(this).find('.comment-like-count').text(likes);
                    $(this).find('.comment-dislike-count').text(dislikes);
                });
            }
        });
    });

});
