jQuery(function ($) {

    function refreshFragments() {
        $(document.body).trigger('wc_fragment_refresh');
    }


    $(document).on('click', '.variation-option', function () {
        const card = $(this).closest('.product-card');

        // حذف استایل‌ها
        card.find('.variation-option')
            .removeClass('active');

        // ست اکتیو
        $(this).addClass('active');

        // آپدیت دیتا
        card.attr('data-variation-id', $(this).data('variation-id'));
        card.find('.product-price').html($(this).data('price'));

        // فعال‌سازی افزودن به سبد
        card.find('.add-to-cart-btn').prop('disabled', false);

        // ریست qty
        card.find('.qty-wrapper').addClass('hidden');
        card.find('.add-to-cart-btn').removeClass('hidden');
    });

    // افزودن
    $(document).on('click', '.add-to-cart-btn', function () {
        const card = $(this).closest('.product-card');
        const activeVar = card.find('.variation-option.active');

        const data = {
            action: 'custom_add_to_cart',
            nonce: wc_cart.nonce,
            product_id: card.data('product-id'),
            variation_id: activeVar.data('variation-id') || 0,
            attributes: activeVar.data('attributes') || {},
            quantity: 1
        };

        $.post(wc_cart.ajax_url, data, function () {
            card.find('.add-to-cart-btn').addClass('hidden');
card.find('.qty-wrapper').removeClass('hidden').find('.qty-input').val(1);
            refreshFragments();
        });
    });


    // + -
    $(document).on('click', '.qty-plus, .qty-minus', function () {
        const card = $(this).closest('.product-card');
        const input = card.find('.qty-input');

        let qty = parseInt(input.val());
        qty += $(this).hasClass('qty-plus') ? 1 : -1;

        if (qty <= 0) {
            removeItem(card);
            return;
        }

        input.val(qty);
        updateQty(card, qty);
    });

    function updateQty(card, qty) {
        $.post(wc_cart.ajax_url, {
            action: 'custom_update_cart',
            nonce: wc_cart.nonce,
            product_id: card.data('product-id'),
            variation_id: card.data('variation-id') || 0,
            quantity: qty
        }, refreshFragments);
    }


    function removeItem(card) {
        console.log("REMOVE ITEM RUN", card.data('product-id'), card.data('variation-id'));
        $.post(wc_cart.ajax_url, {
            action: 'custom_remove_cart',
            nonce: wc_cart.nonce,
            product_id: card.data('product-id'),
            variation_id: card.data('variation-id') || 0
        }, function () {

            // ریست کامل کارت
            card.find('.qty-wrapper').addClass('hidden');
            card.find('.add-to-cart-btn').removeClass('hidden');
            card.find('.qty-input').val(1);

            // پاک کردن کامل شناسه
            card.data('variation-id', 0);
            card.removeAttr('data-variation-id');

            refreshFragments();
            syncProductCards();
            // بروزرسانی کارت‌ها
            $.get(wc_cart.ajax_url, { action: 'get_cart_contents' }, function(cartItems) {

                $('.product-card').each(function() {
                    const c = $(this);
                    const pid = c.data('product-id');

                    // همیشه از attr بخوان، نه data
                    const vid = c.attr('data-variation-id') ? c.attr('data-variation-id') : 0;

                    const item = cartItems.find(i => i.product_id == pid && i.variation_id == vid);

                    if (item) {
                        c.find('.add-to-cart-btn').addClass('hidden');
                        c.find('.qty-wrapper').removeClass('hidden')
                            .find('.qty-input').val(item.quantity);
                    } else {
                        c.find('.add-to-cart-btn').removeClass('hidden');
                        c.find('.qty-wrapper').addClass('hidden')
                            .find('.qty-input').val(1);
                    }
                });
            });
        });
    }

    function syncProductCards() {
        $.get(wc_cart.ajax_url, { action: 'get_cart_contents' }, function(cartItems) {

            $('.product-card').each(function() {
                const c = $(this);
                const pid = c.data('product-id');
                const vid = c.attr('data-variation-id') ? c.attr('data-variation-id') : 0;

                const item = cartItems.find(i => i.product_id == pid && i.variation_id == vid);

                if (item) {
                    c.find('.add-to-cart-btn').addClass('hidden');
                    c.find('.qty-wrapper').removeClass('hidden')
                        .find('.qty-input').val(item.quantity);
                } else {
                    c.find('.add-to-cart-btn').removeClass('hidden');
                    c.find('.qty-wrapper').addClass('hidden')
                        .find('.qty-input').val(1);

                    c.data('variation-id', 0);
                    c.removeAttr('data-variation-id');
                }
            });
        });
    }

    $(document.body).on('removed_from_cart', function () {
        syncProductCards();
    });

    // function removeItem(card) {
    //     $.post(wc_cart.ajax_url, {
    //         action: 'custom_remove_cart',
    //         nonce: wc_cart.nonce,
    //         product_id: card.data('product-id'),
    //         variation_id: card.data('variation-id') || 0
    //     }, function () {
    //
    //         refreshFragments();
    //         syncProductCards();
    //     });
    // }

    // function removeItem(card) {
    //     $.post(wc_cart.ajax_url, {
    //         action: 'custom_remove_cart',
    //         nonce: wc_cart.nonce,
    //         product_id: card.data('product-id'),
    //         variation_id: card.data('variation-id') || 0
    //     }, function () {
    //
    //         // ریست کامل کارت
    //         card.find('.qty-wrapper').addClass('hidden');
    //         card.find('.add-to-cart-btn').removeClass('hidden');
    //         card.find('.qty-input').val(1);
    //
    //         // مهم‌ترین بخش
    //         card.data('variation-id', 0);   // ←← مشکل اصلی همین بود
    //
    //         refreshFragments();
    //
    //         // بروزرسانی کارت‌ها
    //         $.get(wc_cart.ajax_url, { action: 'get_cart_contents' }, function(cartItems) {
    //
    //             $('.product-card').each(function() {
    //                 const c = $(this);
    //                 const pid = c.data('product-id');
    //                 const vid = c.data('variation-id') || 0;
    //
    //                 const item = cartItems.find(i => i.product_id == pid && i.variation_id == vid);
    //
    //                 if (item) {
    //                     c.find('.add-to-cart-btn').addClass('hidden');
    //                     c.find('.qty-wrapper').removeClass('hidden')
    //                         .find('.qty-input').val(item.quantity);
    //                 } else {
    //                     c.find('.add-to-cart-btn').removeClass('hidden');
    //                     c.find('.qty-wrapper').addClass('hidden')
    //                         .find('.qty-input').val(1);
    //                 }
    //             });
    //         });
    //     });
    // }

});




