<?php
get_header();
$paged = (get_query_var('paged')) ? get_query_var('paged') : ((get_query_var('page')) ? get_query_var('page') : 1);
$term_id = get_queried_object_id();
$taxonomy = 'project-tag';
?>
<div class="page-wrap padcast-page">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-10 mx-auto page-head">
                <h1 class="page-title wow fadeInUp" data-wow-delay="0.25s">
                    <?php echo single_term_title(); ?>
                </h1>
                <?php if(term_description()) { ?>
                    <div class="page-desc"><?php echo term_description(); ?></div>
                <?php } ?>
            </div>
            <?php
            $taxonomy = 'project-category';
            $terms = get_terms([
                'taxonomy' => $taxonomy,
                'hide_empty' => false,
            ]);
            ?>
            <?php
            $args = array(
                'post_type' => 'project',
                'paged' => $paged,
                'post_status ' => 'publish',
                'posts_per_page' => 15,
                'tax_query' => array(
                    array(
                        'taxonomy' => 'project-tag',
                        'terms' => $term_id,
                        'field' => 'term_id',
                    )
                ),
            );
            $posts = new WP_Query($args);
            if ($posts->have_posts()):
                $i = 0.25;
                while ($posts->have_posts()) : $posts->the_post();
                    echo ' <div class="col-12 col-sm-6 col-lg-3 wow fadeInUp" data-wow-delay="' . $i . 's">';
                    get_template_part('templates/card/project', 'card');
                    echo '</div>';
                    $i += 0.25; endwhile;
            endif;
            wp_reset_postdata();
            ?>
            <!-- Pagination -->
            <div class="pagination col-12">
                <?php pagination_bar($posts); ?>
            </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>
