<?php
/*
**************   CUSTOM POST TYPE   **************
*/
add_action('init', 'tiyara_cpt_init');
function tiyara_cpt_init(){
    $project_labels = array(
        'name' => __('پروژه ها', 'tiyara'),
        'singular_name' => __('پروژه ها', 'tiyara'),
        'all_items' => __('همه پروژه ها','tiyara'),
        'add_new' => __('پروژه جدید', 'tiyara'),
        'add_new_item' => __('پروژه جدید','tiyara'),
        'edit_item' => __('ویرایش پروژه','tiyara'),
        'parent_item_colon' => ''
    );
    $project_args = array(
        'labels' => $project_labels,
        'public' => true,
        'publicly_queryable' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_rest' => true,
        'query_var' => true,
        'rewrite' => true,
        'capability_type' => 'post',
        'hierarchical' => true,
        'menu_position' => 8,
        'supports' => array('title','thumbnail','excerpt','editor'),
        'has_archive' => false
    );
    register_post_type('project',$project_args);

    $service_labels = array(
        'name' => __('سرویس ها', 'tiyara'),
        'singular_name' => __('سرویس ها', 'tiyara'),
        'all_items' => __('همه سرویس ها','tiyara'),
        'add_new' => __('سرویس جدید', 'tiyara'),
        'add_new_item' => __('سرویس جدید','tiyara'),
        'edit_item' => __('ویرایش سرویس','tiyara'),
        'parent_item_colon' => ''
    );
    $service_args = array(
        'labels' => $service_labels,
        'public' => true,
        'publicly_queryable' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_rest' => true,
        'query_var' => true,
        'rewrite' => true,
        'capability_type' => 'post',
        'hierarchical' => true,
        'menu_position' => 8,
        'supports' => array('title','thumbnail','editor'),
        'has_archive' => false
    );
    register_post_type('service',$service_args);

    $machinery_labels = array(
        'name' => __('ماشین آلات', 'tiyara'),
        'singular_name' => __('ماشین آلات', 'tiyara'),
        'all_items' => __('همه ماشین آلات','tiyara'),
        'add_new' => __('ماشین آلات جدید', 'tiyara'),
        'add_new_item' => __('ماشین آلات جدید','tiyara'),
        'edit_item' => __('ویرایش ماشین آلات','tiyara'),
        'parent_item_colon' => ''
    );
    $machinery_args = array(
        'labels' => $machinery_labels,
        'public' => true,
        'publicly_queryable' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_rest' => true,
        'query_var' => true,
        'rewrite' => true,
        'capability_type' => 'post',
        'hierarchical' => true,
        'menu_position' => 8,
        'supports' => array('title','thumbnail','excerpt','editor'),
        'has_archive' => false
    );
    register_post_type('machinery',$machinery_args);
}



function tiyara_tax_init() {
    //project taxonomy
    $labels = array(
        'name'                       => __( 'دسته بندی ', 'nerdo' ),
        'singular_name'              => __( 'دسته بندی ', 'nerdo' ),
        'menu_name'                  => __( 'دسته بندی ', 'nerdo' ),
    );
    $rewrite = array(
        'slug'                       => __( 'project-category', 'nerdo' ),
        'with_front'                 => true,
        'hierarchical'               => true,
    );
    $args = array(
        'labels'                     => $labels,
        'hierarchical'               => true,
        'public'                     => true,
        'show_ui'                    => true,
        'show_admin_column'          => true,
        'show_in_nav_menus'          => true,
        'show_tagcloud'              => false,
        'rewrite'                    => $rewrite,
    );
    register_taxonomy( 'project-category', array( 'project' ), $args );

    //   project tags
    $labels = array(
        'name'                       => __( 'برچسب ها', 'nerdo' ),
        'singular_name'              => __( 'برچسب ها', 'nerdo' ),
        'menu_name'                  => __( 'برچسب ها', 'nerdo' ),
    );
    $rewrite = array(
        'slug'                       => __( 'project-tag', 'nerdo' ),
        'with_front'                 => true,
        'hierarchical'               => true,
    );
    $args = array(
        'labels'                     => $labels,
        'hierarchical'               => false,
        'public'                     => true,
        'show_ui'                    => true,
        'show_admin_column'          => true,
        'show_in_nav_menus'          => true,
        'show_tagcloud'              => false,
        'rewrite'                    => $rewrite,
    );
    register_taxonomy( 'project-tag', array( 'project' ), $args );

}
add_action( 'init', 'tiyara_tax_init', 0 );
?>
