<?php
/*
Plugin Name: WP Rental SMS Plugin
Plugin URI: http://Nikanadv.ir
Description: add rangine sms to wprental theme.
Author: NikanAdv
Version: 1.0
Author URI: http://Nikanadv.ir
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

function wpestate_select_sms_type($user_mobile,$type,$arguments,$user_email, $user_data_id){
	$current_user	= wp_get_current_user();
	$userID			=   $current_user->ID;

	$sms_verification =esc_html( wprentals_get_option('wp_estate_sms_verification',''));
	if($sms_verification!=='yes'){
		return;
	}
        
	if($user_data_id!=0 && $type!='validation'){
		$roles=array('administrator');
		if( array_intersect($roles, $current_user->roles )){
			//is admin - do not check
		}else{
			$check_phone = get_the_author_meta( 'check_phone_valid' , $user_data_id);
			if($check_phone!='yes'){
				return;
			}
		}
	}      
	
	$value	=   esc_html( wprentals_get_option('wp_estate_'.$type) );
	if (function_exists('icl_translate') ){
		$value	=  icl_translate('wpestate','wp_estate_sms_'.$value, $value ) ;
	}

	wpestate_sms_filter_replace($user_mobile,$value,$arguments,$user_email);

}

function  wpestate_sms_filter_replace($user_phone_no,$message,$arguments,$user_email){
	$arguments ['website_url'] = get_option('siteurl');
	$arguments ['website_name'] = get_option('blogname');       
	$arguments ['user_email'] = $user_email;     
	$user= get_user_by('email',$user_email);
	$arguments ['username'] = $user-> user_login;
        
	foreach($arguments as $key_arg=>$arg_val){
		$to_replace =   trim('%'.$key_arg);
		$message    =   str_replace($to_replace, $arg_val, $message);
	}   
	
	$response= nikan_rental_send_sms($user_phone_no, $message );    

}

function nikan_rental_send_sms($to,$body){
	
	try {
		$client = new SoapClient("http://37.130.202.188/class/sms/wsdlservice/server.php?wsdl");
		
		$encoding   = "UTF-8";
		$user = esc_html( wprentals_get_option('wp_estate_twilio_api_key') );
		$pass = esc_html( wprentals_get_option('wp_estate_twilio_auth_token') );
		$fromNum = esc_html( wprentals_get_option('wp_estate_twilio_phone_no') );
		$toNum = array($to);
		$messageContent = iconv( $encoding, 'UTF-8//TRANSLIT', $body );
		$op  = "send";
		$time = '';
		
		$res = $client->SendSMS($fromNum,$toNum,$messageContent,$user,$pass,$time,$op);

		} catch (SoapFault $ex) {
			$sms_response = $ex->faultstring;
		}
	
    if ( empty( $sms_response ) && $res == 0 ) {
			$response = true;
		}

	return $response;
}