<?php
class ControllerExtensionModuleSeoKeyword extends Controller {
	private $error = array();
	private $moduleName 			= 'seo_keyword';
	private $moduleModel 			= 'model_extension_module_seo_keyword';
	private $modulePath 			= 'extension/module/seo_keyword';
	private $moduleVersion 			= '1.1';

    public function install() {
		$this->load->model($this->modulePath);
		$result = $this->{$this->moduleModel}->install();
		if($result->num_rows){
			$modifications = $this->load->controller('extension/modification/refresh');
		}
    }

    public function uninstall() {
		$this->load->model($this->modulePath);
		$result = $this->{$this->moduleModel}->uninstall();
		if($result->num_rows){
			$modifications = $this->load->controller('extension/modification/refresh');
		}
    }

	public function index() {
		$this->load->language($this->modulePath);

		$this->load->model($this->modulePath);

		$this->document->setTitle($this->language->get('heading_title'));

		$data['heading_title'] = $this->language->get('heading_title');

		$data['button_cancel'] = $this->language->get('button_cancel');
		$data['text_load_message'] = $this->language->get('text_load_message');
		$data['text_retry'] = $this->language->get('text_retry');
		$data['error_notification'] = $this->language->get('error_notification');
		
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('extension/extension', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title') . ' ' . $this->moduleVersion,
			'href' => $this->url->link($this->modulePath, 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['cancel'] = $this->url->link('extension/extension', 'token=' . $this->session->data['token'], 'SSL');
		$data['token'] = $this->session->data['token'];

		$data['notification'] = $this->url->link($this->modulePath . '/getNotification', 'token=' . $this->session->data['token'], 'SSL');

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view($this->modulePath, $data));
	}

	public function getNotification() {
		sleep(1);
		$this->load->language($this->modulePath);

		$json['version'] = $this->moduleVersion;

		$language_code = $this->config->get('config_admin_language');
		$result = $this->getCurlContent("http://google.com/index.php?route=information/message&type=module_seo_keyword_lite&version=$this->moduleVersion&language_code=$language_code");


		if (stripos($result,'<html') !== false || $result == false) {
			$json['message'] = '';
			$json['error'] = $this->language->get('error_notification');
		} else {
			$json['message'] = $result;
			$json['error'] = '';
		}

		$this->response->setOutput(json_encode($json));
	}

	protected function getCurlContent($url) {
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$output = curl_exec($ch);
		curl_close($ch);
		return $output;
	}
}
?>