<?php
/* Gate (DargahPardakht) WebService Pro v2.3 */
class ControllerExtensionPaymentGateDargahPardakht extends Controller {
	private $WebService = array();
	private $errors = array();
	
	public function index() {
		$this->load->language('extension/payment/gate_DargahPardakht');
		
		$data['button_confirm'] = $this->language->get('button_confirm');
		$data['text_wait'] = $this->language->get('text_wait');
		$data['text_loading'] = $this->language->get('text_loading');
		
		return $this->load->view('extension/payment/gate_DargahPardakht', $data);
	}
	
	public function confirm() {
		$this->load->language('extension/payment/gate_DargahPardakht');
		
		$json = array();
		
		$order_id = isset($this->session->data['order_id']) ? $this->session->data['order_id'] : 0;
		
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($order_id);
		
		if ($order_info) {
		
			// -----------------------------------
			$data['terminal_id'] 	 = $this->config->get('gate_DargahPardakht_terminal_id');
			
			$data['address_confirm'] = urlencode($this->url->link('extension/payment/gate_DargahPardakht/callback', 's_order_id=' . $this->encryption->encrypt($order_id), true));
			$data['orderTotal']   = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false);
			$data['orderTotal']   = $this->currency->convert($data['orderTotal'], $order_info['currency_code'], "TOM");
			$data['orderId'] 	  = time();
			$data['orderComment'] = $order_info['comment'];
			
			$ch = curl_init();
			
			curl_setopt($ch, CURLOPT_URL, 'http://DargahPardakht.com/webservice/index.php');
			curl_setopt($ch, CURLOPT_POSTFIELDS, 'id=' . $data['terminal_id'] . '&amount=' . $data['orderTotal'] . '&callback=' . $data['address_confirm'] . '&resnum=' . $data['orderId']);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			
			$result = curl_exec($ch);

			curl_close($ch);
			
			if (is_numeric($result) && $result > 0) {
				$json['success'] = 'http://DargahPardakht.com/webservice/go.php?id=' . $result;
			} else {
				switch (intval($result)) {
					case -1: $json['error'] = 'خطا (-1): ' . 'ﮐﺪ ﭘﺬﯾﺮﻧﺪه ﺻﺤﯿﺢ ﻧﻤﯽ ﺑﺎﺷﺪ!'; break;
					case -2: $json['error'] = 'خطا (-2): ' . 'ﻣﻘﺪار ﻣﺒﻠﻎ ﺻﺤﯿﺢ ﻧﻤﯽ ﺑﺎﺷﺪ!'; break;
					case -3: $json['error'] = 'خطا (-3): ' . 'آدرس ﺑﺎزﮔﺸﺖ ﺻﺤﯿﺢ ﻧﻤﯽ ﺑﺎﺷﺪ!'; break;
					case -4: $json['error'] = 'خطا (-4): ' . 'درﮔﺎه پذیرنده فعال نمیباشد!'; break;
					case -5: $json['error'] = 'خطا (-5): ' . 'ﺷﻤﺎره ﻓﺎﮐﺘﻮر ﺻﺤﯿﺢ ﻧیست!'; break;
					case -6: $json['error'] = 'خطا (-6): ' . 'ﺷﻤﺎره ﻓﺎﮐﺘﻮر ﺗﮑﺮاري اﺳﺖ!'; break;
					case -7: $json['error'] = 'خطا (-7): ' . 'ﺧﻄﺎ در ﺷﺒﮑﻪ ﺑﺎﻧﮑﯽ وﺟﻮد دارد!'; break;
					default : $json['error'] = 'خطای نامشخص روی داده است!'; break;
				}
			}
			// -----------------------------------
			
		} else {
			$json['error'] = $this->language->get('error_order_id');
		}
		
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function callback() {
		if ($this->session->data['payment_method']['code'] == 'gate_DargahPardakht') {
			$this->load->language('extension/payment/gate_DargahPardakht');
			
			$this->document->setTitle($this->language->get('text_heading'));
			
			$data['heading_title'] = $this->language->get('text_heading');
			$data['text_wait'] = $this->language->get('text_wait');
			$data['text_results'] = $this->language->get('text_results');
			
			$data['button_confirm'] = $this->language->get('button_confirm');
			$data['button_continue'] = $this->language->get('button_continue');
			
			$data['breadcrumbs'] = array();

			$data['breadcrumbs'][] = array(
				'text'      => $this->language->get('text_home'),
				'href'      => $this->url->link('common/home')
			); 

			$data['breadcrumbs'][] = array(
				'text'      => $this->language->get('text_heading'),
				'href'      => $this->url->link('extension/payment/gate_DargahPardakht/callback', '', true)
			);
			
			$data['error_warning'] = '';
			
			$data['address_cancel'] = $this->url->link('checkout/checkout', '', true);
			$data['address_success'] = $this->url->link('checkout/success', '', true);
			
			$order_id = isset($this->request->get['s_order_id']) ? $this->encryption->decrypt($this->request->get['s_order_id']) : 0;
			/*$order_id = isset($this->session->data['order_id']) ? $this->session->data['order_id'] : 0;*/
			
			$this->load->model('checkout/order');
			$order_info = $this->model_checkout_order->getOrder($order_id);
			
			if ($order_info) {
				
				// -----------------------------------
				$data['terminal_id'] = $this->config->get('gate_DargahPardakht_terminal_id');
				
				$data['orderTotal'] = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false);
				$data['orderTotal'] = $this->currency->convert($data['orderTotal'], $order_info['currency_code'], "TOM");
				$data['orderId'] 	= $order_info['order_id'];
				
				$data['resNum'] = isset($this->request->post['resnum']) ? $this->request->post['resnum'] : '';
				$data['refNum'] = isset($this->request->post['refnum']) ? $this->request->post['refnum'] : '';
				$data['status'] = isset($this->request->post['status']) ? $this->request->post['status'] : '';

				if ($data['status'] == 1) {
					$ch = curl_init();
					curl_setopt($ch, CURLOPT_URL, 'http://DargahPardakht.com/webservice/verify.php');
					curl_setopt($ch, CURLOPT_POSTFIELDS, 'id=' . $data['terminal_id'] . '&resnum=' . $data['resNum'] . '&refnum=' . $data['refNum'] . '&amount=' . $data['orderTotal']);
					curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					
					$result = curl_exec($ch);
					
					curl_close($ch);
				
					switch (intval($result)) {
						case -1 : $data['error_warning'] = 'خطا (-1):' . 'ﭘﺎراﻣﺘﺮ ﻫﺎي ارﺳﺎﻟﯽ ﺻﺤﯿﺢ ﻧﻤﯽ ﺑﺎﺷﺪ!'; break;
						case 0  : $data['error_warning'] = 'خطا (0):' . 'ﭘﺮداﺧﺖ ﺑﺎ ﻣﻮﻓﻘﯿﺖ اﻧﺠﺎم ﻧﺸﺪه اﺳت!'; break;
						case 1 :  $data['authority'] = $data['refNum']; break;
					} 
				} else {
					$data['error_warning'] = 'خطا: کد وضعیت بازگشتی نادرست است!';
				}
				
				if ($data['error_warning']) {
					$data['continue'] = $data['address_cancel'];
				} else {
					$comment = $data['text_results'] . ' ' . $data['authority'];
					$this->model_checkout_order->addOrderHistory($order_info['order_id'], $this->config->get('gate_DargahPardakht_order_status_id'), $comment, true);
					$data['continue'] = $data['address_success'];
				}
				// -----------------------------------
				
			} else {
				$data['error_warning'] = $this->language->get('error_order_id');
				$data['continue'] = $data['address_cancel'];
			}
		
			$data['column_left'] = $this->load->controller('common/column_left');
			$data['column_right'] = $this->load->controller('common/column_right');
			$data['content_top'] = $this->load->controller('common/content_top');
			$data['content_bottom'] = $this->load->controller('common/content_bottom');
			$data['footer'] = $this->load->controller('common/footer');
			$data['header'] = $this->load->controller('common/header');

			$this->response->setOutput($this->load->view('extension/payment/gate_DargahPardakht_confirm', $data));
		}
	}
}
?>