<?php
class ControllerExtensionPaymentGateDargahPardakht extends Controller {
	private $error = array();
	
	public function index() {
		$this->load->language('extension/payment/gate_DargahPardakht');

		$this->document->setTitle(strip_tags($this->language->get('heading_title')));

		$this->load->model('setting/setting');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('gate_DargahPardakht', $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$this->response->redirect($this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=payment', true));
		}
		
		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_all_zones'] = $this->language->get('text_all_zones');
		$data['text_developer'] = $this->language->get('text_developer');
		
		$data['entry_terminal_id'] = $this->language->get('entry_terminal_id');
		$data['entry_terminal_type'] = $this->language->get('entry_terminal_type');
		$data['entry_order_status'] = $this->language->get('entry_order_status');		
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$data['entry_support'] = $this->language->get('entry_support');
		
		$data['tab_general'] = $this->language->get('tab_general');
		
		$data['fields_configuration_1'] = $this->language->get('fields_configuration_1');
		$data['fields_configuration_2'] = $this->language->get('fields_configuration_2');

		$data['help_support'] = $this->language->get('help_support');
		
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');
		
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['terminal_id'])) {
			$data['error_terminal_id'] = $this->error['terminal_id'];
		} else {
			$data['error_terminal_id'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=payment', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/payment/gate_DargahPardakht', 'token=' . $this->session->data['token'], true)
		);
		
		$data['action'] = $this->url->link('extension/payment/gate_DargahPardakht', 'token=' . $this->session->data['token'], true);

		$data['cancel'] = $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=payment', true);
		
		if (isset($this->request->post['gate_DargahPardakht_terminal_id'])) {
			$data['gate_DargahPardakht_terminal_id'] = $this->request->post['gate_DargahPardakht_terminal_id'];
		} else {
			$data['gate_DargahPardakht_terminal_id'] = $this->config->get('gate_DargahPardakht_terminal_id');
		}

		if (isset($this->request->post['gate_DargahPardakht_order_status_id'])) {
			$data['gate_DargahPardakht_order_status_id'] = $this->request->post['gate_DargahPardakht_order_status_id'];
		} else {
			$data['gate_DargahPardakht_order_status_id'] = $this->config->get('gate_DargahPardakht_order_status_id');
		}

		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['gate_DargahPardakht_status'])) {
			$data['gate_DargahPardakht_status'] = $this->request->post['gate_DargahPardakht_status'];
		} else {
			$data['gate_DargahPardakht_status'] = $this->config->get('gate_DargahPardakht_status');
		}

		if (isset($this->request->post['gate_DargahPardakht_sort_order'])) {
			$data['gate_DargahPardakht_sort_order'] = $this->request->post['gate_DargahPardakht_sort_order'];
		} else {
			$data['gate_DargahPardakht_sort_order'] = $this->config->get('gate_DargahPardakht_sort_order');
		}
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/payment/gate_DargahPardakht', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/payment/gate_DargahPardakht')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!$this->request->post['gate_DargahPardakht_terminal_id']) {
			$this->error['terminal_id'] = $this->language->get('error_terminal_id');
		}

		return !$this->error;
	}
}
?>