<?php
class ControllerExtensionPaymentArianpal extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/payment/arianpal');

		$this->document->setTitle($this->language->get('doc_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('arianpal', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=payment', true));
		}

		$data['heading_title'] = $this->language->get('heading_title');
		
		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_support'] = $this->language->get('text_support');
		$data['text_developer'] = $this->language->get('text_developer');

		$data['entry_pin'] = $this->language->get('entry_pin');
		$data['entry_pass'] = $this->language->get('entry_pass');
		$data['entry_order_status'] = $this->language->get('entry_order_status');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['pin'])) {
			$data['error_pin'] = $this->error['pin'];
		} else {
			$data['error_pin'] = '';
		}

		if (isset($this->error['pass'])) {
			$data['error_pass'] = $this->error['pass'];
		} else {
			$data['error_pass'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=payment', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/payment/arianpal', 'token=' . $this->session->data['token'], true)
		);

		$data['action'] = $this->url->link('extension/payment/arianpal', 'token=' . $this->session->data['token'], true);

		$data['cancel'] = $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=payment', true);

		if (isset($this->request->post['arianpal_pin'])) {
			$data['arianpal_pin'] = $this->request->post['arianpal_pin'];
		} else {
			$data['arianpal_pin'] = $this->config->get('arianpal_pin');
		}
		
		if (isset($this->request->post['arianpal_pass'])) {
			$data['arianpal_pass'] = $this->request->post['arianpal_pass'];
		} else {
			$data['arianpal_pass'] = $this->config->get('arianpal_pass');
		}

		if (isset($this->request->post['arianpal_order_status_id'])) {
			$data['arianpal_order_status_id'] = $this->request->post['arianpal_order_status_id'];
		} else {
			$data['arianpal_order_status_id'] = $this->config->get('arianpal_order_status_id');
		}

		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['arianpal_status'])) {
			$data['arianpal_status'] = $this->request->post['arianpal_status'];
		} else {
			$data['arianpal_status'] = $this->config->get('arianpal_status');
		}

		if (isset($this->request->post['arianpal_sort_order'])) {
			$data['arianpal_sort_order'] = $this->request->post['arianpal_sort_order'];
		} else {
			$data['arianpal_sort_order'] = $this->config->get('arianpal_sort_order');
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/payment/arianpal', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/payment/arianpal')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!$this->request->post['arianpal_pin']) {
			$this->error['pin'] = $this->language->get('error_pin');
		}
		
		if (!$this->request->post['arianpal_pass']) {
			$this->error['pass'] = $this->language->get('error_pass');
		}

		return !$this->error;
	}
}
?>