<?php
class ControllerExtensionModuleyahoomessenger extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/module/yahoomessenger');

		$this->document->setTitle($this->language->get('doc_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('yahoomessenger', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=module', true));
		}

		$data['heading_title'] = $this->language->get('heading_title');
		
		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		
		$data['entry_code'] = $this->language->get('entry_code');
		$data['entry_style'] = $this->language->get('entry_style');
		$data['entry_status'] = $this->language->get('entry_status');
		
		$data['help_code'] = $this->language->get('help_code');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['code'])) {
			$data['error_code'] = $this->error['code'];
		} else {
			$data['error_code'] = '';
		}

		if (isset($this->error['style'])) {
			$data['error_style'] = $this->error['style'];
		} else {
			$data['error_style'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=module', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/module/yahoomessenger', 'token=' . $this->session->data['token'], true)
		);

		$data['action'] = $this->url->link('extension/module/yahoomessenger', 'token=' . $this->session->data['token'], true);

		$data['cancel'] = $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=module', true);

		if (isset($this->request->post['yahoomessenger_status'])) {
			$data['yahoomessenger_status'] = $this->request->post['yahoomessenger_status'];
		} else {
			$data['yahoomessenger_status'] = $this->config->get('yahoomessenger_status');
		}

		if (isset($this->request->post['yahoomessenger_code'])) {
			$data['yahoomessenger_code'] = $this->request->post['yahoomessenger_code'];
		} else {
			$data['yahoomessenger_code'] = $this->config->get('yahoomessenger_code');
		}

		if (isset($this->request->post['yahoomessenger_style'])) {
			$data['yahoomessenger_style'] = $this->request->post['yahoomessenger_style'];
		} else {
			$data['yahoomessenger_style'] = $this->config->get('yahoomessenger_style');
		}
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/yahoomessenger', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/module/yahoomessenger')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['yahoomessenger_code']) {
			$this->error['code'] = $this->language->get('error_code');
		}
		
		if (!$this->request->post['yahoomessenger_style']) {
			$this->error['style'] = $this->language->get('error_style');
		}

		return !$this->error;
	}
}
?>