
-- --------------------------------------------------------

--
-- Table structure for table `oc_modification`
--

DROP TABLE IF EXISTS `oc_modification`;
CREATE TABLE `oc_modification` (
  `modification_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `code` varchar(64) NOT NULL,
  `author` varchar(64) NOT NULL,
  `version` varchar(32) NOT NULL,
  `link` varchar(255) NOT NULL,
  `xml` mediumtext NOT NULL,
  `status` tinyint(1) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`modification_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `oc_modification`
--

INSERT INTO `oc_modification` (`modification_id`, `name`, `code`, `author`, `version`, `link`, `xml`, `status`, `date_added`) VALUES
(1, 'OpenCartFarsi Shamsi Date V2.3.0.2', 'OpenCartFarsi_Shamsi_Date', 'Mojtaba Moghani - wWw.Open-Cart.ir', '3.7', 'http://www.opencartfarsi.com', '<?xml version="1.0" encoding="UTF-8"?>\r\n<modification>\r\n	<name>OpenCartFarsi Shamsi Date V2.3.0.2</name>\r\n	<code>OpenCartFarsi_Shamsi_Date</code>\r\n	<version>3.7</version>\r\n	<author>Mojtaba Moghani - wWw.Open-Cart.ir</author>\r\n	<link>http://www.opencartfarsi.com</link>\r\n\r\n	<!-- admin/controller/catalog -->\r\n	<file path="admin/controller/catalog/product.php">\r\n		<operation>\r\n			<search><![CDATA[$data[''text_amount''] = $this->language->get(''text_amount'');]]></search>\r\n			<add position="after"><![CDATA[		$data[''lang_code''] = $this->language->get(''code'');]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/controller/catalog/review.php">\r\n		<operation>\r\n			<search><![CDATA[''filter_date_added'' => $filter_date_added,]]></search>\r\n			<add position="replace"><![CDATA[''filter_date_added'' => ($this->language->get(''code'') == ''fa'') ? jtg($filter_date_added) : $filter_date_added,]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_added''])),]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_added''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_added''])),]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/controller/catalog/download.php">\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_added''])),]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_added''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_added''])),]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!--admin/controller/customer/customer.php-->\r\n	<file path="admin/controller/customer/customer.php">\r\n		<operation>\r\n			<search><![CDATA[''filter_date_added''        => $filter_date_added,]]></search>\r\n			<add position="replace"><![CDATA[''filter_date_added''        => ($this->language->get(''code'') == ''fa'') ? jtg($filter_date_added) : $filter_date_added,]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_added'']))]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_added''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_added'']))]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[''date_added'' => date(''d/m/y'', strtotime($result[''date_added''])),]]></search>\r\n			<add position="replace"><![CDATA[''date_added'' => ($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_added''])) : date(''d/m/y'', strtotime($result[''date_added''])),]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!-- admin/controller/dashboard -->\r\n	<file path="admin/controller/extension/dashboard/activity.php">\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''datetime_format''), strtotime($result[''date_added'']))]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_added''])) : date($this->language->get(''datetime_format''), strtotime($result[''date_added'']))]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/controller/extension/dashboard/chart.php">\r\n		<operation info="Chart For Week">\r\n			<search><![CDATA[$json[''xaxis''][] = array(date(''w'', strtotime($date)), date(''D'', strtotime($date)));]]></search>\r\n			<add position="replace"><![CDATA[$json[''xaxis''][] = ($this->language->get(''code'') == ''fa'') ? array(date(''w'', strtotime($date)), jdate(''l'', strtotime($date))) : array(date(''w'', strtotime($date)), date(''D'', strtotime($date)));]]></add>\r\n		</operation>\r\n		<operation info="Chart For Month">\r\n			<search><![CDATA[for ($i = 1; $i <= date(''t''); $i++) {]]></search>\r\n			<add position="replace" offset="4"><![CDATA[\r\n				if ($this->language->get(''code'') == ''fa'') {\r\n					for ($i = 1; $i <= jdate(''t''); $i++) {\r\n						$jdate = jdate(''Y'') . ''-'' . jdate(''m'') . ''-'' . $i;\r\n						$date = jtg($jdate);\r\n\r\n						$json[''xaxis''][] = array(jdate(''j'', strtotime($date)), jdate(''d'', strtotime($date)));\r\n					}\r\n				}  else {\r\n					for ($i = 1; $i <= date(''t''); $i++) {\r\n						$date = date(''Y'') . ''-'' . date(''m'') . ''-'' . $i;\r\n\r\n						$json[''xaxis''][] = array(date(''j'', strtotime($date)), date(''d'', strtotime($date)));\r\n					}\r\n				}\r\n			]]></add>\r\n		</operation>\r\n		<operation info="Chart For Year">\r\n			<search><![CDATA[$json[''xaxis''][] = array($i, date(''M'', mktime(0, 0, 0, $i)));]]></search>\r\n			<add position="replace"><![CDATA[$json[''xaxis''][] = ($this->language->get(''code'') == ''fa'') ? array($i, jdate(''F'', jmktime(0, 0, 0, $i, 1, jdate(''Y'')))) : array($i, date(''M'', mktime(0, 0, 0, $i)));]]></add>\r\n		</operation>\r\n	</file>\r\n	<!--admin/controller/extension/dashboard/customer.php\r\n		admin/controller/extension/dashboard/order.php\r\n		admin/controller/extension/dashboard/sale.php\r\n	-->\r\n	<file path="admin/controller/extension/dashboard/{customer,order,sale}.php">\r\n		<operation>\r\n			<search><![CDATA[date(''Y-m-d'', strtotime(''-1 day''))]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate(''Y-m-d'', strtotime(''-1 day'')) : date(''Y-m-d'', strtotime(''-1 day''))]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[date(''Y-m-d'', strtotime(''-2 day''))]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate(''Y-m-d'', strtotime(''-2 day'')) : date(''Y-m-d'', strtotime(''-2 day''))]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/controller/extension/dashboard/recent.php">\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_added''])),]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_added''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_added''])),]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!-- admin/controller/extension -->\r\n	<file path="admin/controller/extension/{event,modification}.php">\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_added''])),]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_added''])) :date($this->language->get(''date_format_short''), strtotime($result[''date_added''])),]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!--admin/controller/localisation/currency.php\r\n		admin/controller/localisation/tax_rate.php\r\n	-->\r\n	<file path="admin/controller/localisation/{currency,tax_rate}.php">\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_modified''])),]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_modified''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_modified''])),]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/controller/localisation/tax_rate.php">\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_added''])),]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_added''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_added''])),]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/controller/localisation/zone.php">\r\n		<operation>\r\n			<search><![CDATA[$order = ''ASC'';]]></search>\r\n			<add position="replace"><![CDATA[$order = ''DESC'';]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!--admin/controller/marketing/affiliate.php\r\n		admin/controller/marketing/marketing.php\r\n	-->\r\n	<file path="admin/controller/marketing/{affiliate,marketing}.php">\r\n		<operation>\r\n			<search><![CDATA[''filter_date_added'' => $filter_date_added,]]></search>\r\n			<add position="replace" regex="true"><![CDATA[''filter_date_added'' => ($this->language->get(''code'') == ''fa'') ? jtg($filter_date_added) : $filter_date_added,]]></add>\r\n		</operation>\r\n	</file>\r\n	<!--admin/controller/marketing/affiliate.php\r\n		admin/controller/marketing/marketing.php\r\n		admin/controller/marketing/coupon.php\r\n	-->\r\n	<file path="admin/controller/marketing/{affiliate,marketing,coupon}.php">\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_added'']))]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_added''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_added'']))]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/controller/marketing/coupon.php">\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_start''])),]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_start''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_start''])),]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_end''])),]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_end''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_end''])),]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[$data[''text_amount''] = $this->language->get(''text_amount'');]]></search>\r\n			<add position="after"><![CDATA[		$data[''lang_code''] = $this->language->get(''code'');]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!--admin/controller/report/affiliate.php\r\n		admin/controller/report/affiliate_activity.php\r\n		admin/controller/report/customer_activity.php\r\n		admin/controller/report/customer_credit.php\r\n		admin/controller/report/customer_order.php\r\n		admin/controller/report/customer_reward.php\r\n		admin/controller/report/marketing.php\r\n		admin/controller/report/product_purchased.php\r\n		admin/controller/report/sale_coupon.php\r\n		admin/controller/report/sale_order.php\r\n		admin/controller/report/sale_return.php\r\n		admin/controller/report/sale_shipping.php\r\n		admin/controller/report/sale_tax.php\r\n	-->\r\n	<file path="admin/controller/report/{affiliate,affiliate_activity,customer_activity,customer_credit,customer_reward,sale_coupon}.php">\r\n		<operation>\r\n			<search><![CDATA[''filter_date_start''	=> $filter_date_start,]]></search>\r\n			<add position="replace" offset="1"><![CDATA[\r\n			''filter_date_start'' => ($this->language->get(''code'') == ''fa'') ? jtg($filter_date_start) : $filter_date_start,\r\n			''filter_date_end''	=> ($this->language->get(''code'') == ''fa'') ? jtg($filter_date_end) : $filter_date_end,\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/controller/report/{marketing,product_purchased,sale_order,sale_shipping,sale_tax}.php">\r\n		<operation>\r\n			<search><![CDATA[''filter_date_start''	     => $filter_date_start,]]></search>\r\n			<add position="replace" offset="1"><![CDATA[\r\n			''filter_date_start'' => ($this->language->get(''code'') == ''fa'') ? jtg($filter_date_start) : $filter_date_start,\r\n			''filter_date_end''	=> ($this->language->get(''code'') == ''fa'') ? jtg($filter_date_end) : $filter_date_end,\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/controller/report/customer_order.php">\r\n		<operation>\r\n			<search><![CDATA[''filter_date_start''			=> $filter_date_start,]]></search>\r\n			<add position="replace" offset="1"><![CDATA[\r\n			''filter_date_start'' => ($this->language->get(''code'') == ''fa'') ? jtg($filter_date_start) : $filter_date_start,\r\n			''filter_date_end''	=> ($this->language->get(''code'') == ''fa'') ? jtg($filter_date_end) : $filter_date_end,\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/controller/report/sale_return.php">\r\n		<operation>\r\n			<search><![CDATA[''filter_date_start''	      => $filter_date_start,]]></search>\r\n			<add position="replace" offset="1"><![CDATA[\r\n			''filter_date_start'' => ($this->language->get(''code'') == ''fa'') ? jtg($filter_date_start) : $filter_date_start,\r\n			''filter_date_end''	=> ($this->language->get(''code'') == ''fa'') ? jtg($filter_date_end) : $filter_date_end,\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n	<!--admin/controller/report/customer_activity.php\r\n		admin/controller/report/customer_online.php\r\n	-->\r\n	<file path="admin/controller/report/{customer_activity,customer_online}.php">\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''datetime_format''), strtotime($result[''date_added'']))]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_added''])) : date($this->language->get(''datetime_format''), strtotime($result[''date_added'']))]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/controller/report/sale_order.php">\r\n		<operation>\r\n			<search><![CDATA[$filter_date_start = date(''Y-m-d'', strtotime(date(''Y'') . ''-'' . date(''m'') . ''-01''));]]></search>\r\n			<add position="replace"><![CDATA[$filter_date_start = ($this->language->get(''code'') == ''fa'') ? jdate(''Y'') . ''-'' . jdate(''m'') . ''-01'' : date(''Y-m-d'', strtotime(date(''Y'') . ''-'' . date(''m'') . ''-01''));]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[$filter_date_end = date(''Y-m-d'');]]></search>\r\n			<add position="replace"><![CDATA[$filter_date_end = ($this->language->get(''code'') == ''fa'') ? jdate(''Y-m-d'') : date(''Y-m-d'');]]></add>\r\n		</operation>\r\n	</file>\r\n	<!--admin/controller/report/sale_order.php\r\n		admin/controller/report/sale_return.php\r\n		admin/controller/report/sale_shipping.php\r\n		admin/controller/report/sale_tax.php\r\n	-->\r\n	<file path="admin/controller/report/{sale_order,sale_return,sale_shipping,sale_tax}.php">\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_start''])),]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_start''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_start''])),]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_end''])),]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_end''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_end''])),]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!--admin/controller/sale/recurring.php-->\r\n	<file path="admin/controller/sale/recurring.php">\r\n		<operation>\r\n			<search><![CDATA[''filter_date_added''         => $filter_date_added,]]></search>\r\n			<add position="replace"><![CDATA[''filter_date_added''        => ($this->language->get(''code'') == ''fa'') ? jtg($filter_date_added) : $filter_date_added,]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[$data[''date_added''] = date($this->language->get(''date_format_short''), strtotime($order_info[''date_added'']));]]></search>\r\n			<add position="replace"><![CDATA[$data[''date_added''] = ($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($order_info[''date_added''])) : date($this->language->get(''date_format_short''), strtotime($order_info[''date_added'']));]]></add>\r\n		</operation>\r\n	</file>\r\n	<!--admin/controller/sale/order.php\r\n		admin/controller/sale/recurring.php\r\n		admin/controller/sale/return.php\r\n		admin/controller/sale/voucher.php\r\n	-->\r\n	<file path="admin/controller/sale/{order,recurring,return,voucher}.php">\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_added'']))]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_added''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_added'']))]]></add>\r\n		</operation>\r\n	</file>\r\n	<!--admin/controller/sale/order.php\r\n		admin/controller/sale/return.php\r\n	-->\r\n	<file path="admin/controller/sale/order.php">\r\n		<operation>\r\n			<search><![CDATA[''filter_date_added''    => $filter_date_added,]]></search>\r\n			<add position="replace" offset="1"><![CDATA[\r\n			''filter_date_added''    => ($this->language->get(''code'') == ''fa'') ? jtg($filter_date_added) : $filter_date_added,\r\n			''filter_date_modified'' => ($this->language->get(''code'') == ''fa'') ? jtg($filter_date_modified) : $filter_date_modified,\r\n			]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($order_info[''date_added'']))]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($order_info[''date_added''])) : date($this->language->get(''date_format_short''), strtotime($order_info[''date_added'']))]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/controller/sale/return.php">\r\n		<operation>\r\n			<search><![CDATA[''filter_date_added''       => $filter_date_added,]]></search>\r\n			<add position="replace" offset="1"><![CDATA[\r\n			''filter_date_added''    => ($this->language->get(''code'') == ''fa'') ? jtg($filter_date_added) : $filter_date_added,\r\n			''filter_date_modified'' => ($this->language->get(''code'') == ''fa'') ? jtg($filter_date_modified) : $filter_date_modified,\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/controller/sale/{order,return}.php">\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_modified''])),]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_modified''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_modified''])),]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!-- admin/controller/setting -->\r\n	<file path="admin/controller/setting/setting.php">\r\n		<operation>\r\n			<search><![CDATA[$data[''entry_currency_auto''] = $this->language->get(''entry_currency_auto'');]]></search>\r\n			<add position="after"><![CDATA[		$data[''entry_shamsidate_format''] = $this->language->get(''entry_shamsidate_format'');]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[$data[''help_currency_auto''] = $this->language->get(''help_currency_auto'');]]></search>\r\n			<add position="after"><![CDATA[		$data[''help_shamsidate_format''] = $this->language->get(''help_shamsidate_format'');]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[if (isset($this->request->post[''config_currency_auto''])) {]]></search>\r\n			<add position="before"><![CDATA[\r\n		$data[''shamsidate_formats''] = array();\r\n		$data[''shamsidate_formats''][] = array(\r\n			''code'' 	=> $this->language->get(''date_format_short''),\r\n			''title'' => ($this->language->get(''code'') == ''fa'') ? jdate($this->language->get(''date_format_short'')) : date($this->language->get(''date_format_short''))\r\n		);\r\n		$data[''shamsidate_formats''][] = array(\r\n			''code'' 	=> $this->language->get(''date_format_long''),\r\n			''title'' => ($this->language->get(''code'') == ''fa'') ? jdate($this->language->get(''date_format_long'')) : date($this->language->get(''date_format_long''))\r\n		);\r\n		$data[''shamsidate_formats''][] = array(\r\n			''code'' 	=> $this->language->get(''datetime_format''),\r\n			''title'' => ($this->language->get(''code'') == ''fa'') ? jdate($this->language->get(''datetime_format'')) : date($this->language->get(''datetime_format''))\r\n		);\r\n		$data[''shamsidate_formats''][] = array(\r\n			''code'' 	=> $this->language->get(''datetime_format_long''),\r\n			''title'' => ($this->language->get(''code'') == ''fa'') ? jdate($this->language->get(''datetime_format_long'')) : date($this->language->get(''datetime_format_long''))\r\n		);\r\n		\r\n		if (isset($this->request->post[''config_shamsidate_format''])) {\r\n			$data[''config_shamsidate_format''] = $this->request->post[''config_shamsidate_format''];\r\n		} else {\r\n			$data[''config_shamsidate_format''] = $this->config->get(''config_shamsidate_format'');\r\n		}\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/controller/setting/store.php">\r\n		<operation>\r\n			<search><![CDATA[$data[''entry_currency''] = $this->language->get(''entry_currency'');]]></search>\r\n			<add position="after"><![CDATA[		$data[''entry_shamsidate_format''] = $this->language->get(''entry_shamsidate_format'');]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[$data[''help_currency''] = $this->language->get(''help_currency'');]]></search>\r\n			<add position="after"><![CDATA[		$data[''help_shamsidate_format''] = $this->language->get(''help_shamsidate_format'');]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[if (isset($this->request->post[''config_currency''])) {]]></search>\r\n			<add position="before"><![CDATA[\r\n		$data[''shamsidate_formats''] = array();\r\n		$data[''shamsidate_formats''][] = array(\r\n			''code'' 	=> $this->language->get(''date_format_short''),\r\n			''title'' => ($this->language->get(''code'') == ''fa'') ? jdate($this->language->get(''date_format_short'')) : date($this->language->get(''date_format_short''))\r\n		);\r\n		$data[''shamsidate_formats''][] = array(\r\n			''code'' 	=> $this->language->get(''date_format_long''),\r\n			''title'' => ($this->language->get(''code'') == ''fa'') ? jdate($this->language->get(''date_format_long'')) : date($this->language->get(''date_format_long''))\r\n		);\r\n		$data[''shamsidate_formats''][] = array(\r\n			''code'' 	=> $this->language->get(''datetime_format''),\r\n			''title'' => ($this->language->get(''code'') == ''fa'') ? jdate($this->language->get(''datetime_format'')) : date($this->language->get(''datetime_format''))\r\n		);\r\n		$data[''shamsidate_formats''][] = array(\r\n			''code'' 	=> $this->language->get(''datetime_format_long''),\r\n			''title'' => ($this->language->get(''code'') == ''fa'') ? jdate($this->language->get(''datetime_format_long'')) : date($this->language->get(''datetime_format_long''))\r\n		);\r\n		\r\n		if (isset($this->request->post[''config_shamsidate_format''])) {\r\n			$data[''config_shamsidate_format''] = $this->request->post[''config_shamsidate_format''];\r\n		} else {\r\n			$data[''config_shamsidate_format''] = $this->config->get(''config_shamsidate_format'');\r\n		}\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!--admin/controller/tool-->\r\n	<file path="admin/controller/tool/upload.php">\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_added''])),]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_added''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_added''])),]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!--admin/controller/user/api.php\r\n		admin/controller/user/user.php\r\n	-->\r\n	<file path="admin/controller/user/{api,user}.php">\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_added''])),]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_added''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_added''])),]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!-- admin/language -->\r\n	<file path="admin/language/en-gb/en-gb.php">\r\n		<operation>\r\n			<search><![CDATA[$_[''datetime_format'']]]></search>\r\n			<add position="before"><![CDATA[\r\n$_[''datetime_format_long''] 			= ''d/m/Y - H:i:s'';\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/language/en-gb/setting/setting.php">\r\n		<operation>\r\n			<search><![CDATA[$_[''entry_currency_auto'']]]></search>\r\n			<add position="before"><![CDATA[\r\n$_[''entry_shamsidate_status'']          = ''Shamsi Date Status'';\r\n$_[''entry_shamsidate_format'']          = ''Shamsi Date Format'';\r\n			]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[$_[''help_currency_auto'']]]></search>\r\n			<add position="before"><![CDATA[\r\n$_[''help_shamsidate_status'']           = ''By Activate This Option You Can View Date In Format Shamsi Date.'';\r\n$_[''help_shamsidate_format'']           = ''Shamsi Date Format For Persian Language.'';\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/language/en-gb/setting/store.php">\r\n		<operation>\r\n			<search><![CDATA[$_[''entry_currency'']]]></search>\r\n			<add position="before"><![CDATA[\r\n$_[''entry_shamsidate_status'']          = ''Shamsi Date Status'';\r\n$_[''entry_shamsidate_format'']          = ''Shamsi Date Format'';\r\n			]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[$_[''help_currency'']]]></search>\r\n			<add position="before"><![CDATA[\r\n$_[''help_shamsidate_status'']           = ''By Activate This Option You Can View Date In Format Shamsi Date.'';\r\n$_[''help_shamsidate_format'']           = ''Shamsi Date Format For Persian Language.'';\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/language/fa-ir/common/footer.php">\r\n		<operation error="skip">\r\n			<search><![CDATA[$_[''text_version'']]]></search>\r\n			<add position="before"><![CDATA[$_[''text_footer''] 	= ''&#1578;&#1605;&#1575;&#1605;&#1740; &#1581;&#1602;&#1608;&#1602; &#1576;&#1585;&#1575;&#1740; <a target="_blank" href="http://www.opencartfarsi.com" title="OpenCartFarsi.Com">&#1575;&#1662;&#1606; &#1705;&#1575;&#1585;&#1578; &#1601;&#1575;&#1585;&#1587;&#1740; &#1583;&#1575;&#1578; &#1705;&#1575;&#1605;</a> &#1605;&#1581;&#1601;&#1608;&#1592; &#1575;&#1587;&#1578;. &copy; 1389-'' . jdate(''Y'') . '' '';]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!-- admin/model/catalog -->\r\n	<file path="admin/model/catalog/product.php">\r\n		<operation>\r\n			<search><![CDATA[$this->db->escape($data[''date_available''])]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'' ? $this->db->escape(jtg($data[''date_available''])) : $this->db->escape($data[''date_available'']))]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[$this->db->escape($product_discount[''date_start''])]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'' ? $this->db->escape(jtg($product_discount[''date_start''])) : $this->db->escape($product_discount[''date_start'']))]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[date_end = ''" . $this->db->escape($product_discount[''date_end'']) . "'']]></search>\r\n			<add position="replace"><![CDATA[date_end = ''" . ($this->language->get(''code'') == ''fa'' ? $this->db->escape(jtg($product_discount[''date_end''])) : $this->db->escape($product_discount[''date_end''])) . "'']]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[date_start = ''" . $this->db->escape($product_special[''date_start'']) . "'']]></search>\r\n			<add position="replace"><![CDATA[date_start = ''" . ($this->language->get(''code'') == ''fa'' ? $this->db->escape(jtg($product_special[''date_start''])) : $this->db->escape($product_special[''date_start''])) . "'']]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[date_end = ''" . $this->db->escape($product_special[''date_end'']) . "'']]></search>\r\n			<add position="replace"><![CDATA[date_end = ''" . ($this->language->get(''code'') == ''fa'' ? $this->db->escape(jtg($product_special[''date_end''])) : $this->db->escape($product_special[''date_end''])) . "'']]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!-- admin/model/marketing -->\r\n	<file path="admin/model/marketing/coupon.php">\r\n		<operation>\r\n			<search><![CDATA[date_start = ''" . $this->db->escape($data[''date_start'']) . "'', date_end = ''" . $this->db->escape($data[''date_end'']) . "'']]></search>\r\n			<add position="replace"><![CDATA[date_start = ''" . ($this->language->get(''code'') == ''fa'' ? $this->db->escape(jtg($data[''date_start''])) : $this->db->escape($data[''date_start''])) . "'', date_end = ''" . ($this->language->get(''code'') == ''fa'' ? $this->db->escape(jtg($data[''date_end''])) : $this->db->escape($data[''date_end''])) . "'']]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!-- admin/model/sale -->\r\n	<file path="admin/model/sale/return.php">\r\n		<operation>\r\n			<search><![CDATA[date_ordered = ''" . $this->db->escape($data[''date_ordered'']) . "'',]]></search>\r\n			<add position="replace"><![CDATA[date_ordered = ''" . ($this->language->get(''code'') == ''fa'' ? $this->db->escape(jtg($data[''date_ordered''])) : $this->db->escape($data[''date_ordered''])) . "'',]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!-- admin/model/report -->\r\n	<file path="admin/model/report/customer.php">\r\n		<operation info="getTotalCustomersByMonth">\r\n			<search><![CDATA[for ($i = 1; $i <= date(''t''); $i++) {]]></search>\r\n			<add position="before"><![CDATA[/* *********************************** */\r\n		if ($this->language->get(''code'') == ''fa'') {\r\n			for ($i = 1; $i <= jdate(''t''); $i++) {\r\n				$jdate = jdate(''Y'') . ''-'' . jdate(''m'') . ''-'' . $i;\r\n				$date = jtg($jdate);\r\n\r\n				$customer_data[jdate(''j'', strtotime($date))] = array(\r\n					''day''   => jdate(''d'', strtotime($date)),\r\n					''total'' => 0\r\n				);\r\n			}\r\n			\r\n			$jmdate = jdate(''Y'') . ''-'' . jdate(''m'') . ''-1'';\r\n			$gmdate = jtg($jmdate);\r\n			$query = $this->db->query("SELECT COUNT(*) AS total, date_added FROM `" . DB_PREFIX . "customer` WHERE DATE(date_added) >= ''" . $this->db->escape($gmdate) . "'' GROUP BY DATE(date_added)");\r\n\r\n			foreach ($query->rows as $result) {\r\n				$customer_data[jdate(''j'', strtotime($result[''date_added'']))] = array(\r\n					''day''   => jdate(''d'', strtotime($result[''date_added''])),\r\n					''total'' => $result[''total'']\r\n				);\r\n			}\r\n		} else {\r\n/* *********************************** */]]></add>\r\n		</operation>\r\n		<operation info="getTotalCustomersByMonth">\r\n			<search><![CDATA[$customer_data[date(''j'', strtotime($result[''date_added'']))] = array(]]></search>\r\n			<add position="after" offset="4"><![CDATA[\r\n		}//Add\r\n			]]></add>\r\n		</operation>\r\n		<operation info="getTotalCustomersByYear">\r\n			<search><![CDATA[for ($i = 1; $i <= 12; $i++) {]]></search>\r\n			<add position="before"><![CDATA[/* *********************************** */\r\n		if ($this->language->get(''code'') == ''fa'') {\r\n			for ($i = 1; $i <= 12; $i++) {\r\n				$jmonth = gregorian_to_jalali(date(''Y''), $i, date(''d'')); \r\n				$jmonth = $jmonth[1];\r\n				$jyear = jdate(''Y'');\r\n				\r\n				$customer_data[$jmonth] = array(\r\n					''month'' => jdate(''F'', jmktime(0, 0, 0, $jmonth)),//M or F\r\n					''total'' => 0\r\n				);\r\n\r\n				$jmdate = jdate(''Y'') . ''-'' . $jmonth . ''-1'';\r\n				$gmdate = jtg($jmdate);\r\n				$query = $this->db->query("SELECT YEAR(date_added) AS year, MONTH(date_added) AS month, DAY(date_added) AS day, date_added FROM `" . DB_PREFIX . "customer` WHERE DATE(date_added) >= ''" . $this->db->escape($gmdate) . "'' GROUP BY DATE(date_added)");\r\n				$total_rows = 0;\r\n				$date_add = '''';\r\n\r\n				if ($query->num_rows) {\r\n					foreach ($query->rows as $result) {\r\n						$customer_jdate = gregorian_to_jalali($result[''year''], $result[''month''], $result[''day'']);\r\n						\r\n						if ($customer_jdate[0] == $jyear && $customer_jdate[1] == $jmonth) {\r\n							if($total_rows == 0) {$date_add = $result[''date_added''];}\r\n							$total_rows = $total_rows + 1;\r\n						}\r\n					}\r\n					\r\n					$customer_data[jdate(''n'', strtotime($date_add))] = array(\r\n						''month'' => jdate(''F'', strtotime($date_add)),//M or F\r\n						''total'' => $total_rows\r\n					);\r\n				}\r\n			}\r\n		} else {\r\n/* *********************************** */]]></add>\r\n		</operation>\r\n		<operation info="getTotalCustomersByYear">\r\n			<search><![CDATA[$customer_data[date(''n'', strtotime($result[''date_added'']))] = array(]]></search>\r\n			<add position="after" offset="4"><![CDATA[\r\n		}//Add\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/model/report/sale.php">\r\n		<operation info="getTotalOrdersByMonth">\r\n			<search><![CDATA[for ($i = 1; $i <= date(''t''); $i++) {]]></search>\r\n			<add position="before"><![CDATA[/* *********************************** */\r\n		if ($this->language->get(''code'') == ''fa'') {\r\n			for ($i = 1; $i <= jdate(''t''); $i++) {\r\n				$jdate = jdate(''Y'') . ''-'' . jdate(''m'') . ''-'' . $i;\r\n				$date = jtg($jdate);\r\n\r\n				$order_data[jdate(''j'', strtotime($date))] = array(\r\n					''day''   => jdate(''d'', strtotime($date)),\r\n					''total'' => 0\r\n				);\r\n			}\r\n\r\n			$jmdate = jdate(''Y'') . ''-'' . jdate(''m'') . ''-1'';\r\n			$gmdate = jtg($jmdate);\r\n			$query = $this->db->query("SELECT COUNT(*) AS total, date_added FROM `" . DB_PREFIX . "order` WHERE order_status_id > ''0'' AND DATE(date_added) >= ''" . $this->db->escape($gmdate) . "'' GROUP BY DATE(date_added)");\r\n\r\n			foreach ($query->rows as $result) {\r\n				$order_data[jdate(''j'', strtotime($result[''date_added'']))] = array(\r\n					''day''   => jdate(''d'', strtotime($result[''date_added''])),\r\n					''total'' => $result[''total'']\r\n				);\r\n			}\r\n		} else {\r\n/* *********************************** */]]></add>\r\n		</operation>\r\n		<operation info="getTotalOrdersByMonth">\r\n			<search><![CDATA[$order_data[date(''j'', strtotime($result[''date_added'']))] = array(]]></search>\r\n			<add position="after" offset="4"><![CDATA[\r\n		}//Add\r\n			]]></add>\r\n		</operation>\r\n		<operation info="getTotalOrdersByYear">\r\n			<search><![CDATA[for ($i = 1; $i <= 12; $i++) {]]></search>\r\n			<add position="before"><![CDATA[/* *********************************** */\r\n		if ($this->language->get(''code'') == ''fa'') {\r\n			for ($i = 1; $i <= 12; $i++) {\r\n				$jmonth = gregorian_to_jalali(date(''Y''), $i, date(''d'')); \r\n				$jmonth = $jmonth[1];\r\n				$jyear = jdate(''Y'');\r\n				\r\n				$order_data[$jmonth] = array(\r\n					''month'' => jdate(''F'', jmktime(0, 0, 0, $jmonth)),//M or F\r\n					''total'' => 0\r\n				);\r\n\r\n				$jmdate = jdate(''Y'') . ''-'' . $jmonth . ''-1'';\r\n				$gmdate = jtg($jmdate);\r\n				$query = $this->db->query("SELECT YEAR(date_added) AS year, MONTH(date_added) AS month, DAY(date_added) AS day, date_added FROM `" . DB_PREFIX . "order` WHERE order_status_id > ''0'' AND DATE(date_added) >= ''" . $this->db->escape($gmdate) . "'' GROUP BY DATE(date_added)");\r\n				$total_rows = 0;\r\n				$date_add = '''';\r\n						\r\n				if ($query->num_rows) {\r\n					foreach ($query->rows as $result) {\r\n						$order_jdate = gregorian_to_jalali($result[''year''], $result[''month''], $result[''day'']);\r\n						\r\n						if ($order_jdate[0] == $jyear && $order_jdate[1] == $jmonth) {\r\n							if($total_rows == 0) {$date_add = $result[''date_added''];}\r\n							$total_rows = $total_rows + 1;\r\n						}\r\n					}\r\n					\r\n					$order_data[jdate(''n'', strtotime($date_add))] = array(\r\n						''month'' => jdate(''F'', strtotime($date_add)),//M or F\r\n						''total'' => $total_rows\r\n					);\r\n				}\r\n			}\r\n		} else {\r\n/* *********************************** */]]></add>\r\n		</operation>\r\n		<operation info="getTotalOrdersByYear">\r\n			<search><![CDATA[$order_data[date(''n'', strtotime($result[''date_added'']))] = array(]]></search>\r\n			<add position="after" offset="4"><![CDATA[\r\n		}//Add\r\n			]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[order_status_id IN(" . implode(",", $implode) . ")]]></search>\r\n			<add position="replace"><![CDATA[order_status_id > ''0'']]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!-- admin/view/template -->\r\n	<file path="admin/view/template/catalog/product_form.tpl">\r\n		<operation>\r\n			<search><![CDATA[<?php echo $date_available; ?>]]></search>\r\n			<add position="replace"><![CDATA[<?php echo !isset($this->request->post[''date_available'']) ? ($lang_code == ''fa'' ? gtj($date_available) : $date_available) : $date_available; ?>]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[<?php echo $product_discount[''date_start'']; ?>]]></search>\r\n			<add position="replace"><![CDATA[<?php echo !isset($this->request->post[''product_discount'']) ? ($lang_code == ''fa'' ? gtj($product_discount[''date_start'']) : $product_discount[''date_start'']) : $product_discount[''date_start'']; ?>]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[<?php echo $product_discount[''date_end'']; ?>]]></search>\r\n			<add position="replace"><![CDATA[<?php echo !isset($this->request->post[''product_discount'']) ? ($lang_code == ''fa'' ? gtj($product_discount[''date_end'']) : $product_discount[''date_end'']) : $product_discount[''date_end'']; ?>]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[<?php echo $product_special[''date_start'']; ?>]]></search>\r\n			<add position="replace"><![CDATA[<?php echo !isset($this->request->post[''product_special'']) ? ($lang_code == ''fa'' ? gtj($product_special[''date_start'']) : $product_special[''date_start'']) : $product_special[''date_start'']; ?>]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[<?php echo $product_special[''date_end'']; ?>]]></search>\r\n			<add position="replace"><![CDATA[<?php echo !isset($this->request->post[''product_special'']) ? ($lang_code == ''fa'' ? gtj($product_special[''date_end'']) : $product_special[''date_end'']) : $product_special[''date_end'']; ?>]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<file path="admin/view/template/marketing/coupon_form.tpl">\r\n		<operation>\r\n			<search><![CDATA[<?php echo $date_start; ?>]]></search>\r\n			<add position="replace"><![CDATA[<?php echo !isset($this->request->post[''date_start'']) ? ($lang_code == ''fa'' ? gtj($date_start) : $date_start) : $date_start; ?>]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[<?php echo $date_end; ?>]]></search>\r\n			<add position="replace"><![CDATA[<?php echo !isset($this->request->post[''date_end'']) ? ($lang_code == ''fa'' ? gtj($date_end) : $date_end) : $date_end; ?>]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<file path="admin/view/template/setting/setting.tpl">\r\n		<operation>\r\n			<search><![CDATA[<label class="col-sm-2 control-label" for="input-length-class"><?php echo $entry_length_class; ?></label>]]></search>\r\n			<add position="before" offset="1"><![CDATA[\r\n<!--*****************Start Shamsi Date********************-->\r\n              <div class="form-group">\r\n                <label class="col-sm-2 control-label" for="input-shamsidate-format"><span data-toggle="tooltip" title="<?php echo $help_shamsidate_format; ?>"><?php echo $entry_shamsidate_format; ?></span></label>\r\n                <div class="col-sm-10">\r\n                  <select name="config_shamsidate_format" id="input-shamsidate-format" class="form-control">\r\n                    <?php foreach ($shamsidate_formats as $format) { ?>\r\n                    <?php if ($format[''code''] == $config_shamsidate_format) { ?>\r\n                    <option value="<?php echo $format[''code'']; ?>" selected="selected"><?php echo $format[''title'']; ?></option>\r\n                    <?php } else { ?>\r\n                    <option value="<?php echo $format[''code'']; ?>"><?php echo $format[''title'']; ?></option>\r\n                    <?php } ?>\r\n                    <?php } ?>\r\n                  </select>\r\n                </div>\r\n              </div>\r\n<!--*****************Ends Shamsi Date********************-->\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/view/template/setting/store_form.tpl">\r\n		<operation>\r\n			<search><![CDATA[<div class="tab-pane" id="tab-option">]]></search>\r\n			<add position="before" offset="1"><![CDATA[\r\n<!--*****************Start Shamsi Date********************-->\r\n              <div class="form-group">\r\n                <label class="col-sm-2 control-label" for="input-shamsidate-format"><span data-toggle="tooltip" title="<?php echo $help_shamsidate_format; ?>"><?php echo $entry_shamsidate_format; ?></span></label>\r\n                <div class="col-sm-10">\r\n                  <select name="config_shamsidate_format" id="input-shamsidate-format" class="form-control">\r\n                    <?php foreach ($shamsidate_formats as $format) { ?>\r\n                    <?php if ($format[''code''] == $config_shamsidate_format) { ?>\r\n                    <option value="<?php echo $format[''code'']; ?>" selected="selected"><?php echo $format[''title'']; ?></option>\r\n                    <?php } else { ?>\r\n                    <option value="<?php echo $format[''code'']; ?>"><?php echo $format[''title'']; ?></option>\r\n                    <?php } ?>\r\n                    <?php } ?>\r\n                  </select>\r\n                </div>\r\n              </div>\r\n<!--*****************Ends Shamsi Date********************-->\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!--catalog/controller/account/download.php\r\n		catalog/controller/account/order.php\r\n		catalog/controller/account/recurring.php\r\n		catalog/controller/account/return.php\r\n		catalog/controller/account/reward.php\r\n		catalog/controller/account/transaction.php\r\n	-->\r\n	<file path="catalog/controller/account/{download,order,recurring,return,reward,transaction}.php">\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_added'']))]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_added''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_added'']))]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="catalog/controller/account/order.php">\r\n		<operation>\r\n			<search><![CDATA[$data[''date_added''] = date($this->language->get(''date_format_short''), strtotime($order_info[''date_added'']));]]></search>\r\n			<add position="replace"><![CDATA[$data[''date_added''] = ($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($order_info[''date_added''])) : date($this->language->get(''date_format_short''), strtotime($order_info[''date_added'']));]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="catalog/controller/account/recurring.php">\r\n		<operation>\r\n			<search><![CDATA[$data[''date_added''] = date($this->language->get(''date_format_short''), strtotime($recurring_info[''date_added'']));]]></search>\r\n			<add position="replace"><![CDATA[$data[''date_added''] = ($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($recurring_info[''date_added''])) : date($this->language->get(''date_format_short''), strtotime($recurring_info[''date_added'']));]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="catalog/controller/account/return.php">\r\n		<operation>\r\n			<search><![CDATA[$data[''date_ordered''] = date($this->language->get(''date_format_short''), strtotime($return_info[''date_ordered'']));]]></search>\r\n			<add position="replace"><![CDATA[$data[''date_ordered''] = ($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($return_info[''date_ordered''])) : date($this->language->get(''date_format_short''), strtotime($return_info[''date_ordered'']));]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[$data[''date_added''] = date($this->language->get(''date_format_short''), strtotime($return_info[''date_added'']));]]></search>\r\n			<add position="replace"><![CDATA[$data[''date_added''] = ($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($return_info[''date_added''])) : date($this->language->get(''date_format_short''), strtotime($return_info[''date_added'']));]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!-- catalog/controller/affiliate -->\r\n	<file path="catalog/controller/affiliate/transaction.php">\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_added'']))]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_added''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_added'']))]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!-- catalog/controller/common -->\r\n	<file path="catalog/controller/common/footer.php">\r\n		<operation error="skip">\r\n			<search><![CDATA[date(''Y'', time())]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'' ? jdate(''Y'', time()) : date(''Y'', time()))]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!-- catalog/controller/product -->\r\n	<file path="catalog/controller/product/product.php">\r\n		<operation>\r\n			<search><![CDATA[date($this->language->get(''date_format_short''), strtotime($result[''date_added'']))]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'') ? jdate($this->config->get(''config_shamsidate_format''), strtotime($result[''date_added''])) : date($this->language->get(''date_format_short''), strtotime($result[''date_added'']))]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!-- catalog/model/account -->\r\n	<file path="catalog/model/account/return.php">\r\n		<operation>\r\n			<search><![CDATA[$this->db->escape($data[''date_ordered''])]]></search>\r\n			<add position="replace"><![CDATA[($this->language->get(''code'') == ''fa'' ? $this->db->escape(jtg($data[''date_ordered''])) : $this->db->escape($data[''date_ordered'']))]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!-- catalog/model/checkout -->\r\n	<file path="catalog/model/checkout/order.php">\r\n		<operation>\r\n			<search><![CDATA[date($language->get(''date_format_short''), strtotime($order_info[''date_added'']))]]></search>\r\n			<add position="replace"><![CDATA[$language->get(''code'') == ''fa'' ? jdate($this->config->get(''config_shamsidate_format''), strtotime($order_info[''date_added''])) : date($language->get(''date_format_short''), strtotime($order_info[''date_added'']))]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<!-- catalog/language -->\r\n	<file path="catalog/language/en-gb/en-gb.php">\r\n		<operation>\r\n			<search><![CDATA[$_[''datetime_format'']]]></search>\r\n			<add position="before"><![CDATA[\r\n$_[''datetime_format_long''] = ''d/m/Y H:i:s'';\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<file path="system/engine/loader.php">\r\n		<operation>\r\n			<search><![CDATA[$result = $this->registry->get(''event'')->trigger(''view/'' . $route . ''/after'', array(&$route, &$data, &$output));]]></search>\r\n			<add position="after" offset="4"><![CDATA[\r\n		$direction = is_object($this->registry->get(''language'')) ? strtolower($this->registry->get(''language'')->get(''direction'')) : ''rtl'';\r\n		$replaces = array();\r\n		if ($direction == ''rtl'') {\r\n			$replaces[''catalog/view/javascript/common.js''] = ''catalog/view/javascript/common-rtl.js'';\r\n			$replaces[''catalog/view/javascript/jquery/magnific/magnific-popup.css''] = ''catalog/view/javascript/jquery/magnific/magnific-popup-rtl.css'';\r\n			$replaces[''catalog/view/javascript/jquery/magnific/jquery.magnific-popup.min.js''] = ''catalog/view/javascript/jquery/magnific/jquery.magnific-popup.farsi.min.js'';\r\n			$replaces[''view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.css''] = ''view/javascript/jquery/datetimepicker/bootstrap-persiandatetimepicker.css'';\r\n			$replaces[''view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.js''] = ''view/javascript/jquery/datetimepicker/bootstrap-persiandatetimepicker.min.js'';\r\n			$replaces[''view/javascript/jquery/datetimepicker/moment.js''] = ''view/javascript/jquery/datetimepicker/calendar.js'';\r\n			$replaces[''view/javascript/summernote/summernote.js''] = ''view/javascript/summernote/summernote.farsi.js'';\r\n			$replaces[''view/javascript/summernote/summernote.css''] = ''view/javascript/summernote/summernote-rtl.css'';\r\n			$replaces[''view/javascript/summernote/opencart.js''] = ''view/javascript/summernote/opencartfarsi.js'';\r\n		}\r\n		$output = str_replace(array_keys($replaces), $replaces, $output);\r\n		]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n</modification>', 1, '2016-08-29 13:09:16');
INSERT INTO `oc_modification` (`modification_id`, `name`, `code`, `author`, `version`, `link`, `xml`, `status`, `date_added`) VALUES
(2, 'Patch For OpenCart V2.3.0.2', 'patch', 'Mojtaba Moghani - wWw.Open-Cart.ir', '1.1', 'http://www.opencartfarsi.com', '<?xml version="1.0" encoding="UTF-8"?>\r\n<modification>\r\n	<name>Patch For OpenCart V2.3.0.2</name>\r\n	<code>patch</code>\r\n	<version>1.1</version>\r\n	<author>Mojtaba Moghani - wWw.Open-Cart.ir</author>\r\n	<link>http://www.opencartfarsi.com</link>\r\n	\r\n	<file path="catalog/controller/common/column_left.php">\r\n		<operation>\r\n			<search><![CDATA[$modules = $this->model_design_layout->getLayoutModules($layout_id, ''column_left'');]]></search>\r\n			<add position="replace"><![CDATA[/* ********************************** */\r\n		if ($this->language->get(''direction'') == ''rtl'') {\r\n			$modules = $this->model_design_layout->getLayoutModules($layout_id, ''column_right'');\r\n		} else {\r\n			$modules = $this->model_design_layout->getLayoutModules($layout_id, ''column_left'');\r\n		}\r\n/* ********************************** */]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[return $this->load->view(''common/column_left'', $data);]]></search>\r\n			<add position="replace"><![CDATA[/* ********************************** */\r\n		if ($this->language->get(''direction'') == ''rtl'') {\r\n			return $this->load->view(''common/column_right'', $data);\r\n		} else {\r\n			return $this->load->view(''common/column_left'', $data);\r\n		}\r\n/* ********************************** */]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="catalog/controller/common/column_right.php">\r\n		<operation>\r\n			<search><![CDATA[$modules = $this->model_design_layout->getLayoutModules($layout_id, ''column_right'');]]></search>\r\n			<add position="replace"><![CDATA[/* ********************************** */\r\n		if ($this->language->get(''direction'') == ''rtl'') {\r\n			$modules = $this->model_design_layout->getLayoutModules($layout_id, ''column_left'');\r\n		} else {\r\n			$modules = $this->model_design_layout->getLayoutModules($layout_id, ''column_right'');\r\n		}\r\n/* ********************************** */]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[return $this->load->view(''common/column_right'', $data);]]></search>\r\n			<add position="replace"><![CDATA[/* ********************************** */\r\n		if ($this->language->get(''direction'') == ''rtl'') {\r\n			return $this->load->view(''common/column_left'', $data);\r\n		} else {\r\n			return $this->load->view(''common/column_right'', $data);\r\n		}\r\n/* ********************************** */]]></add>\r\n		</operation>\r\n	</file>\r\n</modification>', 1, '2016-08-29 11:39:08'),
(3, 'راست چین سازی ایمیل های اپن کارت فارسی 2.3.0.2', 'RTL_Email', 'Mojtaba Moghani - wWw.Open-Cart.ir', '1.4', 'http://www.opencartfarsi.com', '<?xml version="1.0" encoding="UTF-8"?>\r\n<modification>\r\n	<name>راست چین سازی ایمیل های اپن کارت فارسی 2.3.0.2</name>\r\n	<code>RTL_Email</code>\r\n	<version>1.4</version>\r\n	<author>Mojtaba Moghani - wWw.Open-Cart.ir</author>\r\n	<link>http://www.opencartfarsi.com</link>\r\n	<file path="catalog/controller/extension/total/voucher.php">\r\n		<operation>\r\n			<search><![CDATA[$mail->setHtml($this->load->view(''mail/voucher'', $data));]]></search>\r\n			<add position="replace"><![CDATA[\r\n				if ($order_info[''language_code''] == ''fa-ir'') {\r\n					$mail->setHtml($this->load->view(''mail/voucher_farsi'', $data));\r\n				} else {\r\n					$mail->setHtml($this->load->view(''mail/voucher'', $data));\r\n				}\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="catalog/model/checkout/order.php">\r\n		<operation>\r\n			<search><![CDATA[$mail->setHtml($this->load->view(''mail/order'', $data));]]></search>\r\n			<add position="replace"><![CDATA[\r\n				if ($order_info[''language_code''] == ''fa-ir'') {\r\n					$mail->setHtml($this->load->view(''mail/order_farsi'', $data));\r\n				} else {\r\n					$mail->setHtml($this->load->view(''mail/order'', $data));\r\n				}\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/model/sale/voucher.php">\r\n		<operation>\r\n			<search><![CDATA[$mail->setHtml($this->load->view(''mail/voucher'', $data));]]></search>\r\n			<add position="replace"><![CDATA[\r\n				if ($order_info[''language_code''] == ''fa-ir'') {\r\n					$mail->setHtml($this->load->view(''mail/voucher_farsi'', $data));\r\n				} else {\r\n					$mail->setHtml($this->load->view(''mail/voucher'', $data));\r\n				}\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n</modification>', 1, '2016-08-31 15:42:23'),
(4, 'کد امنیتی برای صفحه ورود به مدیریت 2.3.0.2', 'Admin_Captcha', 'Mojtaba Moghani - wWw.Open-Cart.ir', '2.5', 'http://www.opencartfarsi.com', '<?xml version="1.0" encoding="UTF-8"?>\r\n<modification>\r\n	<name>کد امنیتی برای صفحه ورود به مدیریت 2.3.0.2</name>\r\n	<code>Admin_Captcha</code>\r\n	<version>2.5</version>\r\n	<author>Mojtaba Moghani - wWw.Open-Cart.ir</author>\r\n	<link>http://www.opencartfarsi.com</link>\r\n	<file path="admin/controller/setting/setting.php">\r\n		<operation>\r\n			<search><![CDATA[if (isset($this->request->post[''config_logo''])) {]]></search>\r\n			<add position="before"><![CDATA[\r\n		$data[''captcha_pages''][] = array(\r\n			''text''  => $this->language->get(''text_admin''),\r\n			''value'' => ''admin''\r\n		);\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/language/en-gb/setting/setting.php">\r\n		<operation>\r\n			<search><![CDATA[$_[''text_contact'']]]></search>\r\n			<add position="after"><![CDATA[$_[''text_admin'']        = ''Admin Login'';]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/language/fa-ir/setting/setting.php">\r\n		<operation>\r\n			<search><![CDATA[$_[''text_contact'']]]></search>\r\n			<add position="after"><![CDATA[$_[''text_admin'']     = ''ورود به مدیریت'';]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<file path="admin/controller/common/login.php">\r\n		<operation>\r\n			<search><![CDATA[if ($this->config->get(''config_password'')) {]]></search>\r\n			<add position="before"><![CDATA[\r\n		// Admin Captcha\r\n		if ($this->config->get($this->config->get(''config_captcha'') . ''_status'') && in_array(''admin'', (array)$this->config->get(''config_captcha_page''))) {\r\n			$data[''captcha''] = $this->load->controller(''common/'' . $this->config->get(''config_captcha''), $this->error);\r\n		} else {\r\n			$data[''captcha''] = '''';\r\n		}\r\n			]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[protected function validate() {]]></search>\r\n			<add position="after"><![CDATA[\r\n		// Admin Captcha\r\n		if ($this->config->get($this->config->get(''config_captcha'') . ''_status'') && in_array(''admin'', (array)$this->config->get(''config_captcha_page''))) {\r\n			$captcha = $this->load->controller(''common/'' . $this->config->get(''config_captcha'') . ''/validate'');\r\n\r\n			if ($captcha) {\r\n				$this->error[''captcha''] = $captcha;\r\n			}\r\n		}\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/view/template/common/login.tpl">\r\n		<operation>\r\n			<search><![CDATA[<label for="input-password"><?php echo $entry_password; ?></label>]]></search>\r\n			<add position="before" offset="1"><![CDATA[<?php echo $captcha; ?>]]></add>\r\n		</operation>\r\n	</file>\r\n</modification>', 1, '2016-08-29 11:39:31'),
(5, 'Seo All Links 2.3.0.2', 'seo_all_links', 'Mojtaba Moghani', '1.2', 'http://www.opencartfarsi.com', '<?xml version="1.0" encoding="UTF-8"?>\r\n<modification>\r\n	<name>Seo All Links 2.3.0.2</name>\r\n	<code>seo_all_links</code>\r\n	<version>1.2</version>\r\n	<author>Mojtaba Moghani</author>\r\n    <link>http://www.opencartfarsi.com</link>\r\n	<file path="catalog/controller/startup/seo_url.php">\r\n		<operation>\r\n			<search><![CDATA[class ControllerStartupSeoUrl extends Controller {]]></search>\r\n			<add position="after"><![CDATA[\r\n					private $url_list = array (\r\n						''common/home'' => '''',\r\n						''account/wishlist'' => ''wishlist'',\r\n						''account/account'' => ''my-account'',\r\n						''account/edit'' => ''edit-account'',\r\n						''account/password'' => ''change-password'',\r\n						''account/address'' => ''address-book'',\r\n						''account/address/edit'' => ''address-book-edit'',\r\n						''account/reward'' => ''reward-points'',\r\n						''account/login'' => ''login'',\r\n						''account/logout'' => ''logout'',\r\n						''account/order'' => ''order-history'',\r\n						''account/order/info'' => ''order-history-details'',\r\n						''account/newsletter'' => ''newsletter'',\r\n						''account/forgotten'' => ''forgot-password'',\r\n						''account/download'' => ''downloads'',\r\n						''account/return'' => ''my-returns'',\r\n						''account/return/add'' => ''return-add'',\r\n						''account/transaction'' => ''transactions'',\r\n						''account/register'' => ''register'',\r\n						''account/recurring'' => ''recurring'',\r\n						''account/voucher'' => ''gift-vouchers'',\r\n						''account/voucher/success'' => ''voucher-success'',\r\n						''affiliate/account'' => ''affiliates'',\r\n						''affiliate/edit'' => ''edit-affiliate-account'',\r\n						''affiliate/password'' => ''change-affiliate-password'',\r\n						''affiliate/payment'' => ''affiliate-payment'',\r\n						''affiliate/tracking'' => ''affiliate-tracking-code'',\r\n						''affiliate/transaction'' => ''affiliate-transactions'',\r\n						''affiliate/logout'' => ''affiliate-logout'',\r\n						''affiliate/forgotten'' => ''affiliate-forgot-password'',\r\n						''affiliate/register'' => ''register-affiliate'',\r\n						''affiliate/login'' => ''affiliate-login'',\r\n						''checkout/cart'' => ''cart'',\r\n						''checkout/checkout'' => ''checkout'',\r\n						''checkout/success'' => ''checkout-success'',\r\n						''information/contact'' => ''contact'',\r\n						''information/sitemap'' => ''sitemap'',\r\n						''product/special'' => ''specials'',\r\n						''product/manufacturer'' => ''brands'',\r\n						''product/compare'' => ''compare-products'',\r\n						''product/search'' => ''search''\r\n					);\r\n			]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[$this->request->get[''route''] = ''error/not_found'';]]></search>\r\n			<add position="after" offset="4"><![CDATA[\r\n					if ( $_s = $this->setURL($this->request->get[''_route_'']) ) {\r\n						$this->request->get[''route''] = $_s;\r\n					}\r\n			]]></add>\r\n		</operation> \r\n		<operation>\r\n			<search><![CDATA[if ($url) {]]></search>\r\n			<add position="before" offset="3"><![CDATA[\r\n					if( $_u = $this->getURL($data[''route'']) ){\r\n                        $url .= $_u;\r\n                        unset($data[$key]);\r\n                    }\r\n			]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[return $link;]]></search>\r\n			<add position="after" offset="2"><![CDATA[\r\n	public function getURL($route) {\r\n			if( count($this->url_list) > 0) {\r\n				 foreach ($this->url_list as $key => $value) {\r\n					if($route == $key) {\r\n						return ''/''.$value;\r\n					}\r\n				 }\r\n			}\r\n			return false;\r\n	}\r\n	public function setURL($_route) {\r\n			if( count($this->url_list) > 0 ){\r\n				 foreach ($this->url_list as $key => $value) {\r\n					if($_route == $value) {\r\n						return $key;\r\n					}\r\n				 }\r\n			}\r\n			return false;\r\n	}\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n</modification>', 1, '2016-08-29 11:39:40'),
(6, 'Product Auto Assign To Parent Categories', 'product_auto_assign_to_parent_categories', 'Mojtaba Moghani', '2.3', 'http://www.opencartfarsi.com', '<?xml version="1.0" encoding="UTF-8"?>\r\n<modification>\r\n	<name>Product Auto Assign To Parent Categories</name>\r\n	<code>product_auto_assign_to_parent_categories</code>\r\n	<version>2.3</version>\r\n	<author>Mojtaba Moghani</author>\r\n	<link>http://www.opencartfarsi.com</link>\r\n\r\n	<file path="admin/controller/catalog/product.php">\r\n		<operation>\r\n			<search><![CDATA[$data[''entry_category''] = $this->language->get(''entry_category'');]]></search>\r\n			<add position="after"><![CDATA[		$data[''entry_autoassign''] = $this->language->get(''entry_autoassign'');]]></add>\r\n		</operation>\r\n		<operation>\r\n			<search><![CDATA[$this->response->setOutput($this->load->view(''catalog/product_form'', $data));]]></search>\r\n			<add position="before"><![CDATA[		if (isset($this->request->post[''autoassign''])) {\r\n			$data[''autoassign''] = $this->request->post[''autoassign''];\r\n		} else {\r\n			$data[''autoassign''] = '''';\r\n		}\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/language/en-gb/catalog/product.php">\r\n		<operation>\r\n			<search><![CDATA[$_[''entry_category'']]]></search>\r\n			<add position="after"><![CDATA[$_[''entry_autoassign'']        = ''Assign to all parents of selected categories'';]]></add>\r\n		</operation>\r\n	</file>\r\n	<file path="admin/language/fa-ir/catalog/product.php">\r\n		<operation>\r\n			<search><![CDATA[$_[''entry_category'']]]></search>\r\n			<add position="after"><![CDATA[$_[''entry_autoassign'']        = ''تخصیص به همه والدهای دسته بندی های انتخاب شده'';]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<file path="admin/model/catalog/product.php">\r\n		<operation>\r\n			<search><![CDATA[if (isset($data[''product_category''])) {]]></search>\r\n			<add position="replace" offset="4"><![CDATA[	if (empty($data[''autoassign''])) {\r\n		if (isset($data[''product_category''])) {\r\n			foreach ($data[''product_category''] as $category_id) {\r\n				$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_category SET product_id = ''" . (int)$product_id . "'', category_id = ''" . (int)$category_id . "''");\r\n			}		\r\n		}\r\n    } else {\r\n		if (isset($data[''product_category''])) {\r\n			$all_cats = array();\r\n			foreach ($data[''product_category''] as $category_id) {\r\n				$parent_cats = explode(".", $this->getCategoryParentsIds($category_id));\r\n				$all_cats = array_merge($all_cats, $parent_cats);\r\n			}\r\n			$all_cats = array_unique($all_cats);\r\n			foreach($all_cats as $category_id) {\r\n				$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_category SET product_id = ''" . (int)$product_id . "'', category_id = ''" . (int)$category_id . "''");\r\n			}\r\n		}\r\n    }		]]></add>\r\n		</operation>\r\n    \r\n		<operation>\r\n			<search><![CDATA[public function addProduct($data) {]]></search>\r\n			<add position="before"><![CDATA[  public function getCategoryParentsIds($category_id) {\r\n		$query = $this->db->query("SELECT c.category_id, c.parent_id FROM " . DB_PREFIX . "category c WHERE c.category_id = ''" . (int)$category_id . "'' ORDER BY c.sort_order");\r\n		\r\n		$category_info = $query->row;\r\n		\r\n		if ($category_info[''parent_id'']) {\r\n			return $this->getCategoryParentsIds($category_info[''parent_id'']) . "." . $category_info[''category_id''];\r\n		} else {\r\n			return $category_info[''category_id''];\r\n		}\r\n	}\r\n	]]></add>\r\n		</operation>\r\n	</file>\r\n\r\n	<file path="admin/view/template/catalog/product_form.tpl">\r\n		<operation>\r\n			<search><![CDATA[<input type="text" name="category" value="" placeholder="<?php echo $entry_category; ?>" id="input-category" class="form-control" />]]></search>\r\n			<add position="before"><![CDATA[<p><label><input type="checkbox" name="autoassign" value="1"<?php if ($autoassign) { ?> checked="checked"<?php } ?> /> <?php echo $entry_autoassign; ?></label></p>]]></add>\r\n		</operation>\r\n	</file>\r\n</modification>', 1, '2016-08-29 11:39:48'),
(7, 'TO TOP', 'totop', 'Dotbox Creative', '1.1', 'http://www.dotboxcreative.com', '<modification>\r\n	<name>TO TOP</name>\r\n	<code>totop</code>\r\n	<version>1.1</version>\r\n	<author>Dotbox Creative</author>\r\n	<link>http://www.dotboxcreative.com</link>\r\n	<file path="catalog/view/theme/*/template/common/footer.tpl">\r\n		<operation>\r\n			<search><![CDATA[</body></html>]]></search>\r\n			<add position="before"><![CDATA[\r\n<style type="text/css">\r\n	#ToTopHover {background: url(''image/totop.png'') no-repeat left -51px;cursor: pointer;width: 51px;height: 51px;display: block;overflow: hidden;float: left;opacity: 0;-moz-opacity: 0;filter: alpha(opacity=0);}\r\n	#ToTop {display: none;text-decoration: none;position: fixed;bottom: 20px;right: 20px;overflow: hidden;width: 51px;height: 51px;border: none;text-indent: -999px;background: url(''image/totop.png'') no-repeat left top;}\r\n</style>\r\n<script type="text/javascript">\r\n	jQuery(document).ready(function(){$().UItoTop({easingType:''easeOutQuint''});});\r\n	(function($){\r\n		$.fn.UItoTop = function(options) {\r\n			var defaults = {\r\n				text: ''To Top'',\r\n				min: 200,\r\n				inDelay:600,\r\n				outDelay:400,\r\n				containerID: ''ToTop'',\r\n				containerHoverID: ''ToTopHover'',\r\n				scrollSpeed: 1200,\r\n				easingType: ''linear''\r\n			};\r\n			var settings = $.extend(defaults, options);\r\n			var containerIDhash = ''#'' + settings.containerID;\r\n			var containerHoverIDHash = ''#''+settings.containerHoverID;\r\n			$(''body'').append(''<a id="''+settings.containerID+''">''+settings.text+''</a>'');\r\n			$(containerIDhash).hide().click(function(){\r\n				$(''html, body'').animate({scrollTop: 0}, settings.scrollSpeed);\r\n				event.preventDefault();\r\n			})\r\n			.prepend(''<span id="''+settings.containerHoverID+''"></span>'')\r\n			.hover(function() {\r\n					$(containerHoverIDHash, this).stop().animate({\r\n						''opacity'': 1\r\n					}, 600, ''linear'');\r\n				}, function() { \r\n					$(containerHoverIDHash, this).stop().animate({\r\n						''opacity'': 0\r\n					}, 700, ''linear'');\r\n				});			\r\n			$(window).scroll(function() {\r\n				var sd = $(window).scrollTop();\r\n				if(typeof document.body.style.maxHeight === "undefined") {\r\n					$(containerIDhash).css({\r\n						''position'': ''absolute'',\r\n						''top'': $(window).scrollTop() + $(window).height() - 50\r\n					});\r\n				}\r\n				if ( sd > settings.min ) \r\n					$(containerIDhash).fadeIn(settings.inDelay);\r\n				else \r\n					$(containerIDhash).fadeOut(settings.Outdelay);\r\n			});\r\n	};\r\n	})(jQuery);\r\n</script>\r\n			]]></add>\r\n		</operation>\r\n	</file>\r\n</modification>', 1, '2016-08-29 11:40:06');

-- ----------------------------------------------------------
