<?php
require_once(DIR_SYSTEM . 'library/nuSoap/nusoap.php');
class ControllerExtensionPaymentOCFMellat extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/payment/ocf_mellat');
		$this->install();

		$this->document->setTitle($this->language->get('doc_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('ocf_mellat', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=payment', true));
		}

		$data['heading_title'] = $this->language->get('heading_title');
		
		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_wait'] = $this->language->get('text_wait');
		$data['text_loading'] = $this->language->get('text_loading');

		$data['entry_terminal_id'] = $this->language->get('entry_terminal_id');
		$data['entry_username'] = $this->language->get('entry_username');
		$data['entry_password'] = $this->language->get('entry_password');
		$data['entry_sale_amount'] = $this->language->get('entry_sale_amount');
		$data['entry_sale_order_id'] = $this->language->get('entry_sale_order_id');
		$data['entry_sale_reference_id'] = $this->language->get('entry_sale_reference_id');
		$data['entry_order_status'] = $this->language->get('entry_order_status');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$data['fields_configuration_1'] = $this->language->get('fields_configuration_1');
		$data['fields_configuration_2'] = $this->language->get('fields_configuration_2');
		$data['fields_configuration_3'] = $this->language->get('fields_configuration_3');
		$data['fields_configuration_4'] = $this->language->get('fields_configuration_4');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');
		$data['button_settle'] = $this->language->get('button_settle');
		$data['button_refund'] = $this->language->get('button_refund');

		$data['tab_general'] = $this->language->get('tab_general');
		$data['tab_settle'] = $this->language->get('tab_settle');
		$data['tab_refund'] = $this->language->get('tab_refund');
		$data['tab_info'] = $this->language->get('tab_info');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=payment', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/payment/ocf_mellat', 'token=' . $this->session->data['token'], true)
		);

		$data['action'] = $this->url->link('extension/payment/ocf_mellat', 'token=' . $this->session->data['token'], true);

		$data['cancel'] = $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=payment', true);

		if (isset($this->request->post['ocf_mellat_terminal_id'])) {
			$data['ocf_mellat_terminal_id'] = $this->request->post['ocf_mellat_terminal_id'];
		} else {
			$data['ocf_mellat_terminal_id'] = $this->config->get('ocf_mellat_terminal_id');
		}

		if (isset($this->request->post['ocf_mellat_username'])) {
			$data['ocf_mellat_username'] = $this->request->post['ocf_mellat_username'];
		} else {
			$data['ocf_mellat_username'] = $this->config->get('ocf_mellat_username');
		}

		if (isset($this->request->post['ocf_mellat_password'])) {
			$data['ocf_mellat_password'] = $this->request->post['ocf_mellat_password'];
		} else {
			$data['ocf_mellat_password'] = $this->config->get('ocf_mellat_password');
		}

		if (isset($this->request->post['ocf_mellat_order_status_id'])) {
			$data['ocf_mellat_order_status_id'] = $this->request->post['ocf_mellat_order_status_id'];
		} else {
			$data['ocf_mellat_order_status_id'] = $this->config->get('ocf_mellat_order_status_id');
		}

		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['ocf_mellat_status'])) {
			$data['ocf_mellat_status'] = $this->request->post['ocf_mellat_status'];
		} else {
			$data['ocf_mellat_status'] = $this->config->get('ocf_mellat_status');
		}

		if (isset($this->request->post['ocf_mellat_sort_order'])) {
			$data['ocf_mellat_sort_order'] = $this->request->post['ocf_mellat_sort_order'];
		} else {
			$data['ocf_mellat_sort_order'] = $this->config->get('ocf_mellat_sort_order');
		}
		
		$data['token'] = $this->session->data['token'];

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/payment/ocf_mellat', $data));
	}
	
	public function settle() {
		
		$json = array();
		if (!isset($this->request->get['sale_order_id'])) { $json['error'] = $this->language->get('error_sale_order_id'); }
		if (!isset($this->request->get['sale_reference_id'])) { $json['error'] = $this->language->get('error_sale_reference_id'); }
		
		if (!$json) {
			
			/* Connect */
			$this->load->library('mellat');
			$this->WebService = new Mellat($this->config->get('ocf_mellat_terminal_id'), $this->config->get('ocf_mellat_username'), $this->config->get('ocf_mellat_password'));
			
			$data['settle'] = $this->WebService->Settle($this->request->get['sale_order_id'], $this->request->get['sale_reference_id']);
			//$data['action'] = $this->WebService->data['Config']['Action'];
			
			if ($this->WebService->errors) {
				$json['error'] = implode(', ', $this->WebService->errors);
			} else {
				if ($data['settle']) {
					$json['success'] = $this->language->get('text_settle_success'); 
				} else {
					$json['error'] = $this->language->get('text_settle_error');
				}
			}
		}
		
		$this->response->setOutput(json_encode($json));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/payment/ocf_mellat')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}

	public function install() {
		$unFiles = array(
			DIR_APPLICATION . 'controller/payment/mellat.php',
			DIR_APPLICATION . 'language/english/payment/mellat.php',
			DIR_APPLICATION . 'language/en-gb/payment/mellat.php',
			DIR_APPLICATION . 'language/persian/payment/mellat.php',
			DIR_APPLICATION . 'language/fa-ir/payment/mellat.php',
			DIR_APPLICATION . 'view/template/payment/mellat.tpl',
			DIR_CATALOG . 'controller/payment/mellat.php',
			DIR_CATALOG . 'language/english/payment/mellat.php',
			DIR_CATALOG . 'language/en-gb/payment/mellat.php',
			DIR_CATALOG . 'language/persian/payment/mellat.php',
			DIR_CATALOG . 'language/fa-ir/payment/mellat.php',
			DIR_CATALOG . 'model/payment/mellat.php',
			DIR_CATALOG . 'view/theme/default/template/payment/mellat.tpl',
			DIR_CATALOG . 'view/theme/default/template/payment/mellat_confirm.tpl',

			DIR_APPLICATION . 'controller/payment/ocf_mellat.php',
			DIR_APPLICATION . 'language/english/payment/ocf_mellat.php',
			DIR_APPLICATION . 'language/en-gb/payment/ocf_mellat.php',
			DIR_APPLICATION . 'language/persian/payment/ocf_mellat.php',
			DIR_APPLICATION . 'language/fa-ir/payment/ocf_mellat.php',
			DIR_APPLICATION . 'view/template/payment/ocf_mellat.tpl',
			DIR_CATALOG . 'controller/payment/ocf_mellat.php',
			DIR_CATALOG . 'language/english/payment/ocf_mellat.php',
			DIR_CATALOG . 'language/en-gb/payment/ocf_mellat.php',
			DIR_CATALOG . 'language/persian/payment/ocf_mellat.php',
			DIR_CATALOG . 'language/fa-ir/payment/ocf_mellat.php',
			DIR_CATALOG . 'model/payment/ocf_mellat.php',
			DIR_CATALOG . 'view/theme/default/template/payment/ocf_mellat.tpl',
			DIR_CATALOG . 'view/theme/default/template/payment/ocf_mellat_confirm.tpl',
		);
		
		foreach ($unFiles as $unFile) {
			if (file_exists($unFile)) { unlink($unFile); }
		}
	}
}
?>