<?php
CSFWPHAMRAH::createSection($prefix, array(
	'parent' => 'home-set',
	'title' => esc_html__('Slider', 'wp_hamrah'),
	'fields' => array(
    	array(
          'id'      => 'height_slider',
          'type'    => 'slider',
          'title'   => esc_html__('Height Slider', 'wp_hamrah'),
          'min'     => 0,
          'max'     => 350,
          'step'    => 1,
          'unit'    => 'px',
          'default' => 105,
        ),
		array(
			'id' => 'sliders',
			'type' => 'repeater',
			'title' =>  esc_html__('List of Slides', 'wp_hamrah'),
			'fields' => array(
				array(
					'id'    => 'img',
					'type'  => 'upload',
					'title' =>  esc_html__('Image', 'wp_hamrah'),
					'library'      => 'image',
					'preview' => true,
				),

				array(
					'id'          => 'type',
					'type'        => 'select',
					'title' =>  esc_html__('type', 'wp_hamrah'),
					'options'     => array(
						'no_link'  => esc_html__('Only image without link','wp_hamrah'),
						'link'  => esc_html__('External link','wp_hamrah'),
						'product_cat'  => esc_html__('Product category','wp_hamrah'),
  						'product'  => esc_html__('Product','wp_hamrah'),
 						'page'  => esc_html__('Page','wp_hamrah'),
					),
				),
				//------------ Link --------
				array(
					'id'          => 'val_link',
					'type'        => 'text',
					'title'       => esc_html__('value','wp_hamrah'),
					'desc'=>esc_html__('The link must be entered with http or https','wp_hamrah'),
					'validate' => 'csf_validate_url',
					'dependency' => array( 'type', '==', 'link' )
				),
			 
				//-------- Category product ----
				array(
					'id'          => 'val_product_cat',
					'type'        => 'select',
					'title'       => esc_html__('value','wp_hamrah'),
					'placeholder' => esc_html__('Select a category','wp_hamrah'),
					'dependency' => array( 'type', '==', 'product_cat' ),
					'chosen'      => true,
					'ajax'        => true,
					'options'     => 'categories',
					'query_args'  => array(
						'taxonomy'  => 'product_cat',
					),

				),
			 
				//-------- product ----
				array(
					'id'          => 'val_product',
					'type'        => 'select',
					'title'       => esc_html__('value','wp_hamrah'),
					'placeholder' => esc_html__('Select a Product','wp_hamrah'),
					'dependency' => array( 'type', '==', 'product' ),
					'chosen'      => true,
					'ajax'        => true,
					'options'     => 'posts',
					'query_args'  => array(
						'post_type'  => 'product',
					),
				),
			 
				//-------- Page ----
				array(
					'id'          => 'val_page',
					'type'        => 'select',
					'title'       => esc_html__('value','wp_hamrah'),
					'placeholder' => esc_html__('Select a Page','wp_hamrah'),
					'dependency' => array( 'type', '==', 'page' ),
					'chosen'      => true,
					'ajax' => true,
					'options'     => 'pages',
				),

			),
		),

	),

));

