<?php
CSFWPHAMRAH::createSection($prefix, array(
    'parent' => 'home-set',
    'title' => esc_html__('Advertisement banner', 'wp_hamrah'),
    'fields' => array(
        array(
            'id' => 'banners_ads',
            'type' => 'group',
            'title' =>  esc_html__('List of banner ads', 'wp_hamrah'),
            'fields' => array(


                array(
                    'id'          => 'view',
                    'type'        => 'select',
                    'title' =>  esc_html__('width', 'wp_hamrah'),
                    'options'     => array(
                        'grid'  => esc_html__('half', 'wp_hamrah'),
                        'full'  => esc_html__('full', 'wp_hamrah'),
                    ),

                ),
	            array(
		            'id'    => 'img',
		            'type'  => 'upload',
		            'title' =>  esc_html__('Image', 'wp_hamrah'),
		            'library'      => 'image',
		            'preview' => true,
	            ),
                array(
                    'id'          => 'type',
                    'type'        => 'select',
                    'title' =>  esc_html__('type', 'wp_hamrah'),
                    'options'     => array(
                        'no_link'  => esc_html__('Only image without link','wp_hamrah'),
                        'link'  => esc_html__('External link','wp_hamrah'),
                        'product_cat'  => esc_html__('Product category','wp_hamrah'),
                        'product'  => esc_html__('Product','wp_hamrah'),
                        'page'  => esc_html__('Page','wp_hamrah'),
                    ),
                ),
              //------------ Link --------
                array(
                    'id'          => 'val_link',
                    'type'        => 'text',
                    'title'       => esc_html__('value','wp_hamrah'),
                    'desc'=>esc_html__('The link must be entered with http or https','wp_hamrah'),
                    'validate' => 'csf_validate_url',
                    'dependency' => array( 'type', '==', 'link' )
                ),
                
                //-------- Category product ----
                array(
                    'id'          => 'val_product_cat',
                    'type'        => 'select',
                    'title'       => esc_html__('value','wp_hamrah'),
                    'placeholder' => esc_html__('Select a category','wp_hamrah'),
                    'dependency' => array( 'type', '==', 'product_cat' ),
                    'chosen'      => true,
                    'ajax' => true,
                    'options'     => 'categories',
                    'query_args'  => array(
                        'taxonomy'  => 'product_cat',
                    ),

                ),
                 
                  //-------- product ----
                array(
                    'id'          => 'val_product',
                    'type'        => 'select',
                    'title'       => esc_html__('value','wp_hamrah'),
                    'placeholder' => esc_html__('Select a Product','wp_hamrah'),
                    'dependency' => array( 'type', '==', 'product' ),
                    'chosen'      => true,
                    'ajax' => true,
                    'options'     => 'posts',
                    'query_args'  => array(
                        'post_type'  => 'product',
                    ),
                ),
               
                //-------- Page ----
                array(
                    'id'          => 'val_page',
                    'type'        => 'select',
                    'title'       => esc_html__('value','wp_hamrah'),
                    'placeholder' => esc_html__('Select a Page','wp_hamrah'),
                    'dependency' => array( 'type', '==', 'page' ),
                    'chosen'      => true,
                    'options'     => 'pages',
                    'ajax' => true,
                ),

	            /*********************   Half   **************************/
	            array(
		            'id'    => 'img_2',
		            'type'  => 'upload',
		            'title' =>  esc_html__('Image 2', 'wp_hamrah'),
		            'library'      => 'image',
		            'dependency' => array( 'view', '==', 'grid' ),
		            'preview' => true,
	            ),
	            array(
		            'id'          => 'type_2',
		            'type'        => 'select',
		            'title' =>  esc_html__('type 2', 'wp_hamrah'),
		            'dependency' => array( 'view', '==', 'grid' ),
		            'options'     => array(
			            'no_link'  => esc_html__('Only image without link','wp_hamrah'),
			            'link'  => esc_html__('External link','wp_hamrah'),
			            'product_cat'  => esc_html__('Product category','wp_hamrah'),
 			            'product'  => esc_html__('Product','wp_hamrah'),
 			            'page'  => esc_html__('Page','wp_hamrah'),
		            ),
	            ),
	            //------------ Link --------
	            array(
		            'id'          => 'val_link_2',
		            'type'        => 'text',
		            'title'       => esc_html__('value 2','wp_hamrah'),
		            'desc'=>esc_html__('The link must be entered with http or https','wp_hamrah'),
		            'validate' => 'csf_validate_url',
		            'dependency' => [
			             array( 'view', '==', 'grid' ),
						array( 'type_2', '==', 'link' )
			            ]
	            ),
	           
	            //-------- Category product ----
	            array(
		            'id'          => 'val_product_cat_2',
		            'type'        => 'select',
		            'title'       => esc_html__('value 2','wp_hamrah'),
		            'placeholder' => esc_html__('Select a category','wp_hamrah'),
		            'dependency' => [
			            array( 'view', '==', 'grid' ),
			            array( 'type_2', '==', 'product_cat' )
		            ],
		            'chosen'      => true,
		            'ajax' => true,
		            'options'     => 'categories',
		            'query_args'  => array(
			            'taxonomy'  => 'product_cat',
		            ),

	            ),
	            
	            //-------- product ----
	            array(
		            'id'          => 'val_product_2',
		            'type'        => 'select',
		            'title'       => esc_html__('value 2','wp_hamrah'),
		            'placeholder' => esc_html__('Select a Product','wp_hamrah'),
		            'dependency' => [
			            array( 'view', '==', 'grid' ),
			            array( 'type_2', '==', 'product' )
		            ],
                    'ajax' => true,
		            'chosen'      => true,
		            'options'     => 'posts',
		            'query_args'  => array(
			            'post_type'  => 'product',
		            ),
	            ),
	           
	            //-------- Page ----
	            array(
		            'id'          => 'val_page_2',
		            'type'        => 'select',
		            'title'       => esc_html__('value 2','wp_hamrah'),
		            'placeholder' => esc_html__('Select a Page','wp_hamrah'),
		            'dependency' => [
			            array( 'view', '==', 'grid' ),
			            array( 'type_2', '==', 'page' )
		            ],
		            'chosen'      => true,
		            'options'     => 'pages',
		            'ajax' => true,
	            ),


            ),
        ),

    ),

));

