<?php

CSFWPHAMRAH::createSection($prefix, array(
    'id' => 'auth-set',
    'title' => esc_html__('Authentication', 'wp_hamrah'),
         'icon' => 'fas fa-sign-in-alt',
));
CSFWPHAMRAH::createSection($prefix, array(
    'parent' => 'auth-set',
    'title' => esc_html__('General', 'wp_hamrah'),
      'icon' => 'far fa-user',
      'fields' => array(

        array(
            'id' => 'auth_image',
            'type' => 'upload',
            'title' => esc_html__('Image', 'wp_hamrah'),
            'preview' => true,
        ),
        
        array(
            'id' => 'req_auth_app',
            
            'type' => 'switcher',
            'title' => esc_html__('Mandatory login to the app', 'wp_hamrah'),
            'text_width' => 100
        ),
    array(
            'id' => 'dis_register',
            'type' => 'switcher',
            'title' => esc_html__('Disable Registration', 'wp_hamrah'),
            'text_width' => 100
        ),



        array(
            'id'    => 'auth_rules',
            'type'  => 'select',
            'title' =>  esc_html__('Rules', 'wp_hamrah'),
            'placeholder' =>  esc_html__('Select a page', 'wp_hamrah'),
            'chosen'      => true,
            'options'     => 'pages',
            'query_args'  => array(
                'posts_per_page' => -1 // for get all pages (also it's same for posts).
            ),
        ),
        array(
            'id' => 'support',
            'type' => 'text',
            'title' => esc_html__('Support Contact', 'wp_hamrah'),
        ),
    ),

));
CSFWPHAMRAH::createSection($prefix, array(
    'parent' => 'auth-set',
    'title' => esc_html__('SMS', 'wp_hamrah'),
     'icon' => 'far fa-comment-dots',
    'fields' => array(

        array(
            'id' => 'is_sms_reg',
            'type' => 'switcher',
            'title' => esc_html__('Enable SMS registration', 'wp_hamrah'),
            'text_width' => 100
        ),

        array(
            'id' => 'is_on_time',
            'type' => 'switcher',
            'title' => esc_html__('Authentication with a one-time code', 'wp_hamrah'),
            'text_width' => 100,
            'dependency' => array('is_sms_reg', '==', 'true')
        ),
        
        array(
            'id' => 'add_displayname_field',
            'type' => 'switcher',
            'title' => esc_html__('Add displayname on register', 'wp_hamrah'),
            'text_width' => 100,
            'dependency' => array('is_sms_reg', '==', 'true')
        ),
        
         array(
            'id' => 'is_displayname_required',
            'type' => 'switcher',
            'title' => esc_html__('Require displayname', 'wp_hamrah'),
            'text_width' => 100,
            'dependency' => array(array('is_sms_reg', '==', 'true'),array('add_displayname_field','==',true))
        ),
        
        array(
            'id' => 'exp_time_code',
            'type' => 'number',
            'title' => esc_html__('Code duration', 'wp_hamrah'),
            'default' => 4,
            'unit' => esc_html__('Minutes', 'wp_hamrah'),
            'dependency' => array('is_sms_reg', '==', 'true')
        ),
        array(
            'id' => 'panel_sms',
            'type' => 'select',
            'title' => esc_html__('Select SMS system', 'wp_hamrah'),
            'placeholder' => esc_html__('Select your SMS system', 'wp_hamrah'),
            'options' => array(
                'sms_ir' => 'SMS.IR',
                'sms_ir_new' => 'SMS.IR جدید',
                'ippanel' => 'آی پی پنل',
                'melipayamak' => 'ملی پیامک',
                'rayegansms' => 'رایگان اس ام اس',
            ),
            'dependency' => array('is_sms_reg', '==', 'true')
        ),


//-------------- SMS.IR  -------------//
        array(
            'id' => 'secret_key_sms_ir',
            'type' => 'text',
            'title' => 'کلید امنیتی (Secret Key)',
            'dependency' => [
                array('is_sms_reg', '==', 'true'),
                array('panel_sms', '==', 'sms_ir'),
            ],
        ),

        array(
            'id' => 'api_key_sms_ir',
            'type' => 'text',
            'title' => 'کلید api   (api key)',
            'dependency' => [
                array('is_sms_reg', '==', 'true'),
                array('panel_sms', 'any', 'sms_ir,sms_ir_new'),
            ],
        ),
        array(
            'id' => 'code_reg_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ثبت نام',
            'dependency' => [
                array('is_sms_reg', '==', 'true'),
                array('panel_sms', 'any', 'sms_ir,sms_ir_new'),
            ],
            'desc' => esc_html__('به جای متغییر کد عبارت code را وارد نمایید. توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد', 'wp_hamrah'),

        ),
        array(
            'id' => 'code_lost_sms_ir',
            'type' => 'text',
            'title' => 'کد متن فراموشی رمز عبور',
            'dependency' => [
                array('is_sms_reg', '==', 'true'),
                array('panel_sms', 'any', 'sms_ir,sms_ir_new'),
            ],
            'desc' => esc_html__('به جای متغییر کد عبارت code را وارد نمایید. توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد', 'wp_hamrah'),

        ),


        //-------------- ippanel  -------------//
        array(
            'id' => 'username_ippanel',
            'type' => 'text',
            'title' => 'نام کاربری',
            'dependency' => [
                array('is_sms_reg', '==', 'true'),
                array('panel_sms', '==', 'ippanel'),
            ],
        ),

        array(
            'id' => 'pass_ippanel',
            'type' => 'text',
            'title' => 'رمز عبور',
            'dependency' => [
                array('is_sms_reg', '==', 'true'),
                array('panel_sms', '==', 'ippanel'),
            ],

        ),
        array(
            'id' => 'from_ippanel',
            'type' => 'text',
            'title' => 'شماره ارسال کننده',
            'dependency' => [
                array('is_sms_reg', '==', 'true'),
                array('panel_sms', '==', 'ippanel'),
            ],
        ),
        array(
            'id' => 'code_reg_ippanel',
            'type' => 'text',
            'title' => 'کد متن ثبت نام',
            'dependency' => [
                array('is_sms_reg', '==', 'true'),
                array('panel_sms', '==', 'ippanel'),
            ],
            'desc' => esc_html__('به جای متغییر کد عبارت code را وارد نمایید. توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد', 'wp_hamrah'),

        ),
        array(
            'id' => 'code_lost_ippanel',
            'type' => 'text',
            'title' => 'کد متن فراموشی رمز عبور',
            'dependency' => [
                array('is_sms_reg', '==', 'true'),
                array('panel_sms', '==', 'ippanel'),
            ],
            'desc' => esc_html__('به جای متغییر کد عبارت code را وارد نمایید. توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد', 'wp_hamrah'),

        ),


        //-------------- rayegansms  -------------//

        array(
            'id' => 'username_rayegansms',
            'type' => 'text',
            'title' => 'نام کاربری',
            'dependency' => [
                array('is_sms_reg', '==', 'true'),
                array('panel_sms', '==', 'rayegansms'),
            ],
        ),

        array(
            'id' => 'pass_rayegansms',
            'type' => 'text',
            'title' => 'رمز عبور',
            'dependency' => [
                array('is_sms_reg', '==', 'true'),
                array('panel_sms', '==', 'rayegansms'),
            ],

        ),

        array(
            'id' => 'code_reg_rayegansms',
            'type' => 'textarea',
            'title' => 'متن ثبت نام',
            'dependency' => [
                array('is_sms_reg', '==', 'true'),
                array('panel_sms', '==', 'rayegansms'),
            ],
            'desc' => esc_html__('به جای متغییر کد عبارت code را وارد نمایید. توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد', 'wp_hamrah'),

        ),
        array(
            'id' => 'code_lost_rayegansms',
            'type' => 'textarea',
            'title' => 'متن فراموشی رمز عبور',
            'dependency' => [
                array('is_sms_reg', '==', 'true'),
                array('panel_sms', '==', 'rayegansms'),
            ],
            'desc' => esc_html__('به جای متغییر کد عبارت code را وارد نمایید. توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد', 'wp_hamrah'),

        ),

        //-------------- melipayamak  -------------//

        array(
            'id' => 'username_melipayamak',
            'type' => 'text',
            'title' => 'نام کاربری',
            'dependency' => [
                array('is_sms_reg', '==', 'true'),
                array('panel_sms', '==', 'melipayamak'),
            ],
        ),
        array(
            'id' => 'pass_melipayamak',
            'type' => 'text',
            'title' => 'رمز عبور',
            'dependency' => [
                array('is_sms_reg', '==', 'true'),
                array('panel_sms', '==', 'melipayamak'),
            ],
        ),
        array(
            'id' => 'code_reg_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ثبت نام',
            'dependency' => [
                array('is_sms_reg', '==', 'true'),
                array('panel_sms', '==', 'melipayamak'),
            ],
            'desc' => esc_html__(' توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد', 'wp_hamrah'),

        ),

        array(
            'id' => 'code_lost_melipayamak',
            'type' => 'text',
            'title' => 'کد متن فراموشی رمز عبور',
            'dependency' => [
                array('is_sms_reg', '==', 'true'),
                array('panel_sms', '==', 'melipayamak'),
            ],
            'desc' => esc_html__(' توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد', 'wp_hamrah'),
        ),

    ),

));
CSFWPHAMRAH::createSection($prefix, array(
    'parent' => 'auth-set',
    'title' => esc_html__('Email', 'wp_hamrah'),
         'icon' => 'far fa-envelope',

    'fields' => array(
        array(
            'id' => 'subject_email_lost',
            'type' => 'text',
            'title' => esc_html__('Subject in password recovery', 'wp_hamrah'),

        ),
        array(
            'id' => 'content_email_lost',
            'type' => 'wp_editor',
            'title' => esc_html__('Content in password recovery', 'wp_hamrah'),
            'desc' => esc_html__('Enter the {code} phrase instead of the code variable. Note that only the code is sent as a variable, so there should be only one variable in your text', 'wp_hamrah'),

        ),

    ),

));