<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * WooCommerce Order Tracking
 * Displays the order tracking form.
 */

if( !class_exists( 'woocommerce' ) )
{
	add_shortcode('av_wctracking', 'avia_please_install_woo');
	return;
}

if ( !class_exists( 'avia_sc_wctracking' ) )
{
	class avia_sc_wctracking extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('Order Tracking', 'avia_framework' );
			$this->config['tab']		= __('WooCommerce', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."tracking.png";
			$this->config['order']		= 87;
			$this->config['target']		= 'avia-target-insert';
			$this->config['shortcode'] 	= 'av_wctracking';
			$this->config['tooltip'] 	= __('Displays WooCommerce order tracking form.', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
		}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}



		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			$output = do_shortcode( '[woocommerce_order_tracking]' );
			$meta['el_class'];
						
			return $output;
		}
	}
}
