<?php
/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Modern Product Listing
 * Displays a product image with a modern style
 */


if( !class_exists( 'woocommerce' ) )
{
	add_shortcode('wc_product_img_modern', 'avia_please_install_woo');
	return;
}

if ( !class_exists( 'avia_wc_product_img_modern' ) ) 
{
	class avia_wc_product_img_modern extends aviaShortcodeTemplate
	{
			/**
			 * Create the config array for the shortcode button
			 */
			function shortcode_insert_button()
			{
				$template_url = get_stylesheet_directory_uri();
				$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
				$this->config['name']		= __('Modern Product Image', 'avia_framework' );
				$this->config['tab']		= __('WooCommerce', 'avia_framework' );
				$this->config['icon']		= $child_sc_imgs."product-img.png";
				$this->config['order']		= 97;
				$this->config['target']		= 'avia-target-insert';
				$this->config['shortcode'] 	= 'wc_product_img_modern';
				$this->config['tooltip'] 	= __('Displays a product image with a modern style.', 'avia_framework' );
				$this->config['tinyMCE']    = array('disable'=>true);
				$this->config['modal_data'] = array('modal_class' => 'ssmed');
				$this->config['preview'] 	= false;
				$this->config['posttype'] 	= array('product',__('This element can only be used on single product pages','avia_framework'));
			}

		
			/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{

				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
											
				    array(	
						"name" 	=> __("Link Settings", 'avia_framework' ),
						"desc" 	=> __("Select whether or not you would like the image linked to a larger image via lightbox.", 'avia_framework' ),
						"id" 	=> "link_img",
						"type" 	=> "select",
						"std" 	=> "lightbox-img",
						"subtype" => array("No Link"=>'no-link',"Lightbox"=>'lightbox-img')
						), 
						
					array(	
						"name" 	=> __("Sale Tagline", 'avia_framework' ),
						"desc" 	=> __("Enter what you would like displayed when the product is on sale.<br /><strong>Example:</strong> SALE - 10% OFF<br />To disable the sale badge completely, simply leave the field blank.", 'avia_framework' ),
						"id" 	=> "tagline",
						"std" 	=> __("SALE", 'avia_framework' ),
						"type" 	=> "input"),
					
					array(	
						"name" 	=> __("Custom Tagline", 'avia_framework' ),
						"desc" 	=> __("Enter a custom tagline you would like to display on the product image. Note, this will override anything you have in the 'Sale Tagline' field.", 'avia_framework' ),
						"id" 	=> "custom_tagline",
						"std" 	=> "",
						"type" 	=> "input"),
							
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Style Options" , 'avia_framework'),
							'nodescription' => true
						),
							
					array(	
							"name" 	=> __("Tagline Text Style", 'avia_framework' ),
							"desc" 	=> __("Select the text style for the sale tagline.", 'avia_framework' ),
							"id" 	=> "sale",
							"type" 	=> "select",
							"container_class" => 'av_half',
							"std" 	=> "light",
							"subtype" => array("Light"=>'light',"Dark"=>'dark')
							),
							
					array(	
							"name" 	=> __("Tagline Badge Background Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the badge background.", 'avia_framework' ),
							"id" 	=> "sale_bg",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#d54e21",
						),  
					
					array(	
							"name" 	=> __("Border Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the border color.", 'avia_framework' ),
							"id" 	=> "border_color",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#c1c1c1",
						),
						
					array(	
							"name" 	=> __("Image Hover Effect",'avia_framework' ),
							"desc" 	=> __("Check to disable the image hover effect.", 'avia_framework'),
							"id" 	=> "img_effect",
							"container_class" => 'av_half',
							"std" 	=> "",
							"type" 	=> "checkbox"),
						
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
					array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
						
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
						
						
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
				);

			}
			
			
			/**
			 * Frontend Shortcode Handler
			 *
			 * @param array $atts array of attributes
			 * @param string $content text within enclosing form of shortcode element 
			 * @param string $shortcodename the shortcode found, when == callback name
			 * @return string $output returns the modified html string 
			 */
			function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
			{
				if(is_rtl()): wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all'); else: wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css',false,'1.1','all'); endif;
			    extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes 
				extract(shortcode_atts(array('tagline' => 'SALE', 'custom_tagline' => '', 'sale' => '', 'sale_bg' => '', 'link_img' => '', 'img_effect' => '', 'border_color' => '' ), $atts, $this->config['shortcode']));
			   
			    $meta['el_class'];
			
				global $woocommerce, $product;
				if(!is_object($woocommerce) || !is_object($woocommerce->query) || empty($product)) return;
			
				ob_start();
			
							
				global $product;
				$product_image = get_the_post_thumbnail( $post_id, 'shop_catalog' );
				$product_image_large = get_the_post_thumbnail_url( $post_id, 'large' );
							
				$sale  = $atts['sale'];
				$sale_bg  = $atts['sale_bg'];
				if($sale == 'light') $sale = 'style="color:#f5f5f5; background-color:'.$sale_bg.' !important;"';
				if($sale == 'dark') $sale = 'style="color:#151515; text-shadow:none !important; background-color:'.$sale_bg.' !important;"';
				
				$tagline = $atts['tagline'];
				$customtag = $atts['custom_tagline']; 
				if ( ($product->is_on_sale()) && ($tagline) && (!$customtag) ) {
					$saletag = '<h3 '.$sale.' class="sale">'.$tagline.'</h3>';
				}
				if ($customtag){$ctag = '<h3 '.$sale.' class="sale">'.$customtag.'</h3>';}
				
				$link_img  = $atts['link_img'];
				if ($link_img == 'lightbox-img'){
				$prodimglink = '<a href="'.$product_image_large.'"></a>';
				}
				if ($link_img == 'nolink'){
				$prodimglink = '';
				}
				
				if ($link_img == 'lightbox-img'){
				$clicktext = '<div class="avia_textblock text-center itemprop="text"><p style="margin-top:0px !important; margin-bottom:25px !important;"><small>CLICK TO PREVIEW</small></p></div>';
				}
				if ($link_img == 'nolink'){
				$clicktext = '';
				}
				
				$img_effect = $atts['img_effect'];
				if ($img_effect) {$product_image = "<img src=".get_the_post_thumbnail_url( $post_id, 'shop_catalog' )." style='-webkit-transform: none !important; transform: none !important;' />";}
			    
			    $output = "";
			    $output .= '<figure class="modprod {$av_display_classes}" style="border:1px solid '.$border_color.';">'. $product_image;
				$output .= '<figcaption style="background-image:none !important;">';
				$output .= $saletag;
				$output .= $ctag;
				$output .= '</figcaption>'.$prodimglink;
				$output .= '</figure>'.$clicktext;
				
				return $output;
			}
	}
}
