<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Shortlink
 * Displays copyright year(s).
 */
 
if ( !class_exists( 'avia_copyright' ) )
{
	class avia_copyright extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('Copyright Year', 'avia_framework' );
			$this->config['tab']		= __('Spiderfly Elements', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."copyright.png";
			$this->config['order']		= 11;
			$this->config['target']		= 'avia-target-insert';
			$this->config['shortcode'] 	= 'av_copyright';
			$this->config['modal_data'] = array('modal_class' => 'mediumscreen');
			$this->config['tooltip'] 	= __('Displays copyright year(s).', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
			$this->config['preview'] 	= true;
		}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}


		/**
		 * Popup Elements
		 *
		 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
		 * opens a modal window that allows to edit the element properties
		 *
		 * @return void
		 */
		function popup_elements()
		{
			$this->elements = array(
					
				array(
						"type" 	=> "tab_container", 'nodescription' => true
					),
					
				array(
							"type" 	=> "tab",
							"name"	=> __("Options",'avia_framework' ),
							'nodescription' => true
						),
						
					array(
						"name" 	=> "",
						"desc" 	=> __("For additional styling needs, use the CSS class of 'copyright'.", 'avia_framework' ),
						"type" 	=> "heading",
						"description_class" => "av-builder-note av-neutral",
						),
						
					array(	
						"name" 	=> __("Prefix", 'avia_framework' ),
						"desc" 	=> __("Define what should be displayed before the date(s). Leave blank to disable.", 'avia_framework' ),
						"id" 	=> "prefix",
						"std" 	=> __("Copyright", 'avia_framework' ),
						"type" 	=> "input"), 
						
					array(	
						"name" 	=> __("Start Year", 'avia_framework' ),
						"desc" 	=> __("Optionally include a start year.", 'avia_framework' ),
						"id" 	=> "startyr",
						"std" 	=> "",
						"type" 	=> "input"),
						
					array(	
						"name" 	=> __("Suffix", 'avia_framework' ),
						"desc" 	=> __("Define what should be displayed after the date(s). Leave blank to disable.", 'avia_framework' ),
						"id" 	=> "suffix",
						"std" 	=> __("All Rights Reserved", 'avia_framework' ),
						"type" 	=> "input"),
				            
				    array(	
							"name" 	=> __("Text Color", 'avia_framework' ),
							"desc" 	=> __("Select a color for the shortlink text.", 'avia_framework' ),
							"id" 	=> "color",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Color", 'avia_framework' )=>'', __("Meta Color", 'avia_framework' )=>'meta-heading', __("Custom Color", 'avia_framework' )=>'custom-color-shortlink')
							), 
							
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your shortlink text here.", 'avia_framework' ),
							"id" 	=> "custom_font",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('color','equals','custom-color-shortlink')
						),
							
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
						
								array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
	
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	

					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
				
				);
		}


		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		 
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes 
			extract(shortcode_atts(array('prefix'=>'', 'startyr'=>'', 'suffix'=>'', 'color'=>'', 'custom_font'=>''), $atts, $this->config['shortcode']));
			
			$meta['el_class'];
			
			// if the color is a custom hex value add the styling for both border and font
	        		if($color == "custom-color-shortlink" && $custom_font)  
	        		{
	        			$styling .= "color:{$custom_font} !important;";
	        		}
			//finish up the styling string
	        		if(!empty($styling)) $styling = "style='{$styling}'";
			
			if(!empty($prefix)) $prefix = "{$prefix} &nbsp;";
			if(!empty($startyr)) $startyr = "{$startyr} - ";
			if(!empty($suffix)) $suffix = ",&nbsp; {$suffix}";
		
			//html markup
	        		$output .= "<div {$styling} class='copyright {$av_display_classes}'> &copy; ".$prefix.$startyr."";
					$output .= date('Y');
					$output .= $suffix."</div>";
			
			return $output;
		}
	}
}
