"use strict";

document.addEventListener("DOMContentLoaded", function () {
  const buttons = document.querySelectorAll(".toggleButton");
  const mainMenu = document.getElementById("mainMenu");
  const toggleMobileBtn = document.getElementById("mobileMenuToggle");
  const mobileCloseBtn = document.getElementById("mobileMenuClose");
  const mobileMenu = document.getElementById("mobileMenu");
  const mobileSubBtns = document.querySelectorAll(".sub-toggle-button");
  const tabs = document.querySelectorAll(".tab");
  const tabContents = document.querySelectorAll(".content");

  // Preloader
  const preloader = document.querySelector(".preloader");
  preloader && (preloader.classList.remove("flex"), preloader.classList.add("hidden"));

  // Dark Mode
  if (
    localStorage.getItem("color-theme") === "dark" ||
    (!("color-theme" in localStorage) && window.matchMedia("(prefers-color-scheme: dark)").matches)
  ) {
    document.documentElement.classList.add("dark");
  } else {
    document.documentElement.classList.remove("dark");
  }
  var themeToggleDarkIcon = document.getElementById("theme-toggle-dark-icon");
  var themeToggleLightIcon = document.getElementById("theme-toggle-light-icon");

  // Change the icons inside the button based on previous settings
  if (
    localStorage.getItem("color-theme") === "dark" ||
    (!("color-theme" in localStorage) && window.matchMedia("(prefers-color-scheme: dark)").matches)
  ) {
    themeToggleLightIcon.classList.remove("hidden");
  } else {
    themeToggleDarkIcon.classList.remove("hidden");
  }

  var themeToggleBtn = document.getElementById("theme-toggle");

  themeToggleBtn.addEventListener("click", function () {
    // toggle icons inside button
    themeToggleDarkIcon.classList.toggle("hidden");
    themeToggleLightIcon.classList.toggle("hidden");

    // if set via local storage previously
    if (localStorage.getItem("color-theme")) {
      if (localStorage.getItem("color-theme") === "light") {
        document.documentElement.classList.add("dark");
        localStorage.setItem("color-theme", "dark");
      } else {
        document.documentElement.classList.remove("dark");
        localStorage.setItem("color-theme", "light");
      }

      // if NOT set via local storage previously
    } else {
      if (document.documentElement.classList.contains("dark")) {
        document.documentElement.classList.remove("dark");
        localStorage.setItem("color-theme", "light");
      } else {
        document.documentElement.classList.add("dark");
        localStorage.setItem("color-theme", "dark");
      }
    }
  });

  //  Mobile menu
  toggleMobileBtn.addEventListener("click", () => {
    toggleMobileBtn.classList.add("hidden");
    setTimeout(() => {
      mobileMenu.classList.remove("translate-x-full");
    }, 300);
  });
  // Close mobile menu
  mobileCloseBtn.addEventListener("click", () => {
    toggleMobileBtn.classList.add("block");
    setTimeout(() => {
      mobileMenu.classList.add("translate-x-full");
    }, 300);
  });

  // Mobile sub menus
  mobileSubBtns.forEach((subbtn) => {
    subbtn.addEventListener("click", () => {
      const targetId = subbtn.getAttribute("data-sub");
      const targetMenu = document.getElementById(targetId);

      const chevron = subbtn.querySelector(".sub-chevron");

      if (!targetMenu) return;

      const isOpen = targetMenu.classList.contains("max-h-[1000px]");

      // Close all other submenus and reset chevrons
      mobileSubBtns.forEach((otherBtn) => {
        const otherId = otherBtn.getAttribute("data-sub");
        const otherMenu = document.getElementById(otherId);
        const otherChevron = otherBtn.querySelector(".chevron");

        if (otherMenu && otherMenu !== targetMenu) {
          otherMenu.classList.remove("max-h-[1000px]", "opacity-100");
          otherMenu.classList.add("max-h-0", "opacity-0");
          if (otherChevron) {
            otherChevron.classList.remove("rotate-180");
          }
        }
      });

      // // highlight current link(Mobile)
      // document.querySelectorAll(".link").forEach((link) => {
      //   const currentPath = window.location.pathname;
      //   const linkPath = new URL(link.href).pathname;

      //   linkPath === currentPath
      //     ? link.classList.add("border-r-4", "border-red-600")
      //     : "";
      // });

      // Toggle current submenu and chevron
      if (isOpen) {
        targetMenu.classList.remove("max-h-[1000px]", "opacity-100");
        targetMenu.classList.add("max-h-0", "opacity-0");
        if (chevron) {
          chevron.classList.remove("rotate-180");
        }
      } else {
        targetMenu.classList.remove("max-h-0", "opacity-0");
        targetMenu.classList.add("max-h-[1000px]", "opacity-100");
        if (chevron) {
          chevron.classList.add("rotate-180");
        }
      }
    });
  });

  // Main Menus
  buttons.forEach((button) => {
    button.addEventListener("click", () => {
      const targetId = button.getAttribute("data-target");
      const targetMenu = document.getElementById(targetId);
      const targetChevron = button.querySelector(".menu-chevron");

      if (!targetMenu) return;

      const isHidden = targetMenu.classList.contains("hidden");

      // Close all other menus and reset chevrons
      buttons.forEach((btn) => {
        const otherId = btn.getAttribute("data-target");
        const otherMenu = document.getElementById(otherId);
        const otherChevron = btn.querySelector(".menu-chevron");

        if (otherMenu && otherMenu !== targetMenu) {
          otherMenu.classList.remove("opacity-100", "translate-y-0");
          otherMenu.classList.add("opacity-0", "-translate-y-1");
          setTimeout(() => {
            otherMenu.classList.add("hidden");
          }, 300);

          if (otherChevron && otherChevron !== targetChevron) {
            otherChevron.classList.remove("rotate-180");
          }
        }
      });

      // Toggle target menu
      if (isHidden) {
        targetMenu.classList.remove("hidden");
        targetMenu.classList.remove("opacity-0", "-translate-y-1");
        targetMenu.classList.add("opacity-100", "translate-y-0");

        if (targetChevron) targetChevron.classList.add("rotate-180");
      } else {
        targetMenu.classList.remove("opacity-100", "translate-y-0");
        targetMenu.classList.add("opacity-0", "-translate-y-1");
        setTimeout(() => {
          targetMenu.classList.add("hidden");
        }, 300);

        if (targetChevron) targetChevron.classList.remove("rotate-180");
      }
    });
  });

  // Close menus when clicking outside
  document.addEventListener("click", (event) => {
    const isClickInsideToggle = event.target.closest(".toggleButton");
    const isClickInsideMenu = Array.from(buttons).some((btn) => {
      const menuId = btn.getAttribute("data-target");
      const menu = document.getElementById(menuId);
      return menu && menu.contains(event.target);
    });

    // If click is outside both toggles and menus
    if (!isClickInsideToggle && !isClickInsideMenu) {
      buttons.forEach((btn) => {
        const menuId = btn.getAttribute("data-target");
        const menu = document.getElementById(menuId);
        const chevron = btn.querySelector(".menu-chevron");

        if (menu && !menu.classList.contains("hidden")) {
          menu.classList.remove("opacity-100", "translate-y-0");
          menu.classList.add("opacity-0", "-translate-y-1");

          setTimeout(() => {
            menu.classList.add("hidden");
          }, 300);
        }

        if (chevron) {
          chevron.classList.remove("rotate-180");
        }
      });
    }
  });

  // Scroll direction to show/hide main menu
  let lastScrollY = window.scrollY;
  window.addEventListener("scroll", () => {
    const currentScrollY = window.scrollY;

    if (currentScrollY < lastScrollY) {
      mainMenu.classList.remove("-translate-y-full", "opacity-0");
      mainMenu.classList.add("translate-y-0", "opacity-100");
    } else {
      mainMenu.classList.add("-translate-y-full", "opacity-0");
      mainMenu.classList.remove("translate-y-0", "opacity-100");
    }

    lastScrollY = currentScrollY;
  });

  // Main Slider
  const icons = [
    '\n    <svg class="svg-icon pagination-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 64 64">\n    <path class="dark:fill-red-700 dark:stroke-red-700" fill="#dc2626" stroke="#dc2626" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m32 63 27-16H5l27 16Zm0-32 27 16H5l27-16Z"></path>\n    <path class="dark:fill-red-500" fill="#f87171" stroke="#f87171" stroke-linecap="round" stroke-linejoin="round" stroke-width="2.22" d="M44.007 44.047c-6.596 6.604-17.336 6.604-24.025 0-6.69-6.604-6.595-17.36 0-24.058 6.595-6.699 17.335-6.605 24.025 0C47.21 23.196 49 27.536 49 31.97a17.08 17.08 0 0 1-4.993 12.076Z"></path>\n    <mask id="a" width="38" height="38" x="13" y="13" maskUnits="userSpaceOnUse" style="mask-type:alpha">\n        <path class="dark:fill-red-700" fill="#dc2626" fill-rule="evenodd" d="M19.19 19.21c7.04-7.15 18.485-7.032 25.596-.011l.006.005c3.41 3.414 5.318 8.036 5.318 12.767 0 4.821-1.906 9.444-5.318 12.86-7.032 7.042-18.472 7.034-25.59.006-7.14-7.05-7.022-18.507-.011-25.627Z" clip-rule="evenodd"></path>\n    </mask>\n    <g mask="url(#a)">\n        <path fill="#fff" d="M14.94 38.157a1 1 0 1 0-1.88.686l1.88-.686Zm6.639 8.172.56-.829a1.052 1.052 0 0 0-.067-.041l-.493.87ZM32 49.212l.143-.99a.999.999 0 0 0-.286 0l.143.99Zm18.94-10.369a1 1 0 1 0-1.88-.686l1.88.686Zm-8.519 7.486-.493-.87a1.052 1.052 0 0 0-.067.041l.56.829ZM27.263 20.153l.46-.888a.939.939 0 0 0-.048-.023l-.412.91Zm-2.179-2.973-.997-.072a.918.918 0 0 0 .008.216l.99-.144Zm2.18-2.972.411.91a.94.94 0 0 0 .049-.023l-.46-.887Zm10.42 0-.46.887a.985.985 0 0 0 .048.024l.412-.911Zm2.18 2.972.997.073a1.008 1.008 0 0 0-.008-.217l-.99.144Zm-2.18 2.973-.412-.911a.888.888 0 0 0-.028.013l.44.898Zm9.398 15.827.471.881.015-.008-.486-.873Zm-14.47 3.35.02-1h-.04l.02 1Zm-14.47-3.35-.487.873.038.02.448-.893Zm33.434-2.72a1 1 0 1 0-1.552-1.261l1.552 1.26Zm-37.542-2.167a1 1 0 1 0-1.668 1.102l1.668-1.102Zm30.042-3.582.467.884a.98.98 0 0 0 .036-.02l-.503-.864ZM31.96 30.34l.022-1h-.045l.023 1Zm-12.12-2.83-.503.865a.985.985 0 0 0 .036.02l.467-.884Zm29.679-4.227a1 1 0 1 0-1.84-.785l1.84.785Zm-33.297-.778a1 1 0 1 0-1.846.77l1.846-.77Zm22.22-3.817a1 1 0 1 0 0 2v-2Zm.947 1.65.655-.755-.282-.244h-.373v1Zm-3.6 28.24.492.87-.492-.87Zm-3.79.929h-1v1h1v-1Zm-6.45-28.819a1 1 0 1 0 0-2v2Zm-.948-.35v-1h-.373l-.282.245.655.756Zm3.6 28.24-.492.87.492-.87Zm3.79 1.929a1 1 0 1 0 0-2v2ZM33 21.732a1 1 0 1 0-2 0h2ZM13.06 38.843c.545 1.49 1.745 3.11 3.162 4.559 1.431 1.463 3.162 2.832 4.864 3.797l.986-1.74c-1.52-.861-3.104-2.11-4.42-3.456-1.33-1.36-2.31-2.741-2.713-3.846l-1.878.686Zm7.959 8.314c2.97 2.009 7.483 3.572 11.124 3.044l-.286-1.98c-2.99.434-7.004-.885-9.718-2.72l-1.12 1.656Zm28.042-9c-.404 1.105-1.382 2.486-2.713 3.847-1.316 1.345-2.9 2.594-4.42 3.455l.986 1.74c1.702-.965 3.433-2.334 4.864-3.797 1.417-1.449 2.617-3.07 3.161-4.559l-1.878-.686Zm-7.2 7.343c-2.714 1.836-6.728 3.155-9.718 2.722l-.286 1.98c3.641.527 8.154-1.036 11.124-3.045l-1.12-1.657Zm-9.387-25.14c-1.665 0-3.303-.343-4.75-1.095l-.922 1.775c1.774.921 3.737 1.32 5.672 1.32v-2Zm-4.799-1.118c-.89-.404-1.456-1.209-1.601-2.206l-1.98.288c.234 1.604 1.185 3.028 2.757 3.74l.824-1.822Zm-1.594-1.99c.066-.89.655-1.708 1.594-2.133l-.824-1.822c-1.524.69-2.64 2.1-2.764 3.81l1.994.146Zm1.643-2.157C29.17 14.344 30.809 14 32.474 14v-2c-1.935 0-3.898.4-5.672 1.32l.922 1.775ZM32.474 14c1.665 0 3.302.344 4.75 1.095l.92-1.775C36.372 12.4 34.41 12 32.475 12v2Zm4.798 1.119c.89.403 1.456 1.208 1.602 2.205l1.979-.288c-.234-1.604-1.184-3.028-2.757-3.74l-.824 1.823Zm1.594 1.989c-.065.89-.655 1.709-1.594 2.134l.825 1.822c1.523-.69 2.639-2.102 2.764-3.811l-1.995-.145Zm-1.622 2.147a10.563 10.563 0 0 1-4.77 1.105v2c1.948 0 3.804-.404 5.65-1.31l-.88-1.795Zm9.366 15.843c-4.256 2.276-9.108 3.327-13.979 3.232l-.04 2c5.18.1 10.376-1.015 14.962-3.469l-.943-1.763ZM32.592 38.33c-4.853.095-9.617-1.047-14.003-3.244l-.896 1.788c4.658 2.334 9.742 3.557 14.938 3.455l-.04-2Zm17.432-6.331c-1.072 1.32-1.807 2.204-3.428 3.107l.972 1.747c1.974-1.098 2.908-2.238 4.008-3.593l-1.552-1.261Zm-31.396 3.107c-2.016-1.122-3.609-2.522-4.594-4.013l-1.668 1.102c1.202 1.82 3.065 3.42 5.289 4.658l.973-1.747Zm24.981-8.48c-3.595 1.899-7.562 2.805-11.628 2.714l-.045 2c4.397.098 8.701-.883 12.607-2.945l-.934-1.768ZM31.936 29.34c-4.066.09-8.032-.815-11.628-2.713l-.934 1.768c3.906 2.062 8.21 3.043 12.607 2.945l-.045-2Zm15.744-6.842c-.639 1.496-2.047 2.95-4.107 4.149l1.006 1.728c2.29-1.333 4.078-3.071 4.94-5.092l-1.839-.785Zm-27.336 4.149c-2.087-1.215-3.493-2.635-4.121-4.142l-1.846.77c.858 2.057 2.665 3.763 4.961 5.1l1.006-1.728Zm18.098-5.959a.959.959 0 0 1-.446-.112c-.006-.003.006.004.042.03.069.048.16.118.271.202.102.078.224.171.327.244.05.036.114.08.18.119a1.361 1.361 0 0 0 .282.126c.053.015.157.041.291.041v-2a.963.963 0 0 1 .38.078c.04.018.065.034.067.035l-.042-.03c-.07-.048-.16-.118-.272-.203a17.26 17.26 0 0 0-.326-.244 2.683 2.683 0 0 0-.18-.118 1.364 1.364 0 0 0-.283-.126 1.037 1.037 0 0 0-.29-.042v2Zm.292.406c1.07.928 2.195 2.611 3.068 4.798a21.483 21.483 0 0 1 1.502 7.436c.101 5.33-1.907 10.93-8.007 14.38l.985 1.74c6.879-3.89 9.134-10.27 9.022-16.158a23.484 23.484 0 0 0-1.645-8.139c-.942-2.362-2.22-4.36-3.614-5.568l-1.31 1.51Zm-3.437 26.614c-1.11.627-2.446.799-3.297.799v2c1.043 0 2.762-.2 4.282-1.058l-.985-1.741Zm-9.747-29.02a1.037 1.037 0 0 0-.43.093 1.364 1.364 0 0 0-.144.075 2.66 2.66 0 0 0-.18.118c-.103.073-.224.166-.326.244a11.34 11.34 0 0 1-.272.204l-.042.029a.888.888 0 0 1 .177-.074.962.962 0 0 1 .27-.038v2a1.041 1.041 0 0 0 .429-.093c.062-.027.113-.057.145-.075.065-.04.13-.083.18-.119.102-.073.224-.166.326-.244.11-.084.202-.154.271-.203l.042-.029a.871.871 0 0 1-.177.074.958.958 0 0 1-.27.038v-2Zm-1.603.895c-1.393 1.209-2.672 3.206-3.614 5.568a23.481 23.481 0 0 0-1.645 8.139c-.112 5.887 2.143 12.269 9.022 16.159l.985-1.741c-6.1-3.45-8.108-9.05-8.007-14.38.05-2.676.637-5.266 1.502-7.436.873-2.187 1.998-3.87 3.068-4.798l-1.31-1.51ZM27.71 49.45c1.52.859 3.239 1.058 4.282 1.058v-2c-.852 0-2.188-.172-3.297-.8l-.985 1.742ZM31 21.732v27.775h2V21.732h-2Z"></path>\n    </g>\n    <path class="dark:stroke-white" stroke="#450a0a" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M35.5 3 32 1l-3.5 2m19.9 7.4-5.8-3.3M59 20.6v-4l-3.5-2M59 35.3v-6.6M5 43.4V47v-1m54-2.6V47v-1M5 28.7v6.6m3.5-20.7-3.5 2v4M21.4 7.1l-5.8 3.4"></path>\n    </svg>\n    <p class="dark:text-zinc-50 text-xs lg:text-base lg:font-normal font-bold">هاست لینوکس</p>\n    ',
    '\n    <svg class="svg-icon pagination-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 64 64">\n    <path class="dark:fill-white" fill="#450a0a" fill-rule="evenodd" d="M30.882.145a1 1 0 0 1 1.02-.01l3.826 2.226a1 1 0 1 1-1.006 1.728L31.41 2.163 28.243 4.08a1 1 0 1 1-1.036-1.71L30.882.145Zm11.129 7.027a1 1 0 0 1 1.367-.361l7.65 4.45a1 1 0 1 1-1.006 1.728l-7.65-4.45a1 1 0 0 1-.361-1.367Zm-20.78-.015a1 1 0 0 1-.338 1.373l-7.35 4.45a1 1 0 1 1-1.036-1.71l7.35-4.45a1 1 0 0 1 1.373.337Zm36.08 8.915a1 1 0 0 1 1.367-.361l3.825 2.225A1 1 0 0 1 63 18.8v5.6a1 1 0 1 1-2 0v-5.025l-3.328-1.936a1 1 0 0 1-.361-1.367Zm-50.78-.015a1 1 0 0 1-.338 1.373L3 19.364v2.799a1 1 0 1 1-2 0V18.8a1 1 0 0 1 .482-.855l3.675-2.225a1 1 0 0 1 1.373.337ZM2 27.887a1 1 0 0 1 1 1v6.725a1 1 0 1 1-2 0v-6.725a1 1 0 0 1 1-1ZM62 34.6a1 1 0 0 1 1 1v9.564a1 1 0 0 1-2 0V35.6a1 1 0 0 1 1-1ZM2 41.337a1 1 0 0 1 1 1v3.675a1 1 0 1 1-2 0v-3.675a1 1 0 0 1 1-1Z" clip-rule="evenodd"></path>\n    <path class="dark:stroke-white" stroke="#450a0a" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2 46.102 31.4 63 62 45.281"></path>\n    <path class="dark:fill-red-700" fill="#dc2626" d="M21.8 21.5V30l10 5.7 10-5.7v-8.5h-20Z"></path>\n    <path class="dark:fill-red-700" fill="#dc2626" d="M5.8 31v9l10 5.7 10-5.7v-9h-20Zm32 0v9l10 5.7 10-5.7v-9h-20Z"></path>\n    <path class="dark:fill-red-700" fill="#dc2626" d="M21.8 40v9.4l10.5 6.1 10.5-6.1V40h-21Z"></path>\n    <path class="dark:stroke-red-700" stroke="#dc2626" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21.8 21.5V30l10 5.7 10-5.7v-8.5h-20Z"></path>\n    <path class="dark:stroke-red-700" stroke="#dc2626" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5.8 31v9l10 5.7 10-5.7v-9h-20Zm32 0v9l10 5.7 10-5.7v-9h-20Z"></path>\n    <path class="dark:stroke-red-700" stroke="#dc2626" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21.8 40v9.4l10.5 6.1 10.5-6.1V40h-21Z"></path>\n    <path class="dark:fill-red-500" fill="#f87171" d="m31.9 27.1-10-5.7 10-5.8 10 5.8-10 5.7Zm-16.1 9.6-10-5.8 10-5.7 10 5.7-10 5.8Zm32.1 0-10-5.8 10-5.7 10 5.7-10 5.8ZM32 46.4l-10.5-6.1 10.5-6 10.5 6L32 46.4Z"></path>\n    <path stroke="#f87171" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m31.9 27.1-10-5.7 10-5.8 10 5.8-10 5.7Zm-16.1 9.6-10-5.8 10-5.7 10 5.7-10 5.8Zm32.1 0-10-5.8 10-5.7 10 5.7-10 5.8ZM32 46.4l-10.5-6.1 10.5-6 10.5 6L32 46.4Z"></path>\n    </svg>\n    <p class="dark:text-zinc-50 text-xs lg:text-base lg:font-normal font-bold">خرید سرور مجازی</p>\n    ',
    '\n    <svg class="svg-icon pagination-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 64 64">\n    <path class="dark:stroke-white" stroke="#450a0a" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M32 51.4286V63M32 51.4286L3 34.7143M32 51.4286L61 34.7143M32 63L61 46.2857V34.7143M32 63L3 46.2857V34.7143M3 34.7143L32 18L61 34.7143M42.3747 51.5531L37.0043 54.7674"></path>\n    <path fill="#dc2626" stroke="#dc2626" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 21.5L32 37.5L60 21.5V17.0526L32 6L4 17.0526V21.5Z"></path>\n    <path class="dark:fill-red-500" fill="#f87171" stroke="#f87171" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 17L32 33.5L60 17L32 1.5L4 17Z"></path>\n    <path class="dark:stroke-red-700" stroke="#dc2626" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 16.5938L32 30L55 16.5938L32 4L9 16.5938Z"></path>\n    <path fill="#dc2626" stroke="#dc2626" stroke-linejoin="round" stroke-width="2" d="M32 9L46 14V17L32 25L18 17V14L32 9Z"></path>\n    <path class="dark:fill-red-500" fill="#f87171" stroke="#f87171" stroke-linejoin="round" stroke-width="2" d="M32 6L46 14L32 22L18 14L32 6Z"></path>\n    <path fill="#fff" stroke="#fff" stroke-width="0.3" d="M31.0717 16.3185L31.2357 16.3663C31.3554 16.2296 31.4315 16.0868 31.463 15.9384L31.4631 15.9378C31.4934 15.788 31.4755 15.6382 31.4101 15.4888C31.3441 15.3379 31.2266 15.1936 31.0603 15.0559L30.9348 14.952L30.7797 15.0416L30.3331 15.2994L30.2274 15.3605L30.3094 15.4326C30.3985 15.511 30.4552 15.5902 30.4827 15.6704L30.4828 15.6707C30.5109 15.7519 30.5134 15.8322 30.4907 15.9123C30.4677 15.9918 30.4217 16.0686 30.3518 16.1432C30.2814 16.2184 30.1914 16.2879 30.081 16.3516C29.8808 16.4671 29.6523 16.5411 29.3933 16.5759C29.1388 16.6096 28.8645 16.5991 28.5657 16.5396C28.2733 16.4803 27.9737 16.3658 27.6682 16.1894C27.3626 16.013 27.1642 15.8401 27.0616 15.6712C26.9584 15.4987 26.9403 15.3404 26.9987 15.1935C27.059 15.0439 27.1871 14.912 27.3872 14.7965C27.4976 14.7327 27.6179 14.6808 27.7481 14.6401C27.8769 14.5999 28.0101 14.5737 28.1486 14.5611L28.1486 14.5611L28.1513 14.5609C28.2882 14.5472 28.4262 14.5483 28.5666 14.5645L28.5666 14.5645L28.5681 14.5647C28.705 14.5798 28.8418 14.6124 28.9788 14.6645L29.1039 14.7121L29.2098 14.6509L29.6564 14.3931L29.8114 14.3036L29.6317 14.2312C29.3922 14.1345 29.1419 14.0665 28.8811 14.0291L28.8367 14.132M31.0717 16.3185L31.2359 16.3661C31.1171 16.5025 30.9574 16.628 30.7586 16.7428C30.4218 16.9372 30.0351 17.0651 29.5999 17.1226C29.1652 17.1801 28.7194 17.1632 28.2666 17.075C27.8105 16.9863 27.3806 16.8225 26.9761 16.5889C26.5716 16.3554 26.2879 16.1073 26.1341 15.8439C25.9815 15.5825 25.9522 15.3252 26.0517 15.0742C26.1513 14.8229 26.3728 14.5997 26.7096 14.4053C26.9084 14.2905 27.1258 14.1984 27.3619 14.1298C27.5991 14.0606 27.8473 14.017 28.1059 13.9996L28.1272 14.1049M31.0717 16.3185C30.9625 16.4439 30.8148 16.5604 30.6287 16.6678C30.3141 16.8494 29.9575 16.9665 29.5589 17.0192C29.1603 17.0719 28.7491 17.057 28.3253 16.9745C27.9014 16.892 27.495 16.7385 27.106 16.5139C26.717 16.2894 26.4511 16.0547 26.3082 15.8101C26.1653 15.5654 26.1395 15.328 26.2308 15.0979C26.322 14.8677 26.5249 14.6619 26.8395 14.4803C27.0256 14.3728 27.2273 14.2876 27.4446 14.2245C27.6631 14.1607 27.8906 14.1209 28.1272 14.1049M31.0717 16.3185C31.1822 16.1923 31.2518 16.0613 31.2806 15.9255C31.3082 15.7889 31.292 15.652 31.232 15.5148C31.1861 15.4099 31.1125 15.3076 31.0112 15.2079L31.0395 15.1916L30.9096 15.1166L30.7589 15.1772C30.7652 15.1824 30.7714 15.1876 30.7775 15.1928L30.463 15.3744C30.5638 15.4631 30.6305 15.555 30.6629 15.6499C30.6953 15.7435 30.6983 15.8367 30.6719 15.9296C30.6455 16.0211 30.5927 16.1091 30.5134 16.1937C30.4342 16.2783 30.3333 16.3559 30.2109 16.4266C29.9875 16.5555 29.7288 16.6397 29.4347 16.6792L29.3684 14.2594C29.1951 14.2004 29.0178 14.158 28.8367 14.132M28.1272 14.1049L28.1048 13.9997C28.3634 13.9814 28.6228 13.9914 28.8817 14.0291L28.8367 14.132M28.1272 14.1049C28.3625 14.0883 28.599 14.0973 28.8367 14.132M38.2993 11.5992C38.2112 11.3959 38.0273 11.215 37.7539 11.0572L35.3118 9.64734L35.1819 9.57235L35.052 9.64734L34.6054 9.90519L34.4755 9.98019L34.6054 10.0552L37.0115 11.4442C37.1719 11.5368 37.2746 11.6366 37.3264 11.7439L37.3265 11.7442C37.3778 11.8493 37.3761 11.9574 37.3183 12.0709C37.2603 12.1817 37.1423 12.2917 36.9538 12.4005C36.7655 12.5092 36.575 12.5773 36.3832 12.6108C36.1878 12.6436 36.0001 12.6446 35.8161 12.6155C35.6305 12.5856 35.4577 12.5263 35.2974 12.4337L32.8914 11.0447L32.7615 10.9697L32.6315 11.0447L32.1849 11.3025L32.055 11.3775L32.1849 11.4525L34.627 12.8624C34.9002 13.0201 35.2127 13.1266 35.5634 13.1782L35.5647 13.1783C35.9146 13.2283 36.2709 13.2205 36.6297 13.157L36.6305 13.1569C36.9916 13.092 37.3251 12.9685 37.6315 12.7917C37.9378 12.6148 38.1516 12.4223 38.2641 12.2138L38.2643 12.2134C38.3743 12.0061 38.3872 11.8007 38.2993 11.5992ZM38.2993 11.5992C38.2993 11.5992 38.2993 11.5992 38.2993 11.5993L38.1211 11.625L38.2992 11.5991C38.2992 11.5991 38.2993 11.5992 38.2993 11.5992ZM32.6541 15.4403L32.784 15.5153L32.9139 15.4403L33.3605 15.1825L33.4904 15.1075L33.3605 15.0325L32.1433 14.3298L32.8202 13.939C33.122 13.7648 33.3266 13.5834 33.4167 13.3941L33.417 13.3936C33.5038 13.2078 33.4982 13.0262 33.3957 12.8518C33.297 12.681 33.1277 12.5276 32.8923 12.3916C32.6567 12.2557 32.3912 12.1581 32.096 12.1018C31.7935 12.0442 31.4793 12.0428 31.1588 12.0952C30.8309 12.1473 30.5157 12.2662 30.212 12.4415L28.9657 13.161L28.8358 13.236L28.9657 13.311L32.6541 15.4403ZM32.1498 13.5686L31.4873 13.9511L30.1983 13.2069L30.8536 12.8286C31.0413 12.7202 31.2097 12.6596 31.3578 12.6351L31.3578 12.6351L31.3591 12.6349C31.5117 12.6089 31.6501 12.6114 31.7807 12.639L31.7807 12.639L31.7822 12.6393C31.9247 12.6687 32.0618 12.7196 32.193 12.7953C32.3242 12.8711 32.4132 12.9507 32.4653 13.0339L32.4656 13.0344C32.5139 13.1105 32.5195 13.1915 32.4771 13.2808C32.4368 13.3658 32.3345 13.4619 32.1498 13.5686Z"></path>\n    </svg>\n    <p class="dark:text-zinc-50 text-xs lg:text-base lg:font-normal font-bold">خرید سرور اختصاصی</p>\n    ',
    '\n    <svg class="svg-icon pagination-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 64 64">\n    <g clip-path="url(#64-badge-website-1__a)">\n        <path class="dark:stroke-white" stroke="#450a0a" stroke-dasharray="8 8" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M38 9.63159V1.13159L1 22.1316V55.1316L7.87015 51.2583"></path>\n        <path class="dark:stroke-white" stroke="#450a0a" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M44 25.1711V15.1316M35 44.6315L8 60.1316V35.6316M8 35.6316V27.2539L44 6.63159V15.1316M8 35.6316L44 15.1316"></path>\n        <path fill="#dc2626" d="M13.3032 28.5627C13.3032 29.3035 12.7831 30.2043 12.1415 30.5747C11.5 30.9451 10.98 30.6449 10.98 29.9041C10.98 29.1633 11.5001 28.2625 12.1416 27.8921C12.7832 27.5216 13.3032 27.8219 13.3032 28.5627Z"></path>\n        <path fill="#dc2626" d="M16.3032 26.7189C16.3032 27.4597 15.7831 28.3606 15.1415 28.731C14.5 29.1014 13.98 28.8011 13.98 28.0604C13.98 27.3196 14.5001 26.4187 15.1416 26.0483C15.7832 25.6779 16.3032 25.9781 16.3032 26.7189Z"></path>\n        <path fill="#dc2626" d="M19.3032 25.0627C19.3032 25.8035 18.7831 26.7043 18.1415 27.0747C17.5 27.4451 16.98 27.1449 16.98 26.4041C16.98 25.6633 17.5001 24.7625 18.1416 24.3921C18.7832 24.0216 19.3032 24.3219 19.3032 25.0627Z"></path>\n        <path class="dark:stroke-white" stroke="#450a0a" stroke-linejoin="round" stroke-width="2" d="M14 38.0608L24 32.3015V45.1316L14 50.8703V38.0608Z"></path>\n        <path class="dark:stroke-white" stroke="#450a0a" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M39.0002 28.1269V23.7632L29.0005 29.4675V42.2744L36.02 38.2477"></path>\n        <path fill="#dc2626" stroke="#dc2626" stroke-linejoin="round" stroke-width="2" d="M45.4615 17.0525C38.5812 21.0549 33.0003 30.685 33 38.6892C32.9998 43.8343 34.0011 47.1193 39.0031 48.2561L39.0031 50.6047L38.9952 60.7147L43 63L59.0955 18.1275L54.556 15.5763C52.3193 14.3897 48.8004 15.1103 45.4615 17.0525Z"></path>\n        <path class="dark:fill-red-500" fill="#f87171" d="M50.0024 53.1239L43.0034 63L43.0034 50.0584C39.3752 49.5032 37.0028 46.286 37.0029 41.076C37.0032 32.9753 42.8237 23.1247 50.0034 19.0742C57.1831 15.0236 63.0032 18.3069 63.0029 26.4076C63.0028 31.6174 60.6312 37.6901 57.0029 42.3391L57.0029 55.7229L50.0024 53.1239Z"></path>\n        <path class="dark:fill-red-500" fill="#f87171" d="M43.0034 63L42.0034 63C42.0034 63.4354 42.2851 63.8208 42.7 63.9529C43.1148 64.085 43.5675 63.9334 43.8193 63.5782L43.0034 63ZM50.0024 53.1239L50.3504 52.1865C49.9259 52.0288 49.4484 52.1762 49.1865 52.5457L50.0024 53.1239ZM57.0029 55.7229L56.6549 56.6604C56.9618 56.7743 57.3051 56.7308 57.5739 56.5439C57.8427 56.357 58.0029 56.0503 58.0029 55.7229L57.0029 55.7229ZM37.0029 41.076L36.0029 41.076L37.0029 41.076ZM50.0034 19.0742L49.512 18.2032L50.0034 19.0742ZM63.0029 26.4076L64.0029 26.4076L63.0029 26.4076ZM43.0034 50.0584L44.0034 50.0584L44.0034 49.1997L43.1546 49.0699L43.0034 50.0584ZM57.0029 42.3391L56.2146 41.7239L56.0029 41.9951L56.0029 42.3391L57.0029 42.3391ZM43.8193 63.5782L50.8183 53.7022L49.1865 52.5457L42.1875 62.4218L43.8193 63.5782ZM49.6543 54.0614L56.6549 56.6604L57.351 54.7854L50.3504 52.1865L49.6543 54.0614ZM38.0029 41.076C38.0031 37.2478 39.3854 32.9344 41.6718 29.065C43.9576 25.1965 47.0921 21.8648 50.4948 19.9451L49.512 18.2032C45.735 20.3341 42.3694 23.953 39.9499 28.0476C37.5311 32.1412 36.0031 36.8035 36.0029 41.076L38.0029 41.076ZM50.4948 19.9451C53.904 18.0217 56.7634 17.9602 58.7043 19.0551C60.6368 20.1453 62.0031 22.5777 62.0029 26.4075L64.0029 26.4076C64.0031 22.1367 62.4594 18.8771 59.687 17.3132C56.923 15.7539 53.2825 16.076 49.512 18.2032L50.4948 19.9451ZM43.1546 49.0699C41.6154 48.8344 40.3582 48.0454 39.467 46.7469C38.5638 45.4308 38.0028 43.5372 38.0029 41.076L36.0029 41.076C36.0028 43.8247 36.628 46.1448 37.818 47.8786C39.02 49.63 40.7632 50.7272 42.8521 51.0469L43.1546 49.0699ZM42.0034 50.0584L42.0034 63L44.0034 63L44.0034 50.0584L42.0034 50.0584ZM62.0029 26.4075C62.0028 31.3512 59.7349 37.2131 56.2146 41.7239L57.7913 42.9544C61.5275 38.167 64.0028 31.8837 64.0029 26.4076L62.0029 26.4075ZM58.0029 55.7229L58.0029 42.3391L56.0029 42.3391L56.0029 55.7229L58.0029 55.7229Z"></path>\n        <path fill="#dc2626" stroke="#dc2626" stroke-width="2" d="M60.0029 27.862C60.0027 34.0353 55.5254 41.5421 50.0026 44.6289C44.4797 47.7158 40.0027 45.2137 40.0029 39.0404C40.0031 32.8671 44.4805 25.3602 50.0033 22.2734C55.5261 19.1866 60.0031 21.6887 60.0029 27.862Z"></path>\n        <path fill="#fff" stroke="#fff" stroke-linejoin="round" stroke-width="2" d="M50.9393 25.8694L52.3775 30.1505L57.0319 27.463L53.2663 32.7963L54.7044 37.0774L50.939 36.0925L47.1734 41.4257L48.6119 35.4837L44.8464 34.4988L49.5009 31.8114L50.9393 25.8694Z"></path>\n    </g>\n    <defs>\n        <clipPath id="64-badge-website-1__a">\n            <path fill="#fff" d="M0 0H64V64H0z"></path>\n        </clipPath>\n    </defs>\n    </svg>\n    <p class="dark:text-zinc-50 text-xs lg:text-base lg:font-normal font-bold">خرید لایسنس</p>\n    ',
  ];
  const numEl = document.querySelector(".autoplay-progress span");
  const el = document.querySelector(".autoplay-progress svg");
  const mainSwiper = new Swiper(".main-swiper", {
    loop: true,
    rtl: true,
    slidesPerView: 1,
    autoplay: { delay: 5000 },
    pagination: {
      el: ".swiper-pagination",
      clickable: true,
      renderBullet: function (e, o) {
        return `<span class="${o}">${icons[e]}</span>`;
      },
    },
    on: {
      autoplayTimeLeft(t, r, n) {
        el.style.setProperty("--progress", 1 - n), (numEl.textContent = `${Math.ceil(r / 1e3)}`);
      },
    },
  });

  // Domain slider
  const swiper = new Swiper(".domain-swiper", {
    rtl: true,
    loop: true,
    speed: 6000,
    autoplay: {
      delay: 0,
    },
    slidesPerView: 5,
    breakpoints: {
      320: {
        slidesPerView: 1,
      },
      640: {
        slidesPerView: 2,
      },
      1024: {
        slidesPerView: 5,
      },
    },
  });
  // Domain slider
  const featuresSwiper = new Swiper(".features-swiper", {
    rtl: true,
    slidesPerView: 2,
    spaceBetween: 25,
    loop: true,
    speed: 300,
    autoplay: {
      delay: 2000,
    },
  });

  // Pricing Tabs
  const tabButtons = document.querySelectorAll(".tab-btn");
  const contents = document.querySelectorAll(".tab-content");

  tabButtons.forEach((button) => {
    button.addEventListener("click", () => {
      const tabId = button.getAttribute("data-tab");

      tabButtons.forEach((btn) => {
        btn.classList.remove("bg-red-600", "text-white");
        btn.classList.add("bg-red-50", "text-red-600");
      });
      button.classList.add("bg-red-600", "text-white");
      button.classList.remove("bg-red-50", "text-red-600");

      contents.forEach((content) => {
        if (content.id === tabId) {
          content.classList.remove("hidden");
          content.classList.add("opacity-100");
        } else {
          content.classList.add("hidden");
          content.classList.remove("opacity-100");
        }
      });
    });
  });

  // Tabs
  tabs.forEach((tab) => {
    tab.addEventListener("click", () => {
      tabs.forEach((i) => {
        if (i !== tab) {
          i.classList.remove("show-tab");
        }
      });
      tab.classList.toggle("show-tab");
    });
  });

  tabs.forEach((tab) => {
    tab.addEventListener("click", () => {
      tabs.forEach((t) => t.classList.remove("active"));
      tabContents.forEach((c) => c.classList.remove("active"));

      tab.classList.add("active");
      const tabId = tab.dataset.tab;
      document.querySelector(`.content[data-content="${tabId}"]`).classList.add("active");
    });
  });
});

// highlight current link(Desktop)
const topMenus = document.querySelectorAll(".topmenu");
const currentPath = window.location.pathname;

topMenus.forEach((topMenu) => {
  const submenuId = topMenu.getAttribute("data-target");
  const submenu = document.getElementById(submenuId);

  if (submenu) {
    const subMenuLinks = submenu.querySelectorAll("a");
    let isHighlighted = false;

    subMenuLinks.forEach((link) => {
      if (link.getAttribute("href") === currentPath) {
        topMenu.classList.add("highlight");
        isHighlighted = true;
      }
    });

    if (!isHighlighted) {
      topMenu.classList.remove("highlight");
    }
  }
});
