<?php $__env->startComponent('frontend.layouts.content' , ['title' => $post->title , 'subtitle' => 'خلاقیت، زیبایی، کیفیت...']); ?>

    <?php $__env->slot('breadcrumb'); ?>
        <li class="breadcrumb-item"><a href="<?php echo e(route('main')); ?>">خانه</a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo e($post->title); ?></li>
    <?php $__env->endSlot(); ?>
    <?php $__env->startSection('head'); ?>
        <script type="application/ld+json">
            [{
            "@context": "https://schema.org/",
            "@type": "CreativeWorkSeason",
            "name": "<?php echo e($post->title); ?>",
        "aggregateRating": {
        "@type": "AggregateRating",
        "ratingValue": "5",
        "ratingCount": "<?php echo e($post->rating_count); ?>",
        "bestRating": "5",
        "worstRating": "1"
        }}]

        </script>
    <?php $__env->stopSection(); ?>


    <div class="container py-4">

        <div class="row">
            <div class="col-lg-3">
                <aside class="sidebar mb-5 mb-lg-0 pb-2 pb-lg-0">
                    <div class="post-image ml-0"  style="border: solid 1px #f5f5f5 !important;
    padding: 1rem;
    border-radius: 10px">
                        <img src="<?php echo e(asset($post->image)); ?>"
                             class="img-fluid img-thumbnail img-thumbnail-no-borders rounded-10" alt="">
                    </div>
                    <div class="mt-3" style="border: solid 1px #f5f5f5 !important;
    padding: 1rem;
    border-radius: 10px">
                        <h3 class="font-weight-bold text-3 mb-3 ">مطالب اخیر</h3>

                        <ul class="simple-post-list">
                            <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <div class="post-image">
                                        <div class="img-thumbnail img-thumbnail-no-borders d-block">
                                            <a href="<?php echo e(route('post.show' , $post)); ?>">
                                                <img src="<?php echo e(asset($post->image)); ?>" class="border-radius-0" width="50"
                                                     height="50" alt="Main Reasons To Stop Texting And Driving">
                                            </a>
                                        </div>
                                    </div>
                                    <div class="post-info">
                                        <h4 class="font-weight-normal text-3 line-height-8 mb-0 primary-font"><a
                                                    href="<?php echo e(route('post.show' , $post)); ?>" class="text-dark">
                                                <?php echo e($post->title); ?></a></h4>
                                        <div class="post-meta">
                                            <?php echo e(\Hekmatinasser\Verta\Verta::instance($post->created_at)->formatJalaliDate()); ?>

                                        </div>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </ul>
                    </div>
                    <div id="sidebar">
                        <h3>فهرست مطالب</h3>
                        <ul id="h3-list"></ul>
                    </div>


                </aside>
            </div>
            <div class="col-lg-9">
                <div class="blog-posts single-post">

                    <article class="post post-large blog-single-post border-0 m-0 p-0">


                        <div class="d-flex gap-2 align-items-center ">
                            <div class="post-date ml-0">
                                <span class="day"><?php echo e(\Hekmatinasser\Verta\Verta::instance($post->created_at)->format('%d')); ?></span>
                                <span class="month"><?php echo e(\Hekmatinasser\Verta\Verta::instance($post->created_at)->format('%B')); ?></span>
                            </div>
                            <div class="post-meta m-0" style="margin-right: 1rem !important;">
                                <?php if($post->categories): ?>
                                    <?php $__currentLoopData = $post->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span><i class="far fa-folder"></i>
                                            <?php echo e($category->name); ?>,
                                        </span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <?php endif; ?>


                                <span><i class="far fa-comments"></i> <a href="#">
                                        <?php echo e($post->comments->count()); ?>

                                        دیدگاه
                                    </a></span>
                            </div>
                        </div>
                        <div class="post-content ml-0">



                            <?php echo $post->body; ?>



                        </div>
                    </article>

                </div>
            </div>
        </div>

    </div>

    <?php $__env->startSection('scripts'); ?>
        <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
        <script src="<?php echo e(asset('/js/responsive-sidebar.js')); ?>"></script>
        <script src="<?php echo e(asset('/assets/js/comments.js')); ?>"></script>
    <?php $__env->stopSection(); ?>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/yektamentor/public_html/core/Modules/Post/Resources/views/frontend/show.blade.php ENDPATH**/ ?>