<?php $__env->startComponent('backend.layouts.components.main', ['title' => 'مدیریت پلاگین ها' , 'titleBar' => false]); ?>

    <?php $__env->slot('breadcrumb'); ?>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('admin.index')); ?>">پیشخوان</a>
        </li>
        <li class="breadcrumb-item active">پلاگین ها</li>
    <?php $__env->endSlot(); ?>

    
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست پلاگین ها</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr class="text-center">
                            <th>نام</th>
                            <th>توضیحات</th>
                            <th>وضعیت</th>
                            <th>عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php

                                $moduleData = new \Nwidart\Modules\Json($module->getPath() . '\module.json');

                            ?>
                            <?php if($moduleData->get('display')): ?>
                                <tr>
                                    <td style="font-weight: bold">
                                        <?php echo e($moduleData->get('alias')); ?>

                                    </td>
                                    <td>
                                        <?php echo e($moduleData->get('description')); ?>

                                    </td>

                                    <td class="text-center">
                                        <?php if(\Nwidart\Modules\Module::isEnable($module->getName())): ?>

                                            <span class="badge badge-success">فعال</span>

                                        <?php else: ?>
                                            <span class="badge badge-warning">غیرفعال</span>
                                        <?php endif; ?>

                                    </td>

                                    <td class="text-center">
                                        <?php if(\Nwidart\Modules\Module::isEnable($module->getName())): ?>
                                            <form action="<?php echo e(route('admin.module.disable',$module)); ?>" method="post" id="module-<?php echo e($module->getName()); ?>">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('patch'); ?>
                                            </form>
                                            <a type="button" onclick="document.getElementById('module-<?php echo e($module->getName()); ?>').submit()" class="btn light btn-danger btn-xs" id="module-<?php echo e($module->getName()); ?>">غیر فعالسازی</a>
                                        <?php else: ?>
                                            <form action="<?php echo e(route('admin.module.enable',$module)); ?>" method="post" id="module-<?php echo e($module->getName()); ?>">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('patch'); ?>
                                            </form>
                                            <a type="button" onclick="document.getElementById('module-<?php echo e($module->getName()); ?>').submit()" class="btn light btn-success btn-xs" id="module-<?php echo e($module->getName()); ?>">فعالسازی</a>

                                        <?php endif; ?>


                                    </td>
                                </tr>
                            <?php endif; ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/yektamentor/public_html/core/Modules/Main/Resources/views/backend/modules/all.blade.php ENDPATH**/ ?>