<?php $__env->startComponent('backend.layouts.components.main',['title' => 'مدیریت پروژه ها', 'titleBar'=>true , 'button' => 'افزودن پروژه' , 'route' => 'admin.projects.create']); ?>

    <?php $__env->slot('breadcrumb'); ?>
        <li class="breadcrumb-item active">
            <a href="<?php echo e(route('admin.index')); ?>">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">پروژه ها</li>
    <?php $__env->endSlot(); ?>

    
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست پروژه ها</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>کد</th>
                            <th>نام</th>
                            <th>دامنه</th>
                            <th>کارفرما</th>
                            <th>تاریخ شروع</th>
                            <th>تاریخ تمدید</th>
                            <th>وضعیت</th>
                            <th>فایل آموزشی</th>
                            <th>اطلاعات ورود</th>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-projects')): ?>
                                <th>عملیات</th>
                            <?php endif; ?>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($project->tracking_id); ?></td>
                                <td><?php echo e($project->title); ?></td>
                                <td><a href="<?php echo e($project->domain); ?>" target="_blank"><?php echo e($project->domain); ?></a></td>
                                <td>
                                    <a href="<?php echo e(route('admin.users.edit' , $project->user->id)); ?>"><?php echo e($project->user->name); ?></a>
                                </td>
                                <td>
                                    <?php echo e(\Hekmatinasser\Verta\Verta::instance($project->start_date)->formatJalaliDate()); ?>

                                </td>
                                <td>
                                    <?php if(\Illuminate\Support\Carbon::parse($project->renew_date)->isPast()): ?>
                                        <span class="badge badge-pill badge-danger light">
                                            <?php echo e(\Hekmatinasser\Verta\Verta::instance($project->renew_date)->formatDifference()); ?>

                                        </span>
                                    <?php else: ?>
                                        <?php echo e(\Hekmatinasser\Verta\Verta::instance($project->renew_date)->formatJalaliDate()); ?>

                                        <span class="badge badge-pill badge-success light">
                                            <?php echo e(\Hekmatinasser\Verta\Verta::instance($project->renew_date)->formatDifference()); ?>

                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php switch($project->status):
                                        case ('preparation'): ?>
                                        <span class="badge badge-pill badge-info light">در حال انجام</span>
                                        <?php break; ?>
                                        <?php case ('canceled'): ?>
                                        <span class="badge badge-pill badge-danger light">لغو شده یا عدم تمدید</span>
                                        <?php break; ?>
                                        <?php case ('done'): ?>
                                        <span class="badge badge-pill badge-success light">تحویل داده شده</span>
                                        <?php break; ?>
                                    <?php endswitch; ?>
                                </td>
                                <td>
                                    <?php if($project->course_file): ?>
                                        <span class="badge badge-pill badge-primary light">ارسال شده</span>
                                    <?php else: ?>
                                        <span class="badge badge-pill badge-warning light">ارسال نشده</span>
                                    <?php endif; ?>

                                </td>
                                <td>
                                    <?php if($project->login_info): ?>
                                        <span class="badge badge-pill badge-primary light">ارسال شده</span>
                                    <?php else: ?>
                                        <span class="badge badge-pill badge-warning light">ارسال نشده</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <form action="<?php echo e(route('admin.projects.destroy', $project->id)); ?>" method="post"
                                          id="delete-<?php echo e($project->id); ?>">
                                        <?php echo method_field('delete'); ?>
                                        <?php echo csrf_field(); ?>
                                    </form>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-users')): ?>
                                        <a href="<?php echo e(route('admin.projects.edit', $project->id)); ?>" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-<?php echo e($project->id); ?>').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-<?php echo e($project->id); ?>').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
                <?php echo e($projects->links()); ?>

            </div>
        </div>
    </div>
    
<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('/backend/js/search.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/yektamentor/public_html/core/Modules/Project/Resources/views/backend/all.blade.php ENDPATH**/ ?>