<!DOCTYPE html>
<html lang="fa" dir="rtl">
<!--[if lt IE 7]>
<html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>
<html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>
<html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!-->
<!--<![endif]-->
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1">
    {!! SEO::generate() !!}
    <link rel="icon" type="image/png" href="/img/logo.png"/>
    <!-- CSRF -->
    <meta name="csrf-token" content="{{csrf_token()}}">
    <!-- Google Verify -->
    <meta name="google-site-verification" content="x0sN_sOSsWWgtsBdyYhz40NO79FPnQHVcQy90aSG7jg"/>

    <meta name="theme-color" content="#6fc282" />

@yield('head')
<!-- Favicon-->
    <link rel="shortcut icon" type="image/x-icon" href="/img/logo.png">
    <!-- =========== CSS Files =========== -->
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-v4-rtl/4.6.0-2/css/bootstrap-rtl.min.css">
    <link rel="stylesheet" href="https://unpkg.com/aos@next/dist/aos.css"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery.flipster/1.1.5/jquery.flipster.css">
    <!-- Vendor CSS -->
    <link rel="stylesheet" href="/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="/vendor/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="/vendor/animate/animate.min.css">
    <link rel="stylesheet" href="/vendor/simple-line-icons/css/simple-line-icons.min.css">
    <link rel="stylesheet" href="/vendor/owl.carousel/assets/owl.carousel.min.css">
    <link rel="stylesheet" href="/vendor/owl.carousel/assets/owl.theme.default.min.css">
    <link rel="stylesheet" href="/vendor/magnific-popup/magnific-popup.min.css">

    <!-- Theme CSS -->
    <link rel="stylesheet" href="/css/theme.css">
    <link rel="stylesheet" href="/css/theme-elements.css">
    <link rel="stylesheet" href="/css/theme-blog.css">
    <link rel="stylesheet" href="/css/theme-shop.css">

    <!-- Current Page CSS -->
    <link rel="stylesheet" href="/vendor/rs-plugin/css/settings.css">
    <link rel="stylesheet" href="/vendor/rs-plugin/css/layers.css">
    <link rel="stylesheet" href="/vendor/rs-plugin/css/navigation.css">
    <link rel="stylesheet" href="/vendor/circle-flip-slideshow/css/component.css">

    <!-- Demo CSS -->


    <!-- Skin CSS -->
    <link rel="stylesheet" href="/css/skins/default.css">

    <!-- Theme Custom CSS -->
    <link rel="stylesheet" href="/css/custom.css">

    <!-- Head Libs -->
    <script src="/vendor/modernizr/modernizr.min.js"></script>

    <script type="application/ld+json">
            {
              "@context": "https://schema.org",
              "@type": "Organization",
              "url": "https://www.karawebs.com",
              "logo": "https://www.karawebs.com/images/logo.png"
            }


    </script>
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-HE9024HB9X"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
    
      gtag('config', 'G-HE9024HB9X');
    </script>
    <!-- Google Tag Manager -->
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
            j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
            'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer','GTM-TJSGDFL9');</script>
    <!-- End Google Tag Manager -->
</head>

<body>
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-TJSGDFL9"
                  height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
@include('frontend.layouts.partials.header')
<div class="main">
    @yield('content')
</div>

<footer id="footer">
    <div class="container">
        <div class="footer-ribbon">
            <span>یکتا منتور</span>
        </div>
        <div class="row py-5 my-4">
            <div class="col-md-6 col-lg-4 mb-4 mb-lg-0 pb-2 pb-lg-0">
                <h5 class="text-3 mb-3">درباره ما</h5>
                <p class="pr-1">از آخرین ویژگی ها و به‌روزرسانی های ما با خبر شوید. ایمیل خود را وارد کرده و مشترک خبرنامه ما شوید.</p>
            </div>
            <div class="col-md-6 col-lg-3 mb-4 mb-lg-0 pb-2 pb-lg-0">
                <h5 class="text-3 mb-3">جدیدترین مقالات</h5>
                <ul class="simple-post-list">
                    @foreach(\Modules\Post\Entities\Post::all()->take(4) as $post)
                        <li>
                            <div class="post-image">
                                <div class="img-thumbnail img-thumbnail-no-borders d-block">
                                    <a href="{{route('post.show' , $post)}}">
                                        <img src="{{asset($post->image)}}" class="border-radius-0" width="50"
                                             height="50" alt="Main Reasons To Stop Texting And Driving">
                                    </a>
                                </div>
                            </div>
                            <div class="post-info">
                                <h4 class="font-weight-normal text-3 line-height-8 mb-0 primary-font text-white"><a
                                            href="{{route('post.show' , $post)}}" class="text-white">
                                        {{$post->title}}</a></h4>
                                <div class="post-meta">
                                    {{\Hekmatinasser\Verta\Verta::instance($post->created_at)->formatJalaliDate()}}
                                </div>
                            </div>
                        </li>
                    @endforeach


                </ul>
            </div>
            <div class="col-md-6 col-lg-3 mb-4 mb-md-0 pb-2 pb-md-0">
                <div class="contact-details">
                    <h5 class="text-3 mb-3">تماس با ما</h5>
                    <ul class="list list-icons list-icons-lg mb-2">
                        <li class="mb-1"><i class="fab fa-whatsapp text-color-primary"></i><p class="m-0"><a href="tel:8001234567" class="ltr-text">(+98) 937 668 8753</a></p></li>
                        <li class="mb-1"><i class="far fa-envelope text-color-primary"></i><p class="m-0"><a href="mailto:info@yektamentor.com">info@yektamentor.com</a></p></li>
                    </ul>
                </div>
            </div>
            <div class="col-md-6 col-lg-2">
                <h5 class="text-3 mb-3 pb-1">ما را دنبال کنید</h5>
                <ul class="social-icons">
                    <li class="social-icons-instagram"><a href="https://www.instagram.com/yektamentor?igsh=dzA0a2RzbDRnMzM=" target="_blank" title="instagram"><i class="fab fa-instagram"></i></a></li>
                    <li class="social-icons-telegram"><a href="https://t.me/yektamentor" target="_blank" title="telegram"><i class="fab fa-telegram"></i></a></li>
                    <li class="social-icons-youtube"><a href="https://www.youtube.com/@yektamentor" target="_blank" title="youtube"><i class="fab fa-youtube"></i></a></li>
                    <li class="social-icons-linkedin"><a href="https://www.linkedin.com/company/yektamentor" target="_blank" title="linkedin"><i class="fab fa-linkedin"></i></a></li>
                </ul>
            </div>
        </div>
    </div>
    <div class="footer-copyright">
        <div class="container py-2">
            <div class="row py-2 justify-content-center">
                <p>تمامی حقوق محفوظ است</p>
            </div>
        </div>
    </div>
</footer>

</body>

<!-- JS Files -->
<!-- Vendor -->
<script src="/vendor/jquery/jquery.min.js"></script>
<script src="/vendor/jquery.appear/jquery.appear.min.js"></script>
<script src="/vendor/jquery.easing/jquery.easing.min.js"></script>
<script src="/vendor/jquery.cookie/jquery.cookie.min.js"></script>
<script src="/vendor/popper/umd/popper.min.js"></script>
<script src="/vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="/vendor/common/common.min.js"></script>
<script src="/vendor/jquery.validation/jquery.validate.min.js"></script>
<script src="/vendor/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
<script src="/vendor/jquery.gmap/jquery.gmap.min.js"></script>
<script src="/vendor/jquery.lazyload/jquery.lazyload.min.js"></script>
<script src="/vendor/isotope/jquery.isotope.min.js"></script>
<script src="/vendor/owl.carousel/owl.carousel.min.js"></script>
<script src="/vendor/magnific-popup/jquery.magnific-popup.min.js"></script>
<script src="/vendor/vide/jquery.vide.min.js"></script>
<script src="/vendor/vivus/vivus.min.js"></script>

<!-- Theme Base, Components and Settings -->
<script src="/js/theme.js"></script>

<!-- Current Page Vendor and Views -->
<script src="/vendor/rs-plugin/js/jquery.themepunch.tools.min.js"></script>
<script src="/vendor/rs-plugin/js/jquery.themepunch.revolution.min.js"></script>
<script src="/vendor/circle-flip-slideshow/js/jquery.flipshow.min.js"></script>
<script src="/js/views/view.home.js"></script>

<!-- Theme Custom -->
<script src="/js/custom.js"></script>

<!-- Theme Initialization Files -->
<script src="/js/theme.init.js"></script>
<script src="/js/theme.init.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

<!---start GOFTINO code--->
<script type="text/javascript">
    !function(){var a=window,d=document;function g(){var g=d.createElement("script"),s="https://www.goftino.com/widget/tMNYBG",l=localStorage.getItem("goftino");g.type="text/javascript",g.async=!0,g.referrerPolicy="no-referrer-when-downgrade",g.src=l?s+"?o="+l:s;d.getElementsByTagName("head")[0].appendChild(g);}"complete"===d.readyState?g():a.attachEvent?a.attachEvent("onload",g):a.addEventListener("load",g,!1);}();
</script>
@if(auth()->check())
    <script>
        let user_name = "{{auth()->user()->name}}";
        let user_phone = "{{auth()->user()->phone}}";
        let user_avatar = "{{auth()->user()->avatar}}";
        window.addEventListener('goftino_ready', function () {
            Goftino.setUser({
                name: user_name,
                phone: user_phone,
                avatar: user_avatar,
                forceUpdate : true
            });
        });
    </script>
@endif
<!---end GOFTINO code--->
@include('sweet::alert')
@yield('scripts')
</html>
